/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import com.nettgryppa.security.HashCash;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.util.Log;

@TypeCode(value=89)
public class RelayRequest
extends CommunicationPacket {
    private Log log = new Log(RelayPacket.class);
    private HashCash hashCash;
    private byte[] storedData;

    public RelayRequest(HashCash hashCash, DataPacket dataPacket) {
        this.hashCash = hashCash;
        this.storedData = dataPacket.toByteArray();
    }

    public RelayRequest(byte[] data) throws NoSuchAlgorithmException {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        short hashCashLength = buffer.getShort();
        byte[] hashCashData = new byte[hashCashLength];
        buffer.get(hashCashData);
        this.hashCash = new HashCash(new String(hashCashData));
        short dataLength = buffer.getShort();
        this.storedData = new byte[dataLength];
        buffer.get(this.storedData);
        if (buffer.hasRemaining()) {
            this.log.debug("Storage Request Packet has " + buffer.remaining() + " extra bytes.");
        }
    }

    public HashCash getHashCash() {
        return this.hashCash;
    }

    public DataPacket getStoredPacket(PrivateKey localDecryptionKey, I2PAppContext appContext) throws DataFormatException {
        byte[] decryptedData = appContext.elGamalAESEngine().decrypt(this.storedData, localDecryptionKey, appContext.sessionKeyManager());
        return DataPacket.createPacket((byte[])decryptedData);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteArrayStream);
        try {
            this.writeHeader((OutputStream)dataStream);
            String hashCashString = this.hashCash.toString();
            dataStream.writeShort(hashCashString.length());
            dataStream.write(hashCashString.getBytes());
            dataStream.writeShort(this.storedData.length);
            dataStream.write(this.storedData);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteArrayStream.toByteArray();
    }
}

