/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.Util;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

@TypeCode(value=82)
public class RelayPacket
extends DataPacket {
    public static final int XOR_KEY_LENGTH = 32;
    private Log log = new Log(RelayPacket.class);
    private long earliestSendTime;
    private long latestSendTime;
    private byte[] xorKey;
    private Destination nextDestination;
    private byte[] payload;

    public RelayPacket(Destination nextDestination, long earliestSendTime, long latestSendTime) {
        this.nextDestination = nextDestination;
        this.earliestSendTime = earliestSendTime;
        this.latestSendTime = latestSendTime;
    }

    public RelayPacket(byte[] data) throws DataFormatException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.earliestSendTime = buffer.getInt();
        this.latestSendTime = buffer.getInt();
        this.xorKey = new byte[32];
        buffer.get(this.xorKey);
        this.nextDestination = new Destination();
        byte[] destinationData = new byte[384];
        buffer.get(destinationData);
        this.nextDestination.readBytes(destinationData, 0);
        short payloadLength = buffer.getShort();
        this.payload = new byte[payloadLength];
        buffer.get(this.payload);
        if (buffer.hasRemaining()) {
            this.log.debug("Relay Packet has " + buffer.remaining() + " extra bytes.");
        }
    }

    public RelayPacket(DataPacket dataPacket, Destination nextDestination, long earliestSendTime, long latestSendTime, byte[] xorKey) throws DataFormatException {
    }

    public RelayPacket(InputStream inputStream) throws IOException, DataFormatException {
        this(Util.readInputStream((InputStream)inputStream));
    }

    public Destination getNextDestination() {
        return this.nextDestination;
    }

    public long getEarliestSendTime() {
        return this.earliestSendTime;
    }

    public long getLatestSendTime() {
        return this.latestSendTime;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(arrayOutputStream);
        try {
            dataStream.writeInt((int)this.earliestSendTime);
            dataStream.writeInt((int)this.latestSendTime);
            dataStream.write(this.xorKey);
            dataStream.write(this.nextDestination.toByteArray());
            dataStream.writeShort(this.payload.length);
            dataStream.write(this.payload);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return arrayOutputStream.toByteArray();
    }
}

