/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TypeCode(value=76)
public class PeerList
extends DataPacket {
    private Log log = new Log(PeerList.class);
    private Collection<KademliaPeer> peers;

    public PeerList(Collection<KademliaPeer> peers) {
        this.peers = peers;
    }

    public PeerList(byte[] data) throws DataFormatException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.get() != this.getPacketTypeCode()) {
            this.log.error("Wrong type code for PeerList. Expected <" + this.getPacketTypeCode() + ">, got <" + (char)data[0] + ">");
        }
        int numPeers = buffer.getShort();
        this.peers = new ArrayList();
        for (int i = 0; i < numPeers; ++i) {
            Destination destination = new Destination();
            byte[] peerData = new byte[388];
            buffer.get(peerData, 0, 384);
            destination.readBytes(peerData, 0);
            KademliaPeer peer = new KademliaPeer(destination, 0L);
            this.peers.add(peer);
        }
        if (buffer.hasRemaining()) {
            this.log.debug("Peer List has " + buffer.remaining() + " extra bytes.");
        }
    }

    public Collection<KademliaPeer> getPeers() {
        return this.peers;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(arrayOutputStream);
        try {
            dataStream.write((byte)this.getPacketTypeCode());
            dataStream.writeShort(this.peers.size());
            for (KademliaPeer peer : this.peers) {
                dataStream.write(peer.getDestination().toByteArray());
            }
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return arrayOutputStream.toByteArray();
    }
}

