/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.email.EmailDestination;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TypeCode(value=73)
public class IndexPacket
extends DhtStorablePacket {
    private Log log = new Log(IndexPacket.class);
    private Collection<Hash> dhtKeys;
    private Hash destinationHash;

    public IndexPacket(byte[] data) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        if (dataBuffer.get() != this.getPacketTypeCode()) {
            this.log.error("Wrong type code for IndexPacket. Expected <" + this.getPacketTypeCode() + ">, got <" + (char)data[0] + ">");
        }
        this.destinationHash = this.readHash(dataBuffer);
        int numKeys = dataBuffer.get();
        this.dhtKeys = new ArrayList();
        for (int i = 0; i < numKeys; ++i) {
            Hash dhtKey = this.readHash(dataBuffer);
            this.dhtKeys.add(dhtKey);
        }
    }

    public IndexPacket(Collection<EncryptedEmailPacket> emailPackets, EmailDestination emailDestination) {
        this.dhtKeys = new ArrayList();
        for (EncryptedEmailPacket emailPacket : emailPackets) {
            this.dhtKeys.add(emailPacket.getDhtKey());
        }
        this.destinationHash = emailDestination.getHash();
    }

    public IndexPacket(Collection<IndexPacket> indexPackets) {
        this.dhtKeys = new HashSet();
        for (IndexPacket packet : indexPackets) {
            this.dhtKeys.addAll(packet.getDhtKeys());
        }
    }

    public IndexPacket(IndexPacket ... indexPackets) {
        this(Arrays.asList(indexPackets));
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write((byte)this.getPacketTypeCode());
        try {
            this.destinationHash.writeBytes((OutputStream)outputStream);
            outputStream.write((byte)this.dhtKeys.size());
            for (Hash dhtKey : this.dhtKeys) {
                dhtKey.writeBytes((OutputStream)outputStream);
            }
        }
        catch (DataFormatException e) {
            this.log.error("Invalid format for email destination.", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public Collection<Hash> getDhtKeys() {
        return this.dhtKeys;
    }

    public Hash getDhtKey() {
        return this.destinationHash;
    }
}

