/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.PeerList;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.ResponsePacket;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.UnencryptedEmailPacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import i2p.bote.packet.dht.RetrieveRequest;
import i2p.bote.packet.dht.StoreRequest;
import java.nio.ByteBuffer;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class I2PBotePacket {
    private static final int MAX_DATAGRAM_SIZE = 31744;
    private static final Log log = new Log(I2PBotePacket.class);
    private static Class<? extends I2PBotePacket>[] ALL_PACKET_TYPES = new Class[]{RelayPacket.class, ResponsePacket.class, RetrieveRequest.class, StoreRequest.class, FindClosePeersPacket.class, PeerList.class, EncryptedEmailPacket.class, UnencryptedEmailPacket.class, IndexPacket.class};

    public abstract byte[] toByteArray();

    public int getSize() {
        return this.toByteArray().length;
    }

    public boolean isTooBig() {
        return this.getSize() > 31744;
    }

    protected char getPacketTypeCode(Class<? extends I2PBotePacket> dataType) {
        return dataType.getAnnotation(TypeCode.class).value();
    }

    public char getPacketTypeCode() {
        return this.getPacketTypeCode(this.getClass());
    }

    protected void checkPacketType(char packetTypeCode) {
        if (this.getPacketTypeCode() != packetTypeCode) {
            log.error("Packet type code of class " + this.getClass().getSimpleName() + " should be " + this.getPacketTypeCode() + ", is <" + packetTypeCode + ">");
        }
    }

    protected void checkPacketType(byte packetTypeCode) {
        this.checkPacketType((char)packetTypeCode);
    }

    protected Hash readHash(ByteBuffer buffer) {
        byte[] bytes = new byte[32];
        buffer.get(bytes);
        return new Hash(bytes);
    }

    protected static Class<? extends I2PBotePacket> decodePacketTypeCode(char packetTypeCode) {
        for (Class packetType : ALL_PACKET_TYPES) {
            if (packetType.getAnnotation(TypeCode.class).value() != packetTypeCode) continue;
            return packetType;
        }
        log.debug("Invalid type code for I2PBotePacket: <" + packetTypeCode + ">");
        return null;
    }

    public String toString() {
        return "Type=" + this.getClass().getSimpleName() + ", code=<" + this.getPacketTypeCode() + ">, sizeBytes=" + this.getSize();
    }
}

