/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.email.EmailDestination;
import i2p.bote.email.EmailIdentity;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.UnencryptedEmailPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TypeCode(value=69)
public class EncryptedEmailPacket
extends DhtStorablePacket {
    private static final int PADDED_SIZE = 256;
    private Log log = new Log(EncryptedEmailPacket.class);
    private Hash dhtKey;
    private UniqueId deletionKeyPlain;
    private byte[] encryptedData;

    public EncryptedEmailPacket(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.get() != this.getPacketTypeCode()) {
            this.log.error("Wrong type code for EncryptedEmailPacket. Expected <" + this.getPacketTypeCode() + ">, got <" + (char)data[0] + ">");
        }
        this.dhtKey = this.readHash(buffer);
        this.deletionKeyPlain = new UniqueId(buffer);
        short encryptedLength = buffer.getShort();
        this.encryptedData = new byte[encryptedLength];
        buffer.get(this.encryptedData);
    }

    public EncryptedEmailPacket(UnencryptedEmailPacket unencryptedPacket, EmailDestination emailDestination, I2PAppContext appContext) {
        this.dhtKey = this.generateRandomHash();
        this.deletionKeyPlain = unencryptedPacket.getPlaintextDeletionKey();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            unencryptedPacket.getVerificationDeletionKey().writeTo((OutputStream)dataStream);
            unencryptedPacket.getMessageId().writeTo((OutputStream)dataStream);
            dataStream.writeShort(unencryptedPacket.getFragmentIndex());
            dataStream.writeShort(unencryptedPacket.getNumFragments());
            byte[] content = unencryptedPacket.getContent();
            dataStream.writeShort(content.length);
            dataStream.write(content);
            this.encryptedData = this.encrypt(byteStream.toByteArray(), emailDestination, appContext);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream/DataOutputStream.", (Throwable)e);
        }
    }

    private Hash generateRandomHash() {
        RandomSource randomSource = RandomSource.getInstance();
        byte[] bytes = new byte[32];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)randomSource.nextInt(256);
        }
        return new Hash(bytes);
    }

    public UnencryptedEmailPacket decrypt(EmailIdentity identity, I2PAppContext appContext) throws DataFormatException {
        byte[] decryptedData = this.decrypt(this.encryptedData, identity, appContext);
        ByteBuffer buffer = ByteBuffer.wrap(decryptedData);
        UniqueId deletionKeyVerify = new UniqueId(buffer);
        UniqueId messageId = new UniqueId(buffer);
        short fragmentIndex = buffer.getShort();
        short numFragments = buffer.getShort();
        short contentLength = buffer.getShort();
        byte[] content = new byte[contentLength];
        buffer.get(content);
        return new UnencryptedEmailPacket(this.deletionKeyPlain, deletionKeyVerify, messageId, (int)fragmentIndex, (int)numFragments, content);
    }

    private byte[] decrypt(byte[] data, EmailIdentity identity, I2PAppContext appContext) throws DataFormatException {
        PrivateKey privateKey = identity.getPrivateEncryptionKey();
        return appContext.elGamalAESEngine().decrypt(data, privateKey, appContext.sessionKeyManager());
    }

    public byte[] encrypt(byte[] data, EmailDestination emailDestination, I2PAppContext appContext) {
        PublicKey publicKey = emailDestination.getPublicEncryptionKey();
        SessionKey sessionKey = appContext.sessionKeyManager().createSession(publicKey);
        return appContext.elGamalAESEngine().encrypt(data, publicKey, sessionKey, 256L);
    }

    public static Collection<EncryptedEmailPacket> encrypt(Collection<UnencryptedEmailPacket> packets, EmailDestination destination, I2PAppContext appContext) throws DataFormatException {
        ArrayList<EncryptedEmailPacket> encryptedPackets = new ArrayList<EncryptedEmailPacket>();
        for (UnencryptedEmailPacket unencryptedPacket : packets) {
            encryptedPackets.add(new EncryptedEmailPacket(unencryptedPacket, destination, appContext));
        }
        return encryptedPackets;
    }

    public Hash getDhtKey() {
        return this.dhtKey;
    }

    public UniqueId getPlaintextDeletionKey() {
        return this.deletionKeyPlain;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteArrayStream);
        try {
            dataStream.write((byte)this.getPacketTypeCode());
            dataStream.write(this.dhtKey.toByteArray());
            dataStream.write(this.deletionKeyPlain.toByteArray());
            dataStream.writeShort(this.encryptedData.length);
            dataStream.write(this.encryptedData);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteArrayStream.toByteArray();
    }

    public int getSize() {
        return this.toByteArray().length;
    }

    public String toString() {
        return super.toString() + ", DHTkey=" + this.dhtKey + ", delKeyPln=" + this.deletionKeyPlain + ", encrLen=" + this.encryptedData.length;
    }
}

