/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.packet.I2PBotePacket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.i2p.util.Log;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CommunicationPacket
extends I2PBotePacket {
    private static final byte PACKET_VERSION = 1;
    protected static final int HEADER_LENGTH = 38;
    private static final byte[] PACKET_PREFIX = new byte[]{109, 48, 82, -23};
    private static Log static_log = new Log(CommunicationPacket.class);
    private Log log = new Log(CommunicationPacket.class);
    private UniqueId packetId;
    private CountDownLatch sentSignal;
    private long sentTime;

    protected CommunicationPacket() {
        this(new UniqueId());
    }

    protected CommunicationPacket(UniqueId packetId) {
        this.packetId = packetId;
        this.sentSignal = new CountDownLatch(1);
        this.sentTime = -1L;
    }

    protected CommunicationPacket(byte[] data) {
        this.verifyHeader(data);
        this.checkPacketType(data[4]);
        this.packetId = new UniqueId(data, 6);
    }

    public static CommunicationPacket createPacket(byte[] data) {
        char packetTypeCode = (char)data[4];
        Class packetType = CommunicationPacket.decodePacketTypeCode((char)packetTypeCode);
        if (packetType == null || !CommunicationPacket.class.isAssignableFrom(packetType)) {
            static_log.error("Type code is not a CommunicationPacket type code: <" + packetTypeCode + ">");
            return null;
        }
        Class<CommunicationPacket> commPacketType = packetType.asSubclass(CommunicationPacket.class);
        try {
            return commPacketType.getConstructor(byte[].class).newInstance(new Object[]{data});
        }
        catch (Exception e) {
            static_log.warn("Can't instantiate packet for type code <" + packetTypeCode + ">", (Throwable)e);
            return null;
        }
    }

    private void verifyHeader(byte[] packet) {
        for (int i = 0; i < PACKET_PREFIX.length; ++i) {
            if (packet[i] == PACKET_PREFIX[i]) continue;
            this.log.error("Packet prefix invalid at byte " + i + ". Expected = " + PACKET_PREFIX[i] + ", actual = " + packet[i]);
        }
        if (packet[5] != 1) {
            this.log.error("Unsupported packet version: " + packet[5]);
        }
    }

    public void setPacketId(UniqueId packetId) {
        this.packetId = packetId;
    }

    public UniqueId getPacketId() {
        return this.packetId;
    }

    public synchronized void setSentTime(long sentTime) {
        this.sentTime = sentTime;
        this.sentSignal.countDown();
    }

    public synchronized long getSentTime() {
        return this.sentTime;
    }

    public boolean hasBeenSent() {
        return this.sentTime > 0L;
    }

    public boolean awaitSending(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sentSignal.await(timeout, unit);
    }

    protected void writeHeader(OutputStream outputStream) throws IOException {
        outputStream.write(PACKET_PREFIX);
        outputStream.write((byte)this.getPacketTypeCode());
        outputStream.write(1);
        outputStream.write(this.packetId.toByteArray());
    }

    public String toString() {
        return "Type=" + this.getClass().getSimpleName() + ", Id=" + (this.packetId == null ? "<null>" : this.packetId.toString().substring(0, 8)) + "...";
    }
}

