/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import com.nettgryppa.security.HashCash;
import i2p.bote.network.DHT;
import i2p.bote.network.DhtStorageHandler;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketBatch;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.ClosestNodesLookupTask;
import i2p.bote.network.kademlia.KademliaDHT;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.PeerList;
import i2p.bote.packet.ResponsePacket;
import i2p.bote.packet.StatusCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import i2p.bote.packet.dht.RetrieveRequest;
import i2p.bote.packet.dht.StoreRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KademliaDHT
implements DHT,
PacketListener {
    private static final URL BUILT_IN_PEER_FILE = KademliaDHT.class.getResource("built-in-peers.txt");
    private Log log = new Log(KademliaDHT.class);
    private Hash localDestinationHash;
    private I2PSendQueue sendQueue;
    private I2PPacketDispatcher i2pReceiver;
    private File peerFile;
    private Collection<KademliaPeer> initialPeers;
    private BucketManager bucketManager;
    private Map<Class<? extends DhtStorablePacket>, DhtStorageHandler> storageHandlers;

    public KademliaDHT(Destination localDestination, I2PSendQueue sendQueue, I2PPacketDispatcher i2pReceiver, File peerFile) {
        this.localDestinationHash = localDestination.calculateHash();
        this.sendQueue = sendQueue;
        this.i2pReceiver = i2pReceiver;
        this.peerFile = peerFile;
        this.initialPeers = Collections.synchronizedList(new ArrayList());
        this.readPeers(BUILT_IN_PEER_FILE);
        this.readPeers(peerFile);
        this.bucketManager = new BucketManager(sendQueue, this.initialPeers, localDestination.calculateHash());
        this.storageHandlers = new ConcurrentHashMap();
    }

    private Collection<Destination> getClosestNodes(Hash key) {
        ClosestNodesLookupTask lookupTask = new ClosestNodesLookupTask(key, this.sendQueue, this.i2pReceiver, this.bucketManager);
        lookupTask.run();
        return lookupTask.getResults();
    }

    public DhtStorablePacket findOne(Hash key, Class<? extends DhtStorablePacket> dataType) {
        Collection results = this.find(key, dataType, false);
        if (results.isEmpty()) {
            return null;
        }
        return (DhtStorablePacket)results.iterator().next();
    }

    public Collection<DhtStorablePacket> findAll(Hash key, Class<? extends DhtStorablePacket> dataType) {
        return this.find(key, dataType, true);
    }

    public void setStorageHandler(Class<? extends DhtStorablePacket> packetType, DhtStorageHandler storageHandler) {
        this.storageHandlers.put(packetType, storageHandler);
    }

    public int getNumPeers() {
        return this.bucketManager.getPeerCount();
    }

    private Collection<DhtStorablePacket> find(Hash key, Class<? extends DhtStorablePacket> dataType, boolean exhaustive) {
        Collection closeNodes = this.getClosestNodes(key);
        this.log.debug("Querying " + closeNodes.size() + " nodes for data type " + dataType + ", Kademlia key " + key);
        ConcurrentHashSet receivedPackets = new ConcurrentHashSet();
        PacketBatch batch = new PacketBatch();
        for (Destination node : closeNodes) {
            batch.putPacket((CommunicationPacket)new RetrieveRequest(key, dataType), node);
        }
        this.sendQueue.send(batch);
        try {
            batch.awaitSendCompletion();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for Retrieve Requests to be sent.", (Throwable)e);
        }
        try {
            if (exhaustive) {
                TimeUnit.SECONDS.sleep(60L);
            } else {
                batch.awaitFirstReply(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for responses to Retrieve Requests.", (Throwable)e);
        }
        this.log.debug(batch.getResponses().size() + " response packets received for hash " + key + " and data type " + dataType);
        this.sendQueue.remove(batch);
        ConcurrentHashSet storablePackets = this.getStorablePackets(batch);
        DhtStorablePacket localResult = this.findLocally(key, dataType);
        if (localResult != null) {
            this.log.debug("Locally stored packet found for hash " + key + " and data type " + dataType);
            storablePackets.add((Object)localResult);
        }
        return storablePackets;
    }

    private DhtStorablePacket findLocally(Hash key, Class<? extends DhtStorablePacket> dataType) {
        DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(dataType);
        if (storageHandler != null) {
            return storageHandler.retrieve(key);
        }
        return null;
    }

    private ConcurrentHashSet<DhtStorablePacket> getStorablePackets(PacketBatch batch) {
        ConcurrentHashSet storablePackets = new ConcurrentHashSet();
        for (DataPacket packet : batch.getResponses()) {
            if (!(packet instanceof DhtStorablePacket)) continue;
            storablePackets.add((Object)((DhtStorablePacket)packet));
        }
        return storablePackets;
    }

    public void store(DhtStorablePacket packet) throws NoSuchAlgorithmException {
        Hash key = packet.getDhtKey();
        Collection closeNodes = this.getClosestNodes(key);
        this.log.debug("Storing a " + packet.getClass().getSimpleName() + " with key " + key + " on " + closeNodes.size() + " nodes");
        HashCash hashCash = HashCash.mintCash((String)"", (int)1);
        StoreRequest storeRequest = new StoreRequest(hashCash, packet);
        PacketBatch batch = new PacketBatch();
        for (Destination node : closeNodes) {
            batch.putPacket((CommunicationPacket)storeRequest, node);
        }
        this.sendQueue.send(batch);
        try {
            batch.awaitSendCompletion();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for responses to Storage Requests to be sent.", (Throwable)e);
        }
        this.sendQueue.remove(batch);
    }

    public void start() {
        this.i2pReceiver.addPacketListener((PacketListener)this);
        this.bucketManager.start();
        this.bootstrap();
    }

    public void shutDown() {
        this.i2pReceiver.removePacketListener((PacketListener)this);
        this.bucketManager.requestShutdown();
        this.writePeersToFile(this.peerFile);
    }

    private void bootstrap() {
        new BootstrapTask(this).start();
    }

    private void writePeersToFile(File peerFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPeers(URL url) {
        this.log.info("Reading peers from URL: '" + url + "'");
        InputStream stream = null;
        try {
            stream = url.openStream();
            this.readPeers(stream);
        }
        catch (IOException e) {
            this.log.error("Error reading peers from URL.", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.log.error("Can't close input stream.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPeers(File peerFile) {
        this.log.info("Reading peers from file: '" + peerFile.getAbsolutePath() + "'");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(peerFile);
            this.readPeers((InputStream)stream);
        }
        catch (IOException e) {
            this.log.error("Error reading peers from file.", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    this.log.error("Can't close input stream.", (Throwable)e);
                }
            }
        }
    }

    private void readPeers(InputStream inputStream) throws IOException {
        BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(inputStream));
        int numPeersBefore = this.initialPeers.size();
        while (true) {
            String line = null;
            line = inputBuffer.readLine();
            if (line == null) break;
            if (line.startsWith("#")) continue;
            try {
                Destination destination = new Destination(line);
                KademliaPeer peer = new KademliaPeer(destination, 0L);
                if (peer.getDestinationHash().equals((Object)this.localDestinationHash)) continue;
                this.initialPeers.add(peer);
            }
            catch (DataFormatException e) {
                this.log.error("Invalid destination key in line " + line, (Throwable)e);
            }
        }
        this.log.debug(this.initialPeers.size() - numPeersBefore + " peers read.");
    }

    private void sendPeerList(FindClosePeersPacket packet, Destination destination) {
        Collection closestPeers = this.bucketManager.getClosestPeers(packet.getKey(), 2);
        PeerList peerList = new PeerList(closestPeers);
        this.sendQueue.sendResponse((DataPacket)peerList, destination, packet.getPacketId());
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof FindClosePeersPacket) {
            this.sendPeerList((FindClosePeersPacket)packet, sender);
        } else if (packet instanceof StoreRequest) {
            DhtStorablePacket packetToStore = ((StoreRequest)packet).getPacketToStore();
            if (packetToStore != null) {
                DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(packetToStore.getClass());
                if (storageHandler != null) {
                    storageHandler.store(packetToStore);
                } else {
                    this.log.warn("No storage handler found for type " + packetToStore.getClass().getSimpleName() + ".");
                }
            }
        } else if (packet instanceof RetrieveRequest) {
            RetrieveRequest retrieveRequest = (RetrieveRequest)packet;
            DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(retrieveRequest.getDataType());
            if (storageHandler != null) {
                DhtStorablePacket storedPacket = storageHandler.retrieve(retrieveRequest.getKey());
                if (storedPacket != null) {
                    this.log.debug("Packet found for retrieve request: [" + retrieveRequest + "], replying to sender: [" + sender + "]");
                    ResponsePacket response = new ResponsePacket((DataPacket)storedPacket, StatusCode.OK, retrieveRequest.getPacketId());
                    this.sendQueue.send((CommunicationPacket)response, sender);
                } else {
                    this.log.debug("No matching packet found for retrieve request: [" + retrieveRequest + "]");
                }
            } else {
                this.log.warn("No storage handler found for type " + packet.getClass().getSimpleName() + ".");
            }
        }
        this.bucketManager.packetReceived(packet, sender, receiveTime);
    }

    static /* synthetic */ Log access$000(KademliaDHT x0) {
        return x0.log;
    }

    static /* synthetic */ Collection access$100(KademliaDHT x0) {
        return x0.initialPeers;
    }

    static /* synthetic */ BucketManager access$200(KademliaDHT x0) {
        return x0.bucketManager;
    }

    static /* synthetic */ Hash access$300(KademliaDHT x0) {
        return x0.localDestinationHash;
    }

    static /* synthetic */ Collection access$400(KademliaDHT x0, Hash x1) {
        return x0.getClosestNodes(x1);
    }
}

