/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.KademliaUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KBucket
implements Iterable<KademliaPeer> {
    static final BigInteger MIN_HASH_VALUE = BigInteger.ONE.negate().shiftLeft(256);
    static final BigInteger MAX_HASH_VALUE = BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE);
    private static final int CAPACITY = 2;
    private Log log = new Log(KBucket.class);
    private BigInteger startId;
    private BigInteger endId;
    private List<KademliaPeer> peers;
    private Set<KademliaPeer> replacementCache;
    private int depth;
    private boolean replacementCacheEnabled;

    KBucket(BigInteger startId, BigInteger endId, int depth, boolean replacementCacheEnabled) {
        this.startId = startId;
        this.endId = endId;
        Comparator peerComparator = this.createLastReceptionComparator();
        this.peers = new ArrayList();
        this.replacementCache = new ConcurrentSkipListSet(peerComparator);
        this.depth = depth;
        this.replacementCacheEnabled = replacementCacheEnabled;
    }

    BigInteger getStartId() {
        return this.startId;
    }

    BigInteger getEndId() {
        return this.endId;
    }

    List<KademliaPeer> getNodes() {
        return this.peers;
    }

    void add(KademliaPeer node) {
        if (this.isFull()) {
            this.log.error("Error: adding a node to a full k-bucket. Bucket needs to be split first. Size=" + this.size() + ", capacity=" + 2);
        }
        this.peers.add(node);
    }

    synchronized KBucket addOrSplit(KademliaPeer peer) {
        if (!this.rangeContains(peer)) {
            this.log.error("Attempt to add a node whose hash is outside the bucket's range! Bucket start=" + this.startId + " Bucket end=" + this.endId + " peer hash=" + new BigInteger(peer.getDestinationHash().getData()));
        }
        if (this.isFull() && !this.contains(peer)) {
            if (this.canSplit(peer)) {
                KBucket newBucket = this.split(peer.getDestinationHash());
                if (this.rangeContains(peer)) {
                    this.add(peer);
                } else if (newBucket.rangeContains(peer)) {
                    newBucket.add(peer);
                } else {
                    this.log.error("After splitting a bucket, node is outside of both buckets' ranges.");
                }
                return newBucket;
            }
            this.replacementCache.add(peer);
            return null;
        }
        this.addOrUpdate(peer);
        return null;
    }

    private boolean canSplit(KademliaPeer peer) {
        return this.depth % 1 != 0 || this.rangeContains(peer);
    }

    boolean addOrUpdate(KademliaPeer peer) {
        KademliaPeer existingPeer = this.getPeer(peer.getDestination());
        if (existingPeer == null) {
            this.add(peer);
            return true;
        }
        existingPeer.setLastReception(peer.getLastReception());
        return false;
    }

    boolean contains(KademliaPeer peer) {
        return this.getPeer(peer.getDestination()) != null;
    }

    private boolean rangeContains(KademliaPeer peer) {
        BigInteger peerHash = new BigInteger(peer.getDestinationHash().getData());
        return this.startId.compareTo(peerHash) <= 0 || this.endId.compareTo(peerHash) > 0;
    }

    KademliaPeer getPeer(Destination destination) {
        for (KademliaPeer peer : this.peers) {
            if (!peer.getDestination().equals((Object)destination)) continue;
            return peer;
        }
        return null;
    }

    KademliaPeer getClosestPeer(Hash key) {
        KademliaPeer closestPeer = null;
        BigInteger minDistance = MAX_HASH_VALUE;
        for (KademliaPeer peer : this.peers) {
            BigInteger distance = KademliaUtil.getDistance((Hash)key, (Hash)peer.getDestination().calculateHash());
            if (distance.compareTo(minDistance) >= 0) continue;
            closestPeer = peer;
            minDistance = distance;
        }
        return closestPeer;
    }

    KademliaPeer getMostDistantPeer(Hash key) {
        KademliaPeer mostDistantPeer = null;
        BigInteger maxDistance = BigInteger.ZERO;
        for (KademliaPeer peer : this.peers) {
            BigInteger distance = KademliaUtil.getDistance((Hash)key, (Hash)peer.getDestination().calculateHash());
            if (distance.compareTo(maxDistance) <= 0) continue;
            mostDistantPeer = peer;
            maxDistance = distance;
        }
        return mostDistantPeer;
    }

    @Override
    public Iterator<KademliaPeer> iterator() {
        return this.peers.iterator();
    }

    void remove(Destination destination) {
        this.peers.remove(this.getPeer(destination));
    }

    void remove(KademliaPeer node) {
        this.peers.remove(node);
    }

    int size() {
        return this.peers.size();
    }

    boolean isFull() {
        return this.size() >= 2;
    }

    KBucket split() {
        ++this.depth;
        KBucket newBucket = new KBucket(this.startId, this.endId, this.depth, this.replacementCacheEnabled);
        for (int i = 0; i < this.peers.size() / 2; ++i) {
            KademliaPeer peer = (KademliaPeer)this.peers.get(i);
            newBucket.add(peer);
            this.remove(peer);
        }
        return newBucket;
    }

    KBucket split(Hash hash) {
        return this.split(new BigInteger(hash.toBase64()));
    }

    KBucket split(BigInteger pivot) {
        ++this.depth;
        KBucket newBucket = new KBucket(this.startId, pivot.subtract(BigInteger.ONE), this.depth, this.replacementCacheEnabled);
        this.startId = pivot;
        for (KademliaPeer peer : this.peers) {
            BigInteger nodeId = new BigInteger(peer.getDestination().calculateHash().getData());
            if (nodeId.compareTo(pivot) < 0) continue;
            newBucket.add(peer);
            this.remove(peer);
        }
        return newBucket;
    }

    private Comparator<KademliaPeer> createLastReceptionComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

