/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.ClosestNodesLookupTask;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosestNodesLookupTask
implements Runnable {
    private static final int REQUEST_TIMEOUT = 30000;
    private static final int CLOSEST_NODES_LOOKUP_TIMEOUT = 120000;
    private Log log = new Log(ClosestNodesLookupTask.class);
    private Hash key;
    private I2PPacketDispatcher i2pReceiver;
    private BucketManager bucketManager;
    private Random randomNumberGenerator;
    private I2PSendQueue sendQueue;
    private Set<Destination> responseReceived;
    private Set<KademliaPeer> notQueriedYet;
    private Set<FindClosePeersPacket> pendingRequests;

    public ClosestNodesLookupTask(Hash key, I2PSendQueue sendQueue, I2PPacketDispatcher i2pReceiver, BucketManager bucketManager) {
        this.key = key;
        this.sendQueue = sendQueue;
        this.i2pReceiver = i2pReceiver;
        this.bucketManager = bucketManager;
        this.randomNumberGenerator = new Random(this.getTime());
        this.responseReceived = new TreeSet(new HashDistanceComparator(this, key));
        this.notQueriedYet = new ConcurrentHashSet();
        this.pendingRequests = new ConcurrentHashSet();
    }

    @Override
    public void run() {
        IncomingPacketHandler packetListener;
        block5: {
            this.log.debug("Looking up nodes closest to " + this.key);
            packetListener = new IncomingPacketHandler(this, null);
            this.i2pReceiver.addPacketListener((PacketListener)packetListener);
            this.notQueriedYet.addAll(this.bucketManager.getClosestPeers(this.key, 3));
            long startTime = this.getTime();
            while (true) {
                if (this.pendingRequests.size() < 3 && !this.notQueriedYet.isEmpty()) {
                    KademliaPeer peer = this.selectRandom((Collection)this.notQueriedYet);
                    this.notQueriedYet.remove(peer);
                    FindClosePeersPacket packet = new FindClosePeersPacket(this.key);
                    this.pendingRequests.add(packet);
                    try {
                        CommunicationPacket response = this.sendQueue.sendAndWait((CommunicationPacket)packet, peer.getDestination(), 30000L);
                        if (response == null) {
                            peer.incrementStaleCounter();
                            continue;
                        }
                        peer.resetStaleCounter();
                    }
                    catch (InterruptedException e) {
                        this.log.warn("Interrupted while waiting on a lookup request.", (Throwable)e);
                    }
                    continue;
                }
                if (this.responseReceived.size() >= 3) break block5;
                if (this.hasTimedOut(startTime, 120000L)) break;
            }
            this.log.error("Lookup for closest nodes timed out.");
        }
        this.log.debug(this.responseReceived.size() + " nodes found.");
        this.i2pReceiver.removePacketListener((PacketListener)packetListener);
    }

    private KademliaPeer selectRandom(Collection<KademliaPeer> collection) {
        KademliaPeer[] array = new KademliaPeer[collection.size()];
        int index = this.randomNumberGenerator.nextInt(array.length);
        return collection.toArray(array)[index];
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private boolean hasTimedOut(long startTime, long timeout) {
        return this.getTime() > startTime + timeout;
    }

    public List<Destination> getResults() {
        List<Object> resultsList = new ArrayList<Destination>();
        for (Destination destination : this.responseReceived) {
            resultsList.add(destination);
        }
        Collections.sort(resultsList, new HashDistanceComparator(this, this.key));
        if (resultsList.size() > 3) {
            resultsList = resultsList.subList(0, 3);
        }
        return resultsList;
    }

    private boolean contains(Set<KademliaPeer> peerSet, KademliaPeer peerToFind) {
        Hash peerHash = peerToFind.getDestinationHash();
        for (KademliaPeer peer : peerSet) {
            if (!peer.getDestinationHash().equals((Object)peerHash)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Log access$100(ClosestNodesLookupTask x0) {
        return x0.log;
    }

    static /* synthetic */ Set access$200(ClosestNodesLookupTask x0) {
        return x0.pendingRequests;
    }

    static /* synthetic */ Set access$300(ClosestNodesLookupTask x0) {
        return x0.responseReceived;
    }

    static /* synthetic */ Set access$400(ClosestNodesLookupTask x0) {
        return x0.notQueriedYet;
    }

    static /* synthetic */ boolean access$500(ClosestNodesLookupTask x0, Set x1, KademliaPeer x2) {
        return x0.contains(x1, x2);
    }
}

