/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.KBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.KademliaUtil;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.service.I2PBoteThread;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BucketManager
extends I2PBoteThread
implements PacketListener {
    private static final int INTERVAL = 300000;
    private static final int PING_TIMEOUT = 20000;
    private Log log = new Log(BucketManager.class);
    private I2PSendQueue sendQueue;
    private List<KBucket> kBuckets;
    private KBucket siblingBucket;
    private Hash localDestinationHash;

    public BucketManager(I2PSendQueue sendQueue, Collection<KademliaPeer> initialPeers, Hash localDestinationHash) {
        super("BucketMgr");
        this.sendQueue = sendQueue;
        this.localDestinationHash = localDestinationHash;
        this.kBuckets = Collections.synchronizedList(new ArrayList());
        this.kBuckets.add(new KBucket(KBucket.MIN_HASH_VALUE, KBucket.MAX_HASH_VALUE, 0, true));
        this.siblingBucket = new KBucket(KBucket.MIN_HASH_VALUE, KBucket.MAX_HASH_VALUE, 0, false);
        this.addAll(initialPeers);
    }

    public void addAll(Collection<KademliaPeer> nodes) {
        for (KademliaPeer node : nodes) {
            this.addOrUpdate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(KademliaPeer peer) {
        Hash peerHash = peer.getDestinationHash();
        this.log.debug("Adding/updating peer: Hash = " + peerHash);
        peer.resetStaleCounter();
        BucketManager bucketManager = this;
        synchronized (bucketManager) {
            if (!this.siblingBucket.isFull() || this.siblingBucket.contains(peer)) {
                this.siblingBucket.addOrUpdate(peer);
                this.getBucket(peerHash).remove(peer);
            } else if (this.isCloserSibling(peer)) {
                KademliaPeer ejectedPeer = this.siblingBucket.getMostDistantPeer(this.localDestinationHash);
                this.addToBucket(ejectedPeer);
                this.siblingBucket.remove(ejectedPeer);
                this.siblingBucket.addOrUpdate(peer);
                this.getBucket(peerHash).remove(peer);
            } else {
                this.addToBucket(peer);
            }
        }
        this.logBucketStats();
    }

    private void logBucketStats() {
        int numBuckets = this.kBuckets.size();
        int numPeers = this.getAllPeers().size();
        this.log.debug("#buckets=" + numBuckets + "+sibBkt, #peers=" + numPeers);
    }

    private void addToBucket(KademliaPeer peer) {
        Hash nodeHash = peer.getDestinationHash();
        KBucket bucket = this.getBucket(nodeHash);
        KBucket newBucket = bucket.addOrSplit(peer);
        if (newBucket != null) {
            this.kBuckets.add(newBucket);
        }
    }

    private boolean isCloserSibling(KademliaPeer peer) {
        BigInteger peerDistance = KademliaUtil.getDistance((KademliaPeer)peer, (Hash)this.localDestinationHash);
        for (KademliaPeer sibling : this.siblingBucket) {
            BigInteger siblingDistance = KademliaUtil.getDistance((Hash)sibling.getDestinationHash(), (Hash)this.localDestinationHash);
            if (peerDistance.compareTo(siblingDistance) >= 0) continue;
            return true;
        }
        return false;
    }

    public void remove(KademliaPeer peer) {
        Hash nodeHash = peer.getDestinationHash();
        this.getBucket(nodeHash).remove(peer);
    }

    private int getBucketIndex(Hash key) {
        int lowEnd = 0;
        int highEnd = this.kBuckets.size();
        BigInteger keyValue = new BigInteger(key.getData());
        while (lowEnd < highEnd) {
            int centerIndex = (highEnd + lowEnd) / 2;
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getStartId()) < 0) {
                highEnd = centerIndex;
                continue;
            }
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getEndId()) > 0) {
                lowEnd = centerIndex;
                continue;
            }
            return centerIndex;
        }
        this.log.error("This should never happen! No k-bucket found for hash: " + key);
        return -1;
    }

    private KBucket getBucket(Hash key) {
        return (KBucket)this.kBuckets.get(this.getBucketIndex(key));
    }

    public Collection<KademliaPeer> getClosestPeers(Hash key, int count) {
        ConcurrentHashSet closestPeers = new ConcurrentHashSet();
        KademliaPeer[] allPeers = this.getAllPeersSortedByDistance(key);
        for (int i = 0; i < count && i < allPeers.length; ++i) {
            closestPeers.add(allPeers[i]);
        }
        return closestPeers;
    }

    private KademliaPeer[] getAllPeersSortedByDistance(Hash key) {
        List allPeers = this.getAllPeers();
        KademliaPeer[] peerArray = this.getAllPeers().toArray(new KademliaPeer[allPeers.size()]);
        Arrays.sort(peerArray, new PeerDistanceComparator(this, key));
        return peerArray;
    }

    private List<KademliaPeer> getAllPeers() {
        ArrayList<KademliaPeer> allPeers = new ArrayList<KademliaPeer>();
        for (KBucket bucket : this.kBuckets) {
            allPeers.addAll(bucket.getNodes());
        }
        allPeers.addAll(this.siblingBucket.getNodes());
        return allPeers;
    }

    public List<KademliaPeer> getSiblings() {
        ArrayList<KademliaPeer> siblingDestinations = new ArrayList<KademliaPeer>();
        for (KademliaPeer sibling : this.siblingBucket) {
            siblingDestinations.add(sibling);
        }
        return siblingDestinations;
    }

    public int getPeerCount() {
        int count = 0;
        for (KBucket bucket : this.kBuckets) {
            count += bucket.size();
        }
        return count += this.siblingBucket.size();
    }

    public void refreshAll() {
        for (KBucket bucket : this.kBuckets) {
            this.refresh(bucket);
        }
    }

    private void refresh(KBucket bucket) {
        byte[] randomHash = new byte[32];
        for (int i = 0; i < 32; ++i) {
            randomHash[i] = (byte)RandomSource.getInstance().nextInt(256);
        }
        Hash key = new Hash(randomHash);
        this.getClosestPeers(key, 2);
    }

    public void run() {
        while (!this.shutdownRequested()) {
            try {
                BucketManager.sleep((long)300000L);
            }
            catch (InterruptedException e) {
                this.log.debug("Thread '" + this.getName() + "' + interrupted", (Throwable)e);
            }
        }
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        this.addOrUpdate(new KademliaPeer(sender, receiveTime));
    }
}

