/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import com.nettgryppa.security.HashCash;
import i2p.bote.UniqueId;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketBatch;
import i2p.bote.network.PacketBatchItem;
import i2p.bote.network.PacketListener;
import i2p.bote.network.SendQueuePacketListener;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.I2PBotePacket;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.RelayRequest;
import i2p.bote.packet.ResponsePacket;
import i2p.bote.packet.StatusCode;
import i2p.bote.service.I2PBoteThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.data.Destination;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class I2PSendQueue
extends I2PBoteThread
implements PacketListener {
    private Log log = new Log(I2PSendQueue.class);
    private I2PSession i2pSession;
    private PacketQueue packetQueue;
    private Map<UniqueId, ScheduledPacket> outstandingRequests;
    private Set<PacketBatch> runningBatches;
    private int maxBandwidth;
    private Collection<SendQueuePacketListener> sendQueueListeners;
    private Map<SendQueuePacketListener, Long> timeoutValues;

    public I2PSendQueue(I2PSession i2pSession, I2PPacketDispatcher i2pReceiver) {
        super("I2PSendQueue");
        this.i2pSession = i2pSession;
        i2pReceiver.addPacketListener((PacketListener)this);
        this.packetQueue = new PacketQueue(this, null);
        this.outstandingRequests = new ConcurrentHashMap();
        this.runningBatches = new ConcurrentHashSet();
        this.sendQueueListeners = Collections.synchronizedCollection(new ArrayList());
        this.timeoutValues = new HashMap();
    }

    public void send(CommunicationPacket packet, Destination destination) {
        this.send(packet, destination, 0L);
    }

    public CommunicationPacket sendAndWait(CommunicationPacket packet, Destination destination, long timeoutMilliSeconds) throws InterruptedException {
        ScheduledPacket scheduledPacket = new ScheduledPacket(this, packet, destination, 0L);
        long scheduleTime = System.currentTimeMillis();
        this.packetQueue.add((Object)scheduledPacket);
        scheduledPacket.awaitSending();
        this.outstandingRequests.put(packet.getPacketId(), scheduledPacket);
        scheduledPacket.awaitResponse(timeoutMilliSeconds, TimeUnit.MILLISECONDS);
        if (this.log.shouldLog(10)) {
            long responseTime = scheduledPacket.getResponseTime();
            String responseInfo = responseTime < 0L ? "timed out" : "took " + (responseTime - scheduledPacket.getSentTime()) + "ms.";
            this.log.debug("Packet with id " + packet.getPacketId() + " was queued for " + (scheduledPacket.getSentTime() - scheduleTime) + " ms, response " + responseInfo);
        }
        return scheduledPacket.getResponse();
    }

    public void send(CommunicationPacket packet, Destination destination, long earliestSendTime) {
        this.packetQueue.add((Object)new ScheduledPacket(this, packet, destination, earliestSendTime));
    }

    public void sendRelayRequest(RelayPacket relayPacket, HashCash hashCash, long earliestSendTime) {
        RelayRequest relayRequest = new RelayRequest(hashCash, (DataPacket)relayPacket);
        ScheduledPacket scheduledPacket = new ScheduledPacket(this, (CommunicationPacket)relayRequest, relayPacket.getNextDestination(), earliestSendTime);
        this.packetQueue.add((Object)scheduledPacket);
    }

    public void sendResponse(DataPacket packet, Destination destination, UniqueId requestPacketId) {
        this.sendResponse(packet, destination, StatusCode.OK, requestPacketId);
    }

    public void sendResponse(DataPacket packet, Destination destination, StatusCode statusCode, UniqueId requestPacketId) {
        this.send((CommunicationPacket)new ResponsePacket(packet, statusCode, requestPacketId), destination);
    }

    public void send(PacketBatch batch) {
        this.log.debug("Adding a batch containing " + batch.getPacketCount() + " packets.");
        this.runningBatches.add(batch);
        batch.initializeSentSignal();
        for (PacketBatchItem batchItem : batch) {
            ScheduledPacket scheduledPacket = new ScheduledPacket(this, batchItem.getPacket(), batchItem.getDestination(), 0L, batch);
            this.packetQueue.add((Object)scheduledPacket);
        }
    }

    public void remove(PacketBatch batch) {
        this.runningBatches.remove(batch);
    }

    public int getQueueLength() {
        return this.packetQueue.size();
    }

    public void setMaxBandwidth(int maxBandwidth) {
        this.maxBandwidth = maxBandwidth;
    }

    public int getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public void addSendQueueListener(SendQueuePacketListener listener) {
        this.addSendQueueListener(listener, null);
    }

    public void addSendQueueListener(SendQueuePacketListener listener, Long timeout) {
        this.sendQueueListeners.add(listener);
        this.timeoutValues.put(listener, timeout);
    }

    public void removeSendQueueListener(SendQueuePacketListener listener) {
        this.sendQueueListeners.remove(listener);
        this.timeoutValues.remove(listener);
    }

    private void firePacketListeners(CommunicationPacket packet) {
        for (SendQueuePacketListener listener : this.sendQueueListeners) {
            listener.packetSent((I2PBotePacket)packet);
        }
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof ResponsePacket) {
            this.log.debug("Response Packet received: Packet Id = " + packet.getPacketId() + " Sender = " + sender);
            UniqueId packetId = packet.getPacketId();
            for (PacketBatch batch : this.runningBatches) {
                if (!batch.contains(packetId)) continue;
                batch.addResponse(((ResponsePacket)packet).getPayload());
            }
            ScheduledPacket requestPacket = (ScheduledPacket)this.outstandingRequests.remove(packetId);
            if (requestPacket != null) {
                requestPacket.setResponse(packet);
                requestPacket.decrementResponseLatch();
            }
        }
    }

    public void run() {
        I2PDatagramMaker datagramMaker = new I2PDatagramMaker(this.i2pSession);
        while (true) {
            PacketBatch batch;
            ScheduledPacket scheduledPacket;
            try {
                scheduledPacket = this.packetQueue.take();
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting for new packets.", (Throwable)e);
                break;
            }
            CommunicationPacket i2pBotePacket = scheduledPacket.data;
            if (this.maxBandwidth > 0) {
                int packetSizeBits = i2pBotePacket.getSize() * 8;
                int maxBWBitsPerSecond = this.maxBandwidth * 1024;
                long waitTimeMsecs = 1000L * (long)packetSizeBits / (long)maxBWBitsPerSecond;
                if (System.currentTimeMillis() + waitTimeMsecs < scheduledPacket.earliestSendTime) {
                    waitTimeMsecs = scheduledPacket.earliestSendTime;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(waitTimeMsecs);
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted while waiting to send packet.", (Throwable)e);
                }
            }
            boolean isBatchPacket = (batch = scheduledPacket.batch) != null;
            this.log.debug("Sending " + (isBatchPacket ? "" : "non-") + "batch packet: [" + i2pBotePacket + "] to peer: " + scheduledPacket.destination.toBase64());
            byte[] replyableDatagram = datagramMaker.makeI2PDatagram(i2pBotePacket.toByteArray());
            try {
                this.i2pSession.sendMessage(scheduledPacket.destination, replyableDatagram);
                scheduledPacket.data.setSentTime(System.currentTimeMillis());
                this.packetQueue.remove((Object)scheduledPacket);
                if (isBatchPacket) {
                    batch.decrementSentLatch();
                }
                scheduledPacket.decrementSentLatch();
                this.firePacketListeners(scheduledPacket.data);
                this.log.debug("Packet sent. Send queue length is now " + this.packetQueue.size());
                if (!isBatchPacket) continue;
                this.log.debug("  Batch has " + batch.getPacketCount() + " packets total, " + batch.getUnsentPacketCount() + " waiting to be sent.");
            }
            catch (I2PSessionException sessExc) {
                this.log.error("Can't send packet.", (Throwable)sessExc);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException intrExc) {
                    this.log.error("Interrupted while sleeping after a send error.", (Throwable)intrExc);
                }
            }
        }
    }
}

