/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import i2p.bote.network.PacketListener;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.I2PBotePacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class I2PPacketDispatcher
implements I2PSessionListener {
    private Log log = new Log(I2PPacketDispatcher.class);
    private List<PacketListener> packetListeners = Collections.synchronizedList(new ArrayList());

    public void addPacketListener(PacketListener listener) {
        this.packetListeners.add(listener);
    }

    public void removePacketListener(PacketListener listener) {
        this.packetListeners.remove(listener);
    }

    private void firePacketReceivedEvent(CommunicationPacket packet, Destination sender) {
        for (PacketListener listener : this.packetListeners) {
            listener.packetReceived(packet, sender, System.currentTimeMillis());
        }
    }

    public void shutDown() {
    }

    public void reportAbuse(I2PSession session, int severity) {
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        byte[] msg = new byte[]{};
        try {
            msg = session.receiveMessage(msgId);
        }
        catch (I2PSessionException e) {
            this.log.error("Can't get new message from I2PSession.", (Throwable)e);
        }
        I2PDatagramDissector datagramDissector = new I2PDatagramDissector();
        try {
            datagramDissector.loadI2PDatagram(msg);
            datagramDissector.verifySignature();
            byte[] payload = datagramDissector.extractPayload();
            Destination sender = datagramDissector.getSender();
            CommunicationPacket packet = CommunicationPacket.createPacket((byte[])payload);
            if (packet == null) {
                this.log.debug("Ignoring unparseable packet.");
            } else {
                this.logPacket((I2PBotePacket)packet, sender);
                this.firePacketReceivedEvent(packet, sender);
            }
        }
        catch (DataFormatException e) {
            this.log.error("Invalid datagram received.", (Throwable)e);
            e.printStackTrace();
        }
        catch (I2PInvalidDatagramException e) {
            this.log.error("Datagram failed verification.", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void logPacket(I2PBotePacket packet, Destination sender) {
        String senderHash = sender.calculateHash().toBase64().substring(0, 8) + "...";
        this.log.debug("I2P packet received: [" + packet + "] Sender: [" + senderHash + "]");
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        this.log.error("Router says: " + message, error);
    }

    public void disconnected(I2PSession session) {
        this.log.warn("I2P session disconnected.");
    }
}

