/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import i2p.bote.Util;
import i2p.bote.email.EmailIdentity;
import i2p.bote.folder.IncompleteEmailFolder;
import i2p.bote.network.CheckEmailTask;
import i2p.bote.network.DHT;
import i2p.bote.network.PeerManager;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEmailTask
implements Callable<Boolean> {
    public static final int THREAD_STACK_SIZE = 65536;
    private static final int MAX_THREADS = 50;
    private static final ThreadFactory EMAIL_PACKET_TASK_THREAD_FACTORY = Util.createThreadFactory((String)"EmailPktTask", (int)65536);
    private Log log = new Log(CheckEmailTask.class);
    private EmailIdentity identity;
    private DHT dht;
    private PeerManager peerManager;
    private IncompleteEmailFolder incompleteEmailFolder;
    private I2PAppContext appContext;
    private ExecutorService executor;

    public CheckEmailTask(EmailIdentity identity, DHT dht, PeerManager peerManager, IncompleteEmailFolder incompleteEmailFolder, I2PAppContext appContext) {
        this.identity = identity;
        this.dht = dht;
        this.peerManager = peerManager;
        this.incompleteEmailFolder = incompleteEmailFolder;
        this.appContext = appContext;
        this.executor = Executors.newFixedThreadPool(50, EMAIL_PACKET_TASK_THREAD_FACTORY);
    }

    @Override
    public Boolean call() {
        Collection emailPacketKeys = this.findEmailPacketKeys();
        ArrayList results = new ArrayList();
        for (Hash dhtKey : emailPacketKeys) {
            Future result = this.executor.submit(new EmailPacketTask(this, dhtKey));
            results.add(result);
        }
        boolean newEmail = false;
        for (Future result : results) {
            try {
                if (!((Boolean)result.get()).booleanValue()) continue;
                newEmail = true;
            }
            catch (ExecutionException e) {
                this.log.error("Can't retrieve email packet.", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error("Interrupted while checking for mail.", (Throwable)e);
            }
        }
        return newEmail;
    }

    private Collection<Hash> findEmailPacketKeys() {
        this.log.debug("Querying the DHT for index packets with key " + this.identity.getHash());
        Collection packets = this.dht.findAll(this.identity.getHash(), IndexPacket.class);
        ArrayList<IndexPacket> indexPackets = new ArrayList<IndexPacket>();
        for (DhtStorablePacket packet : packets) {
            if (packet instanceof IndexPacket) {
                indexPackets.add((IndexPacket)packet);
                continue;
            }
            this.log.error("DHT returned packet of class " + packet.getClass().getSimpleName() + ", expected IndexPacket.");
        }
        IndexPacket mergedPacket = new IndexPacket(indexPackets);
        this.log.debug("Found " + mergedPacket.getDhtKeys().size() + " Email Packet keys.");
        return mergedPacket.getDhtKeys();
    }

    static /* synthetic */ DHT access$000(CheckEmailTask x0) {
        return x0.dht;
    }

    static /* synthetic */ EmailIdentity access$100(CheckEmailTask x0) {
        return x0.identity;
    }

    static /* synthetic */ I2PAppContext access$200(CheckEmailTask x0) {
        return x0.appContext;
    }

    static /* synthetic */ IncompleteEmailFolder access$300(CheckEmailTask x0) {
        return x0.incompleteEmailFolder;
    }

    static /* synthetic */ Log access$400(CheckEmailTask x0) {
        return x0.log;
    }
}

