/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.UniqueId;
import i2p.bote.folder.Folder;
import i2p.bote.packet.DataPacket;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketFolder<PacketType extends DataPacket>
extends Folder<PacketType> {
    protected static final String PACKET_FILE_EXTENSION = ".pkt";
    private Log log = new Log(PacketFolder.class);

    public PacketFolder(File storageDir) {
        super(storageDir, PACKET_FILE_EXTENSION);
    }

    public <T extends PacketType> void add(T packetToStore) {
        String filename = new UniqueId().toBase64() + PACKET_FILE_EXTENSION;
        this.add(packetToStore, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(DataPacket packetToStore, String filename) {
        FileOutputStream outputStream = null;
        try {
            File file = new File(this.storageDir, filename);
            outputStream = new FileOutputStream(file);
            packetToStore.writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            this.log.error("Can't save packet to file: <" + filename + ">", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error("Can't close file: <" + filename + ">", (Throwable)e);
                }
            }
        }
    }

    public void delete(UniqueId packetId) {
    }

    protected PacketType createFolderElement(File file) throws Exception {
        return (PacketType)DataPacket.createPacket((File)file);
    }
}

