/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.folder.FolderElement;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Folder<T extends FolderElement>
implements Iterable<T> {
    private Log log = new Log(Folder.class);
    protected File storageDir;
    protected String fileExtension;

    protected Folder(File storageDir, String fileExtension) {
        this.storageDir = storageDir;
        this.fileExtension = fileExtension;
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            this.log.error("Can't create directory: '" + storageDir + "'");
        }
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public Collection<T> getElements() {
        ArrayList elements = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        return elements;
    }

    @Override
    public final Iterator<T> iterator() {
        File[] files = this.storageDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (files == null) {
            this.log.error("Cannot list files in directory <" + this.storageDir + ">");
        } else {
            this.log.debug(files.length + " files with the extension '" + this.fileExtension + "' found in '" + this.storageDir + "'.");
        }
        Arrays.sort(files, new /* Unavailable Anonymous Inner Class!! */);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected abstract T createFolderElement(File var1) throws Exception;

    static /* synthetic */ Log access$000(Folder x0) {
        return x0.log;
    }
}

