/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.email.Email;
import i2p.bote.email.MessageId;
import i2p.bote.folder.Folder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailFolder
extends Folder<Email> {
    protected static final String EMAIL_FILE_EXTENSION = ".mail";
    private Log log = new Log(EmailFolder.class);

    public EmailFolder(File storageDir) {
        super(storageDir, EMAIL_FILE_EXTENSION);
    }

    public void add(Email email) throws IOException {
        File emailFile = this.getEmailFile(email);
        this.log.info("Storing email in outbox: '" + emailFile.getAbsolutePath() + "'");
        FileOutputStream emailOutputStream = new FileOutputStream(emailFile);
        email.writeTo((OutputStream)emailOutputStream);
        ((OutputStream)emailOutputStream).close();
    }

    public Email getEmail(String messageIdString) {
        MessageId messageId = new MessageId(messageIdString);
        File file = this.getEmailFile(messageId);
        try {
            return this.createFolderElement(file);
        }
        catch (Exception e) {
            this.log.error("Can't read email from file: <" + file.getAbsolutePath() + ">", (Throwable)e);
            return null;
        }
    }

    private File getEmailFile(Email email) {
        return this.getEmailFile(email.getMessageID());
    }

    private File getEmailFile(MessageId messageId) {
        return new File(this.storageDir, messageId.toBase64() + EMAIL_FILE_EXTENSION);
    }

    public void delete(Email email) {
        if (!this.getEmailFile(email).delete()) {
            this.log.error("Cannot delete file: '" + this.getEmailFile(email) + "'");
        }
    }

    protected Email createFolderElement(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        return new Email((InputStream)inputStream);
    }
}

