/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.folder.PacketFolder;
import i2p.bote.network.DhtStorageHandler;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.File;
import java.io.FilenameFilter;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DhtPacketFolder<T extends DhtStorablePacket>
extends PacketFolder<T>
implements DhtStorageHandler {
    private Log log = new Log(DhtPacketFolder.class);

    public DhtPacketFolder(File storageDir) {
        super(storageDir);
    }

    public void store(DhtStorablePacket packetToStore) {
        this.add((DataPacket)packetToStore, this.getFilename(packetToStore));
    }

    private String getFilename(DhtStorablePacket packet) {
        return packet.getDhtKey().toBase64() + ".pkt";
    }

    public DhtStorablePacket retrieve(Hash dhtKey) {
        String base64Key = dhtKey.toBase64();
        File[] files = this.storageDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (files.length > 1) {
            this.log.warn("More than one packet files found for DHT key " + dhtKey);
        }
        if (files.length > 0) {
            File file = files[0];
            return DhtStorablePacket.createPacket((File)file);
        }
        return null;
    }

    protected boolean filenameMatches(String filename, String base64DhtKey) {
        return filename.startsWith(base64DhtKey);
    }
}

