/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.email;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class EmailDestination {
    private Log log = new Log(EmailDestination.class);
    private PublicKey publicEncryptionKey;
    private SigningPublicKey publicSigningKey;

    public EmailDestination() {
        try {
            I2PClient i2pClient = I2PClientFactory.createClient();
            ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
            i2pClient.createDestination((OutputStream)arrayStream);
            byte[] destinationArray = arrayStream.toByteArray();
            I2PSession i2pSession = i2pClient.createSession((InputStream)new ByteArrayInputStream(destinationArray), null);
            this.initKeys(i2pSession);
        }
        catch (Exception e) {
            this.log.error("Can't generate EmailDestination.", (Throwable)e);
        }
    }

    public EmailDestination(ByteBuffer buffer) {
        byte[] encryptionKeyArray = new byte[256];
        buffer.get(encryptionKeyArray);
        this.publicEncryptionKey = new PublicKey(encryptionKeyArray);
        byte[] signingKeyArray = new byte[128];
        buffer.get(signingKeyArray);
        this.publicSigningKey = new SigningPublicKey(signingKeyArray);
    }

    public EmailDestination(String base64Data) {
        try {
            base64Data = base64Data + "AAAA";
            Destination i2pDestination = new Destination(base64Data);
            this.publicEncryptionKey = i2pDestination.getPublicKey();
            this.publicSigningKey = i2pDestination.getSigningPublicKey();
        }
        catch (DataFormatException e) {
            this.log.error("Can't generate EmailDestination.", (Throwable)e);
        }
    }

    protected void initKeys(I2PSession i2pSession) {
        this.publicEncryptionKey = i2pSession.getMyDestination().getPublicKey();
        this.publicSigningKey = i2pSession.getMyDestination().getSigningPublicKey();
    }

    public PublicKey getPublicEncryptionKey() {
        return this.publicEncryptionKey;
    }

    public SigningPublicKey getPublicSigningKey() {
        return this.publicSigningKey;
    }

    private byte[] getKeysAsArray() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            this.writeTo((OutputStream)byteStream);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    private void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.publicEncryptionKey.writeBytes(outputStream);
            this.publicSigningKey.writeBytes(outputStream);
        }
        catch (DataFormatException e) {
            this.log.error("Invalid encryption key or signing key.", (Throwable)e);
        }
    }

    public Hash getHash() {
        return SHA256Generator.getInstance().calculateHash(this.getKeysAsArray());
    }

    public String getKey() {
        return Base64.encode((byte[])this.getKeysAsArray());
    }

    public String toBase64() {
        return this.getKey();
    }

    public String toString() {
        return this.getKey();
    }
}

