/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.email;

import com.nettgryppa.security.HashCash;
import i2p.bote.UniqueId;
import i2p.bote.Util;
import i2p.bote.email.Email;
import i2p.bote.email.MessageId;
import i2p.bote.email.RecipientType;
import i2p.bote.folder.FolderElement;
import i2p.bote.packet.UnencryptedEmailPacket;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
implements FolderElement {
    private static final int MAX_BYTES_PER_PACKET = 30720;
    private static final char[] NEW_LINE = new char[]{'\r', '\n'};
    private static final Set<String> HEADER_WHITELIST = Email.createHeaderWhitelist();
    private static Log log = new Log(Email.class);
    private File file;
    private List<Header> headers;
    private byte[] content;
    private MessageId messageId;

    public Email() {
        this.headers = Collections.synchronizedList(new ArrayList());
        this.content = new byte[0];
        this.messageId = new MessageId();
    }

    public Email(InputStream inputStream) throws IOException {
        this(Util.readInputStream((InputStream)inputStream));
    }

    public Email(byte[] bytes) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
        this.headers = Collections.synchronizedList(new ArrayList());
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        boolean allHeadersRead = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line)) {
                    allHeadersRead = true;
                    continue;
                }
                if (!allHeadersRead) {
                    String[] splitString = line.split(":\\s*", 2);
                    if (splitString.length > 1) {
                        String name = splitString[0];
                        String value = splitString[1];
                        if (HEADER_WHITELIST.contains(name)) {
                            this.headers.add(new Header(this, name, value));
                        }
                    } else {
                        allHeadersRead = true;
                    }
                }
                if (!allHeadersRead) continue;
                contentStream.write(line.getBytes());
            }
        }
        catch (IOException e) {
            log.error("Can't read from ByteArrayInputStream.", (Throwable)e);
        }
        this.content = contentStream.toByteArray();
        String messageIdString = this.getHeader("Message-Id");
        if (messageIdString != null) {
            this.messageId = new MessageId(messageIdString);
        }
    }

    private static Set<String> createHeaderWhitelist() {
        String[] headerArray = new String[]{"From", "Sender", "To", "CC", "BCC", "Reply-To", "Subject", "Date", "MIME-Version", "Content-Type", "Content-Transfer-Encoding", "Message-Id", "In-Reply-To", "X-HashCash"};
        ConcurrentHashSet headerSet = new ConcurrentHashSet();
        headerSet.addAll(Arrays.asList(headerArray));
        return headerSet;
    }

    public void setHashCash(HashCash hashCash) {
        this.setHeader("X-HashCash", hashCash.toString());
    }

    public void setHeader(String name, String value) {
        for (Header header : this.headers) {
            if (!name.equals(header.name)) continue;
            this.headers.remove(header);
        }
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (HEADER_WHITELIST.contains(name)) {
            this.headers.add(new Header(this, name, value));
        } else {
            log.debug("Ignoring non-whitelisted header: " + name);
        }
    }

    public void setSender(String sender) {
        this.setHeader("Sender", sender);
    }

    public String getSender() {
        String sender = this.getHeader("From");
        if (sender != null) {
            return sender;
        }
        sender = this.getHeader("Sender");
        return sender;
    }

    public void setSubject(String subject) {
        this.setHeader("Subject", subject);
    }

    public String getSubject() {
        return this.getHeader("Subject");
    }

    public Collection<String> getAllRecipients() {
        ArrayList<String> recipients = new ArrayList<String>();
        for (Header header : this.headers) {
            if (!this.isRecipient(header.name)) continue;
            recipients.add(header.value);
        }
        return recipients;
    }

    private boolean isRecipient(String headerName) {
        return RecipientType.TO.equalsString(headerName) || RecipientType.CC.equalsString(headerName) || RecipientType.BCC.equalsString(headerName);
    }

    public void addRecipient(RecipientType type, String address) {
        this.addHeader(type.toString(), address);
    }

    public void updateHeaders() {
        this.setHeader("Content-Type", "text/plain");
        this.setHeader("Content-Transfer-Encoding", "7bit");
        this.setHeader("Message-Id", this.messageId.getEmailMessageId());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT+0"));
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss +0000", Locale.ENGLISH);
        this.setHeader("Date", formatter.format(calendar.getTime()));
    }

    public String getDateString() {
        return this.getHeader("Date");
    }

    public Date getDate() {
        try {
            return this.parseDate(this.getDateString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date parseDate(String dateString) throws ParseException {
        String[] tokens = dateString.split(",\\s+", 2);
        if (tokens.length > 1) {
            dateString = tokens[1];
        }
        SimpleDateFormat parser = new SimpleDateFormat("dd MMM yyyy kk:mm:ss Z", Locale.ENGLISH);
        return parser.parse(dateString);
    }

    public void setContent(String content) {
        this.content = content.getBytes();
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getBodyText() {
        return new String(this.content);
    }

    public MessageId getMessageID() {
        return this.messageId;
    }

    public Collection<UnencryptedEmailPacket> createEmailPackets(String bccToKeep) {
        int blockSize;
        ArrayList<UnencryptedEmailPacket> packets = new ArrayList<UnencryptedEmailPacket>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeTo((OutputStream)outputStream, bccToKeep);
        byte[] emailArray = outputStream.toByteArray();
        int numFragments = (emailArray.length + 30720 - 1) / 30720;
        int fragmentIndex = 0;
        int blockStart = 0;
        while ((blockSize = Math.min(emailArray.length - blockStart, 30720)) > 0) {
            byte[] block = new byte[blockSize];
            System.arraycopy(emailArray, blockStart, block, 0, blockSize);
            UniqueId deletionKeyPlain = new UniqueId();
            UniqueId deletionKeyEncrypted = deletionKeyPlain.clone();
            UnencryptedEmailPacket packet = new UnencryptedEmailPacket(deletionKeyPlain, deletionKeyEncrypted, (UniqueId)this.messageId, fragmentIndex, numFragments, block);
            packets.add(packet);
            ++fragmentIndex;
            blockStart += blockSize;
        }
        return packets;
    }

    public Email removeBCCs(String recipient) {
        List<Header> newHeaders = Collections.synchronizedList(new ArrayList());
        for (Header header : this.headers) {
            if ("BCC".equals(header.name) && recipient.equals(header.value)) continue;
            newHeaders.add(header);
        }
        Email newEmail = new Email();
        newEmail.headers = newHeaders;
        newEmail.content = this.content;
        newEmail.messageId = this.messageId;
        return newEmail;
    }

    private String getHeader(String name) {
        for (Header header : this.headers) {
            if (!name.equals(header.name)) continue;
            return header.value;
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, null);
    }

    public void writeTo(OutputStream outputStream, String bccToKeep) {
        PrintWriter writer = new PrintWriter(outputStream);
        this.writeHeaders(writer, bccToKeep);
        writer.print(NEW_LINE);
        writer.print(new String(this.content));
        writer.print(NEW_LINE);
        writer.close();
    }

    private void writeHeaders(PrintWriter writer, String bccToKeep) {
        for (Header header : this.headers) {
            if (bccToKeep != null && "BCC".equals(header.name) && !bccToKeep.equals(header.value)) continue;
            writer.println(header.toString());
        }
    }
}

