/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote;

import i2p.bote.Configuration;
import i2p.bote.Util;
import i2p.bote.email.Email;
import i2p.bote.email.EmailDestination;
import i2p.bote.email.EmailIdentity;
import i2p.bote.email.Identities;
import i2p.bote.folder.DhtPacketFolder;
import i2p.bote.folder.EmailFolder;
import i2p.bote.folder.IncompleteEmailFolder;
import i2p.bote.folder.IndexPacketFolder;
import i2p.bote.folder.Outbox;
import i2p.bote.folder.PacketFolder;
import i2p.bote.network.CheckEmailTask;
import i2p.bote.network.DHT;
import i2p.bote.network.DhtStorageHandler;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PeerManager;
import i2p.bote.network.kademlia.KademliaDHT;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import i2p.bote.service.OutboxProcessor;
import i2p.bote.service.POP3Service;
import i2p.bote.service.RelayPacketSender;
import i2p.bote.service.SMTPService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

/*
 * Exception performing whole class analysis ignored.
 */
public class I2PBote {
    private static final String VERSION = "0.1.2";
    private static I2PBote instance;
    private Log log = new Log(I2PBote.class);
    private I2PAppContext appContext;
    private I2PClient i2pClient;
    private I2PSession i2pSession;
    private Configuration configuration;
    private Identities identities;
    private I2PSendQueue sendQueue;
    private Outbox outbox;
    private EmailFolder inbox;
    private PacketFolder<RelayPacket> relayPacketFolder;
    private IncompleteEmailFolder incompleteEmailFolder;
    private DhtPacketFolder<? extends DataPacket> emailDhtStorageFolder;
    private IndexPacketFolder indexPacketDhtStorageFolder;
    private SMTPService smtpService;
    private POP3Service pop3Service;
    private OutboxProcessor outboxProcessor;
    private RelayPacketSender relayPacketSender;
    private DHT dht;
    private PeerManager peerManager;
    private ThreadFactory mailCheckThreadFactory;
    private ExecutorService mailCheckExecutor;
    private Collection<Future<Boolean>> mailCheckResults;

    private I2PBote() {
        Thread.currentThread().setName("I2PBoteMain");
        this.initializeLogging();
        this.appContext = new I2PAppContext();
        this.i2pClient = I2PClientFactory.createClient();
        this.configuration = new Configuration();
        this.mailCheckThreadFactory = Util.createThreadFactory((String)"ChkMailTask", (int)65536);
        this.mailCheckExecutor = Executors.newFixedThreadPool(this.configuration.getMaxConcurIdCheckMail(), this.mailCheckThreadFactory);
        this.identities = new Identities(this.configuration.getIdentitiesFile());
        this.initializeSession();
        this.initializeFolderAccess();
        this.initializeServices();
        this.startAllServices();
    }

    private void initializeLogging() {
    }

    private void initializeFolderAccess() {
        this.inbox = new EmailFolder(this.configuration.getInboxDir());
        this.outbox = new Outbox(this.configuration.getLocalOutboxDir());
        this.relayPacketFolder = new PacketFolder(this.configuration.getRelayOutboxDir());
        this.incompleteEmailFolder = new IncompleteEmailFolder(this.configuration.getIncompleteDir(), this.inbox);
        this.emailDhtStorageFolder = new DhtPacketFolder(this.configuration.getEmailDhtStorageDir());
        this.indexPacketDhtStorageFolder = new IndexPacketFolder(this.configuration.getIndexPacketDhtStorageDir());
    }

    private void initializeSession() {
        Properties sessionProperties = new Properties();
        sessionProperties.setProperty("i2cp.gzip", String.valueOf(false));
        File destinationKeyFile = this.configuration.getDestinationKeyFile();
        try {
            FileReader fileReader = new FileReader(destinationKeyFile);
            char[] destKeyBuffer = new char[(int)destinationKeyFile.length()];
            fileReader.read(destKeyBuffer);
            byte[] localDestinationKey = Base64.decode((String)new String(destKeyBuffer));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(localDestinationKey);
            this.i2pSession = this.i2pClient.createSession((InputStream)inputStream, sessionProperties);
            this.i2pSession.connect();
        }
        catch (IOException e) {
            this.log.debug("Destination key file doesn't exist or isn't readable: " + e);
        }
        catch (I2PSessionException e) {
            this.log.warn("Error creating I2PSession", (Throwable)e);
        }
        if (this.i2pSession == null) {
            this.log.debug("Creating new local destination key");
            try {
                ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
                this.i2pClient.createDestination((OutputStream)arrayStream);
                byte[] localDestinationArray = arrayStream.toByteArray();
                this.i2pSession = this.i2pClient.createSession((InputStream)new ByteArrayInputStream(localDestinationArray), sessionProperties);
                this.i2pSession.connect();
                this.saveLocalDestinationKeys(destinationKeyFile, localDestinationArray);
            }
            catch (I2PException e) {
                this.log.error("Error creating local destination key or I2PSession.", (Throwable)e);
            }
            catch (IOException e) {
                this.log.error("Error writing local destination key to file.", (Throwable)e);
            }
        }
        Destination localDestination = this.i2pSession.getMyDestination();
        this.log.debug("Local destination key = " + localDestination.toBase64());
        this.log.debug("Local destination hash = " + localDestination.calculateHash().toBase64());
    }

    private void initializeServices() {
        I2PPacketDispatcher dispatcher = new I2PPacketDispatcher();
        this.i2pSession.addSessionListener((I2PSessionListener)dispatcher, 0, 0);
        this.smtpService = new SMTPService();
        this.pop3Service = new POP3Service();
        this.relayPacketSender = new RelayPacketSender(this.sendQueue, this.relayPacketFolder, this.appContext);
        this.sendQueue = new I2PSendQueue(this.i2pSession, dispatcher);
        this.dht = new KademliaDHT(this.i2pSession.getMyDestination(), this.sendQueue, dispatcher, this.configuration.getPeerFile());
        this.dht.setStorageHandler(EncryptedEmailPacket.class, (DhtStorageHandler)this.emailDhtStorageFolder);
        this.dht.setStorageHandler(IndexPacket.class, (DhtStorageHandler)this.indexPacketDhtStorageFolder);
        this.peerManager = new PeerManager();
        this.outboxProcessor = new OutboxProcessor(this.dht, this.outbox, this.configuration, this.peerManager, this.appContext);
    }

    private void saveLocalDestinationKeys(File keyFile, byte[] localDestinationArray) throws DataFormatException, IOException {
        if (keyFile.exists()) {
            File oldKeyFile = new File(keyFile.getPath() + "_backup");
            keyFile.renameTo(oldKeyFile);
        } else {
            keyFile.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(keyFile);
        fileWriter.write(Base64.encode((byte[])localDestinationArray));
        fileWriter.close();
    }

    public static void startUp() {
        I2PBote.getInstance();
    }

    public static void shutDown() {
        if (instance != null) {
            instance.stopAllServices();
        }
    }

    public static I2PBote getInstance() {
        if (instance == null) {
            instance = new I2PBote();
        }
        return instance;
    }

    public String getVersion() {
        return "0.1.2";
    }

    public Identities getIdentities() {
        return this.identities;
    }

    public String getLocalDestination() {
        return this.i2pSession.getMyDestination().toBase64();
    }

    public void sendEmail(Email email) throws Exception {
        email.updateHeaders();
        String recipient = (String)email.getAllRecipients().iterator().next();
        if (recipient.indexOf(64) >= 0) {
            recipient = recipient.substring(0, recipient.indexOf(64));
        }
        EmailDestination emailDestination = new EmailDestination(recipient);
        Collection emailPackets = email.createEmailPackets(recipient);
        Collection encryptedPackets = EncryptedEmailPacket.encrypt((Collection)emailPackets, (EmailDestination)emailDestination, (I2PAppContext)this.appContext);
        for (EncryptedEmailPacket packet : encryptedPackets) {
            this.dht.store((DhtStorablePacket)packet);
        }
        this.dht.store((DhtStorablePacket)new IndexPacket(encryptedPackets, emailDestination));
    }

    public synchronized void checkForMail() {
        if (!this.isCheckingForMail()) {
            this.mailCheckResults = Collections.synchronizedCollection(new ArrayList());
        }
        for (EmailIdentity identity : this.getIdentities()) {
            CheckEmailTask checkMailTask = new CheckEmailTask(identity, this.dht, this.peerManager, this.incompleteEmailFolder, this.appContext);
            Future result = this.mailCheckExecutor.submit(checkMailTask);
            this.mailCheckResults.add(result);
        }
    }

    public synchronized boolean isCheckingForMail() {
        if (this.mailCheckResults == null) {
            return false;
        }
        for (Future result : this.mailCheckResults) {
            if (result.isDone()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean newMailReceived() {
        if (this.mailCheckResults == null) {
            return false;
        }
        if (this.isCheckingForMail()) {
            return false;
        }
        try {
            for (Future result : this.mailCheckResults) {
                if (!((Boolean)result.get(1L, TimeUnit.MILLISECONDS)).booleanValue()) continue;
                this.mailCheckResults = null;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Error while checking whether new mail has arrived.", (Throwable)e);
        }
        this.mailCheckResults = null;
        return false;
    }

    public EmailFolder getInbox() {
        return this.inbox;
    }

    public int getNumDhtPeers() {
        return this.dht.getNumPeers();
    }

    public int getNumRelayPeers() {
        return this.peerManager.getNumPeers();
    }

    private void startAllServices() {
        this.dht.start();
        this.outboxProcessor.start();
        this.relayPacketSender.start();
        this.smtpService.start();
        this.pop3Service.start();
        this.sendQueue.start();
    }

    private void stopAllServices() {
        this.dht.shutDown();
        this.outboxProcessor.shutDown();
        this.relayPacketSender.requestShutdown();
        this.smtpService.shutDown();
        this.pop3Service.shutDown();
        this.sendQueue.requestShutdown();
        this.mailCheckExecutor.shutdownNow();
    }
}

