/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

public class Configuration
extends Properties {
    private static final long serialVersionUID = -6318245413106186095L;
    private static final String I2P_BOTE_SUBDIR = "i2pbote";
    private static final String CONFIG_FILE_NAME = "i2pbote.config";
    private static final String DEST_KEY_FILE_NAME = "local_dest.key";
    private static final String PEER_FILE_NAME = "peers.txt";
    private static final String IDENTITIES_FILE_NAME = "identities.txt";
    private static final String OUTBOX_DIR = "outbox";
    private static final String OUTBOX_SUBDIR_LOCAL = "local";
    private static final String OUTBOX_SUBDIR_RELAY = "relay";
    private static final String INCOMPLETE_SUBDIR = "incomplete";
    private static final String EMAIL_DHT_SUBDIR = "dht_email_pkt";
    private static final String INDEX_PACKET_DHT_SUBDIR = "dht_index_pkt";
    private static final String INBOX_SUBDIR = "inbox";
    private static final String PARAMETER_REDUNDANCY = "redundancy";
    private static final String PARAMETER_STORAGE_SPACE_INBOX = "storageSpaceInbox";
    private static final String PARAMETER_STORAGE_SPACE_RELAY = "storageSpaceRelay";
    private static final String PARAMETER_STORAGE_TIME = "storageTime";
    private static final String PARAMETER_MAX_FRAGMENT_SIZE = "maxFragmentSize";
    private static final String PARAMETER_HASHCASH_STRENGTH = "hashCashStrength";
    private static final String PARAMETER_SMTP_PORT = "smtpPort";
    private static final String PARAMETER_POP3_PORT = "pop3Port";
    private static final String PARAMETER_MAX_CONCURRENT_IDENTITIES_CHECK_MAIL = "maxConcurIdCheckMail";
    private static final int DEFAULT_REDUNDANCY = 2;
    private static final int DEFAULT_STORAGE_SPACE_INBOX = 0x40000000;
    private static final int DEFAULT_STORAGE_SPACE_RELAY = 0x6400000;
    private static final int DEFAULT_STORAGE_TIME = 31;
    private static final int DEFAULT_MAX_FRAGMENT_SIZE = 0xA00000;
    private static final int DEFAULT_HASHCASH_STRENGTH = 10;
    private static final int DEFAULT_SMTP_PORT = 7661;
    private static final int DEFAULT_POP3_PORT = 7662;
    private static final int DEFAULT_MAX_CONCURRENT_IDENTITIES_CHECK_MAIL = 10;
    private Log log = new Log(Configuration.class);
    private File i2pBoteDir = Configuration.getI2PBoteDirectory();

    public Configuration() {
        if (!this.i2pBoteDir.exists()) {
            this.i2pBoteDir.mkdirs();
        }
        File configFile = new File(this.i2pBoteDir, CONFIG_FILE_NAME);
        boolean configurationLoaded = false;
        if (configFile.exists()) {
            this.log.debug("Loading config file <" + configFile.getAbsolutePath() + ">");
            try {
                DataHelper.loadProps((Properties)this, (File)configFile);
                configurationLoaded = true;
            }
            catch (IOException e) {
                this.log.error("Error loading configuration file <" + configFile.getAbsolutePath() + ">", (Throwable)e);
            }
        }
        if (!configurationLoaded) {
            this.log.info("Can't read configuration file <" + configFile.getAbsolutePath() + ">, using default settings.");
        }
    }

    public File getDestinationKeyFile() {
        return new File(this.i2pBoteDir, DEST_KEY_FILE_NAME);
    }

    public File getPeerFile() {
        return new File(this.i2pBoteDir, PEER_FILE_NAME);
    }

    public File getIdentitiesFile() {
        return new File(this.i2pBoteDir, IDENTITIES_FILE_NAME);
    }

    public File getLocalOutboxDir() {
        return new File(this.getOutboxBaseDir(), OUTBOX_SUBDIR_LOCAL);
    }

    public File getRelayOutboxDir() {
        return new File(this.getOutboxBaseDir(), OUTBOX_SUBDIR_RELAY);
    }

    private File getOutboxBaseDir() {
        return new File(this.i2pBoteDir, OUTBOX_DIR);
    }

    public File getInboxDir() {
        return new File(this.i2pBoteDir, INBOX_SUBDIR);
    }

    public File getIncompleteDir() {
        return new File(this.i2pBoteDir, INCOMPLETE_SUBDIR);
    }

    public File getEmailDhtStorageDir() {
        return new File(this.i2pBoteDir, EMAIL_DHT_SUBDIR);
    }

    public File getIndexPacketDhtStorageDir() {
        return new File(this.i2pBoteDir, INDEX_PACKET_DHT_SUBDIR);
    }

    private static File getI2PBoteDirectory() {
        File i2pAppDir = I2PAppContext.getGlobalContext().getAppDir();
        return new File(i2pAppDir, I2P_BOTE_SUBDIR);
    }

    public void saveToFile(File configFile) throws IOException {
        this.log.debug("Saving config file <" + configFile.getAbsolutePath() + ">");
        DataHelper.storeProps((Properties)this, (File)configFile);
    }

    public int getRedundancy() {
        return this.getIntParameter(PARAMETER_REDUNDANCY, 2);
    }

    public int getStorageSpaceInbox() {
        return this.getIntParameter(PARAMETER_STORAGE_SPACE_INBOX, 0x40000000);
    }

    public int getStorageSpaceRelay() {
        return this.getIntParameter(PARAMETER_STORAGE_SPACE_RELAY, 0x6400000);
    }

    public long getStorageTime() {
        return 86400000L * (long)this.getIntParameter(PARAMETER_STORAGE_TIME, 31);
    }

    public int getMaxFragmentSize() {
        return this.getIntParameter(PARAMETER_MAX_FRAGMENT_SIZE, 0xA00000);
    }

    public int getHashCashStrength() {
        return this.getIntParameter(PARAMETER_HASHCASH_STRENGTH, 10);
    }

    public int getMaxConcurIdCheckMail() {
        return this.getIntParameter(PARAMETER_MAX_CONCURRENT_IDENTITIES_CHECK_MAIL, 10);
    }

    private int getIntParameter(String parameterName, int defaultValue) {
        String stringValue = this.getProperty(parameterName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return new Integer(this.getProperty(parameterName));
        }
        catch (NumberFormatException e) {
            this.log.warn("Can't convert value <" + stringValue + "> for parameter <" + parameterName + "> to int, using default.");
            return defaultValue;
        }
    }
}

