/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.networks.i2p;

import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnectionFactory;
import com.aelitis.azureus.plugins.networks.i2p.I2PPluginConnectionManager;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class I2PPlugin
implements Plugin {
    private static final int PROXY_CON_TIMEOUT = 120000;
    private static final int PROXY_READ_TIMEOUT = 120000;
    protected PluginInterface plugin_interface;
    public static final String[] I2P_JARS = new String[]{"i2p.jar", "streaming.jar", "mstreaming.jar", "jbigi.jar"};
    public static final String CONFIG_ENABLE = "enable";
    public static final boolean CONFIG_ENABLE_DEFAULT = true;
    public static final String CONFIG_PROXY_PORT = "proxy_port";
    public static final int CONFIG_PROXY_PORT_DEFAULT = 0;
    public static final String CONFIG_I2P_LOCATION = "i2p_location";
    public static String CONFIG_I2P_LOCATION_DEFAULT = "";
    public static final String CONFIG_UPNP_ENABLE = "upnp_enable";
    public static final boolean CONFIG_UPNP_ENABLE_DEFAULT = false;
    public static final String CONFIG_UPNP_LEAVE_MAPPING = "upnp_persistent_mapping";
    public static final boolean CONFIG_UPNP_LEAVE_MAPPING_DEFAULT = true;
    public static final String CONFIG_UPNP_PORT = "upnp_port";
    public static final int CONFIG_UPNP_PORT_DEFAULT = 8887;
    public static final String CONFIG_I2P_ROUTER_HOST = "i2p_router_host";
    public static final String CONFIG_I2P_ROUTER_HOST_DEFAULT = "localhost";
    public static final String CONFIG_I2P_ROUTER_PORT = "i2p_router_port";
    public static final int CONFIG_I2P_ROUTER_PORT_DEFAULT = 7654;
    public static final String CONFIG_I2P_ROUTER_OPTIONS = "i2p_router_options";
    public static final String CONFIG_I2P_ROUTER_OPTIONS_DEFAULT = "";
    public static final String CONFIG_TRACE = "trace";
    public static final boolean CONFIG_TRACE_DEFAULT = false;
    protected LoggerChannel log;
    protected LoggerChannelListener log_temp;
    protected List logs = new ArrayList();
    protected BooleanParameter enable;
    protected IntParameter proxy_port;
    protected BooleanParameter upnp_enable;
    protected IntParameter upnp_port;
    protected BooleanParameter upnp_persist;
    protected StringParameter i2p_router_host;
    protected IntParameter i2p_router_port;
    protected StringParameter i2p_router_options;
    protected BooleanParameter trace;

    public void load(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("I2P Network Plugin");
        if (this.plugin_interface.getUtilities().isWindows()) {
            String[] win_defs;
            String[] stringArray = win_defs = new String[]{"C:\\Program Files\\i2p", "C:\\Program Files (x86)\\i2p"};
            int n = win_defs.length;
            int n2 = 0;
            while (n2 < n) {
                String win_def = stringArray[n2];
                if (new File(win_def).exists()) {
                    CONFIG_I2P_LOCATION_DEFAULT = win_def;
                }
                ++n2;
            }
        }
        this.log_temp = new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                I2PPlugin.this.logs.add(content);
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    I2PPlugin.this.logs.add(str);
                }
                I2PPlugin.this.logs.add(Debug.getNestedExceptionMessage((Throwable)error));
            }
        };
        this.log.addListener(this.log_temp);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel config_model = ui_manager.createBasicPluginConfigModel("plugins", "i2pnet.name");
        this.enable = config_model.addBooleanParameter2(CONFIG_ENABLE, "i2pnet.enable", true);
        LabelParameter lab1 = config_model.addLabelParameter2("i2pnet.proxy_port.info");
        this.proxy_port = config_model.addIntParameter2(CONFIG_PROXY_PORT, "i2pnet.proxy_port", 0);
        DirectoryParameter location = config_model.addDirectoryParameter2(CONFIG_I2P_LOCATION, "i2pnet.i2p_location", CONFIG_I2P_LOCATION_DEFAULT);
        this.upnp_enable = config_model.addBooleanParameter2(CONFIG_UPNP_ENABLE, "i2pnet.upnp_enable", false);
        this.upnp_persist = config_model.addBooleanParameter2(CONFIG_UPNP_LEAVE_MAPPING, "i2pnet.upnp_persist", true);
        this.upnp_port = config_model.addIntParameter2(CONFIG_UPNP_PORT, "i2pnet.upnp_port", 8887);
        config_model.createGroup("i2pnet.upnp_group", new Parameter[]{this.upnp_enable, this.upnp_persist, this.upnp_port});
        LabelParameter i2p_lab = config_model.addLabelParameter2("i2pnet.i2p_options.info");
        this.i2p_router_host = config_model.addStringParameter2(CONFIG_I2P_ROUTER_HOST, "i2pnet.i2p_router_host", CONFIG_I2P_ROUTER_HOST_DEFAULT);
        this.i2p_router_port = config_model.addIntParameter2(CONFIG_I2P_ROUTER_PORT, "i2pnet.i2p_router_port", 7654);
        this.i2p_router_options = config_model.addStringParameter2(CONFIG_I2P_ROUTER_OPTIONS, "i2pnet.i2p_router_options", CONFIG_I2P_ROUTER_OPTIONS_DEFAULT);
        config_model.createGroup("i2pnet.i2p_router_group", new Parameter[]{i2p_lab, this.i2p_router_host, this.i2p_router_port, this.i2p_router_options});
        this.trace = config_model.addBooleanParameter2(CONFIG_TRACE, "i2pnet.trace_enable", false);
        this.enable.addEnabledOnSelection((Parameter)this.proxy_port);
        this.enable.addEnabledOnSelection((Parameter)lab1);
        this.enable.addEnabledOnSelection((Parameter)location);
        this.enable.addEnabledOnSelection((Parameter)this.upnp_enable);
        ParameterListener pl = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                I2PPlugin.this.upnp_port.setEnabled(I2PPlugin.this.enable.getValue() && I2PPlugin.this.upnp_enable.getValue());
                I2PPlugin.this.upnp_persist.setEnabled(I2PPlugin.this.enable.getValue() && I2PPlugin.this.upnp_enable.getValue());
            }
        };
        this.enable.addListener(pl);
        this.upnp_enable.addListener(pl);
        pl.parameterChanged(null);
        this.enable.addEnabledOnSelection((Parameter)i2p_lab);
        this.enable.addEnabledOnSelection((Parameter)this.i2p_router_host);
        this.enable.addEnabledOnSelection((Parameter)this.i2p_router_port);
        this.enable.addEnabledOnSelection((Parameter)this.i2p_router_options);
        this.enable.addEnabledOnSelection((Parameter)this.trace);
        if (this.enable.getValue()) {
            boolean bad = false;
            boolean alert = false;
            try {
                String loc = location.getValue();
                if (loc.length() == 0 || !new File(loc).exists()) {
                    bad = true;
                    alert = true;
                    throw new Exception("I2P install location not defined, plugin initialisation failed.");
                }
                System.setProperty("i2p.dir.base", new File(loc).getAbsolutePath());
                File lib = new File(loc, "lib");
                URL[] jars = new URL[I2P_JARS.length];
                int i = 0;
                while (i < jars.length) {
                    File jar = new File(lib, I2P_JARS[i]);
                    if (!jar.exists()) {
                        bad = true;
                        throw new Exception("I2P jar file '" + jar + "' not found");
                    }
                    jars[i] = jar.toURL();
                    ++i;
                }
                ClassLoader class_loader = this.getClass().getClassLoader();
                if (class_loader instanceof URLClassLoader) {
                    URL[] old = ((URLClassLoader)class_loader).getURLs();
                    URL[] new_urls = new URL[old.length + jars.length];
                    System.arraycopy(old, 0, new_urls, 0, old.length);
                    System.arraycopy(jars, 0, new_urls, old.length, jars.length);
                    class_loader = new URLClassLoader(new_urls, class_loader);
                } else {
                    class_loader = new URLClassLoader(jars, class_loader);
                }
                int port = this.proxy_port.getValue();
                if (port == 0) {
                    bad = true;
                    throw new Exception("I2P poxy port not defined, can't initialise");
                }
                final I2PPluginConnectionManager con_man = new I2PPluginConnectionManager(class_loader, this.log);
                AESocksProxyFactory.create((int)port, (long)120000L, (long)120000L, (AESocksProxyPlugableConnectionFactory)con_man);
                this.log.log("Established network proxy on port " + port);
                this.plugin_interface.addListener(new PluginListener(){

                    public void initializationComplete() {
                        con_man.initialise(I2PPlugin.this.i2p_router_host, I2PPlugin.this.i2p_router_port, I2PPlugin.this.i2p_router_options, I2PPlugin.this.trace);
                    }

                    public void closedownInitiated() {
                        con_man.closedown();
                    }

                    public void closedownComplete() {
                    }
                });
            }
            catch (Throwable e) {
                if (bad) {
                    if (alert) {
                        this.log.logAlert(3, e.getMessage());
                    } else {
                        this.log.log(e.getMessage());
                    }
                }
                this.log.log(e);
            }
        }
    }

    public void initialize(PluginInterface _plugin_interface) {
        LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel view_model = ui_manager.createBasicPluginViewModel(loc_utils.getLocalisedMessageText("i2pnet.name"));
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.removeListener(this.log_temp);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(String.valueOf(this.getTimeStamp()) + content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(String.valueOf(this.getTimeStamp()) + str + "\n");
                }
                view_model.getLogArea().appendText(String.valueOf(this.getTimeStamp()) + Debug.getNestedExceptionMessage((Throwable)error) + "\n");
            }

            protected String getTimeStamp() {
                return "[" + new SimpleDateFormat("HH:mm:ss").format(new Date()) + "] ";
            }
        });
        int i = 0;
        while (i < this.logs.size()) {
            this.log.log((String)this.logs.get(i));
            ++i;
        }
        this.logs.clear();
        view_model.getStatus().setText(this.enable.getValue() ? "Enabled" : "Disabled");
        this.enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                view_model.getStatus().setText(I2PPlugin.this.enable.getValue() ? "Enabled" : "Disabled");
            }
        });
        if (this.enable.getValue()) {
            if (this.plugin_interface.getPluginconfig().getCoreBooleanParameter("SOCKS Proxy No Inward Connection")) {
                this.log.logAlert(3, loc_utils.getLocalisedMessageText("i2pnet.tracker.inform"));
            }
            this.plugin_interface.addListener(new PluginListener(){

                public void initializationComplete() {
                    PluginInterface pi_upnp = I2PPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (pi_upnp == null) {
                        I2PPlugin.this.log.log("No UPnP plugin available, not attempting port mapping");
                    } else if (I2PPlugin.this.upnp_enable.getValue()) {
                        UPnPMapping mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(I2PPlugin.this.plugin_interface.getPluginName(), true, I2PPlugin.this.upnp_port.getValue(), true);
                        if (I2PPlugin.this.upnp_persist.getValue()) {
                            mapping.setPersistent(2);
                        }
                    } else {
                        I2PPlugin.this.log.log("UPnP disabled for the plugin, not attempting port mapping");
                    }
                }

                public void closedownInitiated() {
                }

                public void closedownComplete() {
                }
            });
        }
    }
}

