/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.networks.i2p;

import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnectionFactory;
import com.aelitis.azureus.plugins.networks.i2p.I2PPluginConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;

public class I2PPluginConnectionManager
implements AESocksProxyPlugableConnectionFactory {
    private ClassLoader class_loader;
    private LoggerChannel log;
    private Object naming_service;
    private volatile Object socket_manager;
    private Method i2p_NamingService_lookup;
    private Class i2p_Destination;
    private Method i2p_Destination_fromBase64;
    private Method i2p_Destination_fromByteArray;
    private Class i2p_I2PSocketManagerFactory;
    private Method i2p_I2PSocketManager_getSession;
    private Method i2p_I2PSocketManager_ping;
    private Method i2p_I2PSocketManager_connect;
    private Method i2p_I2PSession_getMyDestination;
    private Method i2p_I2PSocket_close;
    private Method i2p_I2PSocket_getInputStream;
    private Method i2p_I2PSocket_getOutputStream;
    private StringParameter router_host;
    private IntParameter router_port;
    private StringParameter router_options;
    private BooleanParameter trace;
    private AESemaphore sem = new AESemaphore("I2PInit");
    private AEMonitor this_mon = new AEMonitor("I2PPluginConnectionManager");

    protected I2PPluginConnectionManager(ClassLoader _class_loader, LoggerChannel _log) {
        this.class_loader = _class_loader;
        this.log = _log;
    }

    protected void initialise(StringParameter _router_host, IntParameter _router_port, StringParameter _router_options, BooleanParameter _trace) {
        this.router_host = _router_host;
        this.router_port = _router_port;
        this.router_options = _router_options;
        this.trace = _trace;
        try {
            this.log.log("Initialising I2P Socket Manager");
            Class<?> i2p_I2PContext = this.class_loader.loadClass("net.i2p.I2PAppContext");
            Method i2p_I2PContext_getGlobalContext = i2p_I2PContext.getMethod("getGlobalContext", new Class[0]);
            Object global_context = i2p_I2PContext_getGlobalContext.invoke(null, new Object[0]);
            Method i2p_I2PContext_namingService = i2p_I2PContext.getMethod("namingService", new Class[0]);
            this.naming_service = i2p_I2PContext_namingService.invoke(global_context, new Object[0]);
            Class<?> i2p_NamingService = this.class_loader.loadClass("net.i2p.client.naming.NamingService");
            this.i2p_NamingService_lookup = i2p_NamingService.getMethod("lookup", String.class);
            this.i2p_Destination = this.class_loader.loadClass("net.i2p.data.Destination");
            this.i2p_Destination_fromBase64 = this.i2p_Destination.getMethod("fromBase64", String.class);
            Class<?> i2p_I2PSession = this.class_loader.loadClass("net.i2p.client.I2PSession");
            this.i2p_I2PSession_getMyDestination = i2p_I2PSession.getMethod("getMyDestination", new Class[0]);
            this.i2p_I2PSocketManagerFactory = this.class_loader.loadClass("net.i2p.client.streaming.I2PSocketManagerFactory");
            Class<?> i2p_I2PSocketManager = this.class_loader.loadClass("net.i2p.client.streaming.I2PSocketManager");
            this.i2p_I2PSocketManager_getSession = i2p_I2PSocketManager.getMethod("getSession", new Class[0]);
            this.i2p_I2PSocketManager_ping = i2p_I2PSocketManager.getMethod("ping", this.i2p_Destination, Long.TYPE);
            this.i2p_I2PSocketManager_connect = i2p_I2PSocketManager.getMethod("connect", this.i2p_Destination);
            Class<?> i2p_I2PSocket = this.class_loader.loadClass("net.i2p.client.streaming.I2PSocket");
            this.i2p_I2PSocket_close = i2p_I2PSocket.getMethod("close", new Class[0]);
            this.i2p_I2PSocket_getInputStream = i2p_I2PSocket.getMethod("getInputStream", new Class[0]);
            this.i2p_I2PSocket_getOutputStream = i2p_I2PSocket.getMethod("getOutputStream", new Class[0]);
            this.connectToRouter();
        }
        catch (Throwable e) {
            this.log.logAlert("I2P Router initialisation failed", e);
        }
    }

    protected void connectToRouter() {
        AEThread t = new AEThread("I2P Initialiser"){

            public void runSupport() {
                boolean error_reported = false;
                while (I2PPluginConnectionManager.this.socket_manager == null) {
                    long last_create_time = System.currentTimeMillis();
                    try {
                        Properties opts = new Properties();
                        StringTokenizer tok = new StringTokenizer(I2PPluginConnectionManager.this.router_options.getValue());
                        while (tok.hasMoreTokens()) {
                            String pair = tok.nextToken();
                            int eq = pair.indexOf(61);
                            if (eq <= 0 || eq >= pair.length()) continue;
                            String key = pair.substring(0, eq);
                            String val = pair.substring(eq + 1);
                            opts.setProperty(key, val);
                        }
                        I2PPluginConnectionManager.this.socket_manager = I2PPluginConnectionManager.this.i2p_I2PSocketManagerFactory.getMethod("createManager", String.class, Integer.TYPE, Properties.class).invoke(null, I2PPluginConnectionManager.this.router_host.getValue(), new Integer(I2PPluginConnectionManager.this.router_port.getValue()), opts);
                        if (I2PPluginConnectionManager.this.socket_manager != null) {
                            I2PPluginConnectionManager.this.log.logAlertRepeatable(1, "I2P Router connection succeeded");
                            Object session = I2PPluginConnectionManager.this.i2p_I2PSocketManager_getSession.invoke(I2PPluginConnectionManager.this.socket_manager, new Object[0]);
                            final Object my_dest = I2PPluginConnectionManager.this.i2p_I2PSession_getMyDestination.invoke(session, new Object[0]);
                            final Object this_sm = I2PPluginConnectionManager.this.socket_manager;
                            AEThread pinger = new AEThread("I2P Pinger"){

                                public void runSupport() {
                                    int consecutive_fails = 0;
                                    while (I2PPluginConnectionManager.this.socket_manager == this_sm) {
                                        try {
                                            Thread.sleep(60000L);
                                            long start = System.currentTimeMillis();
                                            boolean res = (Boolean)I2PPluginConnectionManager.this.i2p_I2PSocketManager_ping.invoke(this_sm, my_dest, new Integer(10000));
                                            I2PPluginConnectionManager.this.log.log("I2P router ping response = " + (res ? "OK" : "Failed") + ", elapsed = " + (System.currentTimeMillis() - start));
                                            if (res) {
                                                consecutive_fails = 0;
                                                continue;
                                            }
                                            if (++consecutive_fails != 3) continue;
                                            I2PPluginConnectionManager.this.routerFailure(this_sm);
                                        }
                                        catch (Throwable e) {
                                            I2PPluginConnectionManager.this.log.log(e);
                                            I2PPluginConnectionManager.this.routerFailure(this_sm);
                                        }
                                    }
                                }
                            };
                            pinger.setDaemon(true);
                            pinger.start();
                            I2PPluginConnectionManager.this.sem.releaseForever();
                            break;
                        }
                    }
                    catch (Throwable e) {
                        I2PPluginConnectionManager.this.log.log("I2P Router connection failed", e);
                    }
                    String msg = "I2P Router connection failed, check that the I2P router is running";
                    if (error_reported) {
                        I2PPluginConnectionManager.this.log.log(msg);
                    } else {
                        error_reported = true;
                        I2PPluginConnectionManager.this.log.logAlert(3, "I2P Router connection failed, check that the I2P router is running");
                    }
                    long sleep = 30000L - (System.currentTimeMillis() - last_create_time);
                    if (sleep <= 0L) continue;
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void routerFailure(Object failed_socket_manager) {
        try {
            this.this_mon.enter();
            if (this.socket_manager == failed_socket_manager) {
                this.log.logAlertRepeatable(3, "I2P Router connection failed");
                this.socket_manager = null;
                this.sem = new AESemaphore("I2PInit");
                this.connectToRouter();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void closedown() {
    }

    protected void log(String str) {
        this.log.log(str);
    }

    protected void trace(String str) {
        if (this.trace.getValue()) {
            this.log.log(str);
        }
    }

    protected boolean proxyI2POnly() {
        return false;
    }

    public AESocksProxyPlugableConnection create(AESocksProxyConnection connection) throws AEProxyException {
        return new I2PPluginConnection(this, connection);
    }

    protected Object i2pSocketManager_connect(String address) throws IOException {
        Object current_socket_manager;
        this.sem.reserve();
        if (address.length() < 400) {
            address = String.valueOf(address) + ".i2p";
        }
        if ((current_socket_manager = this.socket_manager) == null || this.i2p_Destination == null) {
            throw new IOException("I2P network unavailable");
        }
        try {
            Object remote_dest;
            if (this.naming_service != null) {
                remote_dest = this.i2p_NamingService_lookup.invoke(this.naming_service, address);
            } else {
                remote_dest = this.i2p_Destination.newInstance();
                this.i2p_Destination_fromBase64.invoke(remote_dest, address);
            }
            if (remote_dest == null) {
                throw new Exception("Failed to resolve address '" + address + "'");
            }
            Object res = this.i2p_I2PSocketManager_connect.invoke(current_socket_manager, remote_dest);
            return res;
        }
        catch (Throwable e) {
            String msg = Debug.getNestedExceptionMessage((Throwable)e).toLowerCase();
            boolean logit = true;
            if (msg.contains("session is closed")) {
                this.routerFailure(current_socket_manager);
                logit = false;
            } else if (msg.contains("timeout") || msg.contains("timed out")) {
                logit = false;
            }
            if (logit) {
                this.log.log(e);
            }
            throw new IOException(e.getMessage());
        }
    }

    protected void i2pSocket_close(Object socket) throws IOException {
        try {
            this.i2p_I2PSocket_close.invoke(socket, new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.log.log(e);
            throw new IOException(e.getMessage());
        }
    }

    protected InputStream i2pSocket_getInputStream(Object socket) throws IOException {
        try {
            return (InputStream)this.i2p_I2PSocket_getInputStream.invoke(socket, new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.log.log(e);
            throw new IOException(e.getMessage());
        }
    }

    protected OutputStream i2pSocket_getOutputStream(Object socket) throws IOException {
        try {
            return (OutputStream)this.i2p_I2PSocket_getOutputStream.invoke(socket, new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.log.log(e);
            throw new IOException(e.getMessage());
        }
    }
}

