/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.networks.i2p;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyAddress;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.plugins.networks.i2p.I2PPluginConnectionManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;

public class I2PPluginConnection
implements AESocksProxyPlugableConnection {
    private static final boolean TRACE = true;
    public static final int RELAY_BUFFER_SIZE = 65792;
    protected I2PPluginConnectionManager con_man;
    protected Object socket;
    protected boolean socket_closed;
    protected AESocksProxyConnection proxy_connection;
    protected proxyStateRelayData relay_state;
    protected AEMonitor this_mon = new AEMonitor("I2PPluginConnection");

    protected I2PPluginConnection(I2PPluginConnectionManager _con_man, AESocksProxyConnection _proxy_connection) {
        this.con_man = _con_man;
        this.proxy_connection = _proxy_connection;
        this.proxy_connection.disableDNSLookups();
    }

    public String getName() {
        return "I2PPluginConnection";
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            Debug.printStackTrace((Throwable)e);
            return null;
        }
    }

    public int getLocalPort() {
        return -1;
    }

    public void connect(AESocksProxyAddress _address) throws IOException {
        this.con_man.log("connect request to " + _address.getUnresolvedAddress() + "/" + _address.getAddress() + "/" + _address.getPort());
        if (_address.getAddress() != null) {
            if (this.con_man.proxyI2POnly()) {
                this.con_man.log("    NOT delegating resolved, non-I2P delegation disabled");
                throw new IOException("delegation to non-I2P locations disabled");
            }
            this.con_man.log("    delegating resolved");
            AESocksProxyPlugableConnection delegate = this.proxy_connection.getProxy().getDefaultPlugableConnection(this.proxy_connection);
            this.proxy_connection.setDelegate(delegate);
            delegate.connect(_address);
        } else {
            final String externalised_address = AEProxyFactory.getAddressMapper().externalise(_address.getUnresolvedAddress());
            if (!externalised_address.toLowerCase().endsWith(".i2p")) {
                if (this.con_man.proxyI2POnly()) {
                    this.con_man.log("    NOT delegating unresolved, non-I2P delegation disabled");
                    throw new IOException("delegation to non-I2P locations disabled");
                }
                this.con_man.log("    delegating unresolved");
                AESocksProxyPlugableConnection delegate = this.proxy_connection.getProxy().getDefaultPlugableConnection(this.proxy_connection);
                this.proxy_connection.enableDNSLookups();
                this.proxy_connection.setDelegate(delegate);
                delegate.connect(_address);
            } else {
                AEThread connect_thread = new AEThread("I2PConnect"){

                    public void runSupport() {
                        I2PPluginConnection.this.con_man.log("    delegating to I2P");
                        try {
                            String new_externalised_address = externalised_address.substring(0, externalised_address.length() - 4);
                            I2PPluginConnection.this.socket = I2PPluginConnection.this.con_man.i2pSocketManager_connect(new_externalised_address);
                            I2PPluginConnection.this.proxy_connection.connected();
                        }
                        catch (Throwable e) {
                            try {
                                I2PPluginConnection.this.proxy_connection.close();
                            }
                            catch (Throwable f) {
                                f.printStackTrace();
                            }
                            e.printStackTrace();
                            I2PPluginConnection.this.con_man.log("I2PSocket creation fails: " + Debug.getNestedExceptionMessage((Throwable)e));
                        }
                    }
                };
                connect_thread.setDaemon(true);
                connect_thread.start();
            }
        }
    }

    public void relayData() throws IOException {
        try {
            this.this_mon.enter();
            if (this.socket_closed) {
                throw new IOException("I2PPluginConnection::relayData: socket already closed");
            }
            this.relay_state = new proxyStateRelayData(this.proxy_connection.getConnection());
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void close() throws IOException {
        try {
            this.this_mon.enter();
            if (this.socket != null && !this.socket_closed) {
                this.socket_closed = true;
                if (this.relay_state != null) {
                    this.relay_state.close();
                }
                final Object f_socket = this.socket;
                this.socket = null;
                AEThread t = new AEThread("I2P SocketCloser"){

                    public void runSupport() {
                        try {
                            I2PPluginConnection.this.con_man.i2pSocket_close(f_socket);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected class proxyStateRelayData
    implements AEProxyState {
        protected AEProxyConnection connection;
        protected ByteBuffer source_buffer;
        protected ByteBuffer target_buffer;
        protected SocketChannel source_channel;
        protected InputStream input_stream;
        protected OutputStream output_stream;
        protected long outward_bytes = 0L;
        protected long inward_bytes = 0L;
        protected AESemaphore write_sem = new AESemaphore("I2PSocket write sem");
        protected ThreadPool async_pool = new ThreadPool("I2PSocket async", 2);

        protected proxyStateRelayData(AEProxyConnection _connection) throws IOException {
            this.connection = _connection;
            this.source_channel = this.connection.getSourceChannel();
            this.source_buffer = ByteBuffer.allocate(65792);
            this.connection.setReadState((AEProxyState)this);
            this.connection.setWriteState((AEProxyState)this);
            this.connection.requestReadSelect(this.source_channel);
            this.connection.setConnected();
            this.input_stream = I2PPluginConnection.this.con_man.i2pSocket_getInputStream(I2PPluginConnection.this.socket);
            this.output_stream = I2PPluginConnection.this.con_man.i2pSocket_getOutputStream(I2PPluginConnection.this.socket);
            this.async_pool.run(new AERunnable(){

                public void runSupport() {
                    byte[] buffer = new byte[65792];
                    while (!proxyStateRelayData.this.connection.isClosed()) {
                        try {
                            ((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.con_man.trace("I2PCon: " + proxyStateRelayData.this.getStateName() + " : read Starts <- I2P ");
                            long start = System.currentTimeMillis();
                            int len = proxyStateRelayData.this.input_stream.read(buffer);
                            if (len <= 0) break;
                            ((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.con_man.trace("I2PCon: " + proxyStateRelayData.this.getStateName() + " : read Done <- I2P - " + len + ", elapsed = " + (System.currentTimeMillis() - start));
                            if (proxyStateRelayData.this.target_buffer != null) {
                                Debug.out((String)"I2PluginConnection: target buffer should be null");
                            }
                            proxyStateRelayData.this.target_buffer = ByteBuffer.wrap(buffer, 0, len);
                            proxyStateRelayData.this.read();
                        }
                        catch (Throwable e) {
                            if (e instanceof IOException && e.getMessage() != null && (e.getMessage().startsWith("Already closed") || e.getMessage().startsWith("disconnected")) || e instanceof ClosedChannelException) break;
                            Debug.printStackTrace((Throwable)e);
                            break;
                        }
                    }
                    if (!((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.proxy_connection.isClosed()) {
                        try {
                            ((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.proxy_connection.close();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace((Throwable)e);
                        }
                    }
                }
            });
        }

        protected void close() {
            I2PPluginConnection.this.con_man.trace("I2PCon: " + this.getStateName() + " close");
            this.write_sem.releaseForever();
        }

        protected void read() throws IOException {
            this.connection.setTimeStamp();
            int written = this.source_channel.write(this.target_buffer);
            I2PPluginConnection.this.con_man.trace("I2PCon: " + this.getStateName() + " : write -> AZ - " + written);
            this.inward_bytes += (long)written;
            if (this.target_buffer.hasRemaining()) {
                this.connection.requestWriteSelect(this.source_channel);
                this.write_sem.reserve();
            }
            this.target_buffer = null;
        }

        public boolean read(SocketChannel sc) throws IOException {
            if (this.source_buffer.position() != 0) {
                Debug.out((String)"I2PluginConnection: source buffer position invalid");
            }
            this.connection.setTimeStamp();
            final int len = sc.read(this.source_buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new EOFException("read channel shutdown");
            }
            if (this.source_buffer.position() > 0) {
                this.connection.cancelReadSelect(this.source_channel);
                I2PPluginConnection.this.con_man.trace("I2PCon: " + this.getStateName() + " : read <- AZ - " + len);
                this.async_pool.run(new AERunnable(){

                    public void runSupport() {
                        try {
                            proxyStateRelayData.this.source_buffer.flip();
                            long start = System.currentTimeMillis();
                            ((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.con_man.trace("I2PCon: " + proxyStateRelayData.this.getStateName() + " : write Starts -> I2P - " + len);
                            proxyStateRelayData.this.output_stream.write(proxyStateRelayData.this.source_buffer.array(), 0, len);
                            proxyStateRelayData.this.source_buffer.position(0);
                            proxyStateRelayData.this.source_buffer.limit(proxyStateRelayData.this.source_buffer.capacity());
                            proxyStateRelayData.this.output_stream.flush();
                            ((proxyStateRelayData)proxyStateRelayData.this).I2PPluginConnection.this.con_man.trace("I2PCon: " + proxyStateRelayData.this.getStateName() + " : write done -> I2P - " + len + ", elapsed = " + (System.currentTimeMillis() - start));
                            proxyStateRelayData.this.outward_bytes += (long)len;
                            proxyStateRelayData.this.connection.requestReadSelect(proxyStateRelayData.this.source_channel);
                        }
                        catch (Throwable e) {
                            proxyStateRelayData.this.connection.failed(e);
                        }
                    }
                });
            }
            return true;
        }

        public boolean write(SocketChannel sc) throws IOException {
            try {
                int written = this.source_channel.write(this.target_buffer);
                this.inward_bytes += (long)written;
                I2PPluginConnection.this.con_man.trace("I2PCon: " + this.getStateName() + " write -> AZ: " + written);
                if (this.target_buffer.hasRemaining()) {
                    this.connection.requestWriteSelect(this.source_channel);
                } else {
                    this.write_sem.release();
                }
                return written > 0;
            }
            catch (Throwable e) {
                this.write_sem.release();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("write fails: " + Debug.getNestedExceptionMessage((Throwable)e));
            }
        }

        public boolean connect(SocketChannel sc) throws IOException {
            throw new IOException("unexpected connect");
        }

        public String getStateName() {
            String state = this.getClass().getName();
            int pos = state.indexOf("$");
            state = state.substring(pos + 1);
            return String.valueOf(state) + " [out=" + this.outward_bytes + ",in=" + this.inward_bytes + "] " + (this.source_buffer == null ? "" : this.source_buffer.toString()) + " / " + this.target_buffer;
        }
    }
}

