/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;

public class PasswordManager {
    private final I2PAppContext _context;
    protected static final int SALT_LENGTH = 16;
    protected static final int SHASH_LENGTH = 48;
    protected static final String PROP_PW = ".password";
    protected static final String PROP_B64 = ".b64";
    protected static final String PROP_MD5 = ".md5";
    protected static final String PROP_CRYPT = ".crypt";
    protected static final String PROP_SHASH = ".shash";

    public PasswordManager(I2PAppContext ctx) {
        this._context = ctx;
    }

    public boolean check(String realm, String user, String pw) {
        return this.checkPlain(realm, user, pw) || this.checkB64(realm, user, pw) || this.checkHash(realm, user, pw);
    }

    public boolean checkPlain(String realm, String user, String pw) {
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = pfx + '.' + user;
        }
        return pw.equals(this._context.getProperty(pfx + PROP_PW));
    }

    public boolean checkB64(String realm, String user, String pw) {
        String b64;
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = pfx + '.' + user;
        }
        if ((b64 = this._context.getProperty(pfx + PROP_B64)) == null) {
            return false;
        }
        return b64.equals(Base64.encode(DataHelper.getUTF8(pw)));
    }

    public boolean checkHash(String realm, String user, String pw) {
        String shash;
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = pfx + '.' + user;
        }
        if ((shash = this._context.getProperty(pfx + PROP_SHASH)) == null) {
            return false;
        }
        return this.checkHash(shash, pw);
    }

    public boolean checkHash(String shash, String pw) {
        byte[] shashBytes = Base64.decode(shash);
        if (shashBytes == null || shashBytes.length != 48) {
            return false;
        }
        byte[] salt = new byte[16];
        byte[] hash = new byte[32];
        System.arraycopy(shashBytes, 0, salt, 0, 16);
        System.arraycopy(shashBytes, 16, hash, 0, 32);
        byte[] pwHash = this._context.keyGenerator().generateSessionKey(salt, DataHelper.getUTF8(pw)).getData();
        return DataHelper.eq(hash, pwHash);
    }

    public String createHash(String pw) {
        byte[] salt = new byte[16];
        this._context.random().nextBytes(salt);
        byte[] pwHash = this._context.keyGenerator().generateSessionKey(salt, DataHelper.getUTF8(pw)).getData();
        byte[] shashBytes = new byte[48];
        System.arraycopy(salt, 0, shashBytes, 0, 16);
        System.arraycopy(pwHash, 0, shashBytes, 16, 32);
        return Base64.encode(shashBytes);
    }

    public String get(String realm, String user) {
        String rv = this.getPlain(realm, user);
        if (rv != null) {
            return rv;
        }
        return this.getB64(realm, user);
    }

    public String getPlain(String realm, String user) {
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = pfx + '.' + user;
        }
        return this._context.getProperty(pfx + PROP_PW);
    }

    public String getB64(String realm, String user) {
        String b64;
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = pfx + '.' + user;
        }
        if ((b64 = this._context.getProperty(pfx + PROP_B64)) == null) {
            return null;
        }
        return Base64.decodeToString(b64);
    }

    public static String md5Hex(String subrealm, String user, String pw) {
        String fullpw = user + ':' + subrealm + ':' + pw;
        return PasswordManager.md5Hex(fullpw);
    }

    public static String md5Hex(String fullpw) {
        byte[] data = DataHelper.getUTF8(fullpw);
        byte[] sum = PasswordManager.md5Sum(data);
        if (sum != null) {
            return DataHelper.toString(sum);
        }
        return null;
    }

    public static byte[] md5Sum(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

