/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.startup.WorkingDir;

abstract class MigrateJetty {
    private static boolean _wasChecked;
    private static boolean _hasLatestJetty;
    private static final String OLD_CLASS = "org.mortbay.jetty.Server";
    private static final String OLD_CLASS_6 = "org.mortbay.start.Main";
    private static final String NEW_CLASS = "net.i2p.jetty.JettyStart";
    private static final String TEST_CLASS = "org.eclipse.jetty.server.Server";
    private static final String BACKUP_SUFFIX = ".jetty6";
    private static final String JETTY_TEMPLATE_DIR = "eepsite-jetty7";
    private static final String JETTY_TEMPLATE_PKGDIR = "eepsite";
    private static final String BASE_CONTEXT = "contexts/base-context.xml";
    private static final String CGI_CONTEXT = "contexts/cgi-context.xml";

    MigrateJetty() {
    }

    public static void migrate(RouterContext ctx, List<ClientAppConfig> apps) {
        File cfgFile;
        boolean ok;
        boolean shouldSave = false;
        for (int i = 0; i < apps.size(); ++i) {
            String[] args;
            ClientAppConfig app = apps.get(i);
            if (!app.className.equals(OLD_CLASS) && !app.className.equals(OLD_CLASS_6)) continue;
            String client = "client application " + i + " [" + app.clientName + "] from Jetty 5/6 " + app.className + " to Jetty 7 " + NEW_CLASS;
            if (!MigrateJetty.hasLatestJetty()) {
                System.err.println("WARNING: Jetty 7 unavailable, cannot migrate " + client);
                continue;
            }
            if (app.args == null || (args = LoadClientAppsJob.parseArgs(app.args)).length == 0) continue;
            String xml = args[0];
            File xmlFile = new File(xml);
            if (!xmlFile.isAbsolute()) {
                xmlFile = new File(ctx.getAppDir(), xml);
            }
            if (!xmlFile.exists()) {
                System.err.println("WARNING: XML file " + xmlFile + " not found, cannot migrate " + client);
                continue;
            }
            File eepsite = xmlFile.getParentFile();
            boolean ok2 = MigrateJetty.backupFile(xmlFile);
            if (!ok2) {
                System.err.println("WARNING: Failed to backup up XML file " + xmlFile + ", cannot migrate " + client);
                continue;
            }
            File baseEep = new File(ctx.getBaseDir(), JETTY_TEMPLATE_DIR);
            if (!baseEep.exists()) {
                baseEep = new File(ctx.getBaseDir(), JETTY_TEMPLATE_PKGDIR);
            }
            if (baseEep.equals(eepsite)) {
                System.err.println("Eepsite in non-split directory " + eepsite + ", cannot migrate " + client);
                continue;
            }
            File baseContext = new File(baseEep, BASE_CONTEXT);
            if (!baseContext.exists()) {
                System.err.println("WARNING: Cannot find new XML file template " + baseContext + ", cannot migrate " + client);
                continue;
            }
            String newPath = eepsite.getAbsolutePath() + File.separatorChar;
            ok2 = WorkingDir.migrateJettyXml(baseEep, eepsite, "jetty.xml", "./eepsite/", newPath);
            if (!ok2) {
                System.err.println("WARNING: Failed to modify XML file " + xmlFile + ", cannot migrate " + client);
                continue;
            }
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, "jetty-ssl.xml", "./eepsite/", newPath);
            new File(eepsite, "contexts").mkdir();
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, BASE_CONTEXT, "./eepsite/", newPath);
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, CGI_CONTEXT, "./eepsite/", newPath);
            MigrateJetty.backupAndCopyFile(baseEep, eepsite, "jetty-rewrite.xml");
            new File(eepsite, "etc").mkdir();
            File to = new File(eepsite, "etc/realm.properties");
            if (!to.exists()) {
                WorkingDir.copyFile(new File(baseEep, "etc/realm.properties"), to);
            }
            MigrateJetty.backupAndCopyFile(baseEep, eepsite, "etc/webdefault.xml");
            app.className = NEW_CLASS;
            shouldSave = true;
            System.err.println("WARNING: Migrated " + client + '\n' + "Check the following files in " + eepsite + ": jetty.xml, " + BASE_CONTEXT + ", and " + CGI_CONTEXT + "\nYour old jetty.xml was backed up." + '\n' + "If you modified your jetty.xml to change ports, thread limits, etc, you MUST\nedit it to change them again. Your port was reset to 7658.");
        }
        if (shouldSave && (ok = MigrateJetty.backupFile(cfgFile = ClientAppConfig.configFile(ctx)))) {
            ClientAppConfig.writeClientAppConfig(ctx, apps);
            System.err.println("WARNING: Migrated clients config file " + cfgFile + " from Jetty 5/6 " + OLD_CLASS + '/' + OLD_CLASS_6 + " to Jetty 7 " + NEW_CLASS);
        }
    }

    private static boolean hasLatestJetty() {
        if (!_wasChecked) {
            try {
                LoadClientAppsJob.testClient(TEST_CLASS, null);
                _hasLatestJetty = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _wasChecked = true;
        }
        return _hasLatestJetty;
    }

    private static boolean backupFile(File from) {
        boolean rv;
        if (!from.exists()) {
            return true;
        }
        File to = new File(from.getAbsolutePath() + BACKUP_SUFFIX);
        if (to.exists()) {
            to = new File(to.getAbsolutePath() + "." + System.currentTimeMillis());
        }
        if (rv = WorkingDir.copyFile(from, to)) {
            System.err.println("Backed up file " + from + " to " + to);
        } else {
            System.err.println("WARNING: Failed to back up file " + from + " to " + to);
        }
        return rv;
    }

    private static boolean backupAndMigrateFile(File templateDir, File toDir, String filename, String fromString, String toString) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        boolean rv2 = WorkingDir.migrateJettyXml(templateDir, toDir, filename, fromString, toString);
        return rv && rv2;
    }

    private static boolean backupAndCopyFile(File templateDir, File toDir, String filename) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        File from = new File(templateDir, filename);
        boolean rv2 = WorkingDir.copyFile(from, to);
        return rv && rv2;
    }
}

