/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;

public class DeliveryInstructions
extends DataStructureImpl {
    private int _deliveryMode = -1;
    public static final int DELIVERY_MODE_LOCAL = 0;
    public static final int DELIVERY_MODE_DESTINATION = 1;
    public static final int DELIVERY_MODE_ROUTER = 2;
    public static final int DELIVERY_MODE_TUNNEL = 3;
    private Hash _destinationHash;
    private Hash _routerHash;
    private TunnelId _tunnelId;
    private boolean _delayRequested;
    private long _delaySeconds;
    private static final int FLAG_MODE_LOCAL = 0;
    private static final int FLAG_MODE_DESTINATION = 1;
    private static final int FLAG_MODE_ROUTER = 2;
    private static final int FLAG_MODE_TUNNEL = 3;
    @Deprecated
    private static final long FLAG_ENCRYPTED = 128L;
    private static final long FLAG_MODE = 96L;
    private static final long FLAG_DELAY = 16L;
    public static final DeliveryInstructions LOCAL = new LocalInstructions();

    public static DeliveryInstructions create(byte[] data, int offset) throws DataFormatException {
        if (data[offset] == 0) {
            return LOCAL;
        }
        DeliveryInstructions rv = new DeliveryInstructions();
        rv.readBytes(data, offset);
        return rv;
    }

    @Deprecated
    public boolean getEncrypted() {
        return false;
    }

    @Deprecated
    public void setEncrypted(boolean encrypted) {
    }

    @Deprecated
    public SessionKey getEncryptionKey() {
        return null;
    }

    @Deprecated
    public void setEncryptionKey(SessionKey key) {
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setDeliveryMode(int mode) {
        this._deliveryMode = mode;
    }

    public Hash getDestination() {
        return this._destinationHash;
    }

    public void setDestination(Hash dest) {
        this._destinationHash = dest;
    }

    public Hash getRouter() {
        return this._routerHash;
    }

    public void setRouter(Hash router) {
        this._routerHash = router;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    @Deprecated
    public boolean getDelayRequested() {
        return this._delayRequested;
    }

    @Deprecated
    public void setDelayRequested(boolean req) {
        this._delayRequested = req;
    }

    @Deprecated
    public long getDelaySeconds() {
        return this._delaySeconds;
    }

    @Deprecated
    public void setDelaySeconds(long seconds) {
        this._delaySeconds = seconds;
    }

    @Override
    @Deprecated
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        long flags = DataHelper.readLong(in, 1);
        this.setDeliveryMode(DeliveryInstructions.flagMode(flags));
        switch (DeliveryInstructions.flagMode(flags)) {
            case 0: {
                break;
            }
            case 1: {
                Hash destHash = Hash.create(in);
                this.setDestination(destHash);
                break;
            }
            case 2: {
                Hash routerHash = Hash.create(in);
                this.setRouter(routerHash);
                break;
            }
            case 3: {
                Hash tunnelRouterHash = Hash.create(in);
                this.setRouter(tunnelRouterHash);
                TunnelId id = new TunnelId();
                id.readBytes(in);
                this.setTunnelId(id);
            }
        }
        if (DeliveryInstructions.flagDelay(flags)) {
            long delay = DataHelper.readLong(in, 4);
            this.setDelayRequested(true);
            this.setDelaySeconds(delay);
        } else {
            this.setDelayRequested(false);
        }
    }

    public int readBytes(byte[] data, int offset) throws DataFormatException {
        int cur = offset;
        int flags = data[cur] & 0xFF;
        ++cur;
        this.setDeliveryMode(DeliveryInstructions.flagMode(flags));
        switch (DeliveryInstructions.flagMode(flags)) {
            case 0: {
                break;
            }
            case 1: {
                Hash dh = Hash.create(data, cur);
                cur += 32;
                this.setDestination(dh);
                break;
            }
            case 2: {
                Hash rh = Hash.create(data, cur);
                cur += 32;
                this.setRouter(rh);
                break;
            }
            case 3: {
                Hash trh = Hash.create(data, cur);
                this.setRouter(trh);
                this.setTunnelId(new TunnelId(DataHelper.fromLong(data, cur += 32, 4)));
                cur += 4;
            }
        }
        if (DeliveryInstructions.flagDelay(flags)) {
            long delay = DataHelper.fromLong(data, cur, 4);
            cur += 4;
            this.setDelayRequested(true);
            this.setDelaySeconds(delay);
        } else {
            this.setDelayRequested(false);
        }
        return cur - offset;
    }

    private static int flagMode(long flags) {
        long v = flags & 0x60L;
        return (int)(v >>>= 5);
    }

    private static boolean flagDelay(long flags) {
        return 0L != (flags & 0x10L);
    }

    private long getFlags() {
        long val = 0L;
        long fmode = 0L;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                fmode = 32L;
                break;
            }
            case 2: {
                fmode = 64L;
                break;
            }
            case 3: {
                fmode = 96L;
            }
        }
        val |= fmode;
        if (this.getDelayRequested()) {
            val |= 0x10L;
        }
        return val;
    }

    private int getAdditionalInfoSize() {
        int additionalSize = 0;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                additionalSize += 32;
                additionalSize += 4;
            }
        }
        if (this.getDelayRequested()) {
            additionalSize += 4;
        }
        return additionalSize;
    }

    private byte[] getAdditionalInfo() {
        int additionalSize = this.getAdditionalInfoSize();
        byte[] rv = new byte[additionalSize];
        int offset = 0;
        if ((offset += this.getAdditionalInfo(rv, offset)) != additionalSize) {
            throw new IllegalStateException("size mismatch, additionalSize = " + additionalSize + ", offset = " + offset);
        }
        return rv;
    }

    private int getAdditionalInfo(byte[] rv, int offset) {
        int origOffset = offset;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                System.arraycopy(this._destinationHash.getData(), 0, rv, offset, 32);
                offset += 32;
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                offset += 32;
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                DataHelper.toLong(rv, offset += 32, 4, this._tunnelId.getTunnelId());
                offset += 4;
            }
        }
        if (this.getDelayRequested()) {
            DataHelper.toLong(rv, offset, 4, this.getDelaySeconds());
            offset += 4;
        }
        return offset - origOffset;
    }

    @Override
    @Deprecated
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._deliveryMode < 0 || this._deliveryMode > 3) {
            throw new DataFormatException("Invalid data: mode = " + this._deliveryMode);
        }
        long flags = this.getFlags();
        byte[] additionalInfo = this.getAdditionalInfo();
        out.write((byte)flags);
        if (additionalInfo != null) {
            out.write(additionalInfo);
            out.flush();
        }
    }

    public int writeBytes(byte[] target, int offset) {
        if (this._deliveryMode < 0 || this._deliveryMode > 3) {
            throw new IllegalStateException("Invalid data: mode = " + this._deliveryMode);
        }
        long flags = this.getFlags();
        int origOffset = offset;
        DataHelper.toLong(target, offset, 1, flags);
        ++offset;
        offset += this.getAdditionalInfo(target, offset);
        return offset - origOffset;
    }

    public int getSize() {
        return 1 + this.getAdditionalInfoSize();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DeliveryInstructions)) {
            return false;
        }
        DeliveryInstructions instr = (DeliveryInstructions)obj;
        return this.getDelayRequested() == instr.getDelayRequested() && this.getDelaySeconds() == instr.getDelaySeconds() && this.getDeliveryMode() == instr.getDeliveryMode() && DataHelper.eq(this.getDestination(), instr.getDestination()) && DataHelper.eq(this.getEncryptionKey(), instr.getEncryptionKey()) && DataHelper.eq(this.getRouter(), instr.getRouter()) && DataHelper.eq(this.getTunnelId(), instr.getTunnelId());
    }

    public int hashCode() {
        return (int)this.getDelaySeconds() + this.getDeliveryMode() + DataHelper.hashCode(this.getDestination()) + DataHelper.hashCode(this.getEncryptionKey()) + DataHelper.hashCode(this.getRouter()) + DataHelper.hashCode(this.getTunnelId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[DeliveryInstructions: ");
        buf.append("\n\tDelivery mode: ");
        switch (this.getDeliveryMode()) {
            case 0: {
                buf.append("local");
                break;
            }
            case 1: {
                buf.append("destination");
                break;
            }
            case 2: {
                buf.append("router");
                break;
            }
            case 3: {
                buf.append("tunnel");
            }
        }
        buf.append("\n\tDelay requested: ").append(this.getDelayRequested());
        buf.append("\n\tDelay seconds: ").append(this.getDelaySeconds());
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tEncryption key: ").append(this.getEncryptionKey());
        buf.append("\n\tRouter: ").append(this.getRouter());
        buf.append("\n\tTunnelId: ").append(this.getTunnelId());
        return buf.toString();
    }

    private static final class LocalInstructions
    extends DeliveryInstructions {
        private LocalInstructions() {
        }

        @Override
        public void setEncrypted(boolean encrypted) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setEncryptionKey(SessionKey key) {
            throw new RuntimeException("immutable");
        }

        @Override
        public int getDeliveryMode() {
            return 0;
        }

        @Override
        public void setDeliveryMode(int mode) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDestination(Hash dest) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setRouter(Hash router) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setTunnelId(TunnelId id) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDelayRequested(boolean req) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDelaySeconds(long seconds) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void readBytes(InputStream in) throws DataFormatException, IOException {
            throw new RuntimeException("immutable");
        }

        @Override
        public int readBytes(byte[] data, int offset) throws DataFormatException {
            throw new RuntimeException("immutable");
        }

        @Override
        public void writeBytes(OutputStream out) throws DataFormatException, IOException {
            out.write(0);
        }

        @Override
        public int writeBytes(byte[] target, int offset) {
            target[offset] = 0;
            return 1;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String toString() {
            return "[DeliveryInstructions: \n\tDelivery mode: local]";
        }
    }
}

