/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdDSAPublicKey
implements EdDSAKey,
PublicKey {
    private static final long serialVersionUID = 9837459837498475L;
    private final GroupElement A;
    private final GroupElement Aneg;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;

    public EdDSAPublicKey(EdDSAPublicKeySpec spec) {
        this.A = spec.getA();
        this.Aneg = spec.getNegativeA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = spec.getParams();
    }

    public EdDSAPublicKey(X509EncodedKeySpec spec) throws InvalidKeySpecException {
        this(new EdDSAPublicKeySpec(EdDSAPublicKey.decode(spec.getEncoded()), (EdDSAParameterSpec)EdDSANamedCurveTable.getByName("ed25519-sha-512")));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.getByName("ed25519-sha-512"))) {
            return null;
        }
        int totlen = 15 + this.Abyte.length;
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        rv[idx++] = (byte)(13 + this.Abyte.length);
        rv[idx++] = 48;
        rv[idx++] = 8;
        rv[idx++] = 6;
        rv[idx++] = 3;
        rv[idx++] = 43;
        rv[idx++] = 101;
        rv[idx++] = 100;
        rv[idx++] = 10;
        rv[idx++] = 1;
        rv[idx++] = 1;
        rv[idx++] = 3;
        rv[idx++] = (byte)(1 + this.Abyte.length);
        rv[idx++] = 0;
        System.arraycopy(this.Abyte, 0, rv, idx, this.Abyte.length);
        return rv;
    }

    private static byte[] decode(byte[] d) throws InvalidKeySpecException {
        try {
            int idx = 0;
            if (d[idx++] != 48 || d[idx++] != 45 || d[idx++] != 48 || d[idx++] != 8 || d[idx++] != 6 || d[idx++] != 3 || d[idx++] != 43 || d[idx++] != 101 || d[idx++] != 100 || d[idx++] != 10 || d[idx++] != 1 || d[idx++] != 1 || d[idx++] != 3 || d[idx++] != 33 || d[idx++] != 0) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] rv = new byte[32];
            System.arraycopy(d, idx, rv, 0, 32);
            return rv;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new InvalidKeySpecException(ioobe);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        return this.Aneg;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.Abyte);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdDSAPublicKey)) {
            return false;
        }
        EdDSAPublicKey pk = (EdDSAPublicKey)o;
        return Arrays.equals(this.Abyte, pk.getAbyte()) && this.edDsaSpec.equals(pk.getParams());
    }
}

