/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    int modelHandle;
    int checkRenderer;
    int columnCount;
    int sortDirection;
    int ignoreCell;
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    GdkRGBA background;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(int n) {
        int n2 = this.getId(n, true);
        if (this.items[n2] != null) {
            return this.items[n2];
        }
        int n3 = OS.gtk_tree_model_get_path(this.modelHandle, n);
        int n4 = OS.gtk_tree_path_get_depth(n3);
        int[] nArray = new int[n4];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(n3), 4 * n4);
        int n5 = 0;
        if (n4 > 1) {
            OS.gtk_tree_path_up(n3);
            n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_get_iter(this.modelHandle, n5, n3);
        }
        this.items[n2] = new TreeItem(this, n5, 0, nArray[nArray.length - 1], false);
        OS.gtk_tree_path_free(n3);
        if (n5 != 0) {
            OS.g_free(n5);
        }
        return this.items[n2];
    }

    TreeItem _getItem(int n, int n2) {
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n3, n, n2);
        int n4 = this.getId(n3, true);
        OS.g_free(n3);
        if (this.items[n4] != null) {
            return this.items[n4];
        }
        this.items[n4] = new TreeItem(this, n, 0, n2, false);
        return this.items[n4];
    }

    int getId(int n, boolean bl) {
        int n2;
        if (bl) {
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, n, 0, nArray, -1);
            if (nArray[0] != -1) {
                return nArray[0];
            }
        }
        for (n2 = 0; n2 < this.items.length && this.items[n2] != null; ++n2) {
        }
        if (n2 == this.items.length) {
            TreeItem[] treeItemArray = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
            this.items = treeItemArray;
        }
        OS.gtk_tree_store_set(this.modelHandle, n, 0, n2, -1);
        return n2;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        if (n2 == this.ignoreCell) {
            return 0;
        }
        TreeItem treeItem = this._getItem(n4);
        if (treeItem != null) {
            OS.g_object_set_qdata(n2, Display.SWT_OBJECT_INDEX2, treeItem.handle);
        }
        boolean bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(n2);
        boolean bl2 = OS.GTK_IS_CELL_RENDERER_TEXT(n2);
        if (bl2 && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(n2, -1, -1);
        }
        if (!bl && !bl2) {
            return 0;
        }
        int n6 = -1;
        boolean bl3 = false;
        if (this.columnCount == 0) {
            n6 = 6;
            bl3 = this.firstCustomDraw;
        } else {
            TreeColumn treeColumn = (TreeColumn)this.display.getWidget(n);
            if (treeColumn != null) {
                n6 = treeColumn.modelIndex;
                bl3 = treeColumn.customDraw;
            }
        }
        if (n6 == -1) {
            return 0;
        }
        boolean bl4 = false;
        if ((this.style & 0x10000000) != 0 && !treeItem.cached) {
            bl4 = this.checkData(treeItem);
        }
        int[] nArray = new int[1];
        if (bl4) {
            if (bl) {
                nArray[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n6 + 0, nArray, -1);
                OS.g_object_set(n2, OS.GTK3 ? OS.gicon : OS.pixbuf, nArray[0], 0);
                if (nArray[0] != 0) {
                    OS.g_object_unref(nArray[0]);
                }
            } else {
                nArray[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n6 + 1, nArray, -1);
                if (nArray[0] != 0) {
                    OS.g_object_set(n2, OS.text, nArray[0], 0);
                    OS.g_free(nArray[0]);
                }
            }
        }
        if (bl3) {
            if (!this.ownerDraw) {
                nArray[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n6 + 3, nArray, -1);
                if (nArray[0] != 0) {
                    OS.g_object_set(n2, OS.cell_background_gdk, nArray[0], 0);
                    OS.gdk_color_free(nArray[0]);
                }
            }
            if (!bl) {
                nArray[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n6 + 2, nArray, -1);
                if (nArray[0] != 0) {
                    OS.g_object_set(n2, OS.foreground_gdk, nArray[0], 0);
                    OS.gdk_color_free(nArray[0]);
                }
                nArray[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n6 + 4, nArray, -1);
                if (nArray[0] != 0) {
                    OS.g_object_set(n2, OS.font_desc, nArray[0], 0);
                    OS.pango_font_description_free(nArray[0]);
                }
            }
        }
        if (bl4) {
            this.ignoreCell = n2;
            this.setScrollWidth(n, treeItem);
            this.ignoreCell = 0;
        }
        return 0;
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            TreeItem treeItem2 = treeItem.getParentItem();
            Event event = new Event();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            this.currentItem = treeItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            if (treeItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(int n, int n2, boolean bl) {
        int n3;
        OS.gtk_tree_view_column_cell_set_cell_data(n, this.modelHandle, n2, false, false);
        int n4 = 0;
        int[] nArray = new int[1];
        int n5 = 0;
        if (OS.gtk_tree_view_get_expander_column(this.handle) == n) {
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_widget_realize(this.handle);
            n5 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
            OS.gtk_tree_view_get_cell_area(this.handle, n5, n, gdkRectangle);
            n4 += gdkRectangle.x;
            OS.gtk_widget_style_get(this.handle, OS.expander_size, nArray, 0);
            n4 += nArray[0] + 4;
        }
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
        n4 += 2 * nArray[0];
        int n6 = OS.gtk_cell_layout_get_cells(n);
        if (n6 == 0) {
            return 0;
        }
        int n7 = n6;
        while (n7 != 0) {
            n3 = OS.g_list_data(n7);
            if (n3 != 0) {
                this.gtk_cell_renderer_get_preferred_size(n3, this.handle, nArray, null);
                n4 += nArray[0];
            }
            n7 = OS.g_list_next(n7);
        }
        OS.g_list_free(n6);
        if (bl) {
            if (n5 == 0) {
                n5 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
            }
            if ((n3 = (int)(OS.gtk_tree_view_row_expanded(this.handle, n5) ? 1 : 0)) != 0) {
                int n8 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                boolean bl2 = OS.gtk_tree_model_iter_children(this.modelHandle, n8, n2);
                while (bl2) {
                    n4 = Math.max(n4, this.calculateWidth(n, n8, true));
                    bl2 = OS.gtk_tree_model_iter_next(this.modelHandle, n8);
                }
                OS.g_free(n8);
            }
        }
        if (n5 != 0) {
            OS.gtk_tree_path_free(n5);
        }
        if (OS.gtk_tree_view_get_grid_lines(this.handle) > 0) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0);
            n4 += 2 * nArray[0];
        }
        return n4;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        this.clear(0, n, bl);
    }

    void clear(int n, int n2, boolean bl) {
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n3, n, n2);
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, n3, 0, nArray, -1);
        if (nArray[0] != -1) {
            TreeItem treeItem = this.items[nArray[0]];
            treeItem.clear();
        }
        if (bl) {
            this.clearAll(bl, n3);
        }
        OS.g_free(n3);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(bl, 0);
    }

    void clearAll(boolean bl, int n) {
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean bl2 = OS.gtk_tree_model_iter_children(this.modelHandle, n3, n);
        int[] nArray = new int[1];
        while (bl2) {
            OS.gtk_tree_model_get(this.modelHandle, n3, 0, nArray, -1);
            if (nArray[0] != -1) {
                TreeItem treeItem = this.items[nArray[0]];
                treeItem.clear();
            }
            if (bl) {
                this.clearAll(bl, n3);
            }
            bl2 = OS.gtk_tree_model_iter_next(this.modelHandle, n3);
        }
        OS.g_free(n3);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        OS.gtk_widget_realize(this.handle);
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (OS.GTK3 && point.y == 0 && n2 == -1) {
            point.y = this.getItemCount() * this.getItemHeight();
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void copyModel(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        int n8 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_iter_children(n, n8, n5)) {
            int n9;
            int n10;
            int[] nArray2 = new int[OS.gtk_tree_model_iter_n_children(n, n5)];
            int n11 = 0;
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            do {
                if ((n10 = OS.g_malloc(OS.GtkTreeIter_sizeof())) == 0) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(n3, n10, n6);
                OS.gtk_tree_model_get(n, n8, 0, nArray4, -1);
                n9 = nArray4[0];
                TreeItem treeItem = null;
                if (n9 != -1) {
                    treeItem = this.items[n9];
                    if (treeItem != null) {
                        int n12;
                        int n13 = treeItem.handle;
                        nArray2[n11++] = n13;
                        for (n12 = 0; n12 < 3; ++n12) {
                            OS.gtk_tree_model_get(n, n13, n12, nArray4, -1);
                            OS.gtk_tree_store_set(n3, n10, n12, nArray4[0], -1);
                        }
                        for (n12 = 3; n12 < 6; ++n12) {
                            OS.gtk_tree_model_get(n, n13, n12, nArray3, -1);
                            OS.gtk_tree_store_set(n3, n10, n12, nArray3[0], -1);
                            if (nArray3[0] == 0) continue;
                            if (nArray[n12] == OS.G_TYPE_STRING()) {
                                OS.g_free(nArray3[0]);
                                continue;
                            }
                            if (nArray[n12] == OS.GDK_TYPE_COLOR()) {
                                OS.gdk_color_free(nArray3[0]);
                                continue;
                            }
                            if (nArray[n12] == OS.GDK_TYPE_PIXBUF()) {
                                OS.g_object_unref(nArray3[0]);
                                continue;
                            }
                            if (nArray[n12] != OS.PANGO_TYPE_FONT_DESCRIPTION()) continue;
                            OS.pango_font_description_free(nArray3[0]);
                        }
                        for (n12 = 0; n12 < n7 - 6; ++n12) {
                            int n14 = n4 + n12;
                            OS.gtk_tree_model_get(n, n13, n2 + n12, nArray3, -1);
                            OS.gtk_tree_store_set(n3, n10, n14, nArray3[0], -1);
                            if (nArray3[0] == 0) continue;
                            if (nArray[n14] == OS.G_TYPE_STRING()) {
                                OS.g_free(nArray3[0]);
                                continue;
                            }
                            if (nArray[n14] == OS.GDK_TYPE_COLOR()) {
                                OS.gdk_color_free(nArray3[0]);
                                continue;
                            }
                            if (nArray[n14] == OS.GDK_TYPE_PIXBUF()) {
                                OS.g_object_unref(nArray3[0]);
                                continue;
                            }
                            if (nArray[n14] != OS.PANGO_TYPE_FONT_DESCRIPTION()) continue;
                            OS.pango_font_description_free(nArray3[0]);
                        }
                    }
                } else {
                    OS.gtk_tree_store_set(n3, n10, 0, -1, -1);
                }
                this.copyModel(n, n2, n3, n4, nArray, n8, n10, n7);
                if (treeItem != null) {
                    treeItem.handle = n10;
                    continue;
                }
                OS.g_free(n10);
            } while (OS.gtk_tree_model_iter_next(n, n8));
            for (n10 = 0; n10 < nArray2.length; ++n10) {
                n9 = nArray2[n10];
                if (n9 == 0) continue;
                OS.gtk_tree_store_remove(n, n9);
                OS.g_free(n9);
            }
        }
        OS.g_free(n8);
    }

    void createColumn(TreeColumn treeColumn, int n) {
        Object object;
        int n2;
        int n3 = 6;
        if (this.columnCount != 0) {
            int n4;
            int n5;
            n2 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            object = new boolean[n2];
            for (n5 = 0; n5 < this.columnCount; ++n5) {
                int n6 = this.columns[n5].modelIndex;
                for (n4 = 0; n4 < 5; ++n4) {
                    object[n6 + n4] = true;
                }
            }
            while (n3 < n2 && object[n3]) {
                ++n3;
            }
            if (n3 == n2) {
                n5 = this.modelHandle;
                int[] nArray = this.getColumnTypes(this.columnCount + 4);
                n4 = OS.gtk_tree_store_newv(nArray.length, nArray);
                if (n4 == 0) {
                    this.error(2);
                }
                this.copyModel(n5, 6, n4, 6, nArray, 0, 0, n2);
                OS.gtk_tree_view_set_model(this.handle, n4);
                this.setModel(n4);
            }
        }
        if ((n2 = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            object = this.columns[0];
            this.createRenderers(object.handle, object.modelIndex, false, object.style);
        }
        this.createRenderers(n2, n3, n == 0, treeColumn == null ? 0 : treeColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(n2, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(n2, 2);
        }
        OS.gtk_tree_view_column_set_resizable(n2, true);
        OS.gtk_tree_view_column_set_clickable(n2, true);
        OS.gtk_tree_view_column_set_min_width(n2, 0);
        OS.gtk_tree_view_insert_column(this.handle, n2, n);
        if (this.columnCount != 0) {
            OS.gtk_tree_view_column_set_visible(n2, false);
        }
        if (treeColumn != null) {
            treeColumn.handle = n2;
            treeColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n7 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n7 + 1);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] nArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_tree_store_newv(nArray.length, nArray);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(n3, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n4 = (this.style & 0x100) != 0 ? 1 : 2;
        int n5 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n4, n5);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0);
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    int applyThemeBackground() {
        return -1;
    }

    void createItem(TreeColumn treeColumn, int n) {
        int n2;
        int n3;
        int n4;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            treeColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(treeColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(treeColumn.handle, false);
            treeColumn.modelIndex = 6;
            this.createRenderers(treeColumn.handle, treeColumn.modelIndex, true, treeColumn.style);
            treeColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(treeColumn, n);
        }
        int n5 = this.gtk_box_new(0, false, 3);
        if (n5 == 0) {
            this.error(2);
        }
        if ((n4 = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((n3 = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(n5, n3);
        OS.gtk_container_add(n5, n4);
        OS.gtk_widget_show(n5);
        OS.gtk_widget_show(n4);
        treeColumn.labelHandle = n4;
        treeColumn.imageHandle = n3;
        OS.gtk_tree_view_column_set_widget(treeColumn.handle, n5);
        if (OS.GTK3) {
            treeColumn.buttonHandle = OS.gtk_tree_view_column_get_button(treeColumn.handle);
        } else {
            n2 = OS.gtk_widget_get_parent(n5);
            while (n2 != this.handle) {
                if (OS.GTK_IS_BUTTON(n2)) {
                    treeColumn.buttonHandle = n2;
                    break;
                }
                n2 = OS.gtk_widget_get_parent(n2);
            }
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] treeColumnArray = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columns.length);
            this.columns = treeColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        if ((this.state & 0x4000) != 0) {
            treeColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                Font[] fontArray;
                TreeItem treeItem = this.items[n2];
                if (treeItem == null || (fontArray = treeItem.cellFont) == null) continue;
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                treeItem.cellFont = fontArray2;
            }
        }
    }

    void createItem(TreeItem treeItem, int n, int n2) {
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n);
        if (n2 == -1) {
            n2 = n3;
        }
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        treeItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (treeItem.handle == 0) {
            this.error(2);
        }
        if (n2 == n3) {
            OS.gtk_tree_store_append(this.modelHandle, treeItem.handle, n);
        } else {
            OS.gtk_tree_store_insert(this.modelHandle, treeItem.handle, n, n2);
        }
        int n4 = this.getId(treeItem.handle, false);
        this.items[n4] = treeItem;
        this.modelChanged = true;
    }

    void createRenderers(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        OS.gtk_tree_view_column_clear(n);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(n, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.active, 1);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.inconsistent, 2);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.cell_background_gdk, 4);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(n, this.checkRenderer, this.display.cellDataProc, this.handle, 0);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, n);
            }
        }
        int n6 = n5 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0) : OS.gtk_cell_renderer_pixbuf_new();
        if (n5 == 0) {
            this.error(2);
        } else if (!this.ownerDraw && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(n5, 16, 16);
        }
        int n7 = n4 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0) : OS.gtk_cell_renderer_text_new();
        if (n4 == 0) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(n5, Display.SWT_OBJECT_INDEX1, n);
            OS.g_object_set_qdata(n4, Display.SWT_OBJECT_INDEX1, n);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(n5, OS.mode, 1, 0);
        }
        if ((n3 & 0x20000) != 0) {
            OS.g_object_set(n4, OS.xalign, 1.0f, 0);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_pack_end(n, n5, false);
            OS.gtk_tree_view_column_set_alignment(n, 1.0f);
        } else if ((n3 & 0x1000000) != 0) {
            OS.g_object_set(n4, OS.xalign, 0.5f, 0);
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_start(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(n, n5, OS.GTK3 ? OS.gicon : OS.pixbuf, n2 + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(n, n5, OS.cell_background_gdk, 4);
            OS.gtk_tree_view_column_add_attribute(n, n4, OS.cell_background_gdk, 4);
        }
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.text, n2 + 1);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.foreground_gdk, 3);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.font_desc, 5);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != n) continue;
                bl2 = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(n, n4, this.display.cellDataProc, this.handle, 0);
            OS.gtk_tree_view_column_set_cell_data_func(n, n5, this.display.cellDataProc, this.handle, 0);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_iter(n, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn treeColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != treeColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        int n2 = treeColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = treeColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, n2);
        if (this.columnCount == 0) {
            int n3 = this.modelHandle;
            int[] nArray = this.getColumnTypes(1);
            int n4 = OS.gtk_tree_store_newv(nArray.length, nArray);
            if (n4 == 0) {
                this.error(2);
            }
            this.copyModel(n3, treeColumn.modelIndex, n4, 6, nArray, 0, 0, 11);
            OS.gtk_tree_view_set_model(this.handle, n4);
            this.setModel(n4);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                TreeItem treeItem = this.items[i];
                if (treeItem == null) continue;
                int n5 = treeItem.handle;
                int n6 = treeColumn.modelIndex;
                OS.gtk_tree_store_set(this.modelHandle, n5, n6 + 0, 0, -1);
                OS.gtk_tree_store_set(this.modelHandle, n5, n6 + 1, 0, -1);
                OS.gtk_tree_store_set(this.modelHandle, n5, n6 + 2, 0, -1);
                OS.gtk_tree_store_set(this.modelHandle, n5, n6 + 3, 0, -1);
                OS.gtk_tree_store_set(this.modelHandle, n5, n6 + 4, 0, -1);
                Font[] fontArray = treeItem.cellFont;
                if (fontArray == null) continue;
                if (this.columnCount == 0) {
                    treeItem.cellFont = null;
                    continue;
                }
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                treeItem.cellFont = fontArray2;
            }
            if (n == 0) {
                TreeColumn treeColumn2 = this.columns[0];
                treeColumn2.style &= 0xFEFDBFFF;
                treeColumn2.style |= 0x4000;
                this.createRenderers(treeColumn2.handle, treeColumn2.modelIndex, true, treeColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n7 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n7 + 1);
        }
    }

    void destroyItem(TreeItem treeItem) {
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_store_remove(this.modelHandle, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        this.modelChanged = true;
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            int[] nArray = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, nArray, null, null, null)) {
                if (nArray[0] != 0) {
                    int n3 = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(nArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return true;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        for (int i = 0; i < this.columnCount; ++i) {
            TreeColumn treeColumn = this.columns[i];
            if (treeColumn.toolTipText == null) continue;
            treeColumn.setToolTipText(shell2, null);
            treeColumn.setToolTipText(shell, treeColumn.toolTipText);
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        int n = this.gtk_widget_get_window(this.fixedHandle);
        int n2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(n, nArray3, nArray4);
        int n3 = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(n3, gtkAllocation);
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        Rectangle rectangle = new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n4, n5);
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            rectangle.y += this.getHeaderHeight();
        }
        return rectangle;
    }

    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int n = OS.gtk_tree_view_get_columns(this.handle);
        if (n == 0) {
            return new int[0];
        }
        int n2 = 0;
        int n3 = OS.g_list_length(n);
        int[] nArray = new int[n3];
        int n4 = n;
        while (n4 != 0) {
            int n5 = OS.g_list_data(n4);
            if (n5 != 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].handle != n5) continue;
                    nArray[n2++] = i;
                    break;
                }
            }
            n4 = OS.g_list_next(n4);
        }
        OS.g_list_free(n);
        return nArray;
    }

    int[] getColumnTypes(int n) {
        int[] nArray = new int[6 + n * 5];
        nArray[0] = OS.G_TYPE_INT();
        nArray[1] = OS.G_TYPE_BOOLEAN();
        nArray[2] = OS.G_TYPE_BOOLEAN();
        nArray[3] = OS.GDK_TYPE_COLOR();
        nArray[4] = OS.GDK_TYPE_COLOR();
        nArray[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 6; i < nArray.length; i += 5) {
            nArray[i + 0] = OS.GDK_TYPE_PIXBUF();
            nArray[i + 1] = OS.G_TYPE_STRING();
            nArray[i + 2] = OS.GDK_TYPE_COLOR();
            nArray[i + 3] = OS.GDK_TYPE_COLOR();
            nArray[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    GdkColor getContextBackground() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.background != null) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.red = (short)(this.background.red * 65535.0);
                gdkColor.green = (short)(this.background.green * 65535.0);
                gdkColor.blue = (short)(this.background.blue * 65535.0);
                return gdkColor;
            }
            return this.display.COLOR_LIST_BACKGROUND;
        }
        return super.getContextBackground();
    }

    TreeItem getFocusItem() {
        int[] nArray = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, nArray, null);
        if (nArray[0] == 0) {
            return null;
        }
        TreeItem treeItem = null;
        int n = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, n, nArray[0])) {
            int[] nArray2 = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, n, 0, nArray2, -1);
            if (nArray2[0] != -1) {
                treeItem = this.items[nArray2[0]];
            }
        }
        OS.g_free(n);
        OS.gtk_tree_path_free(nArray[0]);
        return treeItem;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                int n2 = this.columns[i].buttonHandle;
                if (n2 == 0) continue;
                this.gtk_widget_get_preferred_size(n2, gtkRequisition);
                n = Math.max(n, gtkRequisition.height);
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        int n = this.gtk_widget_get_window(this.fixedHandle);
        int n3 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(n3, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        return this._getItem(0, n);
    }

    public TreeItem getItem(Point point) {
        int[] nArray;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        int n = point.x;
        int n2 = point.y;
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            n2 -= this.getHeaderHeight();
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, nArray2, nArray = new int[1], null, null)) {
            return null;
        }
        if (nArray2[0] == 0) {
            return null;
        }
        TreeItem treeItem = null;
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, n3, nArray2[0])) {
            boolean bl = false;
            if (OS.gtk_tree_view_get_expander_column(this.handle) == nArray[0]) {
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, nArray2[0], nArray[0], gdkRectangle);
                if ((this.style & 0x8000000) != 0) {
                    bl = n > gdkRectangle.x + gdkRectangle.width;
                } else {
                    boolean bl2 = bl = n < gdkRectangle.x;
                }
            }
            if (!bl) {
                treeItem = this._getItem(n3);
            }
        }
        OS.g_free(n3);
        OS.gtk_tree_path_free(nArray2[0]);
        return treeItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (n == 0) {
            int n2 = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(n2, null, null, null, nArray, nArray2);
            int n3 = nArray2[0];
            if (OS.GTK3) {
                int n4 = this.getTextRenderer(n2);
                OS.gtk_cell_renderer_get_preferred_height_for_width(n4, this.handle, 0, nArray2, null);
                n3 += nArray2[0];
            }
            this.ignoreSize = false;
            return n3;
        }
        int n5 = 0;
        int n6 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, n6);
        int n7 = Math.max(1, this.columnCount);
        for (int i = 0; i < n7; ++i) {
            int n8 = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(n8, this.modelHandle, n6, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(n8, null, null, null, nArray, nArray3);
            n5 = Math.max(n5, nArray3[0]);
        }
        OS.g_free(n6);
        return n5;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0);
    }

    TreeItem[] getItems(int n) {
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n);
        TreeItem[] treeItemArray = new TreeItem[n2];
        if (n2 == 0) {
            return treeItemArray;
        }
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < n2; ++i) {
                treeItemArray[i] = this._getItem(n, i);
            }
        } else {
            int n3 = 0;
            int[] nArray = new int[1];
            int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            boolean bl = OS.gtk_tree_model_iter_children(this.modelHandle, n4, n);
            while (bl) {
                OS.gtk_tree_model_get(this.modelHandle, n4, 0, nArray, -1);
                treeItemArray[n3++] = this.items[nArray[0]];
                bl = OS.gtk_tree_model_iter_next(this.modelHandle, n4);
            }
            OS.g_free(n4);
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.GTK3) {
            return OS.gtk_tree_view_get_grid_lines(this.handle) > 0;
        }
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    int getPixbufRenderer(int n) {
        int n2 = OS.gtk_cell_layout_get_cells(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2;
        int n4 = 0;
        while (n2 != 0) {
            int n5 = OS.g_list_data(n2);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(n5)) {
                n4 = n5;
                break;
            }
            n2 = OS.g_list_next(n2);
        }
        OS.g_list_free(n3);
        return n4;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3 = n2;
            int n4 = OS.g_list_length(n2);
            TreeItem[] treeItemArray = new TreeItem[n4];
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                int n6 = OS.g_list_data(n2);
                int n7 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (OS.gtk_tree_model_get_iter(this.modelHandle, n7, n6)) {
                    treeItemArray[n5] = this._getItem(n7);
                    ++n5;
                }
                n2 = OS.g_list_next(n2);
                OS.g_free(n7);
                OS.gtk_tree_path_free(n6);
            }
            OS.g_list_free(n3);
            if (n5 < n4) {
                TreeItem[] treeItemArray2 = new TreeItem[n5];
                System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n5);
                treeItemArray = treeItemArray2;
            }
            return treeItemArray;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(n);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    int getTextRenderer(int n) {
        int n2 = OS.gtk_cell_layout_get_cells(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2;
        int n4 = 0;
        while (n2 != 0) {
            int n5 = OS.g_list_data(n2);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(n5)) {
                n4 = n5;
                break;
            }
            n2 = OS.g_list_next(n2);
        }
        OS.g_list_free(n3);
        return n4;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, nArray, null, null, null)) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        TreeItem treeItem = null;
        int n = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, n, nArray[0])) {
            treeItem = this._getItem(n);
        }
        OS.g_free(n);
        OS.gtk_tree_path_free(nArray[0]);
        return treeItem;
    }

    int gtk_button_press_event(int n, int n2) {
        int n3;
        int[] nArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        int n4 = super.gtk_button_press_event(n, n2);
        if (n4 != 0) {
            return n4;
        }
        int n5 = gdkEventButton.button;
        if (n5 == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                n4 = 1;
            }
            OS.gtk_tree_path_free(nArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, nArray[0], 0, false);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(nArray[0]);
        }
        if (gdkEventButton.type == 5) {
            this.sendTreeDefaultSelection();
        }
        return n4;
    }

    int gtk_key_press_event(int n, int n2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        int n3 = gdkEventKey.keyval;
        this.keyPressDefaultSelectionHandler(n2, n3);
        return super.gtk_key_press_event(n, n2);
    }

    void keyPressDefaultSelectionHandler(int n, int n2) {
        int n3 = this.gdk_event_get_state(n);
        switch (n2) {
            case 65293: {
                if ((n3 & 0x1C00000D) != 0) break;
                this.sendTreeDefaultSelection();
                break;
            }
            case 32: {
                if ((n3 & 0x1C00000C) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem == null) {
            return;
        }
        Event event = new Event();
        event.item = treeItem;
        this.sendSelectionEvent(14, event, false);
    }

    int gtk_button_release_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_button_release_event(n, n2);
    }

    int gtk_changed(int n) {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem != null) {
            Event event = new Event();
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        switch (OS.GDK_EVENT_TYPE(n2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(n, n2);
            }
        }
        return super.gtk_event_after(n, n2);
    }

    int gtk_expand_collapse_cursor_row(int n, int n2, int n3, int n4) {
        if (n3 != 0 && n4 != 0) {
            this.expandAll = true;
        }
        return 0;
    }

    void drawInheritedBackground(int n, int n2) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            Object object;
            int n3 = OS.gtk_tree_view_get_bin_window(this.handle);
            int n4 = 0;
            if (n != 0) {
                object = new GdkEventExpose();
                OS.memmove((GdkEventExpose)object, n, GdkEventExpose.sizeof);
                if (n3 != object.window) {
                    return;
                }
                n4 = object.region;
            }
            object = new int[1];
            int[] nArray = new int[1];
            this.gdk_window_get_size(n3, (int[])object, nArray);
            int n5 = 0;
            int n6 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n5);
            GdkRectangle gdkRectangle = new GdkRectangle();
            boolean bl = true;
            while (n6 != 0 && bl && nArray[0] > gdkRectangle.y + gdkRectangle.height) {
                int n7 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, n7, n5, n6 - 1);
                n6 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n7);
                int n8 = OS.gtk_tree_model_get_path(this.modelHandle, n7);
                OS.gtk_tree_view_get_cell_area(this.handle, n8, 0, gdkRectangle);
                bl = OS.gtk_tree_view_row_expanded(this.handle, n8);
                OS.gtk_tree_path_free(n8);
                if (n5 != 0) {
                    OS.g_free(n5);
                }
                n5 = n7;
            }
            if (n5 != 0) {
                OS.g_free(n5);
            }
            if (nArray[0] > gdkRectangle.y + gdkRectangle.height) {
                this.drawBackground(control, n3, n2, n4, 0, gdkRectangle.y + gdkRectangle.height, object[0], nArray[0] - (gdkRectangle.y + gdkRectangle.height));
            }
        }
    }

    int gtk_draw(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(0, n2);
        return super.gtk_draw(n, n2);
    }

    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(n2, 0);
        return super.gtk_expose_event(n, n2);
    }

    int gtk_motion_notify_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_motion_notify_event(n, n2);
    }

    int gtk_row_deleted(int n, int n2) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_deleted);
        }
        return 0;
    }

    int gtk_row_has_child_toggled(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, n3, 0, nArray, -1);
        if (nArray[0] >= this.items.length) {
            return 0;
        }
        TreeItem treeItem = this.items[nArray[0]];
        if (treeItem == null) {
            return 0;
        }
        int n4 = OS.gtk_tree_model_iter_n_children(this.modelHandle, treeItem.handle);
        if (n4 != 0 && treeItem.isExpanded) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 51);
            OS.gtk_tree_view_expand_row(this.handle, n2, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 51);
        }
        return 0;
    }

    int gtk_row_inserted(int n, int n2, int n3) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_inserted);
        }
        return 0;
    }

    int gtk_start_interactive_search(int n) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(n, OS.start_interactive_search);
            return 1;
        }
        return 0;
    }

    int gtk_test_collapse_row(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, n2, 0, nArray, -1);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean bl2 = this.modelChanged || !OS.gtk_tree_view_row_expanded(this.handle, n3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1;
        }
        treeItem.isExpanded = false;
        if (bl2) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 50);
            OS.gtk_tree_view_collapse_row(this.handle, n3);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 50);
            return 1;
        }
        return 0;
    }

    int gtk_test_expand_row(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, n2, 0, nArray, -1);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean bl2 = this.modelChanged || OS.gtk_tree_view_row_expanded(this.handle, n3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1;
        }
        treeItem.isExpanded = true;
        if (bl2 || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 51);
            OS.gtk_tree_view_expand_row(this.handle, n3, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 51);
            return 1;
        }
        return 0;
    }

    int gtk_toggled(int n, int n2) {
        int n3 = OS.gtk_tree_path_new_from_string(n2);
        if (n3 == 0) {
            return 0;
        }
        TreeItem treeItem = null;
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, n4, n3)) {
            treeItem = this._getItem(n4);
        }
        OS.g_free(n4);
        OS.gtk_tree_path_free(n3);
        if (treeItem != null) {
            treeItem.setChecked(!treeItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    void gtk_widget_size_request(int n, GtkRequisition gtkRequisition) {
        int n2;
        boolean bl;
        int n3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(n, gtkRequisition);
            return;
        }
        int n4 = n3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl2 = bl = n3 != 0;
        while (n4 != 0) {
            n2 = OS.g_list_data(n4);
            if (OS.gtk_tree_view_column_get_visible(n2)) {
                bl = false;
                break;
            }
            n4 = OS.g_list_next(n4);
        }
        n2 = 0;
        if (bl) {
            n2 = OS.g_list_data(n3);
            OS.gtk_tree_view_column_set_visible(n2, true);
        }
        super.gtk_widget_size_request(n, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(n2, false);
        }
        if (n3 != 0) {
            OS.g_list_free(n3);
        }
    }

    void hideFirstColumn() {
        int n = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n, false);
    }

    void hookEvents() {
        super.hookEvents();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(n, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.getClosure(51), false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.getClosure(50), false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.getClosure(17), false);
        OS.g_signal_connect_closure(this.modelHandle, OS.row_has_child_toggled, this.display.getClosure(84), false);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        int n;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        int n2 = -1;
        int n3 = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        int n4 = OS.gtk_tree_path_get_depth(n3);
        if (n4 == 1 && (n = OS.gtk_tree_path_get_indices(n3)) != 0) {
            int[] nArray = new int[1];
            OS.memmove(nArray, n, 4);
            n2 = nArray[0];
        }
        OS.gtk_tree_path_free(n3);
        return n2;
    }

    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.columns[i].labelHandle;
            if (n == 0 || !this.mnemonicHit(n, c)) continue;
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.columns[i].labelHandle;
            if (n == 0 || !this.mnemonicMatch(n, c)) continue;
            return true;
        }
        return false;
    }

    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        if (this.fixedHandle != 0 && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            OS.gtk_widget_realize(this.fixedHandle);
            return OS.gtk_widget_get_window(this.fixedHandle);
        }
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            int n = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TreeColumn treeColumn = this.columns[i];
                this.createRenderers(treeColumn.handle, treeColumn.modelIndex, i == 0, treeColumn.style);
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem treeItem, boolean bl) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, 0, nArray, -1);
        if (nArray[0] == -1) {
            return;
        }
        if (bl) {
            treeItem.release(false);
        }
        this.items[nArray[0]] = null;
    }

    void releaseItems(int n) {
        int[] nArray = new int[1];
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean bl = OS.gtk_tree_model_iter_children(this.modelHandle, n2, n);
        while (bl) {
            this.releaseItems(n2);
            if (!this.isDisposed()) {
                TreeItem treeItem;
                OS.gtk_tree_model_get(this.modelHandle, n2, 0, nArray, -1);
                if (nArray[0] != -1 && (treeItem = this.items[nArray[0]]) != null) {
                    this.releaseItem(treeItem, true);
                }
            }
            bl = OS.gtk_tree_model_iter_next(this.modelHandle, n2);
        }
        OS.g_free(n2);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.items.length; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    void remove(int n, int n2, int n3) {
        if (n2 > n3) {
            return;
        }
        int n4 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n);
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        int n6 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n6 == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        for (int i = n2; i <= n3; ++i) {
            TreeItem treeItem;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n6, n, n2);
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, n6, 0, nArray, -1);
            TreeItem treeItem2 = treeItem = nArray[0] != -1 ? this.items[nArray[0]] : null;
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
                continue;
            }
            OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_store_remove(this.modelHandle, n6);
            OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(n6);
    }

    public void removeAll() {
        int n;
        this.checkWidget();
        for (n = 0; n < this.items.length; ++n) {
            TreeItem treeItem = this.items[n];
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
        this.items = new TreeItem[4];
        n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_tree_view_set_model(this.handle, 0);
        OS.gtk_tree_store_clear(this.modelHandle);
        OS.gtk_tree_view_set_model(this.handle, this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n2 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    void sendMeasureEvent(int n, int n2, int n3) {
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(n) && this.hooks(41)) {
            int n4 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
            TreeItem treeItem = null;
            if (n4 != 0) {
                treeItem = this._getItem(n4);
            }
            if (treeItem != null) {
                Object object;
                int n5 = 0;
                if (this.columnCount > 0) {
                    int n6 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
                    for (int i = 0; i < this.columnCount; ++i) {
                        if (this.columns[i].handle != n6) continue;
                        n5 = i;
                        break;
                    }
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (n2 != 0) {
                    OS.memmove(nArray, n2, 4);
                }
                if (n3 != 0) {
                    OS.memmove(nArray2, n3, 4);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_get_preferred_height_for_width(n, this.handle, nArray[0], nArray2, null);
                }
                Image image = treeItem.getImage(n5);
                int n7 = 0;
                if (image != null) {
                    object = image.getBounds();
                    n7 = ((Rectangle)object).width;
                }
                nArray[0] = nArray[0] + n7;
                object = new GC(this);
                ((GC)object).setFont(treeItem.getFont(n5));
                Event event = new Event();
                event.item = treeItem;
                event.index = n5;
                event.gc = object;
                event.width = nArray[0];
                event.height = nArray2[0];
                int n8 = OS.gtk_tree_model_get_path(this.modelHandle, n4);
                int n9 = OS.gtk_tree_view_get_selection(this.handle);
                if (OS.gtk_tree_selection_path_is_selected(n9, n8)) {
                    event.detail = 2;
                }
                OS.gtk_tree_path_free(n8);
                this.sendEvent(41, event);
                ((Resource)object).dispose();
                nArray[0] = event.width - n7;
                if (nArray2[0] < event.height) {
                    nArray2[0] = event.height;
                }
                if (n2 != 0) {
                    OS.memmove(n2, nArray, 4);
                }
                if (n3 != 0) {
                    OS.memmove(n3, nArray2, 4);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_set_fixed_size(n, nArray[0], nArray2[0]);
                }
            }
        }
    }

    int rendererGetPreferredWidthProc(int n, int n2, int n3, int n4) {
        int n5 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n5);
        OS.call(gtkCellRendererClass.get_preferred_width, n, n2, n3, n4);
        this.sendMeasureEvent(n, n3, 0);
        return 0;
    }

    int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n8);
        OS.call_get_size(gtkCellRendererClass.get_size, n, this.handle, n3, n4, n5, n6, n7);
        this.sendMeasureEvent(n, n6, n7);
        return 0;
    }

    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.rendererRender(n, n2, 0, n3, n4, n5, 0, n6);
        return 0;
    }

    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.rendererRender(n, 0, n2, n3, n4, n5, n6, n7);
        return 0;
    }

    void rendererRender(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Object object;
        Object object2;
        Object object3;
        int n9;
        TreeItem treeItem = null;
        int n10 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
        if (n10 != 0) {
            treeItem = this._getItem(n10);
        }
        int n11 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
        int n12 = 0;
        if (this.columnCount > 0) {
            for (n9 = 0; n9 < this.columnCount; ++n9) {
                if (this.columns[n9].handle != n11) continue;
                n12 = n9;
                break;
            }
        }
        if (treeItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(n) || (OS.GTK_IS_CELL_RENDERER_PIXBUF(n) || OS.GTK_VERSION > OS.VERSION(3, 13, 0)) && (n12 != 0 || (this.style & 0x20) == 0))) {
            int n13;
            Object object4;
            this.drawFlags = n8;
            this.drawState = 16;
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, 4, nArray, -1);
            if (nArray[0] == 0) {
                int n14 = this.columnCount == 0 ? 6 : this.columns[n12].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, n14 + 3, nArray, -1);
            }
            if (nArray[0] != 0) {
                this.drawState |= 8;
                OS.gdk_color_free(nArray[0]);
            }
            if ((n8 & 1) != 0) {
                this.drawState |= 2;
            }
            if (!(OS.GTK3 && (n8 & 1) != 0 || (n8 & 0x10) == 0)) {
                this.drawState |= 4;
            }
            object3 = new GdkRectangle();
            int n15 = OS.gtk_tree_model_get_path(this.modelHandle, n10);
            OS.gtk_tree_view_get_background_area(this.handle, n15, n11, (GdkRectangle)object3);
            OS.gtk_tree_path_free(n15);
            if (n2 != 0 && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                object4 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(n2, (GdkRectangle)object4);
                ((GdkRectangle)object3).x = ((GdkRectangle)object4).x;
                ((GdkRectangle)object3).width = ((GdkRectangle)object4).width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (object4 = this.findBackgroundControl()) != null) {
                if (n2 != 0) {
                    Cairo.cairo_save(n2);
                    if (!OS.GTK3) {
                        Cairo.cairo_reset_clip(n2);
                    }
                }
                this.drawBackground((Control)object4, n3, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                if (n2 != 0) {
                    Cairo.cairo_restore(n2);
                }
            }
            if ((n13 = this.getTextRenderer(n11)) != 0) {
                this.gtk_cell_renderer_get_preferred_size(n13, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Object object5;
                boolean bl;
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl) {
                    object5 = this.findBackgroundControl();
                    if (object5 == null) {
                        object5 = this;
                    }
                    if (!OS.GTK3) {
                        if (n2 != 0) {
                            Cairo.cairo_save(n2);
                            Cairo.cairo_reset_clip(n2);
                        }
                        this.drawBackground((Control)object5, n3, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                        if (n2 != 0) {
                            Cairo.cairo_restore(n2);
                        }
                    }
                }
                object5 = this.getGC(n2);
                if ((this.drawState & 2) != 0) {
                    ((GC)object5).setBackground(this.display.getSystemColor(26));
                    ((GC)object5).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object5).setBackground(treeItem.getBackground(n12));
                    ((GC)object5).setForeground(treeItem.getForeground(n12));
                }
                ((GC)object5).setFont(treeItem.getFont(n12));
                if ((this.style & 0x8000000) != 0) {
                    ((GdkRectangle)object3).x = this.getClientWidth() - ((GdkRectangle)object3).width - ((GdkRectangle)object3).x;
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0) && n2 != 0) {
                    object2 = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(n2, (GdkRectangle)object2);
                    ((GC)object5).setClipping(((GdkRectangle)object3).x, ((GdkRectangle)object2).y, ((GdkRectangle)object2).width, ((GdkRectangle)object2).height);
                    if (OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                        ((GdkRectangle)object3).width = ((GdkRectangle)object2).width;
                    }
                } else {
                    ((GC)object5).setClipping(((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                }
                object2 = new Event();
                ((Event)object2).item = treeItem;
                ((Event)object2).index = n12;
                ((Event)object2).gc = object5;
                ((Event)object2).x = ((GdkRectangle)object3).x;
                ((Event)object2).y = ((GdkRectangle)object3).y;
                ((Event)object2).width = ((GdkRectangle)object3).width;
                ((Event)object2).height = ((GdkRectangle)object3).height;
                ((Event)object2).detail = this.drawState;
                this.sendEvent(40, (Event)object2);
                this.drawForeground = null;
                this.drawState = ((Event)object2).doit ? ((Event)object2).detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    if (!OS.GTK3) {
                        int n16 = OS.gtk_widget_get_style(n4);
                        object = Converter.wcsToMbcs(null, "cell_odd", true);
                        OS.gtk_paint_flat_box(n16, n3, 3, 0, (GdkRectangle)object3, n4, (byte[])object, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                    }
                } else if (bl) {
                    this.drawForeground = ((GC)object5).getForeground().handle;
                }
                ((Resource)object5).dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = this.getGC(n2);
            gC.setBackground(treeItem.getBackground(n12));
            object3 = new GdkRectangle();
            OS.memmove((GdkRectangle)object3, n5, GdkRectangle.sizeof);
            gC.fillRectangle(((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(n)) {
            n9 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
            object3 = new GtkCellRendererClass();
            OS.memmove((GtkCellRendererClass)object3, n9);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(n)) {
                OS.g_object_set(n, OS.foreground_gdk, this.drawForeground, 0);
            }
            if (OS.GTK3) {
                OS.call(((GtkCellRendererClass)object3).render, n, n2, n4, n5, n6, this.drawFlags);
            } else {
                OS.call(((GtkCellRendererClass)object3).render, n, n3, n4, n5, n6, n7, this.drawFlags);
            }
        }
        if (treeItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(n) && this.hooks(42)) {
            Object object6;
            GdkRectangle gdkRectangle = new GdkRectangle();
            int n17 = OS.gtk_tree_model_get_path(this.modelHandle, n10);
            OS.gtk_tree_view_get_cell_area(this.handle, n17, n11, gdkRectangle);
            OS.gtk_tree_path_free(n17);
            if (n2 != 0 && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle gdkRectangle2 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(n2, gdkRectangle2);
                gdkRectangle.x = gdkRectangle2.x;
                gdkRectangle.width = gdkRectangle2.width;
            }
            this.ignoreSize = true;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gtk_cell_renderer_get_preferred_size(n, this.handle, nArray2, null);
            OS.gtk_tree_view_column_cell_get_position(n11, n, nArray, null);
            this.ignoreSize = false;
            Image image = treeItem.getImage(n12);
            int n18 = 0;
            if (image != null) {
                object2 = image.getBounds();
                n18 = ((Rectangle)object2).width;
            }
            if (n2 != 0 && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                gdkRectangle.x -= n18;
                gdkRectangle.width += n18;
            }
            nArray[0] = nArray[0] - n18;
            nArray2[0] = nArray2[0] + n18;
            object2 = this.getGC(n2);
            if ((this.drawState & 2) != 0) {
                if (OS.gtk_widget_has_focus(this.handle) || OS.GTK3) {
                    object6 = this.display.getSystemColor(26);
                    object = this.display.getSystemColor(27);
                } else {
                    object6 = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    object = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                ((GC)object2).setBackground((Color)object6);
                ((GC)object2).setForeground((Color)object);
            } else {
                ((GC)object2).setBackground(treeItem.getBackground(n12));
                object6 = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : treeItem.getForeground(n12);
                ((GC)object2).setForeground((Color)object6);
            }
            ((GC)object2).setFont(treeItem.getFont(n12));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
            }
            ((GC)object2).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            object6 = new Event();
            ((Event)object6).item = treeItem;
            ((Event)object6).index = n12;
            ((Event)object6).gc = object2;
            ((Event)object6).x = gdkRectangle.x + nArray[0];
            ((Event)object6).y = gdkRectangle.y;
            ((Event)object6).width = nArray2[0];
            ((Event)object6).height = gdkRectangle.height;
            ((Event)object6).detail = this.drawState;
            this.sendEvent(42, (Event)object6);
            ((Resource)object2).dispose();
        }
    }

    private GC getGC(int n) {
        GC gC;
        if (OS.GTK3) {
            GCData gCData = new GCData();
            gCData.cairo = n;
            gC = GC.gtk_new(this, gCData);
        } else {
            gC = new GC(this);
        }
        return gC;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!bl) continue;
            int n2 = OS.gtk_tree_view_get_column(this.handle, i);
            int n3 = this.getTextRenderer(n2);
            OS.gtk_tree_view_column_set_cell_data_func(n2, n3, 0, 0, 0);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                item = this.columns[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem == null) {
            OS.gtk_tree_view_set_drag_dest_row(this.handle, 0, 0);
            return;
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        Rectangle rectangle = treeItem.getBounds();
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, rectangle.x, rectangle.y, nArray, null, null, null)) {
            return;
        }
        if (nArray[0] == 0) {
            return;
        }
        int n = bl ? 0 : 1;
        OS.gtk_tree_view_set_drag_dest_row(this.handle, nArray[0], n);
        OS.gtk_tree_path_free(nArray[0]);
    }

    void setItemCount(int n, int n2) {
        boolean bl;
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, n);
        if (n2 == n3) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, n2, n3 - 1);
        if (bl) {
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            for (int i = n3; i < n2; ++i) {
                int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (n4 == 0) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(this.modelHandle, n4, n);
                OS.gtk_tree_store_set(this.modelHandle, n4, 0, -1, -1);
                OS.g_free(n4);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
        } else {
            for (int i = n3; i < n2; ++i) {
                new TreeItem(this, n, 0, i, true);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.setItemCount(0, n);
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_iter(n, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        }
    }

    void setBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2;
        GdkColor gdkColor;
        if (gdkRGBA == null) {
            gdkColor = this.getDisplay().COLOR_LIST_BACKGROUND;
            gdkRGBA2 = new GdkRGBA();
            gdkRGBA2.alpha = 1.0;
            gdkRGBA2.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
            gdkRGBA2.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
            gdkRGBA2.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        } else {
            this.background = gdkRGBA;
        }
        gdkColor = this.getDisplay().COLOR_LIST_SELECTION;
        gdkRGBA2 = new GdkRGBA();
        gdkRGBA2.alpha = 1.0;
        gdkRGBA2.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
        gdkRGBA2.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
        gdkRGBA2.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            String string = "GtkTreeView {background-color: " + this.gtk_rgba_to_css_string(gdkRGBA) + ";}\n" + "GtkTreeView:selected {background-color: " + this.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
            this.gtk_css_provider_load_from_css(n, string);
        } else {
            super.setBackgroundColor(n, n2, gdkRGBA);
            OS.gtk_widget_override_background_color(n2, 4, gdkRGBA2);
        }
    }

    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n < 0 || n >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n3 = this.columns[nArray[n]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, n3, n2);
            n2 = n3;
        }
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        TreeColumn[] treeColumnArray = this.getColumns();
        for (int i = 0; i < treeColumnArray.length; ++i) {
            if (treeColumnArray[i] == null) continue;
            treeColumnArray[i].setFontDescription(n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (!OS.GTK3) {
            OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        }
        OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
    }

    void setModel(int n) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = n;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        if (this.items != null) {
            for (n = 0; n < this.items.length; ++n) {
                if (this.items[n] == null) continue;
                this.items[n].setOrientation(bl);
            }
        }
        if (this.columns != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (this.columns[n] == null) continue;
                this.columns[n].setOrientation(bl);
            }
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(int n) {
        int n2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(n, n2);
    }

    void setScrollWidth(int n, TreeItem treeItem) {
        int n2;
        if (this.columnCount != 0 || this.currentItem == treeItem) {
            return;
        }
        int n3 = OS.gtk_tree_view_column_get_fixed_width(n);
        if (n3 < (n2 = this.calculateWidth(n, treeItem.handle, true))) {
            OS.gtk_tree_view_column_set_fixed_width(n, n2);
        }
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem == null) continue;
            if (treeItem.isDisposed()) break;
            if (treeItem.parent != this) continue;
            int n3 = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
            this.showItem(n3, false);
            if (bl2) {
                OS.gtk_tree_view_set_cursor(this.handle, n3, 0, false);
            }
            OS.gtk_tree_selection_select_iter(n2, treeItem.handle);
            OS.gtk_tree_path_free(n3);
            bl2 = false;
        }
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = treeColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem treeItem) {
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        int n = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(n, false);
        OS.gtk_tree_view_scroll_to_cell(this.handle, n, 0, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(n);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        OS.gtk_tree_view_scroll_to_cell(this.handle, 0, treeColumn.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int n;
        int n2 = Math.max(1, this.columnCount);
        for (n = 0; n < n2; ++n) {
            int n3 = OS.gtk_tree_view_get_column(this.handle, n);
            if (!OS.gtk_tree_view_column_get_visible(n3)) continue;
            return false;
        }
        n = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length != 0 && treeItemArray[0] != null) {
            this.showItem(treeItemArray[0]);
        }
    }

    void showItem(int n, boolean bl) {
        int n2;
        Object object;
        int n3 = OS.gtk_tree_path_get_depth(n);
        if (n3 > 1) {
            object = new int[n3 - 1];
            n2 = OS.gtk_tree_path_get_indices(n);
            OS.memmove(object, n2, ((int[])object).length * 4);
            int n4 = OS.gtk_tree_path_new();
            for (int i = 0; i < ((int[])object).length; ++i) {
                OS.gtk_tree_path_append_index(n4, object[i]);
                OS.gtk_tree_view_expand_row(this.handle, n4, false);
            }
            OS.gtk_tree_path_free(n4);
        }
        if (bl) {
            object = new GdkRectangle();
            OS.gtk_widget_realize(this.handle);
            OS.gtk_tree_view_get_cell_area(this.handle, n, 0, (GdkRectangle)object);
            n2 = object.y == 0 && object.height == 0 ? 1 : 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, object.x, object.y, nArray, nArray2);
            if (n2 == 0) {
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
                if (nArray2[0] < gdkRectangle.y || nArray2[0] + object.height > gdkRectangle.y + gdkRectangle.height) {
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, n, 0, n3 != 1, 0.5f, 0.0f);
            }
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        int n = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(n, true);
        OS.gtk_tree_path_free(n);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        int n = this.parentingHandle();
        int n2 = OS.gtk_container_get_children(n);
        if (n2 == 0) {
            return;
        }
        int n3 = n2;
        while (n3 != 0) {
            int n4 = OS.g_list_data(n3);
            if (n4 != 0) {
                OS.gtk_widget_queue_resize(n4);
            }
            n3 = OS.g_list_next(n3);
        }
        OS.g_list_free(n2);
        if (OS.GTK3) {
            OS.gtk_widget_queue_resize(this.handle);
        }
    }

    int windowProc(int n, int n2, int n3) {
        switch (n3) {
            case 19: {
                Control control;
                int n4 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
                if (n4 != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
                int n5 = OS.gtk_tree_view_get_bin_window(n);
                if (n5 != gdkEventExpose.window) break;
                this.drawBackground(control, n5, gdkEventExpose.region, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
                break;
            }
        }
        return super.windowProc(n, n2, n3);
    }
}

