/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class RouterAppManager
implements ClientAppManager {
    private final RouterContext _context;
    private final Log _log;
    private final ConcurrentHashMap<ClientApp, String[]> _clients;
    private final ConcurrentHashMap<String, ClientApp> _registered;

    public RouterAppManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(RouterAppManager.class);
        this._clients = new ConcurrentHashMap(16);
        this._registered = new ConcurrentHashMap(8);
        ctx.addShutdownTask(new Shutdown());
    }

    public boolean addAndStart(ClientApp app, String[] args) {
        String[] old;
        if (this._log.shouldLog(20)) {
            this._log.info("Client " + app.getDisplayName() + " ADDED");
        }
        if ((old = this._clients.put(app, args)) != null) {
            throw new IllegalArgumentException("already added");
        }
        try {
            app.startup();
            return true;
        }
        catch (Throwable t) {
            this._clients.remove(app);
            this._log.error("Client " + app + " failed to start", t);
            return false;
        }
    }

    public ClientApp getClientApp(String className, String[] args) {
        for (Map.Entry<ClientApp, String[]> e : this._clients.entrySet()) {
            if (!e.getKey().getClass().getName().equals(className) || !Arrays.equals(e.getValue(), args)) continue;
            return e.getKey();
        }
        return null;
    }

    @Override
    public void notify(ClientApp app, ClientAppState state, String message, Exception e) {
        switch (state) {
            case UNINITIALIZED: 
            case INITIALIZED: {
                if (!this._log.shouldLog(30)) break;
                this._log.warn("Client " + app.getDisplayName() + " is now " + (Object)((Object)state));
                break;
            }
            case STARTING: 
            case RUNNING: {
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " is now " + (Object)((Object)state));
                break;
            }
            case FORKED: 
            case STOPPING: 
            case STOPPED: {
                this._clients.remove(app);
                this._registered.remove(app.getName(), app);
                if (message == null) {
                    message = "";
                }
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " is now " + (Object)((Object)state) + ' ' + message, e);
                break;
            }
            case CRASHED: 
            case START_FAILED: {
                this._clients.remove(app);
                this._registered.remove(app.getName(), app);
                if (message == null) {
                    message = "";
                }
                this._log.log(50, "Client " + app.getDisplayName() + ' ' + (Object)((Object)state) + ' ' + message, e);
            }
        }
    }

    @Override
    public boolean register(ClientApp app) {
        if (!this._clients.containsKey(app) && this._log.shouldLog(20)) {
            this._log.info("Registering untracked client " + app.getName());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Client " + app.getDisplayName() + " REGISTERED AS " + app.getName());
        }
        return this._registered.putIfAbsent(app.getName(), app) == null;
    }

    @Override
    public void unregister(ClientApp app) {
        this._registered.remove(app.getName(), app);
    }

    @Override
    public ClientApp getRegisteredApp(String name) {
        return this._registered.get(name);
    }

    public synchronized void shutdown() {
        HashSet apps = new HashSet(this._clients.keySet());
        for (ClientApp app : apps) {
            ClientAppState state = app.getState();
            if (state != ClientAppState.RUNNING && state != ClientAppState.STARTING) continue;
            try {
                app.shutdown(null);
            }
            catch (Throwable throwable) {}
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>App Manager</h2>");
        buf.append("<h3>Tracked</h3>");
        this.toString1(buf);
        buf.append("<h3>Registered</h3>");
        this.toString2(buf);
        out.write(buf.toString());
    }

    private void toString1(StringBuilder buf) {
        ArrayList<String> list = new ArrayList<String>(this._clients.size());
        for (Map.Entry<ClientApp, String[]> entry : this._clients.entrySet()) {
            ClientApp key = entry.getKey();
            Object[] val = entry.getValue();
            list.add("[" + key.getName() + "] = [" + key.getClass().getName() + ' ' + Arrays.toString(val) + "] " + (Object)((Object)key.getState()) + "<br>");
        }
        Collections.sort(list);
        for (String e : list) {
            buf.append(e);
        }
    }

    private void toString2(StringBuilder buf) {
        ArrayList<String> list = new ArrayList<String>(this._registered.size());
        for (Map.Entry<String, ClientApp> entry : this._registered.entrySet()) {
            String key = entry.getKey();
            ClientApp val = entry.getValue();
            list.add("[" + key + "] = [" + val.getClass().getName() + "]<br>");
        }
        Collections.sort(list);
        for (String e : list) {
            buf.append(e);
        }
    }

    public class Shutdown
    implements Runnable {
        @Override
        public void run() {
            RouterAppManager.this.shutdown();
        }
    }
}

