/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.router;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Hash;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class RouterKeyGenerator
extends RoutingKeyGenerator {
    private final Log _log;
    private final I2PAppContext _context;
    private volatile byte[] _currentModData;
    private volatile byte[] _nextModData;
    private volatile long _nextMidnight;
    private volatile long _lastChanged;
    private final Calendar _cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final String FORMAT = "yyyyMMdd";
    private static final int LENGTH = "yyyyMMdd".length();
    private final SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public RouterKeyGenerator(I2PAppContext context) {
        this._log = context.logManager().getLog(RoutingKeyGenerator.class);
        this._context = context;
        this._fmt.setCalendar(this._cal);
        this.generateDateBasedModData();
    }

    public byte[] getModData() {
        return this._currentModData;
    }

    public byte[] getNextModData() {
        return this._nextModData;
    }

    @Override
    public long getLastChanged() {
        return this._lastChanged;
    }

    public long getTimeTillMidnight() {
        return this._nextMidnight - this._context.clock().now();
    }

    private void setCalToPreviousMidnight(long now) {
        this._cal.setTime(new Date(now));
        this._cal.set(1, this._cal.get(1));
        this._cal.set(6, this._cal.get(6));
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
    }

    private byte[] generateModDataFromCal() {
        Date today = this._cal.getTime();
        String modVal = this._fmt.format(today);
        if (modVal.length() != LENGTH) {
            throw new IllegalStateException();
        }
        byte[] mod = new byte[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            mod[i] = (byte)(modVal.charAt(i) & 0xFF);
        }
        return mod;
    }

    public synchronized boolean generateDateBasedModData() {
        boolean changed;
        long now = this._context.clock().now();
        this.setCalToPreviousMidnight(now);
        byte[] mod = this.generateModDataFromCal();
        boolean bl = changed = !Arrays.equals(this._currentModData, mod);
        if (changed) {
            this._cal.add(5, 1);
            this._nextMidnight = this._cal.getTime().getTime();
            byte[] next = this.generateModDataFromCal();
            this._currentModData = mod;
            this._nextModData = next;
            if (this._lastChanged == now) {
                ++now;
            }
            this._lastChanged = now;
            if (this._log.shouldLog(20)) {
                this._log.info("Routing modifier generated: " + HexDump.dump(mod));
            }
        }
        return changed;
    }

    @Override
    public Hash getRoutingKey(Hash origKey) {
        return RouterKeyGenerator.getKey(origKey, this._currentModData);
    }

    public Hash getNextRoutingKey(Hash origKey) {
        return RouterKeyGenerator.getKey(origKey, this._nextModData);
    }

    private static Hash getKey(Hash origKey, byte[] modData) {
        if (origKey == null) {
            throw new IllegalArgumentException("Original key is null");
        }
        byte[] modVal = new byte[32 + LENGTH];
        System.arraycopy(origKey.getData(), 0, modVal, 0, 32);
        System.arraycopy(modData, 0, modVal, 32, LENGTH);
        return SHA256Generator.getInstance().calculateHash(modVal);
    }
}

