/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    long modelHandle;
    long checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    long ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    GdkRGBA background;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        if (l2 == this.ignoreCell) {
            return 0L;
        }
        long l6 = OS.gtk_tree_model_get_path(l3, l4);
        int[] nArray = new int[1];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(l6), 4L);
        TableItem tableItem = this._getItem(nArray[0]);
        OS.gtk_tree_path_free(l6);
        if (tableItem != null) {
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX2, tableItem.handle);
        }
        boolean bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(l2);
        boolean bl2 = OS.GTK_IS_CELL_RENDERER_TEXT(l2);
        if (bl2 && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(l2, -1, -1);
        }
        if (!bl && !bl2) {
            return 0L;
        }
        int n = -1;
        boolean bl3 = false;
        if (this.columnCount == 0) {
            n = 5;
            bl3 = this.firstCustomDraw;
        } else {
            TableColumn tableColumn = (TableColumn)this.display.getWidget(l);
            if (tableColumn != null) {
                n = tableColumn.modelIndex;
                bl3 = tableColumn.customDraw;
            }
        }
        if (n == -1) {
            return 0L;
        }
        boolean bl4 = false;
        if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
            this.lastIndexOf = nArray[0];
            bl4 = this.checkData(tableItem);
        }
        long[] lArray = new long[1];
        if (bl4) {
            lArray[0] = 0L;
            if (bl) {
                OS.gtk_tree_model_get(l3, l4, n + 0, lArray, -1);
                OS.g_object_set(l2, OS.GTK3 ? OS.gicon : OS.pixbuf, lArray[0], 0L);
                if (lArray[0] != 0L) {
                    OS.g_object_unref(lArray[0]);
                }
            } else {
                OS.gtk_tree_model_get(l3, l4, n + 1, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.text, lArray[0], 0L);
                    OS.g_free(lArray[0]);
                }
            }
        }
        if (bl3) {
            if (!this.ownerDraw) {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 3, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.cell_background_gdk, lArray[0], 0L);
                    OS.gdk_color_free(lArray[0]);
                }
            }
            if (!bl) {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 2, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.foreground_gdk, lArray[0], 0L);
                    OS.gdk_color_free(lArray[0]);
                }
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 4, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.font_desc, lArray[0], 0L);
                    OS.pango_font_description_free(lArray[0]);
                }
            }
        }
        if (bl4) {
            this.ignoreCell = l2;
            this.setScrollWidth(l, tableItem);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TableItem tableItem) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(long l, long l2) {
        OS.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        if (OS.GTK3) {
            int[] nArray = new int[1];
            OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, null);
            return nArray[0];
        }
        int n = 0;
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
        n += 2 * nArray[0];
        long l3 = OS.gtk_cell_layout_get_cells(l);
        if (l3 == 0L) {
            return 0;
        }
        long l4 = l3;
        while (l4 != 0L) {
            long l5 = OS.g_list_data(l4);
            if (l5 != 0L) {
                this.gtk_cell_renderer_get_preferred_size(l5, this.handle, nArray, null);
                n += nArray[0];
            }
            l4 = OS.g_list_next(l4);
        }
        OS.g_list_free(l3);
        if (OS.gtk_tree_view_get_grid_lines(this.handle) > 0) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0L);
            n += 2 * nArray[0];
        }
        return n;
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            for (int i = n; i <= n2; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                tableItem.clear();
            }
        }
    }

    public void clear(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (0 <= nArray[n] && nArray[n] < this.itemCount) continue;
            this.error(6);
        }
        for (n = 0; n < nArray.length; ++n) {
            TableItem tableItem = this.items[nArray[n]];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (OS.GTK3 && point.y == 0 && n2 == -1) {
            point.y = this.getItemCount() * this.getItemHeight();
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void createColumn(TableColumn tableColumn, int n) {
        long l;
        int n2;
        int n3 = 5;
        if (this.columnCount != 0) {
            int n4 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] blArray = new boolean[n4];
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                int n5 = this.columns[n2].modelIndex;
                for (int i = 0; i < 5; ++i) {
                    blArray[n5 + i] = true;
                }
            }
            while (n3 < n4 && blArray[n3]) {
                ++n3;
            }
            if (n3 == n4) {
                long l2 = this.modelHandle;
                long[] lArray = this.getColumnTypes(this.columnCount + 4);
                long l3 = OS.gtk_list_store_newv(lArray.length, lArray);
                if (l3 == 0L) {
                    this.error(2);
                }
                long[] lArray2 = new long[1];
                int[] nArray = new int[1];
                for (int i = 0; i < this.itemCount; ++i) {
                    long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (l4 == 0L) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(l3, l4);
                    TableItem tableItem = this.items[i];
                    if (tableItem != null) {
                        int n6;
                        long l5 = tableItem.handle;
                        for (n6 = 0; n6 < 2; ++n6) {
                            OS.gtk_tree_model_get(l2, l5, n6, nArray, -1);
                            OS.gtk_list_store_set(l3, l4, n6, nArray[0], -1);
                        }
                        for (n6 = 2; n6 < n4; ++n6) {
                            OS.gtk_tree_model_get(l2, l5, n6, lArray2, -1);
                            OS.gtk_list_store_set(l3, l4, n6, lArray2[0], -1);
                            if (lArray2[0] == 0L) continue;
                            if (lArray[n6] == OS.G_TYPE_STRING()) {
                                OS.g_free(lArray2[0]);
                                continue;
                            }
                            if (lArray[n6] == OS.GDK_TYPE_COLOR()) {
                                OS.gdk_color_free(lArray2[0]);
                                continue;
                            }
                            if (lArray[n6] == OS.GDK_TYPE_PIXBUF()) {
                                OS.g_object_unref(lArray2[0]);
                                continue;
                            }
                            if (lArray[n6] != OS.PANGO_TYPE_FONT_DESCRIPTION()) continue;
                            OS.pango_font_description_free(lArray2[0]);
                        }
                        OS.gtk_list_store_remove(l2, l5);
                        OS.g_free(l5);
                        tableItem.handle = l4;
                        continue;
                    }
                    OS.g_free(l4);
                }
                OS.gtk_tree_view_set_model(this.handle, l3);
                this.setModel(l3);
            }
        }
        if ((l = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            TableColumn tableColumn2 = this.columns[0];
            this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, false, tableColumn2.style);
        }
        this.createRenderers(l, n3, n == 0, tableColumn == null ? 0 : tableColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(l, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(l, 2);
        }
        OS.gtk_tree_view_column_set_resizable(l, true);
        OS.gtk_tree_view_column_set_clickable(l, true);
        OS.gtk_tree_view_column_set_min_width(l, 0);
        OS.gtk_tree_view_insert_column(this.handle, l, n);
        if (this.columnCount != 0) {
            OS.gtk_tree_view_column_set_visible(l, false);
        }
        if (tableColumn != null) {
            tableColumn.handle = l;
            tableColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            n2 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(l, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        long l;
        long l2;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            tableColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(tableColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(tableColumn.handle, false);
            tableColumn.modelIndex = 5;
            this.createRenderers(tableColumn.handle, tableColumn.modelIndex, true, tableColumn.style);
            tableColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(tableColumn, n);
        }
        long l3 = this.gtk_box_new(0, false, 3);
        if (l3 == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l3, l);
        OS.gtk_container_add(l3, l2);
        OS.gtk_widget_show(l3);
        OS.gtk_widget_show(l2);
        tableColumn.labelHandle = l2;
        tableColumn.imageHandle = l;
        OS.gtk_tree_view_column_set_widget(tableColumn.handle, l3);
        if (OS.GTK3) {
            tableColumn.buttonHandle = OS.gtk_tree_view_column_get_button(tableColumn.handle);
        } else {
            long l4 = OS.gtk_widget_get_parent(l3);
            while (l4 != this.handle) {
                if (OS.GTK_IS_BUTTON(l4)) {
                    tableColumn.buttonHandle = l4;
                    break;
                }
                l4 = OS.gtk_widget_get_parent(l4);
            }
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if ((this.state & 0x4000) != 0) {
            tableColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            for (int i = 0; i < this.itemCount; ++i) {
                Font[] fontArray;
                TableItem tableItem = this.items[i];
                if (tableItem == null || (fontArray = tableItem.cellFont) == null) continue;
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                tableItem.cellFont = fontArray2;
            }
        }
        if (!this.isVisible()) {
            OS.gtk_container_resize_children(this.handle);
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        tableItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (tableItem.handle == 0L) {
            this.error(2);
        }
        if (n == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, tableItem.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, tableItem.handle, n);
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void createRenderers(long l, int n, boolean bl, int n2) {
        long l2;
        long l3;
        OS.gtk_tree_view_column_clear(l);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(l, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.active, 0);
            OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.inconsistent, 1);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(l, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, l);
            }
        }
        long l4 = l3 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : OS.gtk_cell_renderer_pixbuf_new();
        if (l3 == 0L) {
            this.error(2);
        } else if (!this.ownerDraw && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(l3, 16, 16);
        }
        long l5 = l2 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : OS.gtk_cell_renderer_text_new();
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(l3, Display.SWT_OBJECT_INDEX1, l);
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX1, l);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(l3, OS.mode, 1, 0L);
        }
        if ((n2 & 0x20000) != 0) {
            OS.g_object_set(l2, OS.xalign, 1.0f, 0L);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_pack_end(l, l3, false);
            OS.gtk_tree_view_column_set_alignment(l, 1.0f);
        } else if ((n2 & 0x1000000) != 0) {
            OS.g_object_set(l2, OS.xalign, 0.5f, 0L);
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_start(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(l, l3, OS.GTK3 ? OS.gicon : OS.pixbuf, n + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(l, l3, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(l, l2, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.text, n + 1);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.font_desc, 4);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != l) continue;
                bl2 = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(l, l2, this.display.cellDataProc, this.handle, 0L);
            OS.gtk_tree_view_column_set_cell_data_func(l, l3, this.display.cellDataProc, this.handle, 0L);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    int applyThemeBackground() {
        return -1;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)n).handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= this.itemCount) continue;
            OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)i).handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.itemCount) continue;
            OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)n).handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn tableColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != tableColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        long l = tableColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = tableColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, l);
        if (this.columnCount == 0) {
            long l2 = this.modelHandle;
            long[] lArray = this.getColumnTypes(1);
            long l3 = OS.gtk_list_store_newv(lArray.length, lArray);
            if (l3 == 0L) {
                this.error(2);
            }
            long[] lArray2 = new long[1];
            int[] nArray = new int[1];
            for (int i = 0; i < this.itemCount; ++i) {
                long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (l4 == 0L) {
                    this.error(2);
                }
                OS.gtk_list_store_append(l3, l4);
                TableItem tableItem = this.items[i];
                if (tableItem != null) {
                    int n2;
                    long l5 = tableItem.handle;
                    for (n2 = 0; n2 < 2; ++n2) {
                        OS.gtk_tree_model_get(l2, l5, n2, nArray, -1);
                        OS.gtk_list_store_set(l3, l4, n2, nArray[0], -1);
                    }
                    for (n2 = 2; n2 < 5; ++n2) {
                        OS.gtk_tree_model_get(l2, l5, n2, lArray2, -1);
                        OS.gtk_list_store_set(l3, l4, n2, lArray2[0], -1);
                        if (lArray2[0] == 0L) continue;
                        if (n2 == 2 || n2 == 3) {
                            OS.gdk_color_free(lArray2[0]);
                            continue;
                        }
                        if (n2 != 4) continue;
                        OS.pango_font_description_free(lArray2[0]);
                    }
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 0, lArray2, -1);
                    OS.gtk_list_store_set(l3, l4, 5, lArray2[0], -1);
                    if (lArray2[0] != 0L) {
                        OS.g_object_unref(lArray2[0]);
                    }
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 1, lArray2, -1);
                    OS.gtk_list_store_set(l3, l4, 6, lArray2[0], -1);
                    OS.g_free(lArray2[0]);
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 2, lArray2, -1);
                    OS.gtk_list_store_set(l3, l4, 7, lArray2[0], -1);
                    if (lArray2[0] != 0L) {
                        OS.gdk_color_free(lArray2[0]);
                    }
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 3, lArray2, -1);
                    OS.gtk_list_store_set(l3, l4, 8, lArray2[0], -1);
                    if (lArray2[0] != 0L) {
                        OS.gdk_color_free(lArray2[0]);
                    }
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 4, lArray2, -1);
                    OS.gtk_list_store_set(l3, l4, 9, lArray2[0], -1);
                    if (lArray2[0] != 0L) {
                        OS.pango_font_description_free(lArray2[0]);
                    }
                    OS.gtk_list_store_remove(l2, l5);
                    OS.g_free(l5);
                    tableItem.handle = l4;
                    continue;
                }
                OS.g_free(l4);
            }
            OS.gtk_tree_view_set_model(this.handle, l3);
            this.setModel(l3);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.itemCount; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                long l6 = tableItem.handle;
                int n3 = tableColumn.modelIndex;
                OS.gtk_list_store_set(this.modelHandle, l6, n3 + 0, 0L, -1);
                OS.gtk_list_store_set(this.modelHandle, l6, n3 + 1, 0L, -1);
                OS.gtk_list_store_set(this.modelHandle, l6, n3 + 2, 0L, -1);
                OS.gtk_list_store_set(this.modelHandle, l6, n3 + 3, 0L, -1);
                OS.gtk_list_store_set(this.modelHandle, l6, n3 + 4, 0L, -1);
                Font[] fontArray = tableItem.cellFont;
                if (fontArray == null) continue;
                if (this.columnCount == 0) {
                    tableItem.cellFont = null;
                    continue;
                }
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                tableItem.cellFont = fontArray2;
            }
            if (n == 0) {
                TableColumn tableColumn2 = this.columns[0];
                this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, true, tableColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n4 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n4 + 1);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != tableItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_remove(this.modelHandle, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            long[] lArray = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    long l = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(lArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return true;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumn tableColumn = this.columns[i];
            if (tableColumn.toolTipText == null) continue;
            tableColumn.setToolTipText(shell2, null);
            tableColumn.setToolTipText(shell, tableColumn.toolTipText);
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        long l = this.gtk_widget_get_window(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(l, nArray3, nArray4);
        long l3 = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l3, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        Rectangle rectangle = new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n, n2);
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            rectangle.y += this.getHeaderHeight();
        }
        return rectangle;
    }

    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    long[] getColumnTypes(int n) {
        long[] lArray = new long[5 + n * 5];
        lArray[0] = OS.G_TYPE_BOOLEAN();
        lArray[1] = OS.G_TYPE_BOOLEAN();
        lArray[2] = OS.GDK_TYPE_COLOR();
        lArray[3] = OS.GDK_TYPE_COLOR();
        lArray[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 5; i < lArray.length; i += 5) {
            lArray[i + 0] = OS.GDK_TYPE_PIXBUF();
            lArray[i + 1] = OS.G_TYPE_STRING();
            lArray[i + 2] = OS.GDK_TYPE_COLOR();
            lArray[i + 3] = OS.GDK_TYPE_COLOR();
            lArray[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        }
        return lArray;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long l = OS.gtk_tree_view_get_columns(this.handle);
        if (l == 0L) {
            return new int[0];
        }
        int n = 0;
        int n2 = OS.g_list_length(l);
        int[] nArray = new int[n2];
        long l2 = l;
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].handle != l3) continue;
                    nArray[n++] = i;
                    break;
                }
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    GdkColor getContextBackground() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.background != null) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.red = (short)(this.background.red * 65535.0);
                gdkColor.green = (short)(this.background.green * 65535.0);
                gdkColor.blue = (short)(this.background.blue * 65535.0);
                return gdkColor;
            }
            return this.display.COLOR_LIST_BACKGROUND;
        }
        return super.getContextBackground();
    }

    TableItem getFocusItem() {
        long[] lArray = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return null;
        }
        TableItem tableItem = null;
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        if (l != 0L) {
            int[] nArray = new int[]{-1};
            OS.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                long l = this.columns[i].buttonHandle;
                if (l == 0L) continue;
                this.gtk_widget_get_preferred_size(l, gtkRequisition);
                n = Math.max(n, gtkRequisition.height);
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        long l = this.gtk_widget_get_window(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(l2, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        int n = point.y;
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            n -= this.getHeaderHeight();
        }
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, n, lArray, null, null, null)) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        TableItem tableItem = null;
        if (l != 0L) {
            int[] nArray = new int[1];
            OS.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            long l = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, nArray2);
            int n = nArray2[0];
            if (OS.GTK3) {
                long l2 = this.getTextRenderer(l);
                OS.gtk_cell_renderer_get_preferred_height_for_width(l2, this.handle, 0, nArray2, null);
                n += nArray2[0];
            }
            this.ignoreSize = false;
            return n;
        }
        int n = 0;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, l);
        int n2 = Math.max(1, this.columnCount);
        for (int i = 0; i < n2; ++i) {
            long l3 = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(l3, this.modelHandle, l, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(l3, null, null, null, nArray, nArray3);
            n = Math.max(n, nArray3[0]);
        }
        OS.g_free(l);
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.itemCount; ++i) {
                tableItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.GTK3) {
            return OS.gtk_tree_view_get_grid_lines(this.handle) > 0;
        }
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    long getPixbufRenderer(long l) {
        long l2 = OS.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public TableItem[] getSelection() {
        long l;
        this.checkWidget();
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        long l3 = l = OS.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int n = OS.g_list_length(l);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l);
                long l5 = OS.gtk_tree_path_get_indices(l4);
                if (l5 != 0L) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, l5, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                OS.gtk_tree_path_free(l4);
                l = OS.g_list_next(l);
            }
            OS.g_list_free(l3);
            TableItem[] tableItemArray = new TableItem[n2];
            for (int i = 0; i < tableItemArray.length; ++i) {
                tableItemArray[i] = this._getItem(nArray[i]);
            }
            return tableItemArray;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(l);
    }

    public int getSelectionIndex() {
        long l;
        this.checkWidget();
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        long l3 = l = OS.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int[] nArray = new int[1];
            boolean bl = false;
            while (l != 0L) {
                long l4;
                long l5 = OS.g_list_data(l);
                if (!bl && (l4 = OS.gtk_tree_path_get_indices(l5)) != 0L) {
                    OS.memmove(nArray, l4, 4L);
                    bl = true;
                }
                l = OS.g_list_next(l);
                OS.gtk_tree_path_free(l5);
            }
            OS.g_list_free(l3);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long l;
        this.checkWidget();
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        long l3 = l = OS.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int n = OS.g_list_length(l);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l);
                long l5 = OS.gtk_tree_path_get_indices(l4);
                if (l5 != 0L) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, l5, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                l = OS.g_list_next(l);
                OS.gtk_tree_path_free(l4);
            }
            OS.g_list_free(l3);
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long l) {
        long l2 = OS.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public int getTopIndex() {
        this.checkWidget();
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return 0;
        }
        if (lArray[0] == 0L) {
            return 0;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[1];
        if (l != 0L) {
            OS.memmove(nArray, l, 4L);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    long gtk_button_press_event(long l, long l2) {
        long l3;
        long[] lArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        int n = gdkEventButton.button;
        if (n == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(l3, lArray[0])) {
                l4 = 1L;
            }
            OS.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(lArray[0]);
        }
        if (gdkEventButton.type == 5) {
            this.sendTreeDefaultSelection();
        }
        return l4;
    }

    long gtk_key_press_event(long l, long l2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        int n = gdkEventKey.keyval;
        this.keyPressDefaultSelectionHandler(l2, n);
        return super.gtk_key_press_event(l, l2);
    }

    void keyPressDefaultSelectionHandler(long l, int n) {
        int n2 = this.gdk_event_get_state(l);
        switch (n) {
            case 65293: {
                if ((n2 & 0x1C00000D) != 0) break;
                this.sendTreeDefaultSelection();
                break;
            }
            case 32: {
                if ((n2 & 0x1C00000C) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        TableItem tableItem = this.getFocusItem();
        if (tableItem == null) {
            return;
        }
        Event event = new Event();
        event.item = tableItem;
        this.sendSelectionEvent(14, event, false);
    }

    long gtk_button_release_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_button_release_event(l, l2);
    }

    long gtk_changed(long l) {
        TableItem tableItem = this.getFocusItem();
        if (tableItem != null) {
            Event event = new Event();
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        switch (OS.GDK_EVENT_TYPE(l2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(l, l2);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    void drawInheritedBackground(long l, long l2) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            Object object;
            long l3 = OS.gtk_tree_view_get_bin_window(this.handle);
            long l4 = 0L;
            if (l != 0L) {
                object = new GdkEventExpose();
                OS.memmove((GdkEventExpose)object, l, (long)GdkEventExpose.sizeof);
                if (l3 != object.window) {
                    return;
                }
                l4 = object.region;
            }
            object = new int[1];
            int[] nArray = new int[1];
            this.gdk_window_get_size(l3, (int[])object, nArray);
            int n = 0;
            if (this.itemCount != 0) {
                long l5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, l5, 0L, this.itemCount - 1);
                long l6 = OS.gtk_tree_model_get_path(this.modelHandle, l5);
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, l6, 0L, gdkRectangle);
                n = gdkRectangle.y + gdkRectangle.height;
                OS.gtk_tree_path_free(l6);
                OS.g_free(l5);
            }
            if (nArray[0] > n) {
                this.drawBackground(control, l3, l2, l4, 0, n, object[0], nArray[0] - n);
            }
        }
    }

    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(0L, l2);
        return super.gtk_draw(l, l2);
    }

    long gtk_expose_event(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(l2, 0L);
        return super.gtk_expose_event(l, l2);
    }

    long gtk_motion_notify_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    long gtk_row_deleted(long l, long l2) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(l, OS.row_deleted);
        }
        return 0L;
    }

    long gtk_row_inserted(long l, long l2, long l3) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(l, OS.row_inserted);
        }
        return 0L;
    }

    long gtk_start_interactive_search(long l) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(l, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    long gtk_toggled(long l, long l2) {
        long l3 = OS.gtk_tree_path_new_from_string(l2);
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = OS.gtk_tree_path_get_indices(l3);
        if (l4 != 0L) {
            int[] nArray = new int[1];
            OS.memmove(nArray, l4, 4L);
            TableItem tableItem = this._getItem(nArray[0]);
            tableItem.setChecked(!tableItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        OS.gtk_tree_path_free(l3);
        return 0L;
    }

    void gtk_widget_size_request(long l, GtkRequisition gtkRequisition) {
        long l2;
        boolean bl;
        long l3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(l, gtkRequisition);
            return;
        }
        long l4 = l3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl2 = bl = l3 != 0L;
        while (l4 != 0L) {
            l2 = OS.g_list_data(l4);
            if (OS.gtk_tree_view_column_get_visible(l2)) {
                bl = false;
                break;
            }
            l4 = OS.g_list_next(l4);
        }
        l2 = 0L;
        if (bl) {
            l2 = OS.g_list_data(l3);
            OS.gtk_tree_view_column_set_visible(l2, true);
        }
        super.gtk_widget_size_request(l, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(l2, false);
        }
        if (l3 != 0L) {
            OS.g_list_free(l3);
        }
    }

    void hideFirstColumn() {
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, false);
    }

    void hookEvents() {
        super.hookEvents();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != tableColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        } else {
            for (int i = this.itemCount - 1; i >= 0; --i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        long l2 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(l, l2);
        OS.gtk_tree_path_free(l2);
        return bl;
    }

    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        if (this.fixedHandle != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            OS.gtk_widget_realize(this.fixedHandle);
            return OS.gtk_widget_get_window(this.fixedHandle);
        }
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn tableColumn = this.columns[i];
                this.createRenderers(tableColumn.handle, tableColumn.modelIndex, i == 0, tableColumn.style);
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.itemCount; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(15);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem tableItem = this.items[n];
        boolean bl = false;
        if (tableItem != null) {
            bl = tableItem.isDisposed();
            if (!bl) {
                OS.memmove(l, tableItem.handle, (long)OS.GtkTreeIter_sizeof());
                tableItem.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        }
        if (!bl) {
            long l2 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, l);
            OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
            this.items[this.itemCount] = null;
        }
        OS.g_free(l);
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        for (n3 = n2; n3 >= n; --n3) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n3);
            TableItem tableItem = this.items[n3];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, l2);
            OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(l2);
        n3 = n2 + 1;
        System.arraycopy(this.items, n3, this.items, n, this.itemCount - n3);
        for (int i = this.itemCount - (n3 - n); i < this.itemCount; ++i) {
            this.items[i] = null;
        }
        this.itemCount -= n3 - n;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        int n3 = -1;
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray2[i];
            if (n4 == n3) continue;
            TableItem tableItem = this.items[n4];
            boolean bl = false;
            if (tableItem != null) {
                bl = tableItem.isDisposed();
                if (!bl) {
                    OS.memmove(l2, tableItem.handle, (long)OS.GtkTreeIter_sizeof());
                    tableItem.release(false);
                }
            } else {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n4);
            }
            if (!bl) {
                OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_list_store_remove(this.modelHandle, l2);
                OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
                System.arraycopy(this.items, n4 + 1, this.items, n4, --this.itemCount - n4);
                this.items[this.itemCount] = null;
            }
            n3 = n4;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(l2);
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = this.itemCount - 1; i >= 0; --i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_list_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendMeasureEvent(long l, long l2, long l3) {
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(41)) {
            int n;
            int[] nArray;
            long l4 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
            TableItem tableItem = null;
            boolean bl = false;
            if (l4 != 0L) {
                long l5 = OS.gtk_tree_model_get_path(this.modelHandle, l4);
                nArray = new int[1];
                OS.memmove(nArray, OS.gtk_tree_path_get_indices(l5), 4L);
                n = nArray[0];
                tableItem = this._getItem(n);
                long l6 = OS.gtk_tree_view_get_selection(this.handle);
                bl = OS.gtk_tree_selection_path_is_selected(l6, l5);
                OS.gtk_tree_path_free(l5);
            }
            if (tableItem != null) {
                Object object;
                int n2 = 0;
                if (this.columnCount > 0) {
                    long l7 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
                    for (n = 0; n < this.columnCount; ++n) {
                        if (this.columns[n].handle != l7) continue;
                        n2 = n;
                        break;
                    }
                }
                int[] nArray2 = new int[1];
                nArray = new int[1];
                if (l2 != 0L) {
                    OS.memmove(nArray2, l2, 4L);
                }
                if (l3 != 0L) {
                    OS.memmove(nArray, l3, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_get_preferred_height_for_width(l, this.handle, nArray2[0], nArray, null);
                }
                Image image = tableItem.getImage(n2);
                int n3 = 0;
                if (image != null) {
                    object = image.getBounds();
                    n3 = ((Rectangle)object).width;
                }
                nArray2[0] = nArray2[0] + n3;
                object = new GC(this);
                ((GC)object).setFont(tableItem.getFont(n2));
                Event event = new Event();
                event.item = tableItem;
                event.index = n2;
                event.gc = object;
                event.width = nArray2[0];
                event.height = nArray[0];
                if (bl) {
                    event.detail = 2;
                }
                this.sendEvent(41, event);
                ((Resource)object).dispose();
                nArray2[0] = event.width - n3;
                if (nArray[0] < event.height) {
                    nArray[0] = event.height;
                }
                if (l2 != 0L) {
                    OS.memmove(l2, nArray2, 4L);
                }
                if (l3 != 0L) {
                    OS.memmove(l3, nArray, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_set_fixed_size(l, nArray2[0], nArray[0]);
                }
            }
        }
    }

    long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        long l5 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l5);
        OS.call(gtkCellRendererClass.get_preferred_width, l, l2, l3, l4);
        this.sendMeasureEvent(l, l3, 0L);
        return 0L;
    }

    long rendererGetSizeProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        long l8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l8);
        OS.call_get_size(gtkCellRendererClass.get_size, l, this.handle, l3, l4, l5, l6, l7);
        this.sendMeasureEvent(l, l6, l7);
        return 0L;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        this.rendererRender(l, l2, 0L, l3, l4, l5, 0L, l6);
        return 0L;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        this.rendererRender(l, 0L, l2, l3, l4, l5, l6, l7);
        return 0L;
    }

    void rendererRender(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        Object object;
        Object object2;
        int n;
        GdkRectangle gdkRectangle;
        int n2;
        long l9;
        TableItem tableItem = null;
        long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
        if (l10 != 0L) {
            l9 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            int[] nArray = new int[1];
            OS.memmove(nArray, OS.gtk_tree_path_get_indices(l9), 4L);
            n2 = nArray[0];
            tableItem = this._getItem(n2);
            OS.gtk_tree_path_free(l9);
        }
        l9 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
        int n3 = 0;
        if (this.columnCount > 0) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                if (this.columns[n2].handle != l9) continue;
                n3 = n2;
                break;
            }
        }
        if (tableItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(l) || (OS.GTK_IS_CELL_RENDERER_PIXBUF(l) || OS.GTK_VERSION > OS.VERSION(3, 13, 0)) && (n3 != 0 || (this.style & 0x20) == 0))) {
            long l11;
            Object object3;
            this.drawFlags = (int)l8;
            this.drawState = 16;
            long[] lArray = new long[1];
            OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, 3, lArray, -1);
            if (lArray[0] == 0L) {
                int n4 = this.columnCount == 0 ? 5 : this.columns[n3].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, n4 + 3, lArray, -1);
            }
            if (lArray[0] != 0L) {
                this.drawState |= 8;
                OS.gdk_color_free(lArray[0]);
            }
            if ((l8 & 1L) != 0L) {
                this.drawState |= 2;
            }
            if (!(OS.GTK3 && (l8 & 1L) != 0L || (l8 & 0x10L) == 0L)) {
                this.drawState |= 4;
            }
            gdkRectangle = new GdkRectangle();
            long l12 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            OS.gtk_tree_view_get_background_area(this.handle, l12, l9, gdkRectangle);
            OS.gtk_tree_path_free(l12);
            if (l2 != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                object3 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(l2, (GdkRectangle)object3);
                gdkRectangle.x = ((GdkRectangle)object3).x;
                gdkRectangle.width = ((GdkRectangle)object3).width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (object3 = this.findBackgroundControl()) != null) {
                if (l2 != 0L) {
                    Cairo.cairo_save(l2);
                    if (!OS.GTK3) {
                        Cairo.cairo_reset_clip(l2);
                    }
                }
                this.drawBackground((Control)object3, l3, l2, 0L, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                if (l2 != 0L) {
                    Cairo.cairo_restore(l2);
                }
            }
            if ((l11 = this.getTextRenderer(l9)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(l11, this.handle, null, null);
            }
            if (this.hooks(40)) {
                int n5 = n = (this.drawState & 2) != 0 ? 1 : 0;
                if (n != 0) {
                    object2 = this.findBackgroundControl();
                    if (object2 == null) {
                        object2 = this;
                    }
                    if (!OS.GTK3) {
                        if (l2 != 0L) {
                            Cairo.cairo_save(l2);
                            Cairo.cairo_reset_clip(l2);
                        }
                        this.drawBackground((Control)object2, l3, l2, 0L, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                        if (l2 != 0L) {
                            Cairo.cairo_restore(l2);
                        }
                    }
                }
                object2 = this.getGC(l2);
                if ((this.drawState & 2) != 0) {
                    ((GC)object2).setBackground(this.display.getSystemColor(26));
                    ((GC)object2).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object2).setBackground(tableItem.getBackground(n3));
                    ((GC)object2).setForeground(tableItem.getForeground(n3));
                }
                ((GC)object2).setFont(tableItem.getFont(n3));
                if ((this.style & 0x8000000) != 0) {
                    gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0) && l2 != 0L) {
                    object = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(l2, (GdkRectangle)object);
                    ((GC)object2).setClipping(gdkRectangle.x, ((GdkRectangle)object).y, ((GdkRectangle)object).width, ((GdkRectangle)object).height);
                    if (OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                        gdkRectangle.width = ((GdkRectangle)object).width;
                    }
                } else {
                    ((GC)object2).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                }
                object = new Event();
                ((Event)object).item = tableItem;
                ((Event)object).index = n3;
                ((Event)object).gc = object2;
                ((Event)object).x = gdkRectangle.x;
                ((Event)object).y = gdkRectangle.y;
                ((Event)object).width = gdkRectangle.width;
                ((Event)object).height = gdkRectangle.height;
                ((Event)object).detail = this.drawState;
                this.sendEvent(40, (Event)object);
                this.drawForeground = null;
                this.drawState = ((Event)object).doit ? ((Event)object).detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    long l13;
                    if (OS.GTK3) {
                        Cairo.cairo_save(l2);
                        Cairo.cairo_reset_clip(l2);
                        l13 = OS.gtk_widget_get_style_context(l4);
                        OS.gtk_style_context_save(l13);
                        OS.gtk_style_context_add_class(l13, OS.GTK_STYLE_CLASS_CELL);
                        OS.gtk_style_context_set_state(l13, 4L);
                        OS.gtk_render_background(l13, l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                        OS.gtk_style_context_restore(l13);
                        Cairo.cairo_restore(l2);
                    } else {
                        l13 = OS.gtk_widget_get_style(l4);
                        byte[] byArray = Converter.wcsToMbcs(null, "cell_odd", true);
                        OS.gtk_paint_flat_box(l13, l3, 3, 0, gdkRectangle, l4, byArray, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                    }
                } else if (n != 0) {
                    this.drawForeground = ((GC)object2).getForeground().handle;
                }
                ((Resource)object2).dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = this.getGC(l2);
            gC.setBackground(tableItem.getBackground(n3));
            gdkRectangle = new GdkRectangle();
            OS.memmove(gdkRectangle, l5, (long)GdkRectangle.sizeof);
            gC.fillRectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(l)) {
            long l14 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
            GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
            OS.memmove(gtkCellRendererClass, l14);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(l)) {
                OS.g_object_set(l, OS.foreground_gdk, this.drawForeground, 0L);
            }
            if (OS.GTK3) {
                OS.call(gtkCellRendererClass.render, l, l2, l4, l5, l6, this.drawFlags);
            } else {
                OS.call(gtkCellRendererClass.render, l, l3, l4, l5, l6, l7, this.drawFlags);
            }
        }
        if (tableItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(42)) {
            Object object4;
            GdkRectangle gdkRectangle2 = new GdkRectangle();
            long l15 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            OS.gtk_tree_view_get_background_area(this.handle, l15, l9, gdkRectangle2);
            OS.gtk_tree_path_free(l15);
            if (l2 != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                object4 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(l2, (GdkRectangle)object4);
                gdkRectangle2.x = object4.x;
                gdkRectangle2.width = object4.width;
            }
            this.ignoreSize = true;
            object4 = new int[1];
            int[] nArray = new int[1];
            this.gtk_cell_renderer_get_preferred_size(l, this.handle, nArray, null);
            OS.gtk_tree_view_column_cell_get_position(l9, l, object4, null);
            this.ignoreSize = false;
            Image image = tableItem.getImage(n3);
            n = 0;
            if (image != null) {
                object2 = image.getBounds();
                n = ((Rectangle)object2).width;
            }
            if (l2 != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                gdkRectangle2.x -= n;
                gdkRectangle2.width += n;
            }
            object4[0] = object4[0] - n;
            nArray[0] = nArray[0] + n;
            object2 = this.getGC(l2);
            if ((this.drawState & 2) != 0) {
                Color color;
                if (OS.gtk_widget_has_focus(this.handle) || OS.GTK3) {
                    object = this.display.getSystemColor(26);
                    color = this.display.getSystemColor(27);
                } else {
                    object = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    color = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                ((GC)object2).setBackground((Color)object);
                ((GC)object2).setForeground(color);
            } else {
                ((GC)object2).setBackground(tableItem.getBackground(n3));
                object = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : tableItem.getForeground(n3);
                ((GC)object2).setForeground((Color)object);
            }
            ((GC)object2).setFont(tableItem.getFont(n3));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle2.x = this.getClientWidth() - gdkRectangle2.width - gdkRectangle2.x;
            }
            ((GC)object2).setClipping(gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.width, gdkRectangle2.height);
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).index = n3;
            ((Event)object).gc = object2;
            ((Event)object).x = gdkRectangle2.x + object4[0];
            ((Event)object).y = gdkRectangle2.y;
            ((Event)object).width = nArray[0];
            ((Event)object).height = gdkRectangle2.height;
            ((Event)object).detail = this.drawState;
            this.sendEvent(42, (Event)object);
            ((Resource)object2).dispose();
        }
    }

    private GC getGC(long l) {
        GC gC;
        if (OS.GTK3) {
            GCData gCData = new GCData();
            gCData.cairo = l;
            gC = GC.gtk_new(this, gCData);
        } else {
            gC = new GC(this);
        }
        return gC;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!bl) continue;
            long l = OS.gtk_tree_view_get_column(this.handle, i);
            long l2 = this.getTextRenderer(l);
            OS.gtk_tree_view_column_set_cell_data_func(l, l2, 0L, 0L, 0L);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskin(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                item = this.columns[n2];
                if (item.isDisposed()) continue;
                item.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        TableItem tableItem = this._getItem(n);
        OS.gtk_tree_selection_select_iter(l, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            TableItem tableItem = this._getItem(i);
            OS.gtk_tree_selection_select_iter(l, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (0 > n2 || n2 >= this.itemCount) continue;
            TableItem tableItem = this._getItem(n2);
            OS.gtk_tree_selection_select_iter(l, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int n) {
        if (0 > n || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        long l = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_view_set_cursor(this.handle, l, 0L, false);
        OS.gtk_tree_selection_select_iter(l2, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_path_free(l);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        }
    }

    void setBackgroundColor(long l, long l2, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2;
        GdkColor gdkColor;
        if (gdkRGBA == null) {
            gdkColor = this.getDisplay().COLOR_LIST_BACKGROUND;
            gdkRGBA2 = new GdkRGBA();
            gdkRGBA2.alpha = 1.0;
            gdkRGBA2.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
            gdkRGBA2.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
            gdkRGBA2.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        } else {
            this.background = gdkRGBA;
        }
        gdkColor = this.getDisplay().COLOR_LIST_SELECTION;
        gdkRGBA2 = new GdkRGBA();
        gdkRGBA2.alpha = 1.0;
        gdkRGBA2.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
        gdkRGBA2.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
        gdkRGBA2.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            String string = "GtkTreeView {background-color: " + this.gtk_rgba_to_css_string(gdkRGBA) + ";}\n" + "GtkTreeView:selected {background-color: " + this.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
            this.gtk_css_provider_load_from_css(l, string);
        } else {
            super.setBackgroundColor(l, l2, gdkRGBA);
            OS.gtk_widget_override_background_color(l2, 4, gdkRGBA2);
        }
    }

    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
        }
        for (n = 0; n < nArray.length; ++n) {
            long l = this.columns[nArray[n]].handle;
            long l2 = n == 0 ? 0L : this.columns[nArray[n - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, l, l2);
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        TableColumn[] tableColumnArray = this.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null) continue;
            tableColumnArray[i].setFontDescription(l);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (l == 0L) {
                this.error(2);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            for (int i = this.itemCount; i < n; ++i) {
                OS.gtk_list_store_append(this.modelHandle, l);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
            OS.g_free(l);
            this.itemCount = n;
        } else {
            for (int i = this.itemCount; i < n; ++i) {
                new TableItem(this, 0, i, true);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (!OS.GTK3) {
            OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        }
        OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
    }

    void setModel(long l) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = l;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        for (n = 0; n < this.itemCount; ++n) {
            if (this.items[n] == null) continue;
            this.items[n].setOrientation(bl);
        }
        for (n = 0; n < this.columnCount; ++n) {
            if (this.columns[n] == null) continue;
            this.columns[n].setOrientation(bl);
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(long l) {
        long l2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(l, l2);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
            this.items = tableItemArray;
        }
    }

    void setScrollWidth(long l, TableItem tableItem) {
        int n;
        if (this.columnCount != 0 || this.currentItem == tableItem) {
            return;
        }
        int n2 = OS.gtk_tree_view_column_get_fixed_width(l);
        if (n2 < (n = this.calculateWidth(l, tableItem.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(l, n);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem tableItem) {
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexOf(tableItemArray[i]);
                if (n2 == -1) continue;
                if (bl2) {
                    bl2 = false;
                    this.selectFocusIndex(n2);
                    continue;
                }
                this.select(n2);
            }
            this.showSelection();
        }
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        long l = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)n).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, l, 0L, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(l);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        OS.gtk_tree_view_scroll_to_cell(this.handle, 0L, tableColumn.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            long l = OS.gtk_tree_view_get_column(this.handle, i);
            if (!OS.gtk_tree_view_column_get_visible(l)) continue;
            return false;
        }
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, true);
        return true;
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        this.showItem(tableItem.handle);
    }

    void showItem(long l) {
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, false, 0.0f, 0.0f);
        OS.gtk_tree_path_free(l2);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        this.showItem(tableItem.handle);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        long l = this.parentingHandle();
        long l2 = OS.gtk_container_get_children(l);
        if (l2 == 0L) {
            return;
        }
        long l3 = l2;
        while (l3 != 0L) {
            long l4 = OS.g_list_data(l3);
            if (l4 != 0L) {
                OS.gtk_widget_queue_resize(l4);
            }
            l3 = OS.g_list_next(l3);
        }
        OS.g_list_free(l2);
        if (OS.GTK3) {
            OS.gtk_widget_queue_resize(this.handle);
        }
    }

    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 19: {
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
                long l4 = OS.gtk_tree_view_get_bin_window(l);
                if (l4 != gdkEventExpose.window) break;
                this.drawBackground(control, l4, gdkEventExpose.region, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
            }
        }
        return super.windowProc(l, l2, l3);
    }
}

