/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

public class TunnelPoolSettings {
    private final Hash _destination;
    private String _destinationNickname;
    private int _quantity;
    private int _backupQuantity;
    private int _length;
    private int _lengthVariance;
    private int _lengthOverride;
    private final boolean _isInbound;
    private final boolean _isExploratory;
    private boolean _allowZeroHop;
    private int _IPRestriction;
    private final Properties _unknownOptions;
    private Hash _randomKey;
    private int _priority;
    private final Set<Hash> _aliases;
    private Hash _aliasOf;
    public static final String PREFIX_INBOUND_EXPLORATORY = "router.inboundPool.";
    public static final String PREFIX_OUTBOUND_EXPLORATORY = "router.outboundPool.";
    public static final String PROP_NICKNAME = "nickname";
    public static final String PROP_QUANTITY = "quantity";
    public static final String PROP_BACKUP_QUANTITY = "backupQuantity";
    public static final String PROP_DURATION = "duration";
    public static final String PROP_LENGTH = "length";
    public static final String PROP_LENGTH_VARIANCE = "lengthVariance";
    public static final String PROP_ALLOW_ZERO_HOP = "allowZeroHop";
    public static final String PROP_IP_RESTRICTION = "IPRestriction";
    public static final String PROP_PRIORITY = "priority";
    public static final String PROP_RANDOM_KEY = "randomKey";
    public static final int DEFAULT_QUANTITY = 2;
    public static final int DEFAULT_BACKUP_QUANTITY = 0;
    public static final int DEFAULT_DURATION = 600000;
    private static final boolean isSlow = SystemVersion.isGNU() || SystemVersion.isARM() || SystemVersion.isApache() || !NativeBigInteger.isNative();
    private static final int DEFAULT_IB_LENGTH = 3;
    private static final int DEFAULT_OB_LENGTH = 3;
    private static final int DEFAULT_LENGTH_VARIANCE = 0;
    private static final int DEFAULT_IB_EXPL_LENGTH = 2;
    private static final int DEFAULT_OB_EXPL_LENGTH = isSlow ? 2 : 3;
    private static final int DEFAULT_IB_EXPL_LENGTH_VARIANCE = isSlow ? 0 : 1;
    private static final int DEFAULT_OB_EXPL_LENGTH_VARIANCE = 0;
    public static final boolean DEFAULT_ALLOW_ZERO_HOP = true;
    public static final int DEFAULT_IP_RESTRICTION = 2;
    private static final int MIN_PRIORITY = -25;
    private static final int MAX_PRIORITY = 25;
    private static final int EXPLORATORY_PRIORITY = 30;

    public TunnelPoolSettings(boolean isInbound) {
        this(null, isInbound);
    }

    public TunnelPoolSettings(Hash dest, boolean isInbound) {
        this._destination = dest;
        this._isExploratory = dest == null;
        this._isInbound = isInbound;
        this._quantity = 2;
        this._backupQuantity = 0;
        if (isInbound) {
            this._length = this._isExploratory ? 2 : 3;
            this._lengthVariance = this._isExploratory ? DEFAULT_IB_EXPL_LENGTH_VARIANCE : 0;
        } else {
            this._length = this._isExploratory ? DEFAULT_OB_EXPL_LENGTH : 3;
            this._lengthVariance = this._isExploratory ? 0 : 0;
        }
        this._lengthOverride = -1;
        this._allowZeroHop = this._isExploratory ? true : true;
        this._IPRestriction = 2;
        this._unknownOptions = new Properties();
        this._randomKey = TunnelPoolSettings.generateRandomKey();
        if (this._isExploratory && !this._isInbound) {
            this._priority = 30;
        }
        this._aliases = !this._isExploratory ? new ConcurrentHashSet<Hash>(4) : null;
    }

    public int getQuantity() {
        return this._quantity;
    }

    public void setQuantity(int quantity) {
        this._quantity = quantity;
    }

    public int getBackupQuantity() {
        return this._backupQuantity;
    }

    public void setBackupQuantity(int quantity) {
        this._backupQuantity = quantity;
    }

    public int getTotalQuantity() {
        return this._quantity + this._backupQuantity;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public boolean getAllowZeroHop() {
        return this._allowZeroHop;
    }

    public void setAllowZeroHop(boolean ok) {
        if (!this._isExploratory) {
            this._allowZeroHop = ok;
        }
    }

    public int getLengthVariance() {
        return this._lengthVariance;
    }

    public void setLengthVariance(int variance) {
        this._lengthVariance = variance;
    }

    public int getLengthOverride() {
        return this._lengthOverride;
    }

    public void setLengthOverride(int length) {
        this._lengthOverride = length;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isExploratory() {
        return this._isExploratory;
    }

    public Hash getDestination() {
        return this._destination;
    }

    public Set<Hash> getAliases() {
        return this._aliases;
    }

    public Hash getAliasOf() {
        return this._aliasOf;
    }

    public void setAliasOf(Hash h) {
        this._aliasOf = h;
    }

    public Hash getRandomKey() {
        return this._randomKey;
    }

    public String getDestinationNickname() {
        return this._destinationNickname;
    }

    public void setDestinationNickname(String name) {
        this._destinationNickname = name;
    }

    public int getIPRestriction() {
        int r = this._IPRestriction;
        if (r > 4) {
            r = 4;
        } else if (r < 0) {
            r = 0;
        }
        return r;
    }

    public void setIPRestriction(int b) {
        this._IPRestriction = b;
    }

    public int getPriority() {
        return this._priority;
    }

    public Properties getUnknownOptions() {
        return this._unknownOptions;
    }

    public void readFromProperties(String prefix, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String name = (String)e.getKey();
            String value = (String)e.getValue();
            if (!name.startsWith(prefix)) continue;
            if (name.equalsIgnoreCase(prefix + PROP_ALLOW_ZERO_HOP)) {
                if (this._isExploratory) continue;
                this._allowZeroHop = TunnelPoolSettings.getBoolean(value, true);
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_BACKUP_QUANTITY)) {
                this._backupQuantity = TunnelPoolSettings.getInt(value, 0);
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_LENGTH)) {
                this._length = TunnelPoolSettings.getInt(value, this._isInbound ? (this._isExploratory ? 2 : 3) : (this._isExploratory ? DEFAULT_OB_EXPL_LENGTH : 3));
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_LENGTH_VARIANCE)) {
                this._lengthVariance = TunnelPoolSettings.getInt(value, this._isExploratory ? (this._isInbound ? DEFAULT_IB_EXPL_LENGTH_VARIANCE : 0) : 0);
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_QUANTITY)) {
                this._quantity = TunnelPoolSettings.getInt(value, 2);
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_NICKNAME)) {
                this._destinationNickname = value;
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_IP_RESTRICTION)) {
                this._IPRestriction = TunnelPoolSettings.getInt(value, 2);
                continue;
            }
            if (!this._isInbound && name.equalsIgnoreCase(prefix + PROP_PRIORITY)) {
                int def = this._isExploratory ? 30 : 0;
                int max = this._isExploratory ? 30 : 25;
                this._priority = Math.min(max, Math.max(-25, TunnelPoolSettings.getInt(value, def)));
                continue;
            }
            if (name.equalsIgnoreCase(prefix + PROP_RANDOM_KEY)) {
                byte[] rk = Base64.decode(value);
                if (rk == null || rk.length != 32) continue;
                this._randomKey = new Hash(rk);
                continue;
            }
            this._unknownOptions.setProperty(name.substring(prefix.length()), value);
        }
    }

    public void writeToProperties(String prefix, Properties props) {
        if (props == null) {
            return;
        }
        props.setProperty(prefix + PROP_ALLOW_ZERO_HOP, "" + this._allowZeroHop);
        props.setProperty(prefix + PROP_BACKUP_QUANTITY, "" + this._backupQuantity);
        props.setProperty(prefix + PROP_LENGTH, "" + this._length);
        props.setProperty(prefix + PROP_LENGTH_VARIANCE, "" + this._lengthVariance);
        if (this._destinationNickname != null) {
            props.setProperty(prefix + PROP_NICKNAME, "" + this._destinationNickname);
        }
        props.setProperty(prefix + PROP_QUANTITY, "" + this._quantity);
        props.setProperty(prefix + PROP_IP_RESTRICTION, "" + this._IPRestriction);
        if (!this._isInbound) {
            props.setProperty(prefix + PROP_PRIORITY, Integer.toString(this._priority));
        }
        for (Map.Entry<Object, Object> e : this._unknownOptions.entrySet()) {
            String name = (String)e.getKey();
            String val = (String)e.getValue();
            props.setProperty(prefix + name, val);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Properties p = new Properties();
        this.writeToProperties("", p);
        buf.append("Tunnel pool settings:\n");
        buf.append("====================================\n");
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String name = (String)e.getKey();
            String val = (String)e.getValue();
            buf.append(name).append(" = [").append(val).append("]\n");
        }
        buf.append("is inbound? ").append(this._isInbound).append("\n");
        buf.append("is exploratory? ").append(this._isExploratory).append("\n");
        buf.append("====================================\n");
        return buf.toString();
    }

    private static Hash generateRandomKey() {
        byte[] hash = new byte[32];
        RandomSource.getInstance().nextBytes(hash);
        return new Hash(hash);
    }

    private static final boolean getBoolean(String str, boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        boolean v = Boolean.parseBoolean(str) || "YES".equals(str.toUpperCase(Locale.US));
        return v;
    }

    private static final int getInt(String str, int defaultValue) {
        return (int)TunnelPoolSettings.getLong(str, defaultValue);
    }

    private static final long getLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            long val = Long.parseLong(str);
            return val;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

