/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebPolicyDecisionListener;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.MessageBox;

class WebPolicyDelegate {
    COMObject iWebPolicyDelegate;
    int refCount = 0;
    Browser browser;

    WebPolicyDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebPolicyDelegate = new COMObject(new int[]{2, 0, 0, 5, 5, 5, 3}){

            public int method0(int[] nArray) {
                return WebPolicyDelegate.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return WebPolicyDelegate.this.AddRef();
            }

            public int method2(int[] nArray) {
                return WebPolicyDelegate.this.Release();
            }

            public int method3(int[] nArray) {
                return WebPolicyDelegate.this.decidePolicyForNavigationAction(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method4(int[] nArray) {
                return WebPolicyDelegate.this.decidePolicyForNewWindowAction(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method5(int[] nArray) {
                return WebPolicyDelegate.this.decidePolicyForMIMEType(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method6(int[] nArray) {
                return WebPolicyDelegate.this.unableToImplementPolicyWithError(nArray[0], nArray[1], nArray[2]);
            }
        };
    }

    int decidePolicyForMIMEType(int n, int n2, int n3, int n4, int n5) {
        IWebView iWebView = new IWebView(n);
        int[] nArray = new int[1];
        iWebView.canShowMIMEType(n2, nArray);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n5);
        if (nArray[0] != 0) {
            iWebPolicyDecisionListener.use();
        } else {
            iWebPolicyDecisionListener.download();
        }
        return 0;
    }

    int decidePolicyForNavigationAction(int n, int n2, int n3, int n4, int n5) {
        IWebURLRequest iWebURLRequest = new IWebURLRequest(n3);
        int[] nArray = new int[1];
        int n6 = iWebURLRequest.URL(nArray);
        if (n6 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n5);
        WebKit webKit = (WebKit)this.browser.webBrowser;
        if (webKit.loadingText) {
            iWebPolicyDecisionListener.use();
            return 0;
        }
        if (string.length() == 0) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.startsWith("file://") && webKit.getUrl().startsWith("about:blank") && webKit.untrustedText) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n7 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n7) == '#') {
                string = "about:blank" + string.substring(n7);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        LocationListener[] locationListenerArray = webKit.locationListeners;
        if (locationListenerArray != null) {
            for (int i = 0; i < locationListenerArray.length; ++i) {
                locationListenerArray[i].changing(locationEvent);
            }
        }
        if (locationEvent.doit) {
            if (webKit.jsEnabled != webKit.jsEnabledOnNextPage) {
                webKit.jsEnabled = webKit.jsEnabledOnNextPage;
                IWebView iWebView = new IWebView(n);
                nArray[0] = 0;
                n6 = iWebView.preferences(nArray);
                if (n6 == 0 && nArray[0] != 0) {
                    IWebPreferences iWebPreferences = new IWebPreferences(nArray[0]);
                    n6 = iWebPreferences.setJavaScriptEnabled(webKit.jsEnabled ? 1 : 0);
                    iWebView.setPreferences(iWebPreferences.getAddress());
                    iWebPreferences.Release();
                }
            }
            iWebPolicyDecisionListener.use();
            webKit.lastNavigateURL = string;
        } else {
            iWebPolicyDecisionListener.ignore();
        }
        return 0;
    }

    int decidePolicyForNewWindowAction(int n, int n2, int n3, int n4, int n5) {
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n5);
        iWebPolicyDecisionListener.use();
        return 0;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebPolicyDelegate != null) {
            this.iWebPolicyDelegate.dispose();
            this.iWebPolicyDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebPolicyDelegate.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebPolicyDelegate)) {
            COM.MoveMemory(n2, new int[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int unableToImplementPolicyWithError(int n, int n2, int n3) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebError iWebError = new IWebError(n2);
        String string = null;
        int[] nArray = new int[1];
        int n4 = iWebError.failingURL(nArray);
        if (n4 == 0 && nArray[0] != 0) {
            string = WebKit.extractBSTR(nArray[0]);
            COM.SysFreeString(nArray[0]);
        }
        nArray[0] = 0;
        n4 = iWebError.localizedDescription(nArray);
        if (n4 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string2 = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        String string3 = string != null ? string + "\n\n" : "";
        string3 = string3 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string2});
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
        messageBox.setMessage(string3);
        messageBox.open();
        return 0;
    }
}

