/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class WorkingDir {
    private static final String PROP_BASE_DIR = "i2p.dir.base";
    private static final String PROP_WORKING_DIR = "i2p.dir.config";
    private static final String WORKING_DIR_DEFAULT_WINDOWS = "I2P";
    private static final String WORKING_DIR_DEFAULT_MAC = "i2p";
    private static final String WORKING_DIR_DEFAULT = ".i2p";
    private static final String WORKING_DIR_DEFAULT_DAEMON = "i2p-config";
    private static final String PROP_WRAPPER_LOG = "wrapper.logfile";
    private static final String DEFAULT_WRAPPER_LOG = "wrapper.log";
    private static final long EEPSITE_TIMESTAMP = 1140048000000L;
    private static final String MIGRATE_BASE = "addressbook,eepsite,netDb,hosts.txt,i2psnark.config,i2ptunnel.config,jetty-i2psnark.xml,logger.config,router.config,susimail.config,systray.config,webapps.config";

    public static String getWorkingDir(Properties envProps, boolean migrateOldConfig) {
        boolean oldInstall;
        File oldDirf;
        File test;
        String dir = null;
        if (envProps != null) {
            dir = envProps.getProperty(PROP_WORKING_DIR);
        }
        if (dir == null) {
            dir = System.getProperty(PROP_WORKING_DIR);
        }
        boolean isWindows = SystemVersion.isWindows();
        SecureDirectory dirf = null;
        String gentooWarning = null;
        if (dir != null) {
            dirf = new SecureDirectory(dir);
        } else {
            String appdata;
            String home = System.getProperty("user.home");
            if (isWindows) {
                appdata = System.getenv("APPDATA");
                if (appdata != null) {
                    home = appdata;
                }
                dirf = new SecureDirectory(home, WORKING_DIR_DEFAULT_WINDOWS);
            } else if (SystemVersion.isMac()) {
                appdata = "/Library/Application Support/";
                File old = new File(home, WORKING_DIR_DEFAULT);
                if (old.exists() && old.isDirectory()) {
                    dirf = new SecureDirectory(home, WORKING_DIR_DEFAULT);
                } else {
                    home = home + appdata;
                    dirf = new SecureDirectory(home, WORKING_DIR_DEFAULT_MAC);
                }
            } else if (SystemVersion.isLinuxService()) {
                if (SystemVersion.isGentoo() && WORKING_DIR_DEFAULT_MAC.equals(System.getProperty("user.name"))) {
                    SecureDirectory d1 = new SecureDirectory(home, WORKING_DIR_DEFAULT);
                    SecureDirectory d2 = new SecureDirectory(home, WORKING_DIR_DEFAULT_DAEMON);
                    boolean e1 = WorkingDir.isSetup(d1);
                    boolean e2 = WorkingDir.isSetup(d2);
                    if (e1 && e2) {
                        if (d2.lastModified() < d1.lastModified()) {
                            SecureDirectory tmp = d2;
                            d2 = d1;
                            d1 = tmp;
                        }
                        dirf = d2;
                        gentooWarning = "Warning - Found both an old configuration directory " + d1.getAbsolutePath() + " and new configuration directory " + d2.getAbsolutePath() + " created due to a bug in release 0.9.29\n. Using the new configuration directory. To use the old directory instead, stop i2p, delete the new directory, and restart.";
                    } else {
                        dirf = e1 && !e2 ? d1 : (!e1 && e2 ? d2 : d1);
                    }
                } else {
                    dirf = new SecureDirectory(home, WORKING_DIR_DEFAULT_DAEMON);
                }
            } else {
                dirf = new SecureDirectory(home, WORKING_DIR_DEFAULT);
            }
        }
        String cwd = null;
        if (envProps != null) {
            cwd = envProps.getProperty(PROP_BASE_DIR);
        }
        if (cwd == null && (cwd = System.getProperty(PROP_BASE_DIR)) == null) {
            cwd = System.getProperty("user.dir");
        }
        if (!(test = new File(oldDirf = new File(cwd), "hosts.txt")).exists()) {
            WorkingDir.setupSystemOut(cwd);
            System.err.println("ERROR - Cannot find I2P installation in " + cwd + " - Will probably be just a router with no apps or console at all!");
            return cwd;
        }
        try {
            if (oldDirf.getCanonicalPath().equals(dirf.getCanonicalPath())) {
                WorkingDir.setupSystemOut(cwd);
                return cwd;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        String rv = dirf.getAbsolutePath();
        if (dirf.exists()) {
            if (dirf.isDirectory()) {
                if (WorkingDir.isSetup(dirf)) {
                    WorkingDir.setupSystemOut(rv);
                    if (gentooWarning != null) {
                        System.err.println(gentooWarning);
                    }
                    return rv;
                }
            } else {
                WorkingDir.setupSystemOut(null);
                System.err.println("Wanted to use " + rv + " for a working directory but it is not a directory");
                return cwd;
            }
        }
        if (!(oldInstall = (test = new File(oldDirf, "router.keys")).exists())) {
            test = new File(oldDirf, "logs");
            oldInstall = test.exists();
        }
        if (oldInstall && !migrateOldConfig) {
            WorkingDir.setupSystemOut(cwd);
            return cwd;
        }
        boolean migrateOldData = false;
        if (!dirf.exists() && !((File)dirf).mkdir()) {
            WorkingDir.setupSystemOut(null);
            System.err.println("Wanted to use " + rv + " for a working directory but could not create it");
            return cwd;
        }
        WorkingDir.setupSystemOut(dirf.getAbsolutePath());
        if (migrateOldData) {
            System.err.println("Migrating data files to new user directory " + rv);
        } else {
            System.err.println("Setting up new user directory " + rv);
        }
        boolean success = WorkingDir.migrate(MIGRATE_BASE, oldDirf, dirf);
        File oldEep = new File(oldDirf, "eepsite");
        File newEep = new File(dirf, "eepsite");
        String newPath = newEep.getAbsolutePath() + File.separatorChar;
        success &= WorkingDir.migrateJettyXml(oldEep, newEep, "jetty.xml", "./eepsite/", newPath);
        success &= WorkingDir.migrateJettyXml(oldEep, newEep, "jetty-ssl.xml", "./eepsite/", newPath);
        success &= WorkingDir.migrateJettyXml(oldEep, newEep, "contexts/base-context.xml", "./eepsite/", newPath);
        success &= WorkingDir.migrateJettyXml(oldEep, newEep, "contexts/cgi-context.xml", "./eepsite/", newPath);
        success &= WorkingDir.migrateClientsConfig(oldDirf, dirf);
        WorkingDir.touchRecursive(new File(dirf, "eepsite/docroot"), 1140048000000L);
        if (success &= new SecureDirectory(dirf, "docs").mkdir()) {
            System.err.println("Successfully copied data files to new user directory " + rv);
            return rv;
        }
        System.err.println("FAILED copy of some or all data files to new directory " + rv);
        System.err.println("Check logs for details");
        System.err.println("Continung to use data files in old directory " + cwd);
        return cwd;
    }

    private static boolean isSetup(File dir) {
        if (dir.isDirectory()) {
            String[] files = dir.list();
            if (files == null) {
                return false;
            }
            String[] migrated = DataHelper.split(MIGRATE_BASE, ",");
            for (String file : files) {
                for (int i = 0; i < migrated.length; ++i) {
                    if (!file.equals(migrated[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void setupSystemOut(String dir) {
        File logfile;
        if (System.getProperty("wrapper.version") != null) {
            return;
        }
        String path = System.getProperty(PROP_WRAPPER_LOG);
        if (path != null) {
            logfile = new File(path);
        } else {
            logfile = new File(DEFAULT_WRAPPER_LOG);
            if (!logfile.exists()) {
                if (dir == null) {
                    dir = System.getProperty("java.io.tmpdir");
                }
                logfile = new File(dir, DEFAULT_WRAPPER_LOG);
            }
        }
        System.setProperty(PROP_WRAPPER_LOG, logfile.getAbsolutePath());
        try {
            PrintStream ps = new PrintStream((OutputStream)new SecureFileOutputStream(logfile, true), true, "UTF-8");
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static boolean migrate(String list, File olddir, File todir) {
        boolean rv = true;
        String[] files = DataHelper.split(list, ",");
        for (int i = 0; i < files.length; ++i) {
            File from = new File(olddir, files[i]);
            if (WorkingDir.copy(from, todir)) continue;
            System.err.println("Error copying " + from.getAbsolutePath());
            rv = false;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean migrateClientsConfig(File olddir, File todir) {
        File oldFile = new File(olddir, "clients.config");
        File newFile = new File(todir, "clients.config");
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(newFile), "UTF-8")));
            out.println("# Modified by I2P User dir migration script");
            String s = null;
            boolean isDaemon = SystemVersion.isLinuxService();
            while ((s = DataHelper.readLine(in)) != null) {
                if (s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.endsWith("=\"eepsite/jetty.xml\"")) {
                    s = s.replace("=\"eepsite/jetty.xml\"", "=\"" + todir.getAbsolutePath() + File.separatorChar + "eepsite" + File.separatorChar + "jetty.xml\"");
                } else if (isDaemon && s.equals("clientApp.4.startOnLoad=true")) {
                    s = "clientApp.4.startOnLoad=false";
                }
                out.println(s);
            }
            System.err.println("Copied " + oldFile + " with modifications");
            if (out.checkError()) {
                throw new IOException("Failed write to " + newFile);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                System.err.println("FAILED copy " + oldFile + ": " + ioe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean migrateJettyXml(File olddir, File todir, String filename, String oldString, String newString) {
        File oldFile = new File(olddir, filename);
        File newFile = new File(todir, filename);
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(newFile), "UTF-8")));
            String s = null;
            while ((s = DataHelper.readLine(in)) != null) {
                if (s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.indexOf(oldString) >= 0) {
                    s = s.replace(oldString, newString);
                }
                out.println(s);
            }
            out.println("<!-- Modified by I2P User dir migration script -->");
            System.err.println("Copied " + oldFile + " with modifications");
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                System.err.println("FAILED copy " + oldFile + ": " + ioe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static boolean copy(File src, File targetDir) {
        if (!src.exists()) {
            return true;
        }
        if (!targetDir.exists()) {
            if (!targetDir.mkdir()) {
                System.err.println("FAILED copy " + src.getPath());
                return false;
            }
            System.err.println("Created " + targetDir.getPath());
        }
        SecureDirectory targetFile = new SecureDirectory(targetDir, src.getName());
        if (!src.isDirectory()) {
            return WorkingDir.copyFile(src, targetFile);
        }
        File[] children = src.listFiles();
        if (children == null) {
            System.err.println("FAILED copy " + src.getPath());
            return false;
        }
        if (!targetFile.exists()) {
            if (!((File)targetFile).mkdir()) {
                System.err.println("FAILED copy " + src.getPath());
                return false;
            }
            System.err.println("Created " + targetFile.getPath());
        }
        boolean rv = true;
        for (int i = 0; i < children.length; ++i) {
            rv &= WorkingDir.copy(children[i], targetFile);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFile(File src, File dst) {
        if (!src.exists()) {
            return false;
        }
        boolean rv = true;
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new SecureFileOutputStream(dst);
            DataHelper.copy(in, out);
            System.err.println("Copied " + src.getPath());
        }
        catch (IOException ioe) {
            System.err.println("FAILED copy " + src.getPath() + ": " + ioe);
            rv = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (rv) {
            dst.setLastModified(src.lastModified());
        }
        return rv;
    }

    private static void touchRecursive(File target, long time) {
        if (!target.exists()) {
            return;
        }
        if (target.isFile()) {
            target.setLastModified(time);
            return;
        }
        if (!target.isDirectory()) {
            return;
        }
        File[] children = target.listFiles();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            WorkingDir.touchRecursive(children[i], time);
        }
    }
}

