/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.VersionComparator;

abstract class MigrateJetty {
    private static boolean _wasChecked;
    private static boolean _hasLatestJetty;
    private static final String OLD_CLASS = "org.mortbay.jetty.Server";
    private static final String OLD_CLASS_6 = "org.mortbay.start.Main";
    private static final String NEW_CLASS = "net.i2p.jetty.JettyStart";
    private static final String TEST_CLASS = "org.eclipse.jetty.server.Server";
    private static final String BACKUP_SUFFIX = ".jetty6";
    private static final String BACKUP_SUFFIX_8 = ".jetty8";
    private static final String JETTY_TEMPLATE_DIR = "eepsite-jetty9";
    private static final String JETTY_TEMPLATE_PKGDIR = "eepsite";
    private static final String BASE_CONTEXT = "contexts/base-context.xml";
    private static final String CGI_CONTEXT = "contexts/cgi-context.xml";
    private static final String PROP_JETTY9_MIGRATED = "router.startup.jetty9.migrated";

    MigrateJetty() {
    }

    public static void migrate(RouterContext ctx, List<ClientAppConfig> apps) {
        File cfgFile;
        boolean ok;
        if (ctx.getBooleanProperty(PROP_JETTY9_MIGRATED)) {
            return;
        }
        String installed = ctx.getProperty("router.firstVersion");
        if (installed != null && VersionComparator.comp(installed, "0.9.30") >= 0) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED, "true");
            return;
        }
        boolean shouldSave = false;
        boolean jetty9success = false;
        for (int i = 0; i < apps.size(); ++i) {
            String[] args;
            String backupSuffix;
            String client;
            ClientAppConfig app = apps.get(i);
            if (app.className.equals(NEW_CLASS)) {
                client = "client application " + i + " [" + app.clientName + "] from Jetty 7/8 to Jetty 9";
                backupSuffix = BACKUP_SUFFIX_8;
            } else {
                if (!app.className.equals(OLD_CLASS) && !app.className.equals(OLD_CLASS_6)) continue;
                client = "client application " + i + " [" + app.clientName + "] from Jetty 5/6 " + app.className + " to Jetty 9 " + NEW_CLASS;
                backupSuffix = BACKUP_SUFFIX;
            }
            if (!MigrateJetty.hasLatestJetty()) {
                System.err.println("WARNING: Jetty 7 unavailable, cannot migrate " + client);
                continue;
            }
            if (app.args == null || (args = LoadClientAppsJob.parseArgs(app.args)).length == 0) continue;
            String xml = args[0];
            File xmlFile = new File(xml);
            if (!xmlFile.isAbsolute()) {
                xmlFile = new File(ctx.getAppDir(), xml);
            }
            if (!xmlFile.exists()) {
                System.err.println("WARNING: XML file " + xmlFile + " not found, cannot migrate " + client);
                continue;
            }
            File eepsite = xmlFile.getParentFile();
            boolean ok2 = MigrateJetty.backupFile(xmlFile, backupSuffix);
            if (!ok2) {
                System.err.println("WARNING: Failed to backup up XML file " + xmlFile + ", cannot migrate " + client);
                continue;
            }
            if (app.className.equals(NEW_CLASS)) {
                for (int j = 0; j < args.length; ++j) {
                    if (j > 0 && !(ok2 = MigrateJetty.backupFile(xmlFile = new File(args[j]), backupSuffix))) {
                        System.err.println("WARNING: Failed to backup up XML file " + xmlFile + ", cannot migrate " + client);
                        continue;
                    }
                    boolean ok9 = MigrateJetty.migrateToJetty9(xmlFile);
                    if (!ok9) continue;
                    System.err.println("WARNING: Migrated " + client + ".\nCheck the " + xmlFile.getName() + " file in " + eepsite + ".\nYour old " + xmlFile.getName() + " file was backed up to " + xmlFile.getAbsolutePath() + BACKUP_SUFFIX_8);
                    jetty9success = true;
                }
                continue;
            }
            File baseEep = new File(ctx.getBaseDir(), JETTY_TEMPLATE_DIR);
            if (!baseEep.exists()) {
                baseEep = new File(ctx.getBaseDir(), JETTY_TEMPLATE_PKGDIR);
            }
            if (baseEep.equals(eepsite)) {
                System.err.println("Eepsite in non-split directory " + eepsite + ", cannot migrate " + client);
                continue;
            }
            File baseContext = new File(baseEep, BASE_CONTEXT);
            if (!baseContext.exists()) {
                System.err.println("WARNING: Cannot find new XML file template " + baseContext + ", cannot migrate " + client);
                continue;
            }
            String newPath = eepsite.getAbsolutePath() + File.separatorChar;
            ok2 = WorkingDir.migrateJettyXml(baseEep, eepsite, "jetty.xml", "./eepsite/", newPath);
            if (!ok2) {
                System.err.println("WARNING: Failed to modify XML file " + xmlFile + ", cannot migrate " + client);
                continue;
            }
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, "jetty-ssl.xml", "./eepsite/", newPath);
            new File(eepsite, "contexts").mkdir();
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, BASE_CONTEXT, "./eepsite/", newPath);
            MigrateJetty.backupAndMigrateFile(baseEep, eepsite, CGI_CONTEXT, "./eepsite/", newPath);
            MigrateJetty.backupAndCopyFile(baseEep, eepsite, "jetty-rewrite.xml");
            new File(eepsite, "etc").mkdir();
            File to = new File(eepsite, "etc/realm.properties");
            if (!to.exists()) {
                WorkingDir.copyFile(new File(baseEep, "etc/realm.properties"), to);
            }
            MigrateJetty.backupAndCopyFile(baseEep, eepsite, "etc/webdefault.xml");
            app.className = NEW_CLASS;
            shouldSave = true;
            System.err.println("WARNING: Migrated " + client + '\n' + "Check the following files in " + eepsite + ": jetty.xml, " + BASE_CONTEXT + ", and " + CGI_CONTEXT + "\nYour old jetty.xml was backed up." + '\n' + "If you modified your jetty.xml to change ports, thread limits, etc, you MUST\nedit it to change them again. Your port was reset to 7658.");
        }
        if (shouldSave && (ok = MigrateJetty.backupFile(cfgFile = ClientAppConfig.configFile(ctx)))) {
            ClientAppConfig.writeClientAppConfig(ctx, apps);
            System.err.println("WARNING: Migrated clients config file " + cfgFile + " from Jetty 5/6 " + OLD_CLASS + '/' + OLD_CLASS_6 + " to Jetty 9 " + NEW_CLASS);
        }
        if (jetty9success) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean migrateToJetty9(File xmlFile) {
        if (xmlFile.getName().equals("jetty-jmx.xml")) {
            System.err.println("ERROR: Migration  of " + xmlFile + " file is not supported. Copy new file from $I2P/eepsite-jetty9/jetty-jmx.xml");
            return false;
        }
        boolean modified = false;
        File eepsite = xmlFile.getParentFile();
        File newFile = new File(eepsite, xmlFile.getName() + System.currentTimeMillis() + ".tmp");
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            String s;
            in = new FileInputStream(xmlFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(newFile), "UTF-8")));
            boolean foundQTP = false;
            boolean foundSTP = false;
            boolean foundETP = false;
            boolean foundSCC = false;
            boolean foundHC = false;
            boolean foundSSCC = false;
            while ((s = DataHelper.readLine(in)) != null) {
                if (s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.contains("Modified by I2P migration script for Jetty 9.") || s.contains("This configuration supports Jetty 9.") || s.contains("http://www.eclipse.org/jetty/configure_9_0.dtd")) {
                    if (!modified) {
                        break;
                    }
                } else if (s.contains("org.eclipse.jetty.util.thread.QueuedThreadPool")) {
                    foundQTP = true;
                } else if (foundQTP) {
                    if (!s.contains("Modified by") && !s.contains("<Arg type=\"int\">")) {
                        out.println("        <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                        out.println("        <Arg type=\"int\">20</Arg>     <!-- maxThreads, overridden below -->");
                        out.println("        <Arg type=\"int\">3</Arg>      <!-- minThreads, overridden below -->");
                        out.println("        <Arg type=\"int\">60000</Arg>  <!-- maxIdleTimeMs, overridden below -->");
                        modified = true;
                    }
                    foundQTP = false;
                }
                if (s.contains("<Set name=\"maxIdleTimeMs\">")) {
                    s = s.replace("<Set name=\"maxIdleTimeMs\">", "<Set name=\"idleTimeout\">");
                    modified = true;
                } else if (s.contains("<Set name=\"ThreadPool\">")) {
                    out.println("    <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                    s = s.replace("<Set name=\"ThreadPool\">", "<Arg>");
                    foundSTP = true;
                    modified = true;
                } else if (foundSTP && !foundETP && s.contains("</Set>") && !s.contains("<Set")) {
                    s = s.replace("</Set>", "</Arg>");
                    foundETP = true;
                } else {
                    if (s.contains("org.eclipse.jetty.server.nio.SelectChannelConnector")) {
                        s = s.replace("org.eclipse.jetty.server.nio.SelectChannelConnector", "org.eclipse.jetty.server.ServerConnector");
                        out.println("          <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                        out.println(s);
                        out.println("            <Arg><Ref id=\"Server\" /></Arg>");
                        out.println("            <Arg type=\"int\">1</Arg>     <!-- number of acceptors -->");
                        out.println("            <Arg type=\"int\">0</Arg>     <!-- default number of selectors -->");
                        out.println("            <Arg>");
                        out.println("              <Array type=\"org.eclipse.jetty.server.ConnectionFactory\">    <!-- varargs so we need an array -->");
                        out.println("                <Item>");
                        out.println("                  <New class=\"org.eclipse.jetty.server.HttpConnectionFactory\">");
                        out.println("                    <Arg>");
                        out.println("                      <New class=\"org.eclipse.jetty.server.HttpConfiguration\">");
                        out.println("                        <Set name=\"sendServerVersion\">false</Set>");
                        out.println("                        <Set name=\"sendDateHeader\">true</Set>");
                        out.println("                      </New>");
                        out.println("                    </Arg>");
                        out.println("                  </New>");
                        out.println("                </Item>");
                        out.println("              </Array>");
                        out.println("            </Arg>");
                        modified = true;
                        continue;
                    }
                    if (s.contains("org.eclipse.jetty.http.ssl.SslContextFactory")) {
                        s = s.replace("org.eclipse.jetty.http.ssl.SslContextFactory", "org.eclipse.jetty.util.ssl.SslContextFactory");
                        out.println("  <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                        out.println(s);
                        out.println("    <Set name=\"ExcludeCipherSuites\">");
                        out.println("      <Array type=\"java.lang.String\">");
                        for (String ss : I2PSSLSocketFactory.EXCLUDE_CIPHERS) {
                            out.println("        <Item>" + ss + "</Item>");
                        }
                        out.println("      </Array>");
                        out.println("    </Set>");
                        out.println("    <Set name=\"ExcludeProtocols\">");
                        out.println("      <Array type=\"java.lang.String\">");
                        for (String ss : I2PSSLSocketFactory.EXCLUDE_PROTOCOLS) {
                            out.println("        <Item>" + ss + "</Item>");
                        }
                        out.println("      </Array>");
                        out.println("    </Set>");
                        modified = true;
                        continue;
                    }
                    if (s.contains("org.eclipse.jetty.server.ssl.SslSelectChannelConnector")) {
                        s = s.replace("org.eclipse.jetty.server.ssl.SslSelectChannelConnector", "org.eclipse.jetty.server.ServerConnector");
                        out.println("      <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                        out.println(s);
                        out.println("        <Arg><Ref id=\"Server\" /></Arg>");
                        out.println("        <Arg type=\"int\">1</Arg>     <!-- number of acceptors -->");
                        out.println("        <Arg type=\"int\">0</Arg>     <!-- default number of selectors -->");
                        out.println("        <Arg>");
                        out.println("           <Array type=\"org.eclipse.jetty.server.ConnectionFactory\">    <!-- varargs so we need an array -->");
                        out.println("              <Item>");
                        out.println("                <New class=\"org.eclipse.jetty.server.SslConnectionFactory\">");
                        out.println("                  <Arg><Ref id=\"sslContextFactory\" /></Arg>");
                        out.println("                  <Arg>http/1.1</Arg>");
                        out.println("                </New>");
                        out.println("              </Item>");
                        out.println("              <Item>");
                        out.println("                <New class=\"org.eclipse.jetty.server.HttpConnectionFactory\">");
                        out.println("                  <Arg>");
                        out.println("                    <New class=\"org.eclipse.jetty.server.HttpConfiguration\">");
                        out.println("                      <Set name=\"sendServerVersion\">false</Set>");
                        out.println("                      <Set name=\"sendDateHeader\">true</Set>");
                        out.println("                    </New>");
                        out.println("                  </Arg>");
                        out.println("                </New>");
                        out.println("              </Item>");
                        out.println("            </Array>");
                        out.println("        </Arg>");
                        foundSSCC = true;
                        modified = true;
                        continue;
                    }
                    if (foundSSCC && s.contains("<Set name=\"ExcludeCipherSuites\">")) {
                        while ((s = DataHelper.readLine(in)) != null && !s.contains("</Set>")) {
                        }
                        modified = true;
                        continue;
                    }
                    if (foundSSCC && s.contains("<Ref id=\"sslContextFactory\"")) {
                        modified = true;
                        continue;
                    }
                    if (s.contains("<Set name=\"KeyStore\">")) {
                        s = s.replace("<Set name=\"KeyStore\">", "<Set name=\"KeyStorePath\">");
                        modified = true;
                    } else if (s.contains("<Set name=\"TrustStore\">")) {
                        s = s.replace("<Set name=\"TrustStore\">", "<Set name=\"TrustStorePath\">");
                        modified = true;
                    } else if (s.contains("class=\"org.eclipse.jetty.deploy.providers.ContextProvider\">")) {
                        out.println("        <!-- Modified by I2P migration script for Jetty 9. Do not remove this line -->");
                        s = s.replace("class=\"org.eclipse.jetty.deploy.providers.ContextProvider\">", "class=\"org.eclipse.jetty.deploy.providers.WebAppProvider\">");
                        modified = true;
                    } else if (s.contains("<Set name=\"maxIdleTime\">")) {
                        s = s.replace("<Set name=\"maxIdleTime\">", "<Set name=\"idleTimeout\">");
                        modified = true;
                    } else if (s.contains("<Set name=\"gracefulShutdown\">")) {
                        s = s.replace("<Set name=\"gracefulShutdown\">", "<Set name=\"stopTimeout\">");
                        modified = true;
                    } else if (s.contains("org.eclipse.jetty.server.HttpConfiguration")) {
                        foundHC = true;
                    } else {
                        if (!foundHC && (s.contains("<Set name=\"sendServerVersion\">") || s.contains("<Set name=\"sendDateHeader\">"))) {
                            modified = true;
                            continue;
                        }
                        if (s.contains("<Set name=\"Acceptors\">") || s.contains("<Set name=\"acceptors\">") || s.contains("<Set name=\"statsOn\">") || s.contains("<Set name=\"confidentialPort\">") || s.contains("<Set name=\"lowResourcesConnections\">") || s.contains("<Set name=\"lowResourcesMaxIdleTime\">") || s.contains("<Set name=\"useDirectBuffers\">")) {
                            modified = true;
                            continue;
                        }
                    }
                }
                out.println(s);
            }
        }
        catch (IOException ioe) {
            if (in != null) {
                System.err.println("FAILED migration of " + xmlFile + ": " + ioe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
        if (modified) {
            return FileUtil.rename(newFile, xmlFile);
        }
        newFile.delete();
        return true;
    }

    private static boolean hasLatestJetty() {
        if (!_wasChecked) {
            try {
                LoadClientAppsJob.testClient(TEST_CLASS, null);
                _hasLatestJetty = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _wasChecked = true;
        }
        return _hasLatestJetty;
    }

    private static boolean backupFile(File from) {
        return MigrateJetty.backupFile(from, BACKUP_SUFFIX);
    }

    private static boolean backupFile(File from, String suffix) {
        boolean rv;
        if (!from.exists()) {
            return true;
        }
        File to = new File(from.getAbsolutePath() + suffix);
        if (to.exists()) {
            to = new File(to.getAbsolutePath() + "." + System.currentTimeMillis());
        }
        if (rv = WorkingDir.copyFile(from, to)) {
            System.err.println("Backed up file " + from + " to " + to);
        } else {
            System.err.println("WARNING: Failed to back up file " + from + " to " + to);
        }
        return rv;
    }

    private static boolean backupAndMigrateFile(File templateDir, File toDir, String filename, String fromString, String toString) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        boolean rv2 = WorkingDir.migrateJettyXml(templateDir, toDir, filename, fromString, toString);
        return rv && rv2;
    }

    private static boolean backupAndCopyFile(File templateDir, File toDir, String filename) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        File from = new File(templateDir, filename);
        boolean rv2 = WorkingDir.copyFile(from, to);
        return rv && rv2;
    }
}

