/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.util.ResettableGZIPOutputStream;

public class ReusableGZIPOutputStream
extends ResettableGZIPOutputStream {
    private static final boolean ENABLE_CACHING = false;
    private static final LinkedBlockingQueue<ReusableGZIPOutputStream> _available = null;
    private final ByteArrayOutputStream _buffer;

    public static ReusableGZIPOutputStream acquire() {
        ReusableGZIPOutputStream rv = null;
        if (rv == null) {
            rv = new ReusableGZIPOutputStream();
        }
        return rv;
    }

    public static void release(ReusableGZIPOutputStream out) {
        out.reset();
    }

    private ReusableGZIPOutputStream() {
        super(new ByteArrayOutputStream(40960));
        this._buffer = (ByteArrayOutputStream)this.out;
    }

    @Override
    public void reset() {
        super.reset();
        this._buffer.reset();
        this.def.setLevel(9);
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public byte[] getData() {
        return this._buffer.toByteArray();
    }

    public static void clearCache() {
        if (_available != null) {
            _available.clear();
        }
    }
}

