/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.DirKeyRing;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.SecureFileOutputStream;

public class SU3File {
    private final I2PAppContext _context;
    private final File _file;
    private String _version;
    private int _versionLength;
    private String _signer;
    private int _signatureLength;
    private int _signerLength;
    private int _fileType = -1;
    private ContentType _contentType;
    private long _contentLength;
    private PublicKey _signerPubkey;
    private boolean _headerVerified;
    private SigType _sigType;
    private boolean _verifySignature = true;
    private File _certFile;
    public static final String MAGIC = "I2Psu3";
    private static final byte[] MAGIC_BYTES = DataHelper.getASCII("I2Psu3");
    private static final int FILE_VERSION = 0;
    private static final int MIN_VERSION_BYTES = 16;
    private static final int VERSION_OFFSET = 40;
    public static final int TYPE_ZIP = 0;
    public static final int TYPE_XML = 1;
    public static final int TYPE_HTML = 2;
    public static final int TYPE_XML_GZ = 3;
    public static final int TYPE_TXT_GZ = 4;
    public static final int CONTENT_UNKNOWN = 0;
    public static final int CONTENT_ROUTER = 1;
    public static final int CONTENT_PLUGIN = 2;
    public static final int CONTENT_RESEED = 3;
    public static final int CONTENT_NEWS = 4;
    public static final int CONTENT_BLOCKLIST = 5;
    private static final Map<Integer, ContentType> BY_CODE = new HashMap<Integer, ContentType>();
    private static final ContentType DEFAULT_CONTENT_TYPE;
    private static final int DEFAULT_SIG_CODE = 6;

    public SU3File(String file) {
        this(new File(file));
    }

    public SU3File(File file) {
        this(I2PAppContext.getGlobalContext(), file);
    }

    public SU3File(I2PAppContext context, File file) {
        this._context = context;
        this._file = file;
    }

    public void setVerifySignature(boolean shouldVerify) {
        this._verifySignature = shouldVerify;
    }

    private void setPublicKeyCertificate(File certFile) {
        this._certFile = certFile;
    }

    public String getVersionString() throws IOException {
        this.verifyHeader();
        return this._version;
    }

    public String getSignerString() throws IOException {
        this.verifyHeader();
        return this._signer;
    }

    public SigType getSigType() throws IOException {
        this.verifyHeader();
        return this._sigType;
    }

    public int getContentType() throws IOException {
        this.verifyHeader();
        return this._contentType != null ? this._contentType.getCode() : -1;
    }

    public int getFileType() throws IOException {
        this.verifyHeader();
        return this._fileType;
    }

    public void verifyHeader() throws IOException {
        if (this._headerVerified) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._file);
            this.verifyHeader(in);
        }
        catch (DataFormatException dfe) {
            IOException ioe = new IOException("foo");
            ioe.initCause(dfe);
            throw ioe;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void verifyHeader(InputStream in) throws IOException, DataFormatException {
        int zbyte;
        byte[] magic = new byte[MAGIC_BYTES.length];
        DataHelper.read(in, magic);
        if (!DataHelper.eq(magic, MAGIC_BYTES)) {
            throw new IOException("Not an su3 file");
        }
        SU3File.skip(in, 1);
        int foo = in.read();
        if (foo != 0) {
            throw new IOException("bad file version");
        }
        int sigTypeCode = (int)DataHelper.readLong(in, 2);
        this._sigType = SigType.getByCode(sigTypeCode);
        if (this._sigType == null) {
            throw new IOException("unknown sig type: " + sigTypeCode);
        }
        this._signatureLength = (int)DataHelper.readLong(in, 2);
        if (this._signatureLength != this._sigType.getSigLen()) {
            throw new IOException("bad sig length");
        }
        SU3File.skip(in, 1);
        int _versionLength = in.read();
        if (_versionLength < 16) {
            throw new IOException("bad version length");
        }
        SU3File.skip(in, 1);
        this._signerLength = in.read();
        if (this._signerLength <= 0) {
            throw new IOException("bad signer length");
        }
        this._contentLength = DataHelper.readLong(in, 8);
        if (this._contentLength <= 0L) {
            throw new IOException("bad content length");
        }
        SU3File.skip(in, 1);
        this._fileType = in.read();
        SU3File.skip(in, 1);
        int cType = in.read();
        this._contentType = BY_CODE.get(cType);
        if (this._contentType == null) {
            throw new IOException("unknown content type " + cType);
        }
        SU3File.skip(in, 12);
        byte[] data = new byte[_versionLength];
        int bytesRead = DataHelper.read(in, data);
        if (bytesRead != _versionLength) {
            throw new EOFException();
        }
        for (zbyte = 0; zbyte < _versionLength && data[zbyte] != 0; ++zbyte) {
        }
        this._version = new String(data, 0, zbyte, "UTF-8");
        data = new byte[this._signerLength];
        bytesRead = DataHelper.read(in, data);
        if (bytesRead != this._signerLength) {
            throw new EOFException();
        }
        this._signer = DataHelper.getUTF8(data);
        if (this._verifySignature) {
            if (this._certFile != null) {
                this._signerPubkey = SU3File.loadKey(this._certFile);
            } else {
                DirKeyRing ring = new DirKeyRing(new File(this._context.getBaseDir(), "certificates"));
                try {
                    this._signerPubkey = ring.getKey(this._signer, this._contentType.getName(), this._sigType);
                }
                catch (GeneralSecurityException gse) {
                    IOException ioe = new IOException("keystore error");
                    ioe.initCause(gse);
                    throw ioe;
                }
                if (this._signerPubkey == null) {
                    boolean diff = true;
                    try {
                        diff = !this._context.getBaseDir().getCanonicalPath().equals(this._context.getConfigDir().getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (diff) {
                        ring = new DirKeyRing(new File(this._context.getConfigDir(), "certificates"));
                        try {
                            this._signerPubkey = ring.getKey(this._signer, this._contentType.getName(), this._sigType);
                        }
                        catch (GeneralSecurityException gse) {
                            IOException ioe = new IOException("keystore error");
                            ioe.initCause(gse);
                            throw ioe;
                        }
                    }
                    if (this._signerPubkey == null) {
                        throw new IOException("unknown signer: " + this._signer + " for content type: " + this._contentType.getName());
                    }
                }
            }
        }
        this._headerVerified = true;
    }

    private static void skip(InputStream in, int cnt) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            if (in.read() >= 0) continue;
            throw new EOFException();
        }
    }

    private int getContentOffset() throws IOException {
        this.verifyHeader();
        return 40 + this._versionLength + this._signerLength;
    }

    public boolean verify() throws IOException {
        return this.verifyAndMigrate(null);
    }

    public boolean verifyAndMigrate(File migrateTo) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        boolean rv = false;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(this._file));
            in.mark(10);
            byte[] magic = new byte[MAGIC_BYTES.length];
            DataHelper.read(in, magic);
            if (!DataHelper.eq(magic, MAGIC_BYTES)) {
                throw new IOException("Not an su3 file");
            }
            SU3File.skip(in, 1);
            int foo = in.read();
            if (foo != 0) {
                throw new IOException("bad file version");
            }
            SU3File.skip(in, 1);
            int sigTypeCode = in.read();
            this._sigType = SigType.getByCode(sigTypeCode);
            if (this._sigType == null) {
                throw new IOException("unknown sig type: " + sigTypeCode);
            }
            in.reset();
            MessageDigest md = this._sigType.getDigestInstance();
            DigestInputStream din = new DigestInputStream(in, md);
            in = din;
            if (!this._headerVerified) {
                this.verifyHeader(in);
            } else {
                SU3File.skip(in, this.getContentOffset());
            }
            if (this._verifySignature && this._signerPubkey == null) {
                throw new IOException("unknown signer: " + this._signer + " for content type: " + this._contentType.getName());
            }
            if (migrateTo != null) {
                out = new FileOutputStream(migrateTo);
            }
            byte[] buf = new byte[16384];
            for (long tot = 0L; tot < this._contentLength; tot += (long)read) {
                read = in.read(buf, 0, (int)Math.min((long)buf.length, this._contentLength - tot));
                if (read < 0) {
                    throw new EOFException();
                }
                if (migrateTo == null) continue;
                out.write(buf, 0, read);
            }
            if (this._verifySignature) {
                byte[] sha = md.digest();
                din.on(false);
                Signature signature = new Signature(this._sigType);
                signature.readBytes(in);
                int avail = in.available();
                if (avail > 0) {
                    throw new IOException(avail + " bytes data after sig");
                }
                SimpleDataStructure hash = this._sigType.getHashInstance();
                hash.setData(sha);
                rv = this._context.dsa().verifySignature(signature, hash, this._signerPubkey);
            } else {
                rv = true;
            }
        }
        catch (DataFormatException dfe) {
            IOException ioe = new IOException("foo");
            ioe.initCause(dfe);
            throw ioe;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (migrateTo != null && !rv) {
                migrateTo.delete();
            }
        }
        return rv;
    }

    public void write(File content, int fileType, int contentType, String version, String signer, PrivateKey privkey, SigType sigType) throws IOException {
        InputStream in = null;
        FilterOutputStream out = null;
        boolean ok = false;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(content));
            MessageDigest md = sigType.getDigestInstance();
            out = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this._file)), md);
            out.write(MAGIC_BYTES);
            ((DigestOutputStream)out).write(0);
            ((DigestOutputStream)out).write(0);
            DataHelper.writeLong(out, 2, sigType.getCode());
            DataHelper.writeLong(out, 2, sigType.getSigLen());
            ((DigestOutputStream)out).write(0);
            byte[] verBytes = DataHelper.getUTF8(version);
            if (verBytes.length == 0 || verBytes.length > 255) {
                throw new IllegalArgumentException("bad version length");
            }
            int verLen = Math.max(verBytes.length, 16);
            ((DigestOutputStream)out).write((byte)verLen);
            ((DigestOutputStream)out).write(0);
            byte[] signerBytes = DataHelper.getUTF8(signer);
            if (signerBytes.length == 0 || signerBytes.length > 255) {
                throw new IllegalArgumentException("bad signer length");
            }
            ((DigestOutputStream)out).write((byte)signerBytes.length);
            long contentLength = content.length();
            if (contentLength <= 0L) {
                throw new IllegalArgumentException("No content");
            }
            DataHelper.writeLong(out, 8, contentLength);
            ((DigestOutputStream)out).write(0);
            if (fileType < 0 || fileType > 255) {
                throw new IllegalArgumentException("bad content type");
            }
            ((DigestOutputStream)out).write((byte)fileType);
            ((DigestOutputStream)out).write(0);
            if (contentType < 0 || contentType > 255) {
                throw new IllegalArgumentException("bad content type");
            }
            ((DigestOutputStream)out).write((byte)contentType);
            out.write(new byte[12]);
            out.write(verBytes);
            if (verBytes.length < 16) {
                out.write(new byte[16 - verBytes.length]);
            }
            out.write(signerBytes);
            byte[] buf = new byte[16384];
            for (long tot = 0L; tot < contentLength; tot += (long)read) {
                read = in.read(buf, 0, (int)Math.min((long)buf.length, contentLength - tot));
                if (read < 0) {
                    throw new EOFException();
                }
                ((DigestOutputStream)out).write(buf, 0, read);
            }
            byte[] sha = md.digest();
            ((DigestOutputStream)out).on(false);
            SimpleDataStructure hash = sigType.getHashInstance();
            hash.setData(sha);
            Signature signature = this._context.dsa().sign(hash, privkey, sigType);
            if (signature == null) {
                throw new IOException("sig fail");
            }
            signature.writeBytes(out);
            ok = true;
        }
        catch (DataFormatException dfe) {
            IOException ioe = new IOException("foo");
            ioe.initCause(dfe);
            throw ioe;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (!ok) {
                this._file.delete();
            }
        }
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            int c;
            String stype = null;
            String ctype = null;
            String ftype = null;
            String kfile = null;
            String crlfile = null;
            String kspass = "changeit";
            boolean error = false;
            boolean shouldVerify = true;
            Getopt g = new Getopt("SU3File", args, "t:c:f:k:xp:r:");
            block12: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 116: {
                        stype = g.getOptarg();
                        continue block12;
                    }
                    case 99: {
                        ctype = g.getOptarg();
                        continue block12;
                    }
                    case 102: {
                        ftype = g.getOptarg();
                        continue block12;
                    }
                    case 107: {
                        kfile = g.getOptarg();
                        continue block12;
                    }
                    case 114: {
                        crlfile = g.getOptarg();
                        continue block12;
                    }
                    case 120: {
                        shouldVerify = false;
                        continue block12;
                    }
                    case 112: {
                        kspass = g.getOptarg();
                        continue block12;
                    }
                }
                error = true;
            }
            int idx = g.getOptind();
            String cmd = args[idx];
            ArrayList<String> a = new ArrayList<String>(Arrays.asList(args).subList(idx + 1, args.length));
            if (error) {
                SU3File.showUsageCLI();
            } else if ("showversion".equals(cmd)) {
                ok = SU3File.showVersionCLI((String)a.get(0));
            } else if ("sign".equals(cmd)) {
                Properties props = new Properties();
                props.setProperty("prng.bufferSize", "16384");
                new I2PAppContext(props);
                ok = SU3File.signCLI(stype, ctype, ftype, (String)a.get(0), (String)a.get(1), (String)a.get(2), (String)a.get(3), (String)a.get(4), "", kspass);
            } else if ("bulksign".equals(cmd)) {
                Properties props = new Properties();
                props.setProperty("prng.bufferSize", "16384");
                new I2PAppContext(props);
                ok = SU3File.bulkSignCLI(stype, ctype, (String)a.get(0), (String)a.get(1), (String)a.get(2), (String)a.get(3), kspass);
            } else if ("verifysig".equals(cmd)) {
                ok = SU3File.verifySigCLI((String)a.get(0), kfile);
            } else if ("keygen".equals(cmd)) {
                Properties props = new Properties();
                props.setProperty("prng.bufferSize", "16384");
                new I2PAppContext(props);
                ok = SU3File.genKeysCLI(stype, (String)a.get(0), (String)a.get(1), crlfile, (String)a.get(2), kspass);
            } else if ("extract".equals(cmd)) {
                ok = SU3File.extractCLI((String)a.get(0), (String)a.get(1), shouldVerify, kfile);
            } else {
                SU3File.showUsageCLI();
            }
        }
        catch (NoSuchElementException nsee) {
            SU3File.showUsageCLI();
        }
        catch (IndexOutOfBoundsException ioobe) {
            SU3File.showUsageCLI();
        }
        if (!ok) {
            System.exit(1);
        }
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: SU3File keygen       [-t type|code] [-p keystorepw] [-r crlFile.crl] publicKeyFile.crt keystore.ks you@mail.i2p\n       SU3File sign         [-t type|code] [-c type|code] [-f type|code] [-p keystorepw] inputFile.zip signedFile.su3 keystore.ks version you@mail.i2p\n       SU3File bulksign     [-t type|code] [-c type|code] [-p keystorepw] directory keystore.ks version you@mail.i2p\n                            (signs all .zip, .xml, and .xml.gz files in the directory)\n       SU3File showversion  signedFile.su3\n       SU3File verifysig    [-k file.crt] signedFile.su3  ## -k use this pubkey cert for verification\n       SU3File extract      [-x] [-k file.crt] signedFile.su3 outFile   ## -x don't check sig");
        System.err.println("Default keystore password: \"changeit\"");
        System.err.println(SU3File.dumpTypes());
    }

    private static String dumpTypes() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Available signature types (-t):\n");
        for (SigType sigType : EnumSet.allOf(SigType.class)) {
            if (!sigType.isAvailable() || sigType == SigType.EdDSA_SHA512_Ed25519) continue;
            buf.append("      ").append((Object)sigType).append("\t(code: ").append(sigType.getCode()).append(')');
            if (sigType.getCode() == 6) {
                buf.append(" DEFAULT");
            }
            if (!sigType.isAvailable()) {
                buf.append(" UNAVAILABLE");
            }
            buf.append('\n');
        }
        buf.append("Available content types (-c):\n");
        for (ContentType contentType : EnumSet.allOf(ContentType.class)) {
            buf.append("      ").append((Object)contentType).append("\t(code: ").append(contentType.getCode()).append(')');
            if (contentType == DEFAULT_CONTENT_TYPE) {
                buf.append(" DEFAULT");
            }
            buf.append('\n');
        }
        buf.append("Available file types (-f):\n      ZIP\t(code: 0) DEFAULT\n      XML\t(code: 1)\n      HTML\t(code: 2)\n      XML_GZ\t(code: 3)\n      TXT_GZ\t(code: 4)\n      (user defined)\t(code: 5-255)\n");
        return buf.toString();
    }

    private static ContentType parseContentType(String ctype) {
        try {
            return ContentType.valueOf(ctype.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException iae) {
            try {
                int code = Integer.parseInt(ctype);
                return ContentType.getByCode(code);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    private static final boolean showVersionCLI(String signedFile) {
        try {
            SU3File file = new SU3File(signedFile);
            file.setVerifySignature(false);
            String versionString = file.getVersionString();
            if (versionString.equals("")) {
                System.out.println("No version string found in file '" + signedFile + "'");
            } else {
                System.out.println("Version:  " + versionString);
            }
            String signerString = file.getSignerString();
            if (signerString.equals("")) {
                System.out.println("No signer string found in file '" + signedFile + "'");
            } else {
                System.out.println("Signer:   " + signerString);
            }
            if (file._sigType != null) {
                System.out.println("SigType:  " + (Object)((Object)file._sigType));
            }
            if (file._contentType != null) {
                System.out.println("Content:  " + (Object)((Object)file._contentType));
            }
            String ftype = file._fileType == 0 ? "ZIP" : (file._fileType == 1 ? "XML" : (file._fileType == 2 ? "HTML" : (file._fileType == 3 ? "XML_GZ" : Integer.toString(file._fileType))));
            System.out.println("FileType: " + ftype);
            return !versionString.equals("");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean bulkSignCLI(String stype, String ctype, String dir, String privateKeyFile, String version, String signerName, String kspass) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            System.out.println("Directory does not exist: " + d);
            return false;
        }
        File[] files = d.listFiles();
        if (files == null || files.length == 0) {
            System.out.println("No zip files found in " + d);
            return false;
        }
        String keypw = "";
        try {
            while (keypw.length() < 6) {
                System.out.print("Enter password for key \"" + signerName + "\": ");
                keypw = DataHelper.readLine(System.in);
                if (keypw == null) {
                    System.out.println("\nEOF reading password");
                    return false;
                }
                if ((keypw = keypw.trim()).length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
        }
        catch (IOException ioe) {
            System.out.println("Error asking for password");
            ioe.printStackTrace();
            return false;
        }
        int success = 0;
        for (File in : files) {
            String ftype;
            int len;
            String inputFile = in.getPath();
            if (inputFile.endsWith(".zip")) {
                len = 4;
                ftype = "ZIP";
            } else if (inputFile.endsWith(".xml")) {
                len = 4;
                ftype = "XML";
            } else {
                if (!inputFile.endsWith(".xml.gz")) continue;
                len = 7;
                ftype = "XML_GZ";
            }
            String signedFile = inputFile.substring(0, inputFile.length() - len) + ".su3";
            boolean rv = SU3File.signCLI(stype, ctype, ftype, inputFile, signedFile, privateKeyFile, version, signerName, keypw, kspass);
            if (!rv) {
                return false;
            }
            ++success;
        }
        if (success == 0) {
            System.out.println("No files processed in " + d);
        }
        return success > 0;
    }

    private static final boolean signCLI(String stype, String ctype, String ftype, String inputFile, String signedFile, String privateKeyFile, String version, String signerName, String keypw, String kspass) {
        ContentType ct;
        SigType type;
        SigType sigType = type = stype == null ? SigType.getByCode(6) : SigType.parseSigType(stype);
        if (type == null) {
            System.out.println("Signature type " + stype + " is not supported");
            return false;
        }
        ContentType contentType = ct = ctype == null ? DEFAULT_CONTENT_TYPE : SU3File.parseContentType(ctype);
        if (ct == null) {
            System.out.println("Content type " + ctype + " is not supported");
            return false;
        }
        int ft = 0;
        if (ftype != null) {
            if (ftype.equalsIgnoreCase("ZIP")) {
                ft = 0;
            } else if (ftype.equalsIgnoreCase("XML")) {
                ft = 1;
            } else if (ftype.equalsIgnoreCase("HTML")) {
                ft = 2;
            } else if (ftype.equalsIgnoreCase("XML_GZ")) {
                ft = 3;
            } else {
                try {
                    ft = Integer.parseInt(ftype);
                }
                catch (NumberFormatException nfe) {
                    ft = -1;
                }
                if (ft < 0 || ft > 255) {
                    System.out.println("File type " + ftype + " is not supported");
                    return false;
                }
                if (ft > 3) {
                    System.out.println("Warning: File type " + ftype + " is undefined");
                }
            }
        }
        return SU3File.signCLI(type, ct, ft, inputFile, signedFile, privateKeyFile, version, signerName, keypw, kspass);
    }

    private static final boolean signCLI(SigType type, ContentType ctype, int ftype, String inputFile, String signedFile, String privateKeyFile, String version, String signerName, String keypw, String kspass) {
        try {
            while (keypw.length() < 6) {
                System.out.print("Enter password for key \"" + signerName + "\": ");
                keypw = DataHelper.readLine(System.in);
                if (keypw == null) {
                    System.out.println("\nEOF reading password");
                    return false;
                }
                if ((keypw = keypw.trim()).length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
            File pkfile = new File(privateKeyFile);
            PrivateKey pk = KeyStoreUtil.getPrivateKey(pkfile, kspass, signerName, keypw);
            if (pk == null) {
                System.out.println("Private key for " + signerName + " not found in keystore " + privateKeyFile);
                return false;
            }
            SigType oldType = type;
            if (oldType != (type = SigUtil.fromJavaKey(pk).getType())) {
                System.out.println("Warning: Using private key type " + (Object)((Object)type) + ", ignoring specified type " + (Object)((Object)oldType));
            }
            SU3File file = new SU3File(signedFile);
            file.write(new File(inputFile), ftype, ctype.getCode(), version, signerName, pk, type);
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
            return true;
        }
        catch (GeneralSecurityException gse) {
            System.out.println("Error signing input file '" + inputFile + "'");
            gse.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            System.out.println("Error signing input file '" + inputFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean verifySigCLI(String signedFile, String pkFile) {
        Object in = null;
        try {
            boolean isValidSignature;
            SU3File file = new SU3File(signedFile);
            if (pkFile != null) {
                file.setPublicKeyCertificate(new File(pkFile));
            }
            if (isValidSignature = file.verify()) {
                System.out.println("Signature VALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            } else {
                System.out.println("Signature INVALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            }
            return isValidSignature;
        }
        catch (IOException ioe) {
            System.out.println("Error verifying input file '" + signedFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean extractCLI(String signedFile, String outFile, boolean verifySig, String pkFile) {
        Object in = null;
        try {
            SU3File file = new SU3File(signedFile);
            if (pkFile != null) {
                file.setPublicKeyCertificate(new File(pkFile));
            }
            file.setVerifySignature(verifySig);
            File out = new File(outFile);
            boolean ok = file.verifyAndMigrate(out);
            if (ok) {
                System.out.println("File extracted (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            } else {
                System.out.println("Signature INVALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            }
            return ok;
        }
        catch (IOException ioe) {
            System.out.println("Error extracting from file '" + signedFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean genKeysCLI(String stype, String publicKeyFile, String privateKeyFile, String crlFile, String alias, String kspass) {
        SigType type;
        SigType sigType = type = stype == null ? SigType.getByCode(6) : SigType.parseSigType(stype);
        if (type == null) {
            System.out.println("Signature type " + stype + " is not supported");
            return false;
        }
        return SU3File.genKeysCLI(type, publicKeyFile, privateKeyFile, crlFile, alias, kspass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean genKeysCLI(SigType type, String publicKeyFile, String privateKeyFile, String crlFile, String alias, String kspass) {
        File pubFile = new File(publicKeyFile);
        if (pubFile.exists()) {
            System.out.println("Error: Not overwriting file " + publicKeyFile);
            return false;
        }
        File ksFile = new File(privateKeyFile);
        String keypw = "";
        try {
            while (alias.length() == 0) {
                System.out.print("Enter key name (example@mail.i2p): ");
                alias = DataHelper.readLine(System.in);
                if (alias == null) {
                    System.out.println("\nEOF reading key name");
                    return false;
                }
                alias = alias.trim();
            }
            while (keypw.length() < 6) {
                System.out.print("Enter new key password: ");
                keypw = DataHelper.readLine(System.in);
                if (keypw == null) {
                    System.out.println("\nEOF reading password");
                    return false;
                }
                if ((keypw = keypw.trim()).length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
        }
        catch (IOException ioe) {
            return false;
        }
        OutputStream out = null;
        try {
            Object[] rv = KeyStoreUtil.createKeysAndCRL(ksFile, kspass, alias, alias, "I2P", 3652, type, keypw);
            X509Certificate cert = (X509Certificate)rv[2];
            out = new SecureFileOutputStream(publicKeyFile);
            CertUtil.exportCert(cert, out);
            if (crlFile != null) {
                out.close();
                X509CRL crl = (X509CRL)rv[3];
                out = new SecureFileOutputStream(crlFile);
                CertUtil.exportCRL(crl, out);
            }
        }
        catch (GeneralSecurityException gse) {
            System.err.println("Error creating keys for " + alias);
            gse.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            System.err.println("Error creating keys for " + alias);
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static PublicKey loadKey(File kd) throws IOException {
        try {
            return CertUtil.loadKey(kd);
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("cert error");
            ioe.initCause(gse);
            throw ioe;
        }
    }

    static {
        for (ContentType type : ContentType.values()) {
            BY_CODE.put(type.getCode(), type);
        }
        DEFAULT_CONTENT_TYPE = ContentType.UNKNOWN;
    }

    private static enum ContentType {
        UNKNOWN(0, "unknown"),
        ROUTER(1, "router"),
        PLUGIN(2, "plugin"),
        RESEED(3, "reseed"),
        NEWS(4, "news"),
        BLOCKLIST(5, "blocklist");

        private final int code;
        private final String name;

        private ContentType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static ContentType getByCode(int code) {
            return (ContentType)((Object)BY_CODE.get(code));
        }
    }
}

