/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitReader;
import org.json.zip.Huff;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Unzipper
extends JSONzip {
    BitReader bitreader;

    public Unzipper(BitReader bitreader) {
        this.bitreader = bitreader;
    }

    private boolean bit() throws JSONException {
        try {
            boolean value = this.bitreader.bit();
            return value;
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    private Object getAndTick(Keep keep, BitReader bitreader) throws JSONException {
        try {
            int width = keep.bitsize();
            int integer = bitreader.read(width);
            Object value = keep.value(integer);
            if (integer >= keep.length) {
                throw new JSONException("Deep error.");
            }
            keep.tick(integer);
            return value;
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    public boolean pad(int width) throws JSONException {
        try {
            return this.bitreader.pad(width);
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    private int read(int width) throws JSONException {
        try {
            int value = this.bitreader.read(width);
            return value;
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String read(Huff huff, Huff ext, Keep keep) throws JSONException {
        at = 0;
        allocation = 256;
        bytes = new byte[allocation];
        if (this.bit()) {
            return this.getAndTick(keep, this.bitreader).toString();
        }
        while (true) {
            if (at >= allocation) {
                bytes = Arrays.copyOf(bytes, allocation *= 2);
            }
            if ((c = huff.read(this.bitreader)) != 256) ** GOTO lbl14
            break;
lbl-1000:
            // 1 sources

            {
                bytes[at] = (byte)c;
                ++at;
                c = ext.read(this.bitreader);
lbl14:
                // 2 sources

                ** while ((c & 128) == 128)
            }
lbl15:
            // 1 sources

            bytes[at] = (byte)c;
            ++at;
        }
        if (at == 0) {
            return "";
        }
        kim = new Kim(bytes, at);
        keep.register(kim);
        return kim.toString();
    }

    private JSONArray readArray(boolean stringy) throws JSONException {
        JSONArray jsonarray = new JSONArray();
        jsonarray.put(stringy ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        while (true) {
            if (!this.bit()) {
                if (!this.bit()) {
                    return jsonarray;
                }
                jsonarray.put(stringy ? this.readValue() : this.read(this.stringhuff, this.stringhuffext, this.stringkeep));
                continue;
            }
            jsonarray.put(stringy ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        }
    }

    private Object readJSON() throws JSONException {
        switch (this.read(3)) {
            case 5: {
                return this.readObject();
            }
            case 6: {
                return this.readArray(true);
            }
            case 7: {
                return this.readArray(false);
            }
            case 0: {
                return new JSONObject();
            }
            case 1: {
                return new JSONArray();
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                return Boolean.FALSE;
            }
        }
        return JSONObject.NULL;
    }

    private JSONObject readObject() throws JSONException {
        JSONObject jsonobject = new JSONObject();
        do {
            String name;
            if (jsonobject.opt(name = this.read(this.namehuff, this.namehuffext, this.namekeep)) != null) {
                throw new JSONException("Duplicate key.");
            }
            jsonobject.put(name, !this.bit() ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        } while (this.bit());
        return jsonobject;
    }

    private Object readValue() throws JSONException {
        switch (this.read(2)) {
            case 0: {
                int nr_bits = !this.bit() ? 4 : (!this.bit() ? 7 : 14);
                int integer = this.read(nr_bits);
                switch (nr_bits) {
                    case 7: {
                        integer += 16;
                        break;
                    }
                    case 14: {
                        integer += 144;
                    }
                }
                return integer;
            }
            case 1: {
                Object value;
                int c;
                byte[] bytes = new byte[256];
                int length = 0;
                while ((c = this.read(4)) != endOfNumber) {
                    bytes[length] = bcd[c];
                    ++length;
                }
                try {
                    value = JSONObject.stringToValue(new String(bytes, 0, length, "US-ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JSONException(e);
                }
                this.valuekeep.register(value);
                return value;
            }
            case 2: {
                return this.getAndTick(this.valuekeep, this.bitreader);
            }
            case 3: {
                return this.readJSON();
            }
        }
        throw new JSONException("Impossible.");
    }

    public Object decode() throws JSONException {
        this.generate();
        return this.readJSON();
    }
}

