/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PacketLocal
extends Packet
implements MessageOutputStream.WriteStatus {
    private final I2PAppContext _context;
    private final Log _log;
    private final Connection _connection;
    private final Destination _to;
    private SessionKey _keyUsed;
    private final long _createdOn;
    private final AtomicInteger _numSends = new AtomicInteger();
    private volatile long _lastSend;
    private long _acceptedOn;
    private long _ackOn;
    private long _cancelledOn;
    private final AtomicInteger _nackCount = new AtomicInteger();
    private volatile boolean _retransmitted;
    private volatile SimpleTimer2.TimedEvent _resendEvent;

    public PacketLocal(I2PAppContext ctx, Destination to, I2PSession session) {
        super(session);
        this._context = ctx;
        this._createdOn = ctx.clock().now();
        this._log = ctx.logManager().getLog(PacketLocal.class);
        this._to = to;
        this._connection = null;
        this._lastSend = -1L;
        this._cancelledOn = -1L;
    }

    public PacketLocal(I2PAppContext ctx, Destination to, Connection con) {
        super(con.getSession());
        this._context = ctx;
        this._createdOn = ctx.clock().now();
        this._log = ctx.logManager().getLog(PacketLocal.class);
        this._to = to;
        this._connection = con;
        this._lastSend = -1L;
        this._cancelledOn = -1L;
    }

    public Destination getTo() {
        return this._to;
    }

    @Deprecated
    public SessionKey getKeyUsed() {
        return this._keyUsed;
    }

    @Deprecated
    public void setKeyUsed(SessionKey key) {
        if (key != null) {
            this._log.error("Who is sending tags thru the streaming lib?");
        }
        this._keyUsed = key;
    }

    @Deprecated
    public Set<SessionTag> getTagsSent() {
        return Collections.emptySet();
    }

    @Deprecated
    public void setTagsSent(Set<SessionTag> tags) {
        if (tags != null && !tags.isEmpty()) {
            this._log.error("Who is sending tags thru the streaming lib? " + tags.size());
        }
    }

    public boolean shouldSign() {
        return this.isFlagSet(523);
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._createdOn;
    }

    public void incrementSends() {
        this._numSends.incrementAndGet();
        this._lastSend = this._context.clock().now();
    }

    private void cancelResend() {
        SimpleTimer2.TimedEvent ev = this._resendEvent;
        if (ev != null) {
            ev.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived() {
        long now = this._context.clock().now();
        PacketLocal packetLocal = this;
        synchronized (packetLocal) {
            if (this._ackOn <= 0L) {
                this._ackOn = now;
            }
            this.releasePayload();
            this.notifyAll();
        }
        this.cancelResend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        PacketLocal packetLocal = this;
        synchronized (packetLocal) {
            this._cancelledOn = this._context.clock().now();
            this.releasePayload();
            this.notifyAll();
        }
        this.cancelResend();
        if (this._log.shouldLog(10)) {
            this._log.debug("Cancelled! " + this.toString(), (Throwable)new Exception("cancelled"));
        }
    }

    public SimpleTimer2.TimedEvent getResendEvent() {
        return this._resendEvent;
    }

    public synchronized int getAckTime() {
        if (this._ackOn <= 0L) {
            return -1;
        }
        return (int)(this._ackOn - this._createdOn);
    }

    public int getNumSends() {
        return this._numSends.get();
    }

    public long getLastSend() {
        return this._lastSend;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void incrementNACKs() {
        int cnt = this._nackCount.incrementAndGet();
        SimpleTimer2.TimedEvent evt = this._resendEvent;
        if (!(cnt < 3 || evt == null || this._retransmitted || this._numSends.get() != 1 && this._lastSend >= this._context.clock().now() - 4000L)) {
            this._retransmitted = true;
            evt.reschedule(0L);
            if (this._log.shouldLog(10)) {
                String log = String.format("%s nacks and retransmits. Criteria: nacks=%d, retransmitted=%b, numSends=%d, lastSend=%d, now=%d", this.toString(), cnt, this._retransmitted, this._numSends.get(), this._lastSend, this._context.clock().now());
                this._log.debug(log);
            }
        } else if (this._log.shouldLog(10)) {
            String log = String.format("%s nack but no retransmit.  Criteria: nacks=%d, retransmitted=%b, numSends=%d, lastSend=%d, now=%d", this.toString(), cnt, this._retransmitted, this._numSends.get(), this._lastSend, this._context.clock().now());
            this._log.debug(log);
        }
    }

    public int getNACKs() {
        return this._nackCount.get();
    }

    public void setResendPacketEvent(SimpleTimer2.TimedEvent evt) {
        this._resendEvent = evt;
    }

    public int writeSignedPacket(byte[] buffer, int offset) throws IllegalStateException {
        this.setFlag(8);
        SigningPrivateKey key = this._session.getPrivateKey();
        int size = this.writePacket(buffer, offset, key.getType().getSigLen());
        this._optionSignature = this._context.dsa().sign(buffer, offset, size, key);
        if (this._optionSignature == null) {
            throw new IllegalStateException("Signature failed");
        }
        int signatureOffset = offset + 21 + (this._nacks != null ? 4 * this._nacks.length + 1 : 1) + (this.isFlagSet(64) ? 2 : 0) + (this.isFlagSet(32) ? this._optionFrom.size() : 0) + (this.isFlagSet(128) ? 2 : 0);
        System.arraycopy(this._optionSignature.getData(), 0, buffer, signatureOffset, this._optionSignature.length());
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder formatAsString() {
        Connection con;
        StringBuilder buf = super.formatAsString();
        int nackCount = this._nackCount.get();
        if (nackCount > 0) {
            buf.append(" nacked ").append(nackCount).append(" times");
        }
        PacketLocal packetLocal = this;
        synchronized (packetLocal) {
            if (this._ackOn > 0L) {
                buf.append(" ack after ").append(this.getAckTime());
            }
        }
        int numSends = this._numSends.get();
        if (numSends > 1) {
            buf.append(" sent ").append(numSends).append(" times");
        }
        if (this.isFlagSet(7) && (con = this._connection) != null) {
            buf.append(" from ");
            Destination local = this._session.getMyDestination();
            if (local != null) {
                buf.append(local.calculateHash().toBase64().substring(0, 4));
            } else {
                buf.append("unknown");
            }
            buf.append(" to ");
            Destination remote = con.getRemotePeer();
            if (remote != null) {
                buf.append(remote.calculateHash().toBase64().substring(0, 4));
            } else {
                buf.append("unknown");
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForAccept(int maxWaitMs) throws IOException, InterruptedException {
        boolean accepted;
        long before;
        block7: {
            block6: {
                before = this._context.clock().now();
                accepted = false;
                try {
                    accepted = this._connection.packetSendChoke(maxWaitMs);
                    if (!accepted) break block6;
                }
                catch (Throwable throwable) {
                    if (accepted) {
                        this._acceptedOn = this._context.clock().now();
                    } else {
                        this._acceptedOn = -1L;
                        this.releasePayload();
                    }
                    if (this._acceptedOn - before > 1000L && this._log.shouldLog(10)) {
                        int queued = this._connection.getUnackedPacketsSent();
                        int window = this._connection.getOptions().getWindowSize();
                        int afterQueued = this._connection.getUnackedPacketsSent();
                        this._log.debug("Took " + (this._acceptedOn - before) + "ms to get " + (accepted ? "accepted" : "rejected") + (this._cancelledOn > 0L ? " and CANCELLED" : "") + ", queued behind " + queued + " with a window size of " + window + ", finally accepted with " + afterQueued + " queued: " + this.toString());
                    }
                    throw throwable;
                }
                this._acceptedOn = this._context.clock().now();
                break block7;
            }
            this._acceptedOn = -1L;
            this.releasePayload();
        }
        if (this._acceptedOn - before > 1000L && this._log.shouldLog(10)) {
            int queued = this._connection.getUnackedPacketsSent();
            int window = this._connection.getOptions().getWindowSize();
            int afterQueued = this._connection.getUnackedPacketsSent();
            this._log.debug("Took " + (this._acceptedOn - before) + "ms to get " + (accepted ? "accepted" : "rejected") + (this._cancelledOn > 0L ? " and CANCELLED" : "") + ", queued behind " + queued + " with a window size of " + window + ", finally accepted with " + afterQueued + " queued: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForCompletion(int maxWaitMs) throws IOException, InterruptedException {
        long expiration = this._context.clock().now() + (long)maxWaitMs;
        try {
            while (true) {
                long timeRemaining;
                if ((timeRemaining = expiration - this._context.clock().now()) <= 0L && maxWaitMs > 0) {
                    return;
                }
                PacketLocal packetLocal = this;
                synchronized (packetLocal) {
                    if (this._ackOn > 0L) {
                        return;
                    }
                    if (!this._connection.getIsConnected()) {
                        throw new IOException("disconnected");
                    }
                    if (this._cancelledOn > 0L) {
                        throw new IOException("cancelled");
                    }
                    if (timeRemaining > 60000L) {
                        timeRemaining = 60000L;
                    } else if (timeRemaining <= 0L) {
                        timeRemaining = 10000L;
                    }
                    this.wait(timeRemaining);
                }
            }
        }
        finally {
            if (!this.writeSuccessful()) {
                this.releasePayload();
            }
        }
    }

    @Override
    public synchronized boolean writeAccepted() {
        return this._acceptedOn > 0L && this._cancelledOn <= 0L;
    }

    @Override
    public synchronized boolean writeFailed() {
        return this._cancelledOn > 0L;
    }

    @Override
    public synchronized boolean writeSuccessful() {
        return this._ackOn > 0L && this._cancelledOn <= 0L;
    }

    public void logTCPDump() {
        try {
            I2PSocketManagerFull.pcapWriter.write(this);
        }
        catch (IOException ioe) {
            this._log.warn("pcap write ioe: " + ioe);
        }
    }
}

