/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;
import org.apache.http.conn.util.InetAddressUtils;

public abstract class Addresses {
    private static final File IF_INET6_FILE;
    private static final long INET6_CACHE_EXPIRE = 600000L;
    private static final boolean INET6_CACHE_ENABLED;
    private static final int FLAG_PERMANENT = 128;
    private static final int FLAG_DEPRECATED = 32;
    private static final int FLAG_TEMPORARY = 1;
    private static long _ifCacheTime;
    private static final Map<Inet6Address, Inet6Addr> _ifCache;
    private static final Map<String, byte[]> _IPAddress;

    public static boolean isConnected() {
        return !Addresses.getAddresses(true, false, false).isEmpty();
    }

    public static String getAnyAddress() {
        SortedSet<String> a = Addresses.getAddresses();
        if (!a.isEmpty()) {
            return a.first();
        }
        return null;
    }

    public static SortedSet<String> getAddresses() {
        return Addresses.getAddresses(false, false);
    }

    public static SortedSet<String> getAllAddresses() {
        return Addresses.getAddresses(true, true);
    }

    public static SortedSet<String> getAddresses(boolean includeLocal, boolean includeIPv6) {
        return Addresses.getAddresses(includeLocal, includeLocal, includeIPv6);
    }

    public static SortedSet<String> getAddresses(boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        boolean haveIPv4 = false;
        boolean haveIPv6 = false;
        TreeSet<String> rv = new TreeSet<String>();
        boolean omitDeprecated = INET6_CACHE_ENABLED && !includeSiteLocal && includeIPv6;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (int i = 0; i < allMyIps.length; ++i) {
                    boolean isv4 = allMyIps[i] instanceof Inet4Address;
                    if (isv4) {
                        haveIPv4 = true;
                    } else {
                        haveIPv6 = true;
                    }
                    if (omitDeprecated && !isv4 && Addresses.isDeprecated((Inet6Address)allMyIps[i]) || !Addresses.shouldInclude(allMyIps[i], includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                    rv.add(Addresses.stripScope(allMyIps[i].getHostAddress()));
                }
            }
        }
        catch (UnknownHostException localhost) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            if (ifcs != null) {
                while (ifcs.hasMoreElements()) {
                    NetworkInterface ifc = ifcs.nextElement();
                    Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        boolean isv4 = addr instanceof Inet4Address;
                        if (isv4) {
                            haveIPv4 = true;
                        } else {
                            haveIPv6 = true;
                        }
                        if (omitDeprecated && !isv4 && Addresses.isDeprecated((Inet6Address)addr) || !Addresses.shouldInclude(addr, includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                        rv.add(Addresses.stripScope(addr.getHostAddress()));
                    }
                }
            }
        }
        catch (SocketException socketException) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (includeLoopbackAndWildcard) {
            if (haveIPv4) {
                rv.add("0.0.0.0");
            }
            if (includeIPv6 && haveIPv6) {
                rv.add("0:0:0:0:0:0:0:0");
            }
        }
        return rv;
    }

    private static String stripScope(String ip) {
        int pct = ip.indexOf(37);
        if (pct > 0) {
            ip = ip.substring(0, pct);
        }
        return ip;
    }

    private static boolean shouldInclude(InetAddress ia, boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        return !(ia.isLinkLocalAddress() || ia.isMulticastAddress() || !includeLoopbackAndWildcard && (ia.isAnyLocalAddress() || ia.isLoopbackAddress()) || !includeSiteLocal && (ia.isSiteLocalAddress() || ia.getAddress().length == 16 && (ia.getAddress()[0] & 0xFE) == 252) || !includeIPv6 && !(ia instanceof Inet4Address));
    }

    public static String toString(byte[] addr) {
        if (addr == null) {
            return "null";
        }
        try {
            return InetAddress.getByAddress(addr).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return "bad IP length " + addr.length;
        }
    }

    public static String toString(byte[] addr, int port) {
        if (addr == null) {
            return "null:" + port;
        }
        try {
            String ip = InetAddress.getByAddress(addr).getHostAddress();
            if (addr.length != 16) {
                return ip + ':' + port;
            }
            return '[' + ip + "]:" + port;
        }
        catch (UnknownHostException uhe) {
            return "(bad IP length " + addr.length + "):" + port;
        }
    }

    public static int getPort(String port) {
        int rv = 0;
        if (port != null) {
            try {
                int iport = Integer.parseInt(port);
                if (iport > 0 && iport <= 65535) {
                    rv = iport;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(String host) {
        byte[] rv;
        block10: {
            if (host == null) {
                return null;
            }
            Map<String, byte[]> map = _IPAddress;
            synchronized (map) {
                rv = _IPAddress.get(host);
            }
            if (rv == null) {
                try {
                    rv = InetAddress.getByName(host).getAddress();
                    if (!InetAddressUtils.isIPv4Address(host) && !InetAddressUtils.isIPv6Address(host)) break block10;
                    map = _IPAddress;
                    synchronized (map) {
                        _IPAddress.put(host, rv);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return rv;
    }

    public static byte[] getIP(String host, boolean preferIPv6) {
        if (host == null) {
            return null;
        }
        if (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host)) {
            return Addresses.getIP(host);
        }
        byte[] rv = null;
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            if (addrs == null || addrs.length == 0) {
                return null;
            }
            for (int i = 0; i < addrs.length; ++i) {
                rv = addrs[i].getAddress();
                if (!(preferIPv6 ? rv.length == 16 : rv.length == 4)) {
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return rv;
    }

    public static List<byte[]> getIPs(String host) {
        if (host == null) {
            return null;
        }
        if (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host)) {
            byte[] brv = Addresses.getIP(host);
            if (brv == null) {
                return null;
            }
            return Collections.singletonList(brv);
        }
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            if (addrs == null || addrs.length == 0) {
                return null;
            }
            ArrayList<byte[]> rv = new ArrayList<byte[]>(addrs.length);
            for (int i = 0; i < addrs.length; ++i) {
                rv.add(addrs[i].getAddress());
            }
            return rv;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshCache() {
        long now = System.currentTimeMillis();
        if (now - _ifCacheTime < 600000L) {
            return;
        }
        _ifCache.clear();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(IF_INET6_FILE), "ISO-8859-1"), 4096);
            String line = null;
            while ((line = in.readLine()) != null) {
                Inet6Address addr;
                String as;
                String[] parts = DataHelper.split(line, " ", 6);
                if (parts.length < 5 || (as = parts[0]).length() != 32) continue;
                StringBuilder buf = new StringBuilder(40);
                int i = 0;
                while (true) {
                    buf.append(as.substring(i, i + 4));
                    if ((i += 4) >= 32) break;
                    buf.append(':');
                }
                try {
                    addr = (Inet6Address)InetAddress.getByName(buf.toString());
                }
                catch (UnknownHostException uhe) {
                    continue;
                }
                int flags = 128;
                try {
                    flags = Integer.parseInt(parts[4], 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Inet6Addr a = new Inet6Addr(addr, flags);
                _ifCache.put(addr, a);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        _ifCacheTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDynamic(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            return false;
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeprecated(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            return false;
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isDeprecated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTemporary(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            return false;
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isTemporary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map = _IPAddress;
        synchronized (map) {
            _IPAddress.clear();
        }
        if (_ifCache != null) {
            map = _ifCache;
            synchronized (map) {
                _ifCache.clear();
                _ifCacheTime = 0L;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("External IPv4 Addresses:");
        SortedSet<String> a = Addresses.getAddresses(false, false, false);
        for (String s : a) {
            System.out.println(s);
        }
        System.out.println("\nExternal and Local IPv4 Addresses:");
        a = Addresses.getAddresses(true, false, false);
        for (String s : a) {
            System.out.println(s);
        }
        System.out.println("\nAll External Addresses:");
        a = Addresses.getAddresses(false, false, true);
        for (String s : a) {
            System.out.println(s);
        }
        System.out.println("\nAll External and Local Addresses:");
        a = Addresses.getAddresses(true, false, true);
        for (String s : a) {
            System.out.println(s);
        }
        System.out.println("\nAll addresses:");
        a = Addresses.getAddresses(true, true, true);
        for (String s : a) {
            System.out.println(s);
        }
        System.out.println("\nIPv6 address flags:");
        for (String s : a) {
            if (!s.contains(":")) continue;
            StringBuilder buf = new StringBuilder(64);
            buf.append(s);
            try {
                Inet6Address addr = (Inet6Address)InetAddress.getByName(buf.toString());
                if (addr.isSiteLocalAddress()) {
                    buf.append(" host");
                } else if (addr.isLinkLocalAddress()) {
                    buf.append(" link");
                } else if (addr.isAnyLocalAddress()) {
                    buf.append(" wildcard");
                } else if (addr.isLoopbackAddress()) {
                    buf.append(" loopback");
                } else {
                    buf.append(" global");
                }
                if (Addresses.isTemporary(addr)) {
                    buf.append(" temporary");
                }
                if (Addresses.isDeprecated(addr)) {
                    buf.append(" deprecated");
                }
                if (Addresses.isDynamic(addr)) {
                    buf.append(" dynamic");
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            System.out.println(buf.toString());
        }
        System.out.println("\nIs connected? " + Addresses.isConnected());
    }

    static {
        int size;
        IF_INET6_FILE = new File("/proc/net/if_inet6");
        INET6_CACHE_ENABLED = !SystemVersion.isMac() && !SystemVersion.isWindows() && !SystemVersion.isAndroid() && IF_INET6_FILE.exists();
        _ifCache = INET6_CACHE_ENABLED ? new HashMap(8) : null;
        I2PAppContext ctx = I2PAppContext.getCurrentContext();
        if (ctx != null && ctx.isRouterContext()) {
            long maxMemory = SystemVersion.getMaxMemory();
            long min = 256L;
            long max = 4096L;
            size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 131072L));
        } else {
            size = 32;
        }
        _IPAddress = new LHMCache<String, byte[]>(size);
    }

    private static class Inet6Addr {
        private final Inet6Address addr;
        private final boolean isDyn;
        private final boolean isDep;
        private final boolean isTemp;

        public Inet6Addr(Inet6Address a, int flags) {
            this.addr = a;
            this.isDyn = (flags & 0x80) == 0;
            this.isDep = (flags & 0x20) != 0;
            this.isTemp = (flags & 1) != 0;
        }

        public Inet6Address getAddress() {
            return this.addr;
        }

        public boolean isDynamic() {
            return this.isDyn;
        }

        public boolean isDeprecated() {
            return this.isDep;
        }

        public boolean isTemporary() {
            return this.isTemp;
        }
    }
}

