/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableColumn sortColumn;
    TableItem currentItem;
    NSTableHeaderView headerView;
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    int columnCount;
    int itemCount;
    int lastIndexOf;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreSelect;
    boolean fixScrollWidth;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    boolean acceptsFirstResponder(long l, long l2) {
        return true;
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        long l4;
        long l5 = 0L;
        NSString nSString = new NSString(l3);
        if ((nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute) || nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (l4 = super.accessibilityAttributeValue(l, l2, l3)) != 0L) {
            NSArray nSArray = new NSArray(l4);
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() - 1L);
            nSMutableArray.addObjectsFromArray(nSArray);
            nSMutableArray.removeObjectAtIndex(0L);
            l5 = nSMutableArray.id;
        }
        if (l5 != 0L) {
            return l5;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        this.clearCachedWidth(this.items);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, -1, false);
        return this.items[n];
    }

    int calculateWidth(TableItem[] tableItemArray, int n, GC gC) {
        int n2 = 0;
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = tableItemArray[i];
            if (tableItem == null || !tableItem.cached) continue;
            n2 = Math.max(n2, tableItem.calculateWidth(n, gC, this.isSelected(n)));
        }
        return n2;
    }

    NSSize cellSize(long l, long l2) {
        NSSize nSSize = super.cellSize(l, l2);
        NSCell nSCell = new NSCell(l);
        NSImage nSImage = nSCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] lArray = new long[1];
            OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
            long l3 = lArray[0];
            TableItem tableItem = this._getItem((int)l3);
            OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
            long l4 = lArray[0];
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].nsColumn.id != l4) continue;
                n = i;
                break;
            }
            this.sendMeasureItem(tableItem, n, nSSize, nSCell.isHighlighted());
        }
        return nSSize;
    }

    boolean canDragRowsWithIndexes_atPoint(long l, long l2, long l3, NSPoint nSPoint) {
        boolean bl;
        if (!super.canDragRowsWithIndexes_atPoint(l, l2, l3, nSPoint)) {
            return false;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        long l4 = nSTableView.rowAtPoint(nSPoint);
        long l5 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl2 = bl = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl && !nSTableView.isRowSelected(l4) && (l5 & 0x1A0000L) == 0L) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l4);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSTableView.isRowSelected(l4) && bl || !this.hasFocus();
    }

    boolean checkData(TableItem tableItem) {
        return this.checkData(tableItem, this.indexOf(tableItem));
    }

    boolean checkData(TableItem tableItem, int n) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(tableItem)) {
                tableItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            if (this.currentItem != tableItem) {
                tableItem.clear();
            }
            if (this.currentItem == null) {
                tableItem.redraw(-1);
            }
            this.setScrollWidth(tableItem);
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            for (int i = n; i <= n2; ++i) {
                this.clear(i);
            }
        }
    }

    public void clear(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (0 <= nArray[n] && nArray[n] < this.itemCount) continue;
            this.error(6);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.clear(nArray[n]);
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null) continue;
            tableItem.clear();
        }
        if (this.currentItem == null && this.isDrawing()) {
            this.view.setNeedsDisplay(true);
        }
        this.setScrollWidth(this.items, true);
    }

    void clearCachedWidth(TableItem[] tableItemArray) {
        if (tableItemArray == null) {
            return;
        }
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (tableItemArray[i] == null) continue;
            tableItemArray[i].width = -1;
        }
    }

    long columnAtPoint(long l, long l2, NSPoint nSPoint) {
        if ((this.style & 0x20) != 0 && nSPoint.x <= (double)this.getCheckColumnWidth() && nSPoint.y < this.headerView.frame().height) {
            return 1L;
        }
        return super.columnAtPoint(l, l2, nSPoint);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                for (n3 = 0; n3 < this.columnCount; ++n3) {
                    n4 += this.columns[n3].getWidth();
                }
            } else {
                GC gC = new GC(this);
                n4 += this.calculateWidth(this.items, 0, gC) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n4 += this.getCheckColumnWidth();
            }
        } else {
            n4 = n;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        n3 = 0;
        n3 = n2 == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n3);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TableItem tableItem, int n) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray = tableItem.strings;
        if (stringArray != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n);
            System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
            objectArray[n] = "";
            tableItem.strings = objectArray;
        }
        if (n == 0) {
            tableItem.text = "";
        }
        if ((objectArray = tableItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n);
            System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
            tableItem.images = resourceArray2;
        }
        if (n == 0) {
            tableItem.image = null;
        }
        if ((resourceArray2 = tableItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n);
            System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
            tableItem.cellBackground = colorArray;
        }
        if ((colorArray = tableItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n);
            System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
            tableItem.cellForeground = resourceArray;
        }
        if ((resourceArray = tableItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n);
            System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
            tableItem.cellFont = fontArray;
        }
    }

    void createHandle() {
        NSString nSString;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2L : 0L);
        NSTableView nSTableView = (NSTableView)new SWTTableView().alloc();
        nSTableView.init();
        nSTableView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSTableView.setDataSource(nSTableView);
        nSTableView.setDelegate(nSTableView);
        nSTableView.setColumnAutoresizingStyle(0L);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSTableView.setIntercellSpacing(nSSize);
        nSTableView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSTableView.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSTableView.setHeaderView(null);
        NSString nSString2 = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nSString);
            nSString.release();
            this.checkColumn.headerCell().setTitle(nSString2);
            nSTableView.addTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long l = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(l, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setControlSize(1L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nSString);
        nSString.release();
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.setResizingMask(0L);
        this.firstColumn.headerCell().setTitle(nSString2);
        nSTableView.addTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4L);
        this.firstColumn.setDataCell(this.dataCell);
        nSTableView.setHighlightedTableColumn(null);
        this.scrollView = nSScrollView;
        this.view = nSTableView;
    }

    void createItem(TableColumn tableColumn, int n) {
        int n2;
        NSObject nSObject;
        Object object;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == this.columns.length) {
            object = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object, 0, this.columns.length);
            this.columns = object;
        }
        if (this.columnCount == 0) {
            object = this.firstColumn;
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableColumn)object).setResizingMask(2L);
            this.firstColumn = null;
        } else {
            object = (NSTableColumn)new NSTableColumn().alloc();
            nSObject = (NSString)new NSString().alloc();
            nSObject = ((NSString)nSObject).initWithString(String.valueOf(++NEXT_ID));
            object = ((NSTableColumn)object).initWithIdentifier((NSString)nSObject);
            nSObject.release();
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableView)this.view).addTableColumn((NSTableColumn)object);
            n2 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)this.view).moveColumn(this.columnCount + n2, n + n2);
            ((NSTableColumn)object).setDataCell(this.dataCell);
        }
        tableColumn.createJNIRef();
        nSObject = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object).setHeaderCell((NSCell)nSObject);
        this.display.addWidget(nSObject, tableColumn);
        tableColumn.nsColumn = object;
        ((NSTableColumn)object).setWidth(0.0);
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        for (n2 = 0; n2 < this.itemCount; ++n2) {
            TableItem tableItem = this.items[n2];
            if (tableItem == null || this.columnCount <= 1) continue;
            this.createColumn(tableItem, n);
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.getDrawing() ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
        this.updateRowCount();
        if (n != this.itemCount) {
            this.fixSelection(n, true);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    void deselectAll(long l, long l2, long l3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1L) {
            return;
        }
        super.deselectAll(l, l2, l3);
    }

    void deselectRow(long l, long l2, long l3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == l3) {
            return;
        }
        super.deselectRow(l, l2, l3);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (0 <= n && n < this.itemCount) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.deselectRow(n);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n2 < 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(this.itemCount - 1, n2);
        if (n == 0 && n2 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            for (int i = n; i <= n2; ++i) {
                nSTableView.deselectRow(i);
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        for (int i = 0; i < nArray.length; ++i) {
            nSTableView.deselectRow(nArray[i]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.deselectAll(null);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object object;
        int n;
        int n2;
        for (n2 = 0; n2 < this.columnCount && this.columns[n2] != tableColumn; ++n2) {
        }
        for (n = 0; n < this.itemCount; ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            object = this.items[n];
            if (object == null) continue;
            if (this.columnCount <= 1) {
                ((TableItem)object).strings = null;
                ((TableItem)object).images = null;
                ((TableItem)object).cellBackground = null;
                ((TableItem)object).cellForeground = null;
                ((TableItem)object).cellFont = null;
                continue;
            }
            if (((TableItem)object).strings != null) {
                objectArray2 = ((TableItem)object).strings;
                if (n2 == 0) {
                    ((TableItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                }
                objectArray = new String[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TableItem)object).strings = objectArray;
            } else if (n2 == 0) {
                ((TableItem)object).text = "";
            }
            if (((TableItem)object).images != null) {
                objectArray2 = ((TableItem)object).images;
                if (n2 == 0) {
                    ((TableItem)object).image = objectArray2[1];
                }
                objectArray = new Image[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TableItem)object).images = objectArray;
            } else if (n2 == 0) {
                ((TableItem)object).image = null;
            }
            if (((TableItem)object).cellBackground != null) {
                objectArray2 = ((TableItem)object).cellBackground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TableItem)object).cellBackground = objectArray;
            }
            if (((TableItem)object).cellForeground != null) {
                objectArray2 = ((TableItem)object).cellForeground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TableItem)object).cellForeground = objectArray;
            }
            if (((TableItem)object).cellFont == null) continue;
            objectArray2 = ((TableItem)object).cellFont;
            objectArray = new Font[this.columnCount - 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n2);
            System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
            ((TableItem)object).cellFont = objectArray;
        }
        n = this.indexOf(tableColumn.nsColumn);
        System.arraycopy(this.columns, n2 + 1, this.columns, n2, --this.columnCount - n2);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = tableColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.firstColumn.setResizingMask(0L);
            this.setScrollWidth();
        } else {
            ((NSTableView)this.view).removeTableColumn(tableColumn.nsColumn);
        }
        object = ((NSTableView)this.view).tableColumns();
        int n3 = (int)((NSArray)object).count();
        block2: for (int i = n; i < n3; ++i) {
            long l = ((NSArray)object).objectAtIndex((long)((long)i)).id;
            for (int j = 0; j < this.columnCount; ++j) {
                if (this.columns[j].nsColumn.id != l) continue;
                this.columns[j].sendEvent(10);
                continue block2;
            }
        }
    }

    void destroyItem(TableItem tableItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != tableItem; ++n) {
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return false;
    }

    void drawBackgroundInClipRect(long l, long l2, NSRect nSRect) {
        super.drawViewBackgroundInRect(l, l2, nSRect);
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        Color color;
        boolean bl2 = this.hooks(40);
        boolean bl3 = this.hooks(42);
        boolean bl4 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l);
        NSTableView nSTableView = (NSTableView)this.view;
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
        long l4 = lArray[0];
        TableItem tableItem = this._getItem((int)l4);
        OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
        long l5 = lArray[0];
        long l6 = nSTableView.tableColumns().indexOfObjectIdenticalTo(new id(l5));
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l5) continue;
            n = i;
            break;
        }
        Color color2 = color = tableItem.cellBackground != null ? tableItem.cellBackground[n] : null;
        if (color == null) {
            color = tableItem.background;
        }
        boolean bl5 = color != null;
        boolean bl6 = true;
        boolean bl7 = bl = nSTextFieldCell.isHighlighted();
        boolean bl8 = this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl && (bl2 || bl3)) {
            color4 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(l, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n3 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSTableView.rectOfColumn(l6);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSTableView.rectOfRow(l4);
            nSRect2.width = nSRect3.width;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl3 || bl2) {
            NSRect nSRect4 = nSTableView.frameOfCellAtColumn(l6, l4);
            d = nSRect.x - nSRect4.x;
            d2 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                d -= 0.5;
                d2 -= 0.5;
            }
        }
        int n4 = (int)(nSRect.x - d);
        int n5 = (int)(nSRect.y - d2);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl4) {
            this.sendMeasureItem(tableItem, n, nSSize, bl);
        }
        Color color5 = null;
        if (bl2) {
            nSGraphicsContext.saveGraphicsState();
            object4 = NSAffineTransform.transform();
            ((NSAffineTransform)object4).translateXBy(d, d2);
            ((NSAffineTransform)object4).concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n));
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                object = color4;
                ((GC)object2).setBackground(color3);
            } else {
                object = tableItem.getForeground(n);
                ((GC)object2).setBackground(tableItem.getBackground(n));
            }
            ((GC)object2).setForeground((Color)object);
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            Event event = new Event();
            event.item = tableItem;
            event.gc = object2;
            event.index = n;
            event.detail = 16;
            if (bl5) {
                event.detail |= 8;
            }
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                event.detail |= 2;
            }
            event.x = (int)nSRect2.x;
            event.y = (int)nSRect2.y;
            event.width = (int)nSRect2.width;
            event.height = (int)nSRect2.height;
            this.sendEvent(40, event);
            if (!event.doit) {
                bl7 = false;
                bl5 = false;
                bl6 = false;
            } else {
                bl5 = bl5 && (event.detail & 8) != 0;
                bl6 = (event.detail & 0x10) != 0;
                boolean bl9 = bl7 = bl7 && (event.detail & 2) != 0;
            }
            if (!bl7 && bl) {
                color5 = Color.cocoa_new(this.display, ((GC)object2).getForeground().handle);
            }
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (tableItem.isDisposed()) {
                return;
            }
            if (bl7) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSTableView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        } else if (bl && (this.style & 0x8000) != 0 && !bl8) {
            color5 = tableItem.getForeground(n);
        }
        if (bl5 && !bl7) {
            nSGraphicsContext.saveGraphicsState();
            object4 = color.handle;
            object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], 1.0);
            ((NSColor)object3).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl6) {
            if ((!this.drawExpansion || bl4) && nSImage != null) {
                object4 = new NSRect();
                ((NSRect)object4).x = nSRect.x + 3.0;
                ((NSRect)object4).y = nSRect.y + (double)((float)Math.ceil((nSRect.height - (double)this.imageBounds.height) / 2.0));
                ((NSRect)object4).width = this.imageBounds.width;
                ((NSRect)object4).height = this.imageBounds.height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object3 = NSAffineTransform.transform();
                ((NSAffineTransform)object3).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object3).translateXBy(0.0, -(((NSRect)object4).height + 2.0 * ((NSRect)object4).y));
                ((NSAffineTransform)object3).concat();
                nSImage.drawInRect((NSRect)object4, new NSRect(), 2L, 1.0);
                nSGraphicsContext.restoreGraphicsState();
                int n6 = this.imageBounds.width + 3;
                nSRect.x += (double)n6;
                nSRect.width -= (double)n6;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl10 = false;
            if (color5 != null) {
                object3 = color5.handle;
                if (object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0) {
                    object2 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object = new NSRange();
                    ((NSRange)object).length = ((NSAttributedString)object2).length();
                    ((NSMutableAttributedString)object2).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object);
                    int n7 = this.columnCount == 0 ? 16384 : this.columns[n].style & 0x1024000;
                    NSSize nSSize3 = ((NSAttributedString)object2).size();
                    NSRect nSRect5 = new NSRect();
                    nSRect5.x = nSRect.x + 2.0;
                    nSRect5.y = nSRect.y;
                    nSRect5.width = nSRect.width - 2.0;
                    switch (n7) {
                        case 0x1000000: {
                            nSRect5.width -= 2.0;
                            break;
                        }
                        case 131072: {
                            if (!(nSRect.width > nSSize3.width)) break;
                            nSRect5.width -= 2.0;
                        }
                    }
                    nSRect5.height = nSRect.height;
                    if (nSRect5.height > nSSize3.height) {
                        nSRect5.y += (nSRect5.height - nSSize3.height) / 2.0;
                        nSRect5.height = nSSize3.height;
                    }
                    ((NSAttributedString)object2).drawInRect(nSRect5);
                    ((NSObject)object2).release();
                } else {
                    object2 = NSColor.colorWithDeviceRed((double)object3[0], (double)object3[1], (double)object3[2], (double)object3[3]);
                    nSTextFieldCell.setTextColor((NSColor)object2);
                    bl10 = true;
                }
            } else {
                bl10 = true;
            }
            if (bl10) {
                object3 = nSTextFieldCell.attributedStringValue();
                object2 = ((NSAttributedString)object3).size();
                if (nSRect.height > ((NSSize)object2).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object2).height) / 2.0;
                    nSRect.height = ((NSSize)object2).height;
                }
                super.drawInteriorWithFrame_inView(l, l2, nSRect, l3);
            }
        }
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(d, d2);
            nSAffineTransform.concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n));
            if (bl7) {
                ((GC)object2).setForeground(color4);
                ((GC)object2).setBackground(color3);
            } else {
                ((GC)object2).setForeground(color5 != null ? color5 : tableItem.getForeground(n));
                ((GC)object2).setBackground(tableItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).gc = object2;
            ((Event)object).index = n;
            if (bl6) {
                ((Event)object).detail |= 0x10;
            }
            if (bl5) {
                ((Event)object).detail |= 8;
            }
            if (bl) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = n4;
            ((Event)object).y = n5;
            ((Event)object).width = n2;
            ((Event)object).height = n3;
            this.sendEvent(42, (Event)object);
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    void drawWithExpansionFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(l, l2, nSRect, l3);
        this.drawExpansion = false;
    }

    void drawRect(long l, long l2, NSRect nSRect) {
        this.fixScrollWidth = false;
        super.drawRect(l, l2, nSRect);
        if (this.isDisposed()) {
            return;
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.view.setNeedsDisplay(true);
            }
        }
    }

    NSRect expansionFrameWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        if (this.toolTipText == null) {
            NSRect nSRect2;
            NSRect nSRect3 = super.expansionFrameWithFrame_inView(l, l2, nSRect, l3);
            NSCell nSCell = new NSCell(l);
            NSAttributedString nSAttributedString = nSCell.attributedStringValue();
            NSSize nSSize = nSAttributedString.size();
            if (nSRect3.width != 0.0 && nSRect3.height != 0.0) {
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    NSSize nSSize2 = nSCell.cellSize();
                    nSRect2.width = nSSize2.width;
                } else {
                    nSRect2 = nSRect3;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                }
            } else {
                Object object;
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    object = nSCell.cellSize();
                    nSRect2.width = ((NSSize)object).width;
                } else {
                    nSRect2 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(l, OS.sel_cellSize);
                    nSRect2.width = ((NSSize)object).width;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                } else {
                    object = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect((NSRect)object, nSRect2, (NSRect)object);
                    if (OS.NSEqualRects(nSRect2, (NSRect)object)) {
                        return new NSRect();
                    }
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    Widget findTooltip(NSPoint nSPoint) {
        long l;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (l = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1L) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(l);
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn tableColumn = this.columns[i];
                if (tableColumn.nsColumn.id != id2.id) continue;
                return tableColumn;
            }
        }
        return super.findTooltip(nSPoint);
    }

    void fixSelection(int n, boolean bl) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (!bl && nArray[i] == n) {
                bl2 = true;
                continue;
            }
            int n3 = n2++;
            nArray[n3] = nArray[i];
            if (nArray[n3] < n) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] + (bl ? 1 : -1);
            bl2 = true;
        }
        if (bl2) {
            this.select(nArray, n2, true);
        }
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    public Rectangle getClientArea() {
        NSTableHeaderView nSTableHeaderView;
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        if (OS.VERSION_MMB < OS.VERSION_MMB(10, 11, 0) && (nSTableHeaderView = ((NSTableView)this.view).headerView()) != null) {
            int n = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    TableColumn getColumn(id id2) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i];
        }
        return null;
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            int n2 = this.indexOf(tableColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n2;
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).headerView() != null;
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n = (int)nSTableView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight() + 1;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.itemCount; ++i) {
                tableItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new TableItem[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        TableItem[] tableItemArray = new TableItem[n];
        for (int i = 0; i < n; ++i) {
            tableItemArray[i] = this._getItem((int)lArray[i]);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        return (int)lArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        int[] nArray = new int[n];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        int n;
        NSTableHeaderView nSTableHeaderView;
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && (nSTableHeaderView = ((NSTableView)this.view).headerView()) != null) {
            int n2 = (int)nSTableHeaderView.bounds().height;
            nSPoint.y += (double)n2;
        }
        if ((n = (int)((NSTableView)this.view).rowAtPoint(nSPoint)) == -1) {
            return 0;
        }
        return n;
    }

    NSRect headerRectOfColumn(long l, long l2, long l3) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(l, l2, l3);
        }
        if (l3 == 0L) {
            NSRect nSRect = this.callSuperRect(l, l2, l3);
            nSRect.width = 0.0;
            return nSRect;
        }
        if (l3 == 1L) {
            NSRect nSRect = this.callSuperRect(l, l2, l3);
            nSRect.width += this.checkColumn.width() + 1.0;
            nSRect.x -= this.checkColumn.width() + 1.0;
            return nSRect;
        }
        return this.callSuperRect(l, l2, l3);
    }

    void highlightSelectionInClipRect(long l, long l2, long l3) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
        this.callSuper(l, l2, nSRect);
    }

    long hitTestForEvent(long l, long l2, long l3, NSRect nSRect, long l4) {
        return this.callSuper(l, l2, l3, nSRect, l4);
    }

    long image(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_IMAGE, lArray);
        return lArray[0];
    }

    NSRect imageRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSRect.x += 3.0;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != tableColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        } else {
            for (int i = this.itemCount - 1; i >= 0; --i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(n);
    }

    boolean isTransparent() {
        return true;
    }

    void keyDown(long l, long l2, long l3) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(l, l2, l3);
    }

    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    long menuForEvent(long l, long l2, long l3) {
        if (l != this.headerView.id) {
            NSPoint nSPoint;
            long l4;
            NSEvent nSEvent = new NSEvent(l3);
            NSTableView nSTableView = (NSTableView)this.view;
            NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(l4 = nSTableView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(l4);
                nSTableView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(l, l2, l3);
    }

    void mouseDown(long l, long l2, long l3) {
        NSEvent nSEvent;
        if (l == this.view.id && ((nSEvent = new NSEvent(l3)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(l, l2, l3);
    }

    void mouseDownSuper(long l, long l2, long l3) {
        NSRect nSRect;
        int n;
        NSCell nSCell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean bl = false;
        NSTableView nSTableView = (NSTableView)this.view;
        NSEvent nSEvent = new NSEvent(l3);
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n2 = (int)nSTableView.rowAtPoint(nSPoint);
        if (n2 != -1 && (this.style & 0x20) != 0 && (nSCell = nSTableView.preparedCellAtColumn(n = (int)nSTableView.columnAtPoint(nSPoint), n2)) != null && nSCell.isKindOfClass(OS.class_NSButtonCell) && nSCell.isEnabled() && OS.NSPointInRect(nSPoint, nSRect = nSCell.imageRectForBounds(nSTableView.frameOfCellAtColumn(n, n2)))) {
            this.preventSelect = true;
            bl = true;
        }
        if (!bl && n2 != -1 && (nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1L && nSTableView.isRowSelected(n2) && 0 <= n2 && n2 < this.itemCount) {
            this.selectedRowIndex = n2;
        }
        this.didSelect = false;
        super.mouseDownSuper(l, l2, l3);
        this.didSelect = false;
    }

    boolean needsPanelToBecomeKey(long l, long l2) {
        return false;
    }

    long nextState(long l, long l2) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.clickedRow();
        if (n == -1) {
            n = (int)nSTableView.selectedRow();
        }
        TableItem tableItem = this.items[n];
        if (tableItem.grayed) {
            return tableItem.checked ? 0L : -1L;
        }
        return tableItem.checked ? 0L : 1L;
    }

    long numberOfRowsInTableView(long l, long l2, long l3) {
        return this.itemCount;
    }

    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.itemCount; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
    }

    public void remove(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.release(false);
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.removeAll();
        } else {
            int n3 = n2 - n + 1;
            for (int i = n; i < n3; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                tableItem.release(false);
            }
            int[] nArray = this.getSelectionIndices();
            if (nArray.length != 0) {
                int n4 = 0;
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= n && nArray[i] <= n2) {
                        bl = true;
                        continue;
                    }
                    int n5 = n4++;
                    nArray[n5] = nArray[i];
                    if (nArray[n5] <= n2) continue;
                    int n6 = n5;
                    nArray[n6] = nArray[n6] - n3;
                    bl = true;
                }
                if (bl) {
                    this.select(nArray, n4, true);
                }
            }
            System.arraycopy(this.items, n + n3, this.items, n, this.itemCount - (n + n3));
            for (int i = this.itemCount; i < this.items.length; ++i) {
                this.items[i] = null;
            }
            this.itemCount -= n3;
            this.updateRowCount();
        }
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray2[i];
            if (n4 == n3) continue;
            TableItem tableItem = this.items[n4];
            if (tableItem != null) {
                tableItem.release(false);
            }
            if (n4 != this.itemCount - 1) {
                this.fixSelection(n4, false);
            }
            System.arraycopy(this.items, n4 + 1, this.items, n4, --this.itemCount - n4);
            this.items[this.itemCount] = null;
            n3 = n4;
        }
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.setTableEmpty();
        this.updateRowCount();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskin(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                item = this.columns[n2];
                if (item.isDisposed()) continue;
                item.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    void scrollClipViewToPoint(long l, long l2, long l3, NSPoint nSPoint) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(l, l2, l3, nSPoint);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSTableView)this.view).headerView() != null && nSPoint.x <= (double)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1L));
            }
        }
    }

    public void select(int n) {
        this.checkWidget();
        if (0 <= n && n < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n = Math.max(0, n);
            n2 = Math.min(n2, this.itemCount - 1);
            NSRange nSRange = new NSRange();
            nSRange.location = n;
            nSRange.length = n2 - n + 1;
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= this.itemCount) continue;
            nSMutableIndexSet.addIndex(nArray[i]);
            ++n2;
        }
        if (n2 > 0) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSMutableIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        nSMutableIndexSet.release();
    }

    void select(int[] nArray, int n, boolean bl) {
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < n; ++i) {
            nSMutableIndexSet.addIndex(nArray[i]);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSMutableIndexSet, !bl);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectAll(null);
        this.ignoreSelect = false;
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (nArray[i] == nArray2[i]) continue;
            bl = true;
        }
        if (bl) {
            TableColumn tableColumn;
            int n;
            int n2;
            NSTableView nSTableView = (NSTableView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n3 = (this.style & 0x20) != 0 ? 1 : 0;
            for (int i = 0; i < nArray2.length; ++i) {
                n2 = nArray2[i];
                nArray3[n2] = (int)nSTableView.rectOfColumn((long)((long)(i + n3))).x;
            }
            int[] nArray4 = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                tableColumn = this.columns[n];
                int n4 = this.indexOf(tableColumn.nsColumn);
                int n5 = n2 + n3;
                nSTableView.moveColumn(n4, n5);
                nArray4[n] = (int)nSTableView.rectOfColumn((long)((long)n5)).x;
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            for (n = 0; n < this.columnCount; ++n) {
                tableColumn = tableColumnArray[n];
                if (tableColumn.isDisposed() || nArray4[n] == nArray3[n]) continue;
                tableColumn.sendEvent(10);
            }
        }
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth(this.items, true);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((NSTableView)this.view).setHeaderView(bl ? this.headerView : null);
        this.scrollView.tile();
    }

    void setImage(long l, long l2, long l3) {
        OS.object_setInstanceVariable(l, Display.SWT_IMAGE, l3);
    }

    public void setItemCount(int n) {
        TableItem[] tableItemArray;
        int n2;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        TableItem[] tableItemArray2 = this.items;
        if (n < this.itemCount) {
            for (n2 = n; n2 < this.itemCount; ++n2) {
                tableItemArray = tableItemArray2[n2];
                if (tableItemArray == null || tableItemArray.isDisposed()) continue;
                tableItemArray.release(false);
            }
        }
        if (n > this.itemCount && (this.getStyle() & 0x10000000) == 0) {
            for (n2 = this.itemCount; n2 < n; ++n2) {
                new TableItem(this, 0, n2, true);
            }
            return;
        }
        n2 = Math.max(4, (n + 3) / 4 * 4);
        tableItemArray = new TableItem[n2];
        if (tableItemArray2 != null) {
            System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n, this.itemCount));
        }
        tableItemArray2 = tableItemArray;
        this.items = tableItemArray;
        this.itemCount = n;
        this.updateRowCount();
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n != -1) {
            ((NSTableView)this.view).setRowHeight(n);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        double d = nSFont.ascender();
        double d2 = -nSFont.descender() + nSFont.leading();
        int n = (int)Math.ceil(d + d2) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n = Math.max(n, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl || nSTableView.rowHeight() < (double)n) {
            nSTableView.setRowHeight(n);
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
                this.items = tableItemArray;
            }
            this.setScrollWidth();
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((NSTableView)this.view).setUsesAlternatingRowBackgroundColors(bl);
        ((NSTableView)this.view).setGridStyleMask(bl ? 1L : 0L);
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(this.items, true);
    }

    boolean setScrollWidth(TableItem tableItem) {
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        GC gC = new GC(this);
        int n = tableItem.calculateWidth(0, gC, this.isSelected(this.indexOf(tableItem)));
        gC.dispose();
        int n2 = (int)this.firstColumn.width();
        if (n2 < n) {
            this.firstColumn.setWidth(n);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] tableItemArray, boolean bl) {
        int n;
        if (tableItemArray == null) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        GC gC = new GC(this);
        int n2 = 0;
        for (n = 0; n < tableItemArray.length; ++n) {
            TableItem tableItem = tableItemArray[n];
            if (tableItem == null) continue;
            n2 = Math.max(n2, tableItem.calculateWidth(0, gC, this.isSelected(this.indexOf(tableItem))));
        }
        gC.dispose();
        if (!bl && (n = (int)this.firstColumn.width()) >= n2) {
            return false;
        }
        this.firstColumn.setWidth(n2);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        if (0 <= n && n < this.itemCount) {
            this.select(n);
            this.showIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.select(n, n2);
        this.showIndex(n);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray);
        this.showIndex(nArray[0]);
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.indexOf(tableItemArray[n - i - 1]);
            if (n3 == -1) continue;
            nArray[n2++] = n3;
        }
        if (n2 > 0) {
            this.select(nArray);
            this.showIndex(nArray[0]);
        }
    }

    void setShouldScrollClipView(long l, long l2, boolean bl) {
        this.shouldScroll = bl;
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn == this.sortColumn) {
            return;
        }
        this.setSort(tableColumn, this.sortDirection);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, n);
    }

    void setSort(TableColumn tableColumn, int n) {
        NSImage nSImage = null;
        NSTableColumn nSTableColumn = null;
        if (tableColumn != null) {
            nSTableColumn = tableColumn.nsColumn;
            if (n == 1024) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (n == 128) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != tableColumn) {
            nSTableView.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        nSTableView.setHighlightedTableColumn(nSTableColumn);
        nSTableView.setIndicatorImage(nSImage, nSTableColumn);
        this.sortDirection = n;
        this.sortColumn = tableColumn;
    }

    void setTableEmpty() {
        this.itemCount = 0;
        this.items = new TableItem[4];
        this.imageBounds = null;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = Math.max(0, Math.min(n, this.itemCount));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSTableView.frameOfCellAtColumn((long)0L, (long)((long)n2)).y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && nSTableView.headerView() != null) {
            NSRect nSRect = this.headerView.frame();
            nSPoint.y -= nSRect.y + nSRect.height;
        }
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n = this.indexOf(tableColumn.nsColumn);
        if (0 > n || n >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSTableView)this.view).scrollColumnToVisible(n);
    }

    void showIndex(int n) {
        if (0 <= n && n < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(n);
        }
    }

    public void showItem(TableItem tableItem) {
        int n;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n = this.indexOf(tableItem)) != -1) {
            this.showIndex(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n >= 0) {
            this.checkData(this._getItem(n));
            this.showIndex(n);
        }
    }

    void selectRowIndexes_byExtendingSelection(long l, long l2, long l3, boolean bl) {
        NSIndexSet nSIndexSet;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (nSIndexSet = new NSIndexSet(l3)).count() == 0L) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(l, l2, l3, bl);
    }

    void sendDoubleSelection() {
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.clickedRow();
        if (n == -1) {
            n = (int)nSTableView.selectedRow();
        }
        if (n != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSTableView.tableColumns();
                int n2 = (int)nSTableView.clickedColumn();
                if (n2 != -1) {
                    id id2 = ((NSArray)object).objectAtIndex(n2);
                    if (id2.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            object = new Event();
            ((Event)object).item = this._getItem(n);
            this.sendSelectionEvent(14, (Event)object, false);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return bl;
    }

    void sendMeasureItem(TableItem tableItem, int n, NSSize nSSize, boolean bl) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n3 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSTableView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(tableItem.getFont(n));
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n;
        event.width = n2;
        event.height = n3;
        if (bl && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n3 < event.height) {
                nSTableView.setRowHeight(event.height);
            }
            if (n2 != event.width && this.columnCount == 0 && n == 0) {
                tableItem.width = event.width;
                if (this.setScrollWidth(tableItem)) {
                    nSTableView.setNeedsDisplay(true);
                }
            }
        }
    }

    void tableViewColumnDidMove(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSOldColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSNewColumn");
        id id3 = nSDictionary.valueForKey(nSString);
        nSString.release();
        int n = new NSNumber(id2).intValue();
        int n2 = new NSNumber(id3).intValue();
        NSTableView nSTableView = (NSTableView)this.view;
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        NSArray nSArray = nSTableView.tableColumns();
        for (int i = n3; i <= n4; ++i) {
            id id4 = nSArray.objectAtIndex(i);
            TableColumn tableColumn = this.getColumn(id4);
            if (tableColumn == null) continue;
            tableColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
        this.headerView.setNeedsDisplay(true);
    }

    void tableViewColumnDidResize(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSTableColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        TableColumn tableColumn = this.getColumn(id2);
        if (tableColumn == null) {
            return;
        }
        tableColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n = this.indexOf(tableColumn.nsColumn);
        if (n == -1) {
            return;
        }
        NSArray nSArray = nSTableView.tableColumns();
        int n2 = (int)nSTableView.numberOfColumns();
        for (int i = n + 1; i < n2; ++i) {
            id2 = nSArray.objectAtIndex(i);
            tableColumn = this.getColumn(id2);
            if (tableColumn == null) continue;
            tableColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
    }

    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.selectedRow();
        if (n == -1) {
            this.sendSelectionEvent(13);
        } else {
            TableItem tableItem = this._getItem(n);
            Event event = new Event();
            event.item = tableItem;
            event.index = n;
            this.sendSelectionEvent(13, event, false);
        }
    }

    void tableViewSelectionDidChange(long l, long l2, long l3) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    void tableViewSelectionIsChanging(long l, long l2, long l3) {
        this.didSelect = true;
        this.sendSelection();
    }

    void tableView_didClickTableColumn(long l, long l2, long l3, long l4) {
        TableColumn tableColumn = this.getColumn(new id(l4));
        if (tableColumn == null) {
            return;
        }
        tableColumn.sendSelectionEvent(13);
    }

    long tableView_objectValueForTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        int n = (int)l5;
        TableItem tableItem = this._getItem(n);
        this.checkData(tableItem, n);
        if (this.checkColumn != null && l4 == this.checkColumn.id) {
            NSNumber nSNumber = tableItem.checked && tableItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(tableItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l4) continue;
            return tableItem.createString((int)i).id;
        }
        return tableItem.createString((int)0).id;
    }

    boolean tableView_shouldReorderColumn_toColumn(long l, long l2, long l3, long l4, long l5) {
        if ((this.style & 0x20) != 0) {
            if (l4 == 0L) {
                return false;
            }
            if (l5 == 0L) {
                return false;
            }
        }
        NSTableView nSTableView = new NSTableView(l3);
        id id2 = nSTableView.tableColumns().objectAtIndex(l4);
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i].movable;
        }
        return true;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        if ((this.style & 0x20) != 0 && new NSCell(l4).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        return nSTableView.isRowSelected(l6);
    }

    void tableView_setObjectValue_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            TableItem tableItem = this.items[(int)l6];
            tableItem.checked = !tableItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            event.index = (int)l6;
            this.sendSelectionEvent(13, event, false);
            tableItem.redraw(-1);
        }
    }

    void tableView_willDisplayCell_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            return;
        }
        TableItem tableItem = this.items[(int)l6];
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l5) continue;
            n = i;
            break;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l4);
        OS.object_setInstanceVariable(l4, Display.SWT_ROW, l6);
        OS.object_setInstanceVariable(l4, Display.SWT_COLUMN, l5);
        Image image = n == 0 ? tableItem.image : (tableItem.images == null ? null : tableItem.images[n]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = tableItem.cellForeground != null ? tableItem.cellForeground[n] : null;
                if (color == null) {
                    color = tableItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n2 = (this.style & 0x4000000) != 0 ? 1 : 0;
        int n3 = 0;
        if (this.columnCount > 0) {
            int n4 = this.columns[n].style;
            if ((n4 & 0x1000000) != 0) {
                n3 = 2;
            } else if ((n4 & 0x20000) != 0) {
                n3 = 1;
            }
        }
        Font font2 = font = tableItem.cellFont != null ? tableItem.cellFont[n] : null;
        if (font == null) {
            font = tableItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2L);
            nSMutableParagraphStyle.setAlignment(n3);
            nSMutableParagraphStyle.setBaseWritingDirection(n2);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n3);
            nSTextFieldCell.setBaseWritingDirection(n2);
        }
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        if (n == 29) {
            this.dragDetected = true;
        } else if (n == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                NSTableView nSTableView = (NSTableView)this.view;
                NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
                int n2 = (int)nSIndexSet.count();
                long[] lArray = new long[n2];
                nSIndexSet.getIndexes(lArray, n2, 0L);
                for (int i = 0; i < n2; ++i) {
                    if (lArray[i] == (long)this.selectedRowIndex) continue;
                    this.ignoreSelect = true;
                    nSTableView.deselectRow(lArray[i]);
                    this.ignoreSelect = false;
                }
                Event event = new Event();
                event.item = this._getItem(this.selectedRowIndex);
                this.selectedRowIndex = -1;
                this.sendSelectionEvent(13, event, false);
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    NSRect titleRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            int n = this.imageBounds.width + 3;
            nSRect.x += (double)n;
            nSRect.width -= (double)n;
        }
        return nSRect;
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl, this.headerView);
    }

    void updateRowCount() {
        NSTableView nSTableView = (NSTableView)this.view;
        this.setRedraw(false);
        this.ignoreSelect = true;
        nSTableView.noteNumberOfRowsChanged();
        this.ignoreSelect = false;
        nSTableView.tile();
        this.setRedraw(true);
    }
}

