/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;

public class MaskedIPSet
extends HashSet<String> {
    public MaskedIPSet() {
    }

    public MaskedIPSet(int initialCapacity) {
        super(initialCapacity);
    }

    public MaskedIPSet(RouterContext ctx, Hash peer, int mask) {
        this(ctx, peer, ctx.netDb().lookupRouterInfoLocally(peer), mask);
    }

    public MaskedIPSet(RouterContext ctx, RouterInfo pinfo, int mask) {
        this(ctx, pinfo != null ? pinfo.getHash() : null, pinfo, mask);
    }

    public MaskedIPSet(RouterContext ctx, Hash peer, RouterInfo pinfo, int mask) {
        super(4);
        if (pinfo == null) {
            return;
        }
        byte[] commIP = ctx.commSystem().getIP(peer);
        if (commIP != null) {
            this.add(MaskedIPSet.maskedIP(commIP, mask));
        }
        Collection<RouterAddress> paddr = pinfo.getAddresses();
        for (RouterAddress pa : paddr) {
            byte[] pib = pa.getIP();
            if (pib == null) continue;
            this.add(MaskedIPSet.maskedIP(pib, mask));
            int port = pa.getPort();
            if (port > 0) {
                this.add("p" + port);
            }
            if (pa.getCost() != 2 || !"NTCP".equals(pa.getTransportStyle())) continue;
            this.add("=cost2");
        }
        String family = pinfo.getOption("family");
        if (family != null) {
            this.add('x' + family);
        }
    }

    private static String maskedIP(byte[] ip, int mask) {
        char delim;
        StringBuilder buf = new StringBuilder(1 + mask * 2);
        if (ip.length == 16) {
            mask = 6;
            delim = ':';
        } else {
            delim = '.';
        }
        buf.append(delim);
        buf.append(Long.toHexString(DataHelper.fromLong(ip, 0, mask)));
        return buf.toString();
    }

    public boolean containsAny(Set<String> b) {
        if (this.isEmpty() || b.isEmpty()) {
            return false;
        }
        for (String s : b) {
            if (!this.contains(s)) continue;
            return true;
        }
        return false;
    }
}

