/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    int frameHandle;
    int labelHandle;
    int imageHandle;
    ImageList imageList;
    Image image;
    String text;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.labelHandle == 0) {
            return;
        }
        control._getAccessible().addRelation(9, this._getAccessible());
        control.labelRelation = this;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point;
        int n3;
        int n4;
        boolean bl2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                if (n == -1) {
                    n = 64;
                }
            } else if (n2 == -1) {
                n2 = 64;
            }
        }
        boolean bl3 = bl2 = this.labelHandle != 0 && (this.style & 0x40) != 0 && OS.gtk_widget_get_visible(this.labelHandle);
        if (bl2 || this.frameHandle != 0) {
            this.forceResize();
        }
        if (bl2) {
            n4 = OS.gtk_label_get_layout(this.labelHandle);
            n3 = OS.pango_layout_get_width(n4);
            if (n != -1) {
                OS.pango_layout_set_width(n4, n * 1024);
            } else {
                OS.pango_layout_set_width(n4, -1);
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.pango_layout_get_pixel_size(n4, nArray, nArray2);
            OS.pango_layout_set_width(n4, n3);
            if (this.frameHandle != 0) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.gtk_widget_get_size_request(this.labelHandle, nArray3, nArray4);
                OS.gtk_widget_set_size_request(this.labelHandle, 1, 1);
                point = this.computeNativeSize(this.frameHandle, -1, -1, bl);
                OS.gtk_widget_set_size_request(this.labelHandle, nArray3[0], nArray4[0]);
                --point.y;
            } else {
                point = new Point(0, 0);
            }
            point.x = --point.x + (n == -1 ? nArray[0] : n);
            point.y = point.y + (n2 == -1 ? nArray2[0] : n2);
        } else if (this.frameHandle != 0) {
            int[] nArray = new int[1];
            int[] nArray5 = new int[1];
            OS.gtk_widget_get_size_request(this.handle, nArray, nArray5);
            OS.gtk_widget_set_size_request(this.handle, n, n2);
            point = this.computeNativeSize(this.frameHandle, -1, -1, bl);
            OS.gtk_widget_set_size_request(this.handle, nArray[0], nArray5[0]);
        } else {
            point = this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n2 == -1 && this.labelHandle != 0) {
            n4 = OS.gtk_label_get_layout(this.labelHandle);
            n3 = OS.pango_layout_get_context(n4);
            int n5 = OS.pango_context_get_language(n3);
            int n6 = this.getFontDescription();
            int n7 = OS.pango_context_get_metrics(n3, n6, n5);
            int n8 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(n7));
            int n9 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(n7));
            OS.pango_font_metrics_unref(n7);
            int n10 = n8 + n9;
            int[] nArray = new int[1];
            OS.g_object_get(this.labelHandle, OS.ypad, nArray, 0);
            n10 += 2 * nArray[0];
            if (this.frameHandle != 0) {
                n10 += 2 * this.getThickness((int)this.frameHandle).y;
                n10 += 2 * OS.gtk_container_get_border_width(this.frameHandle);
            }
            point.y = Math.max(point.y, n10);
        }
        return point;
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        if ((this.style & 2) != 0) {
            this.handle = (this.style & 0x100) != 0 ? this.gtk_separator_new(0) : this.gtk_separator_new(1);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = this.gtk_box_new(0, false, 0);
            if (this.handle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.labelHandle);
            OS.gtk_container_add(this.handle, this.imageHandle);
            OS.gtk_box_set_child_packing(this.handle, this.labelHandle, true, true, 0, 0);
            OS.gtk_box_set_child_packing(this.handle, this.imageHandle, true, true, 0, 0);
        }
        if ((this.style & 0x800) != 0) {
            this.frameHandle = OS.gtk_frame_new(null);
            if (this.frameHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.frameHandle);
            OS.gtk_container_add(this.frameHandle, this.handle);
            OS.gtk_frame_set_shadow_type(this.frameHandle, 3);
        } else {
            OS.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_label_set_line_wrap(this.labelHandle, true);
            OS.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
        this.setAlignment();
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if (this.frameHandle != 0) {
            return this.getThickness((int)this.frameHandle).x;
        }
        return 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    boolean isDescribedByLabel() {
        return false;
    }

    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            Control control = this;
            while (control.parent != null) {
                int n;
                Control[] controlArray = control.parent._getChildren();
                for (n = 0; n < controlArray.length && controlArray[n] != control; ++n) {
                }
                if (++n < controlArray.length && controlArray[n].setFocus()) {
                    return bl;
                }
                control = control.parent;
            }
        }
        return bl;
    }

    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    void register() {
        super.register();
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.frameHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    void resizeHandle(int n, int n2) {
        if (OS.GTK3) {
            OS.swt_fixed_resize(OS.gtk_widget_get_parent(this.fixedHandle), this.fixedHandle, n, n2);
            int n3 = this.frameHandle != 0 ? this.frameHandle : this.handle;
            OS.swt_fixed_resize(OS.gtk_widget_get_parent(n3), n3, n, n2);
        } else {
            OS.gtk_widget_set_size_request(this.fixedHandle, n, n2);
            OS.gtk_widget_set_size_request(this.frameHandle != 0 ? this.frameHandle : this.handle, n, n2);
        }
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.setAlignment();
    }

    void setAlignment() {
        if ((this.style & 0x4000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 1, 1);
                this.gtk_label_set_align(0.0f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 1, 3);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.0f);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            }
            OS.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 3, 1);
                this.gtk_label_set_align(0.5f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 3, 3);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.0f);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            }
            OS.gtk_label_set_justify(this.labelHandle, 2);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 2, 1);
                this.gtk_label_set_align(1.0f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.0f);
                OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            }
            OS.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    private void gtk_label_set_align(float f, float f2) {
        OS.gtk_label_set_xalign(this.labelHandle, f);
        OS.gtk_label_set_yalign(this.labelHandle, f2);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (OS.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            this.setBackgroundColor(this.fixedHandle, gdkColor);
            if (this.labelHandle != 0) {
                this.setBackgroundColor(this.labelHandle, gdkColor);
            }
            if (this.imageHandle != 0) {
                this.setBackgroundColor(this.imageHandle, gdkColor);
            }
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bl2 && this.labelHandle != 0 && (this.style & 0x40) != 0;
        if (bl3) {
            OS.gtk_widget_set_size_request(this.labelHandle, -1, -1);
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            GtkAllocation gtkAllocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
            int n6 = gtkAllocation.width;
            int n7 = gtkAllocation.height;
            OS.gtk_widget_set_size_request(this.labelHandle, n6, n7);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.labelHandle, gtkRequisition);
            OS.gtk_widget_get_allocation(this.labelHandle, gtkAllocation);
            gtkAllocation.width = n6;
            gtkAllocation.height = n7;
            OS.gtk_widget_size_allocate(this.labelHandle, gtkAllocation);
        }
        return n5;
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        if (this.labelHandle != 0) {
            this.setFontDescription(this.labelHandle, n);
        }
        if (this.imageHandle != 0) {
            this.setFontDescription(this.imageHandle, n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        this.setForegroundColor(this.fixedHandle, gdkColor);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, gdkColor);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, n);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            this.imageList = new ImageList();
            int n = this.imageList.add(image);
            int n2 = this.imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            OS.gtk_widget_hide(this.labelHandle);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        OS.gtk_widget_hide(this.imageHandle);
        OS.gtk_widget_show(this.labelHandle);
    }

    void setWidgetBackground() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkColor gdkColor = (this.state & 0x2000) != 0 ? this.getBackgroundColor() : null;
            super.setBackgroundColor(gdkColor);
        } else {
            super.setWidgetBackground();
        }
    }

    void showWidget() {
        super.showWidget();
        if (this.frameHandle != 0) {
            OS.gtk_widget_show(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }

    int gtk_separator_new(int n) {
        int n2 = 0;
        n2 = OS.GTK3 ? OS.gtk_separator_new(n) : (n == 0 ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new());
        return n2;
    }
}

