/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class BuildMessageProcessor {
    private final I2PAppContext ctx;
    private final Log log;
    private final DecayingBloomFilter _filter;

    public BuildMessageProcessor(I2PAppContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logManager().getLog(this.getClass());
        this._filter = this.selectFilter();
    }

    private DecayingBloomFilter selectFilter() {
        long maxMemory = SystemVersion.getMaxMemory();
        int m = SystemVersion.isAndroid() || SystemVersion.isARM() || maxMemory < 0x6000000L ? 17 : (this.ctx.getProperty("router.maxParticipatingTunnels", 10000) > 10000 && maxMemory > 0x10000000L ? 23 : (maxMemory > 0x10000000L ? 22 : (maxMemory > 0x8000000L ? 21 : 19)));
        if (this.log.shouldInfo()) {
            this.log.info("Selected Bloom filter m = " + m);
        }
        return new DecayingBloomFilter(this.ctx, 3600000, 32, "TunnelBMP", m);
    }

    public BuildRequestRecord decrypt(TunnelBuildMessage msg, Hash ourHash, PrivateKey privKey) {
        BuildRequestRecord rv = null;
        int ourHop = -1;
        long beforeActualDecrypt = 0L;
        long afterActualDecrypt = 0L;
        byte[] ourHashData = ourHash.getData();
        long beforeLoop = System.currentTimeMillis();
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            EncryptedBuildRecord rec = msg.getRecord(i);
            int len = 16;
            boolean eq = DataHelper.eq(ourHashData, 0, rec.getData(), 0, len);
            if (!eq) continue;
            beforeActualDecrypt = System.currentTimeMillis();
            try {
                rv = new BuildRequestRecord(this.ctx, privKey, rec);
                afterActualDecrypt = System.currentTimeMillis();
                boolean isBad = SessionKey.INVALID_KEY.equals(rv.readReplyKey());
                if (isBad) {
                    if (this.log.shouldLog(30)) {
                        this.log.warn(msg.getUniqueId() + ": Bad reply key: " + rv);
                    }
                    this.ctx.statManager().addRateData("tunnel.buildRequestBadReplyKey", 1L);
                    return null;
                }
                boolean isDup = this._filter.add(rv.getData(), 136, 32);
                if (isDup) {
                    if (this.log.shouldLog(30)) {
                        this.log.warn(msg.getUniqueId() + ": Dup record: " + rv);
                    }
                    this.ctx.statManager().addRateData("tunnel.buildRequestDup", 1L);
                    return null;
                }
                if (this.log.shouldLog(10)) {
                    this.log.debug(msg.getUniqueId() + ": Matching record: " + rv);
                }
                ourHop = i;
                break;
            }
            catch (DataFormatException dfe) {
                if (!this.log.shouldLog(30)) continue;
                this.log.warn(msg.getUniqueId() + ": Matching record decrypt failure", dfe);
            }
        }
        if (rv == null) {
            if (this.log.shouldLog(30)) {
                this.log.warn(msg.getUniqueId() + ": No matching record");
            }
            return null;
        }
        long beforeEncrypt = System.currentTimeMillis();
        SessionKey replyKey = rv.readReplyKey();
        byte[] iv = rv.readReplyIV();
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            if (i == ourHop) continue;
            EncryptedBuildRecord data = msg.getRecord(i);
            byte[] bytes = data.getData();
            this.ctx.aes().encrypt(bytes, 0, bytes, 0, replyKey, iv, 0, 528);
        }
        long afterEncrypt = System.currentTimeMillis();
        msg.setRecord(ourHop, null);
        if (afterEncrypt - beforeLoop > 1000L && this.log.shouldLog(30)) {
            this.log.warn("Slow decryption, total=" + (afterEncrypt - beforeLoop) + " looping=" + (beforeEncrypt - beforeLoop) + " decrypt=" + (afterActualDecrypt - beforeActualDecrypt) + " encrypt=" + (afterEncrypt - beforeEncrypt));
        }
        return rv;
    }
}

