/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.SigType;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.UPnPManager;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;

public class TransportManager
implements TransportEventListener {
    private final Log _log;
    private final Map<String, Transport> _transports;
    private final Map<String, Transport> _pluggableTransports;
    private final RouterContext _context;
    private final UPnPManager _upnpManager;
    private final DHSessionKeyBuilder.PrecalcRunner _dhThread;
    public static final String PROP_ENABLE_UDP = "i2np.udp.enable";
    public static final String PROP_ENABLE_NTCP = "i2np.ntcp.enable";
    public static final String PROP_ENABLE_UPNP = "i2np.upnp.enable";
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final long SIGTYPE_BANLIST_DURATION = 129600000L;
    private static final int HIGH_CAPACITY_PCT = 50;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public TransportManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportManager.class);
        this._context.statManager().createRateStat("transport.banlistOnUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.banlistOnUsupportedSigType", "Add a peer to the banlist since signature type is unsupported", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.noBidsYetNotAllUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailBanlisted", "Could not attempt to bid on message, as they were banlisted", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailSelf", "Could not attempt to bid on message, as it targeted ourselves", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailNoTransports", "Could not attempt to bid on message, as none of the transports could attempt it", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailAllTransports", "Could not attempt to bid on message, as all of the transports had failed", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._transports = new ConcurrentHashMap<String, Transport>(2);
        this._pluggableTransports = new HashMap<String, Transport>(2);
        this._upnpManager = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UPNP) ? new UPnPManager(context, this) : null;
        this._dhThread = new DHSessionKeyBuilder.PrecalcRunner(context);
    }

    synchronized void registerAndStart(Transport t) {
        String style = t.getStyle();
        if (style.equals("NTCP") || style.equals("SSU")) {
            throw new IllegalArgumentException("Builtin transport");
        }
        if (this._transports.containsKey(style) || this._pluggableTransports.containsKey(style)) {
            throw new IllegalStateException("Dup transport");
        }
        boolean shouldStart = !this._transports.isEmpty();
        this._pluggableTransports.put(style, t);
        this.addTransport(t);
        t.setListener(this);
        if (shouldStart) {
            this.initializeAddress(t);
            t.startListening();
            this._context.router().rebuildRouterInfo();
        }
    }

    synchronized void stopAndUnregister(Transport t) {
        String style = t.getStyle();
        if (style.equals("NTCP") || style.equals("SSU")) {
            throw new IllegalArgumentException("Builtin transport");
        }
        t.setListener(null);
        this._pluggableTransports.remove(style);
        this.removeTransport(t);
        t.stopListening();
        this._context.router().rebuildRouterInfo();
    }

    DHSessionKeyBuilder.Factory getDHFactory() {
        return this._dhThread;
    }

    private void addTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        Transport old = this._transports.put(transport.getStyle(), transport);
        if (old != null && old != transport && this._log.shouldLog(30)) {
            this._log.warn("Replacing transport " + transport.getStyle());
        }
        transport.setListener(this);
    }

    private void removeTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        Transport old = this._transports.remove(transport.getStyle());
        if (old != null && this._log.shouldLog(30)) {
            this._log.warn("Removing transport " + transport.getStyle());
        }
        transport.setListener(null);
    }

    private void configTransports() {
        boolean enableUDP = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UDP);
        UDPTransport udp = null;
        if (enableUDP) {
            udp = new UDPTransport(this._context, this._dhThread);
            this.addTransport(udp);
            this.initializeAddress(udp);
        }
        if (TransportManager.isNTCPEnabled(this._context)) {
            int port;
            NTCPTransport ntcp = new NTCPTransport(this._context, this._dhThread);
            this.addTransport(ntcp);
            this.initializeAddress(ntcp);
            if (udp != null && (port = udp.getRequestedPort()) > 0) {
                ntcp.externalAddressReceived(Transport.AddressSource.SOURCE_CONFIG, null, port);
            }
        }
        if (this._transports.isEmpty()) {
            this._log.log(50, "No transports are enabled");
        }
    }

    public static boolean isNTCPEnabled(RouterContext ctx) {
        return ctx.getBooleanPropertyDefaultTrue(PROP_ENABLE_NTCP);
    }

    private void initializeAddress(Transport t) {
        SortedSet<String> ipset = Addresses.getAddresses(false, true);
        boolean hasNonTempV6Address = false;
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(4);
        ArrayList<Inet6Address> tempV6Addresses = new ArrayList<Inet6Address>(4);
        for (String ips : ipset) {
            try {
                InetAddress addr = InetAddress.getByName(ips);
                if (ips.contains(":") && addr instanceof Inet6Address) {
                    Inet6Address v6addr = (Inet6Address)addr;
                    if (Addresses.isTemporary(v6addr)) {
                        tempV6Addresses.add(v6addr);
                        continue;
                    }
                    hasNonTempV6Address = true;
                }
                addresses.add(addr);
            }
            catch (UnknownHostException e) {
                this._log.error("UDP failed to bind to local address", e);
            }
        }
        if (!tempV6Addresses.isEmpty()) {
            if (hasNonTempV6Address) {
                if (this._log.shouldWarn()) {
                    for (Inet6Address addr : tempV6Addresses) {
                        this._log.warn("Not binding to temporary address " + addr.getHostAddress());
                    }
                }
            } else {
                addresses.addAll(tempV6Addresses);
            }
        }
        for (InetAddress ia : addresses) {
            byte[] ip = ia.getAddress();
            t.externalAddressReceived(Transport.AddressSource.SOURCE_INTERFACE, ip, 0);
        }
    }

    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        for (Transport t : this._transports.values()) {
            if (source == Transport.AddressSource.SOURCE_SSU && t.getStyle().equals("SSU")) continue;
            t.externalAddressReceived(source, ip, port);
        }
    }

    public void externalAddressRemoved(Transport.AddressSource source, boolean ipv6) {
        for (Transport t : this._transports.values()) {
            if (source == Transport.AddressSource.SOURCE_SSU && t.getStyle().equals("SSU")) continue;
            t.externalAddressRemoved(source, ipv6);
        }
    }

    public void forwardPortStatus(String style, byte[] ip, int port, int externalPort, boolean success, String reason) {
        Transport t = this.getTransport(style);
        if (t != null) {
            t.forwardPortStatus(ip, port, externalPort, success, reason);
        }
    }

    public synchronized void startListening() {
        if (this._dhThread.getState() == Thread.State.NEW) {
            this._dhThread.start();
        }
        if (this._upnpManager != null && Addresses.getAnyAddress() == null) {
            this._upnpManager.start();
        }
        this.configTransports();
        this._log.debug("Starting up the transport manager");
        ArrayList<Transport> tps = new ArrayList<Transport>();
        Transport tp = this.getTransport("NTCP");
        if (tp != null) {
            tps.add(tp);
        }
        if ((tp = this.getTransport("SSU")) != null) {
            tps.add(tp);
        }
        for (Transport t : this._pluggableTransports.values()) {
            tps.add(t);
        }
        for (Transport t : tps) {
            t.startListening();
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " started");
        }
        this.transportAddressChanged();
        this._log.debug("Done start listening on transports");
        this._context.router().rebuildRouterInfo();
    }

    public synchronized void restart() {
        this.stopListening();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListening();
    }

    public synchronized void stopListening() {
        if (this._upnpManager != null) {
            this._upnpManager.stop();
        }
        for (Transport t : this._transports.values()) {
            t.stopListening();
        }
        this._transports.clear();
    }

    public synchronized void shutdown() {
        this.stopListening();
        this._dhThread.shutdown();
        Addresses.clearCaches();
        TransportImpl.clearCaches();
    }

    public Transport getTransport(String style) {
        return this._transports.get(style);
    }

    int getTransportCount() {
        return this._transports.size();
    }

    public int countActivePeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActivePeers();
        }
        return peers;
    }

    public int countActiveSendPeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActiveSendPeers();
        }
        return peers;
    }

    public boolean haveOutboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (!t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public boolean haveHighOutboundCapacity() {
        if (this._transports.isEmpty()) {
            return false;
        }
        for (Transport t : this._transports.values()) {
            if (t.haveCapacity(50)) continue;
            return false;
        }
        return true;
    }

    public boolean haveInboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (!t.hasCurrentAddress() || !t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        for (Transport t : this._transports.values()) {
            Vector<Long> tempSkews = t.getClockSkews();
            if (tempSkews == null || tempSkews.isEmpty()) continue;
            skews.addAll(tempSkews);
        }
        return skews;
    }

    public CommSystemFacade.Status getReachabilityStatus() {
        CommSystemFacade.Status rv = CommSystemFacade.Status.UNKNOWN;
        for (Transport t : this._transports.values()) {
            CommSystemFacade.Status s = t.getReachabilityStatus();
            if (s.getCode() >= rv.getCode()) continue;
            rv = s;
        }
        return rv;
    }

    @Deprecated
    public void recheckReachability() {
        for (Transport t : this._transports.values()) {
            t.recheckReachability();
        }
    }

    public boolean isBacklogged(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (!t.isBacklogged(peer)) continue;
            return true;
        }
        return false;
    }

    public boolean isEstablished(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (!t.isEstablished(peer)) continue;
            return true;
        }
        return false;
    }

    public void mayDisconnect(Hash peer) {
        for (Transport t : this._transports.values()) {
            t.mayDisconnect(peer);
        }
    }

    public boolean wasUnreachable(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (t.wasUnreachable(peer)) continue;
            return false;
        }
        return true;
    }

    public byte[] getIP(Hash peer) {
        return TransportImpl.getIP(peer);
    }

    public List<RouterAddress> getAddresses() {
        ArrayList<RouterAddress> rv = new ArrayList<RouterAddress>(4);
        for (Transport t : this._transports.values()) {
            t.updateAddress();
        }
        for (Transport t : this._transports.values()) {
            rv.addAll(t.getCurrentAddresses());
        }
        return rv;
    }

    private Set<Port> getPorts() {
        HashSet<Port> rv = new HashSet<Port>(4);
        for (Transport t : this._transports.values()) {
            Transport udp;
            int port = t.getRequestedPort();
            if (t.getStyle().equals("NTCP") && port <= 0 && this._context.getBooleanProperty("i2np.ntcp.autoport") && (udp = this.getTransport("SSU")) != null) {
                port = t.getRequestedPort();
            }
            if (port <= 0) continue;
            rv.add(new Port(t.getStyle(), port));
        }
        return rv;
    }

    public TransportBid getBid(OutNetMessage msg) {
        List<TransportBid> bids = this.getBids(msg);
        if (bids == null || bids.isEmpty()) {
            return null;
        }
        return bids.get(0);
    }

    public List<TransportBid> getBids(OutNetMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message?  no bidding on a null outNetMessage!");
        }
        if (this._context.router().getRouterInfo().equals(msg.getTarget())) {
            throw new IllegalArgumentException("Bids for a message bound to ourselves?");
        }
        ArrayList<TransportBid> rv = new ArrayList<TransportBid>(this._transports.size());
        Set<String> failedTransports = msg.getFailedTransports();
        for (Transport t : this._transports.values()) {
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Transport " + t.getStyle() + " bid: " + bid);
                }
                rv.add(bid);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
        }
        return rv;
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        int unreachableTransports = 0;
        Hash peer = msg.getTarget().getIdentity().calculateHash();
        Set<String> failedTransports = msg.getFailedTransports();
        TransportBid rv = null;
        for (Transport t : this._transports.values()) {
            if (t.isUnreachable(peer)) {
                ++unreachableTransports;
                msg.transportFailed(t.getStyle());
                continue;
            }
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (bid.getLatencyMs() == 999999) {
                    msg.transportFailed(t.getStyle());
                } else if (rv == null || rv.getLatencyMs() > bid.getLatencyMs()) {
                    rv = bid;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Transport " + t.getStyle() + " bid: " + bid + " currently winning? " + (rv == bid) + " (winning latency: " + rv.getLatencyMs() + " / " + rv + ")");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
            }
            if (!t.isUnreachable(peer)) continue;
            ++unreachableTransports;
        }
        if (unreachableTransports >= this._transports.size()) {
            if (msg.getTarget().getIdentity().getSigningPublicKey().getType() == null) {
                this._context.statManager().addRateData("transport.banlistOnUnsupportedSigType", 1L);
                this._context.banlist().banlistRouterForever(peer, TransportManager._x("Unsupported signature type"));
            } else if (unreachableTransports >= this._transports.size() && this.countActivePeers() > 0) {
                String v;
                RouterIdentity id;
                boolean incompat = false;
                RouterInfo us = this._context.router().getRouterInfo();
                if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp(v = msg.getTarget().getVersion(), "0.9.16") < 0) {
                    incompat = true;
                }
                if (incompat) {
                    this._context.statManager().addRateData("transport.banlistOnUnsupportedSigType", 1L);
                    this._context.banlist().banlistRouter(peer, TransportManager._x("No support for our signature type"), null, null, this._context.clock().now() + 129600000L);
                } else {
                    this._context.statManager().addRateData("transport.banlistOnUnreachable", msg.getLifetime(), msg.getLifetime());
                    this._context.banlist().banlistRouter(peer, TransportManager._x("Unreachable on any transport"));
                }
            }
        } else if (rv == null) {
            this._context.statManager().addRateData("transport.noBidsYetNotAllUnreachable", unreachableTransports, msg.getLifetime());
        }
        return rv;
    }

    @Override
    public void messageReceived(I2NPMessage message, RouterIdentity fromRouter, Hash fromRouterHash) {
        block3: {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2NPMessage received: " + message.getClass().getSimpleName());
            }
            try {
                this._context.inNetMessagePool().add(message, fromRouter, fromRouterHash);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error receiving message", iae);
            }
        }
    }

    @Override
    public void transportAddressChanged() {
        if (this._upnpManager != null) {
            this._upnpManager.rescan();
            this._upnpManager.update(this.getPorts());
        }
    }

    public List<String> getMostRecentErrorMessages() {
        ArrayList<String> rv = new ArrayList<String>(16);
        for (Transport t : this._transports.values()) {
            rv.addAll(t.getMostRecentErrorMessages());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        if (this._context.getBooleanProperty(PROP_ADVANCED)) {
            out.write("<p><b>");
            out.write(this._t("Status"));
            out.write(": ");
            out.write(this._t(this.getReachabilityStatus().toStatusString()));
            out.write("</b></p>");
        }
        TreeMap<String, Transport> transports = new TreeMap<String, Transport>();
        for (Transport t : this._transports.values()) {
            transports.put(t.getStyle(), t);
        }
        for (Transport t : transports.values()) {
            t.renderStatusHTML(out, urlBase, sortFlags);
        }
        if (!this._transports.isEmpty()) {
            out.write(this.getTransportsLegend());
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3>").append(this._t("Router Transport Addresses")).append("</h3><pre>\n");
        for (Transport t : this._transports.values()) {
            if (t.hasCurrentAddress()) {
                for (RouterAddress ra : t.getCurrentAddresses()) {
                    buf.append(ra.toString());
                    buf.append("\n\n");
                }
                continue;
            }
            buf.append(this._t("{0} is used for outbound connections only", t.getStyle()));
            buf.append("\n\n");
        }
        buf.append("</pre>\n");
        out.write(buf.toString());
        if (!SystemVersion.isAndroid()) {
            if (this._upnpManager != null) {
                out.write(this._upnpManager.renderStatusHTML());
            } else {
                out.write("<h3><a name=\"upnp\"></a>" + this._t("UPnP is not enabled") + "</h3>\n");
            }
        }
        out.write("</p>\n");
        out.flush();
    }

    private final String getTransportsLegend() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3 id=\"help\">").append(this._t("Help")).append("</h3><div class=\"configure\"><p>").append(this._t("Your transport connection limits are automatically set based on your configured bandwidth.")).append('\n').append(this._t("To override these limits, add the settings i2np.ntcp.maxConnections=nnn and i2np.udp.maxConnections=nnn on the advanced configuration page.")).append("</p></div>\n");
        buf.append("<h3>").append(this._t("Definitions")).append("</h3><div class=\"configure\"><p><b id=\"def.peer\">").append(this._t("Peer")).append("</b>: ").append(this._t("The remote peer, identified by router hash")).append("<br>\n<b id=\"def.dir\">").append(this._t("Dir")).append("</b>: <img alt=\"Inbound\" src=\"/themes/console/images/inbound.png\"> ").append(this._t("Inbound connection")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img alt=\"Outbound\" src=\"/themes/console/images/outbound.png\"> ").append(this._t("Outbound connection")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" alt=\"V\" height=\"8\" width=\"12\"> ").append(this._t("They offered to introduce us (help other peers traverse our firewall)")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" alt=\"^\" height=\"8\" width=\"12\"> ").append(this._t("We offered to introduce them (help other peers traverse their firewall)")).append("<br>\n<b id=\"def.idle\">").append(this._t("Idle")).append("</b>: ").append(this._t("How long since a packet has been received / sent")).append("<br>\n<b id=\"def.rate\">").append(this._t("In/Out")).append("</b>: ").append(this._t("The smoothed inbound / outbound transfer rate (KBytes per second)")).append("<br>\n<b id=\"def.up\">").append(this._t("Up")).append("</b>: ").append(this._t("How long ago this connection was established")).append("<br>\n<b id=\"def.skew\">").append(this._t("Skew")).append("</b>: ").append(this._t("The difference between the peer's clock and your own")).append("<br>\n<b id=\"def.cwnd\">CWND</b>: ").append(this._t("The congestion window, which is how many bytes can be sent without an acknowledgement")).append(" / <br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._t("The number of sent messages awaiting acknowledgement")).append(" /<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._t("The maximum number of concurrent messages to send")).append(" /<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._t("The number of pending sends which exceed congestion window")).append("<br>\n<b id=\"def.ssthresh\">SST</b>: ").append(this._t("The slow start threshold")).append("<br>\n<b id=\"def.rtt\">RTT</b>: ").append(this._t("The round trip time in milliseconds")).append("<br>\n<b id=\"def.rto\">RTO</b>: ").append(this._t("The retransmit timeout in milliseconds")).append("<br>\n<b id=\"def.mtu\">MTU</b>: ").append(this._t("Current maximum send packet size / estimated maximum receive packet size (bytes)")).append("<br>\n<b id=\"def.send\">").append(this._t("TX")).append("</b>: ").append(this._t("The total number of messages sent to the peer")).append("<br>\n<b id=\"def.recv\">").append(this._t("RX")).append("</b>: ").append(this._t("The total number of messages received from the peer")).append("<br>\n<b id=\"def.resent\">").append(this._t("Dup TX")).append("</b>: ").append(this._t("The total number of packets retransmitted to the peer")).append("<br>\n<b id=\"def.dupRecv\">").append(this._t("Dup RX")).append("</b>: ").append(this._t("The total number of duplicate packets received from the peer")).append("</p></div>\n");
        return buf.toString();
    }

    private static final String _x(String s) {
        return s;
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private final String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    static class Port {
        public final String style;
        public final int port;

        public Port(String style, int port) {
            this.style = style;
            this.port = port;
        }

        public int hashCode() {
            return this.style.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Port)) {
                return false;
            }
            Port p = (Port)o;
            return this.port == p.port && this.style.equals(p.style);
        }
    }
}

