/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc = new Callback(ToolBar.class, "MenuItemSelectedProc", 2);

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        OS.gtk_orientable_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0 && !OS.GTK3) {
            byte[] byArray = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, byArray);
        }
        if (OS.GTK3) {
            int n2 = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_invalidate(n2);
        }
        OS.gtk_toolbar_set_icon_size(this.handle, OS.GTK3 ? 2 : 3);
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    int applyThemeBackground() {
        return -1;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return point;
    }

    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n = this.indexOf(this.currentFocusItem)) == -1) {
            n = toolItemArray.length - 1;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n;
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        for (int i = 0; i < toolItemArray2.length; ++i) {
            ToolItem toolItem = toolItemArray2[i];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    int enterExitHandle() {
        return this.handle;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        ToolItem[] toolItemArray = this.getItems();
        if (this.toolTipText == null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem.toolTipText == null) continue;
                toolItem.setToolTipText(shell2, null);
                toolItem.setToolTipText(shell, toolItem.toolTipText);
            }
        }
    }

    boolean forceFocus(int n) {
        int n2 = 0;
        if ((this.style & 0x8000000) != 0) {
            n2 = 1;
        }
        int n3 = this.handle;
        if (this.currentFocusItem != null) {
            n3 = this.currentFocusItem.handle;
        }
        if (OS.gtk_widget_child_focus(n3, n2)) {
            return true;
        }
        return super.forceFocus(n);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (!toolItemArray[i].getBounds().contains(point)) continue;
            return toolItemArray[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return 0;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        return n2;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return new ToolItem[0];
        }
        int n2 = OS.g_list_length(n);
        ToolItem[] toolItemArray = new ToolItem[n2];
        int n3 = n;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = OS.g_list_data(n);
            Widget widget = this.display.getWidget(n5);
            if (widget != null) {
                toolItemArray[n4++] = (ToolItem)widget;
            }
            n = OS.g_list_next(n);
        }
        OS.g_list_free(n3);
        if (n4 != toolItemArray.length) {
            ToolItem[] toolItemArray2 = new ToolItem[n4];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, n4);
            toolItemArray = toolItemArray2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            toolItemArray[n2++] = this.tabItemList[i];
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    int gtk_key_press_event(int n, int n2) {
        if (!this.hasFocus()) {
            return 0;
        }
        int n3 = super.gtk_key_press_event(n, n2);
        return n3;
    }

    int gtk_focus(int n, int n2) {
        return 0;
    }

    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (toolItem != toolItemArray[i]) continue;
            return i;
        }
        return -1;
    }

    static int MenuItemSelectedProc(int n, int n2) {
        Display display = Display.getCurrent();
        ToolItem toolItem = (ToolItem)display.getWidget(n2);
        if (toolItem != null) {
            return toolItem.getParent().menuItemSelected(n, toolItem);
        }
        return 0;
    }

    int menuItemSelected(int n, ToolItem toolItem) {
        Event event = new Event();
        switch (toolItem.style) {
            case 4: {
                event.detail = 4;
                GtkAllocation gtkAllocation = new GtkAllocation();
                OS.gtk_widget_get_allocation(n, gtkAllocation);
                event.x = gtkAllocation.x;
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - gtkAllocation.width - event.x;
                }
                event.y = gtkAllocation.y + gtkAllocation.height;
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                toolItem.selectRadio();
                break;
            }
            case 32: {
                boolean bl = toolItem.getSelection();
                toolItem.setSelection(!bl);
            }
        }
        toolItem.sendSelectionEvent(13, event, false);
        return 0;
    }

    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            int n = toolItemArray[i].labelHandle;
            if (n == 0 || !this.mnemonicHit(n, c)) continue;
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            int n = toolItemArray[i].labelHandle;
            if (n == 0 || !this.mnemonicMatch(n, c)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        int n;
        ToolItem[] toolItemArray = this.getItems();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < toolItemArray.length; ++n) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem == null) continue;
            toolItem.resizeControl();
            bl |= toolItem.text != null && toolItem.text.length() > 0;
            bl2 |= toolItem.image != null;
        }
        n = 0;
        if (bl && bl2) {
            n = (this.style & 0x20000) != 0 ? 3 : 2;
        } else if (bl) {
            n = 1;
        } else if (bl2) {
            n = 0;
        }
        OS.gtk_toolbar_set_style(this.handle, n);
    }

    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null || toolItem.isDisposed()) continue;
            toolItem.release(false);
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    void reskinChildren(int n) {
        ToolItem[] toolItemArray = this._getItems();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) continue;
                toolItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return n5;
    }

    void setBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            String string = "GtkToolbar {background-color: " + this.gtk_rgba_to_css_string(gdkRGBA) + "}";
            this.gtk_css_provider_load_from_css(n, string);
        } else {
            super.setBackgroundColor(n, n2, gdkRGBA);
        }
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setFontDescription(n);
        }
        this.relayout();
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setForegroundColor(gdkColor);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        ToolItem[] toolItemArray = this._getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setOrientation(bl);
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent == this) continue;
                this.error(32);
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            String string2 = string != null ? null : toolItemArray[i].toolTipText;
            shell.setToolTipText(toolItemArray[i].handle, string2);
        }
    }

    static {
        if (menuItemSelectedFunc.getAddress() == 0) {
            SWT.error(3);
        }
    }
}

