/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.util.Log;

public class FIFOBandwidthRefiller
implements Runnable {
    private final Log _log;
    private final I2PAppContext _context;
    private final FIFOBandwidthLimiter _limiter;
    private int _inboundKBytesPerSecond;
    private int _outboundKBytesPerSecond;
    private int _inboundBurstKBytesPerSecond;
    private int _outboundBurstKBytesPerSecond;
    private long _lastRefillTime;
    private long _lastCheckConfigTime;
    private long _configCheckPeriodMs = 60000L;
    private volatile boolean _isRunning;
    public static final String PROP_INBOUND_BANDWIDTH = "i2np.bandwidth.inboundKBytesPerSecond";
    public static final String PROP_OUTBOUND_BANDWIDTH = "i2np.bandwidth.outboundKBytesPerSecond";
    public static final String PROP_INBOUND_BURST_BANDWIDTH = "i2np.bandwidth.inboundBurstKBytesPerSecond";
    public static final String PROP_OUTBOUND_BURST_BANDWIDTH = "i2np.bandwidth.outboundBurstKBytesPerSecond";
    public static final String PROP_INBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.inboundBurstKBytes";
    public static final String PROP_OUTBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.outboundBurstKBytes";
    public static final int DEFAULT_INBOUND_BANDWIDTH = 300;
    public static final int DEFAULT_OUTBOUND_BANDWIDTH = 60;
    public static final int DEFAULT_INBOUND_BURST_BANDWIDTH = 300;
    public static final int DEFAULT_OUTBOUND_BURST_BANDWIDTH = 60;
    public static final int DEFAULT_BURST_SECONDS = 60;
    public static final int MIN_INBOUND_BANDWIDTH = 5;
    public static final int MIN_OUTBOUND_BANDWIDTH = 5;
    public static final int MIN_INBOUND_BANDWIDTH_PEAK = 5;
    public static final int MIN_OUTBOUND_BANDWIDTH_PEAK = 5;
    public static final int MAX_OUTBOUND_BANDWIDTH = 16384;
    private static final long REPLENISH_FREQUENCY = 40L;
    private static final int TOTAL_TIME = 4000;
    private static final int PERIODS = 100;
    private final AtomicInteger _currentParticipating = new AtomicInteger();
    private long _lastPartUpdateTime;
    private int _lastTotal;
    private long _lastTotalTime;
    private int _lastIndex;
    private final int[] _counts = new int[100];
    private final long[] _times = new long[100];
    private final ReentrantReadWriteLock _updateLock = new ReentrantReadWriteLock(false);

    FIFOBandwidthRefiller(I2PAppContext context, FIFOBandwidthLimiter limiter) {
        this._limiter = limiter;
        this._context = context;
        this._log = context.logManager().getLog(FIFOBandwidthRefiller.class);
        this.reinitialize();
        this._isRunning = true;
    }

    synchronized void shutdown() {
        this._isRunning = false;
    }

    @Override
    public void run() {
        this._lastRefillTime = this._limiter.now();
        ArrayList<FIFOBandwidthLimiter.Request> buffer = new ArrayList<FIFOBandwidthLimiter.Request>(2);
        while (this._isRunning) {
            long now = this._limiter.now();
            if (now >= this._lastCheckConfigTime + this._configCheckPeriodMs) {
                this.checkConfig();
                this._lastCheckConfigTime = now = this._limiter.now();
            }
            this.updateParticipating(now);
            boolean updated = this.updateQueues(buffer, now);
            if (updated) {
                this._lastRefillTime = now;
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void reinitialize() {
        this._lastRefillTime = this._limiter.now();
        this.checkConfig();
        this._lastCheckConfigTime = this._lastRefillTime;
    }

    private boolean updateQueues(List<FIFOBandwidthLimiter.Request> buffer, long now) {
        long numMs = now - this._lastRefillTime;
        if (this._log.shouldLog(10)) {
            this._log.debug("Updating bandwidth after " + numMs + " (status: " + this._limiter.getStatus().toString() + " rate in=" + this._inboundKBytesPerSecond + ", out=" + this._outboundKBytesPerSecond + ")");
        }
        if (numMs >= 2000L || numMs <= 0L) {
            numMs = 40L;
        }
        if (numMs >= 40L) {
            long inboundToAdd = (long)(1024 * this._inboundKBytesPerSecond) * numMs / 1000L;
            long outboundToAdd = (long)(1024 * this._outboundKBytesPerSecond) * numMs / 1000L;
            if (inboundToAdd < 0L) {
                inboundToAdd = 0L;
            }
            if (outboundToAdd < 0L) {
                outboundToAdd = 0L;
            }
            long maxBurstIn = (long)((this._inboundBurstKBytesPerSecond - this._inboundKBytesPerSecond) * 1024) * numMs / 1000L;
            long maxBurstOut = (long)((this._outboundBurstKBytesPerSecond - this._outboundKBytesPerSecond) * 1024) * numMs / 1000L;
            this._limiter.refillBandwidthQueues(buffer, inboundToAdd, outboundToAdd, maxBurstIn, maxBurstOut);
            return true;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Refresh delay too fast (" + numMs + ")");
        }
        return false;
    }

    private void checkConfig() {
        this.updateInboundRate();
        this.updateOutboundRate();
        this.updateInboundBurstRate();
        this.updateOutboundBurstRate();
        this.updateInboundPeak();
        this.updateOutboundPeak();
    }

    private void updateInboundRate() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH, 300);
        if (in != this._inboundKBytesPerSecond) {
            this._inboundKBytesPerSecond = in <= 0 || in > 5 ? in : 5;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating inbound rate to " + this._inboundKBytesPerSecond);
            }
        }
        if (this._inboundKBytesPerSecond <= 0) {
            this._inboundKBytesPerSecond = 300;
        }
    }

    private void updateOutboundRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH, 60);
        if (out != this._outboundKBytesPerSecond) {
            this._outboundKBytesPerSecond = out >= 16384 ? 16384 : (out <= 0 || out >= 5 ? out : 5);
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating outbound rate to " + this._outboundKBytesPerSecond);
            }
        }
        if (this._outboundKBytesPerSecond <= 0) {
            this._outboundKBytesPerSecond = 60;
        }
    }

    private void updateInboundBurstRate() {
        int in = this._context.getProperty(PROP_INBOUND_BURST_BANDWIDTH, 300);
        if (in != this._inboundBurstKBytesPerSecond) {
            this._inboundBurstKBytesPerSecond = in <= 0 || in >= this._inboundKBytesPerSecond ? in : this._inboundKBytesPerSecond;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating inbound burst rate to " + this._inboundBurstKBytesPerSecond);
            }
        }
        if (this._inboundBurstKBytesPerSecond <= 0) {
            this._inboundBurstKBytesPerSecond = 300;
        }
        this._limiter.setInboundBurstKBps(this._inboundBurstKBytesPerSecond);
    }

    private void updateOutboundBurstRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BURST_BANDWIDTH, 60);
        if (out != this._outboundBurstKBytesPerSecond) {
            this._outboundBurstKBytesPerSecond = out <= 0 || out >= this._outboundKBytesPerSecond ? out : this._outboundKBytesPerSecond;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating outbound burst rate to " + this._outboundBurstKBytesPerSecond);
            }
        }
        if (this._outboundBurstKBytesPerSecond <= 0) {
            this._outboundBurstKBytesPerSecond = 60;
        }
        this._limiter.setOutboundBurstKBps(this._outboundBurstKBytesPerSecond);
    }

    private void updateInboundPeak() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH_PEAK, 60 * this._inboundBurstKBytesPerSecond);
        if (in != this._limiter.getInboundBurstBytes()) {
            if (in >= 5) {
                if (in < this._inboundBurstKBytesPerSecond) {
                    this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setInboundBurstBytes(in * 1024);
                }
            } else if (5 < this._inboundBurstKBytesPerSecond) {
                this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setInboundBurstBytes(5120);
            }
        }
    }

    private void updateOutboundPeak() {
        int in = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH_PEAK, 60 * this._outboundBurstKBytesPerSecond);
        if (in != this._limiter.getOutboundBurstBytes()) {
            if (in >= 5) {
                if (in < this._outboundBurstKBytesPerSecond) {
                    this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setOutboundBurstBytes(in * 1024);
                }
            } else if (5 < this._outboundBurstKBytesPerSecond) {
                this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setOutboundBurstBytes(5120);
            }
        }
    }

    int getOutboundKBytesPerSecond() {
        return this._outboundKBytesPerSecond;
    }

    int getInboundKBytesPerSecond() {
        return this._inboundKBytesPerSecond;
    }

    int getOutboundBurstKBytesPerSecond() {
        return this._outboundBurstKBytesPerSecond;
    }

    int getInboundBurstKBytesPerSecond() {
        return this._inboundBurstKBytesPerSecond;
    }

    void incrementParticipatingMessageBytes(int size) {
        this._currentParticipating.addAndGet(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentParticipatingBandwidth() {
        this._updateLock.readLock().lock();
        try {
            int n = this.locked_getCurrentParticipatingBandwidth();
            return n;
        }
        finally {
            this._updateLock.readLock().unlock();
        }
    }

    private int locked_getCurrentParticipatingBandwidth() {
        int current = this._currentParticipating.get();
        long totalTime = this._limiter.now() - this._lastPartUpdateTime + this._lastTotalTime;
        if (totalTime <= 0L) {
            return 0;
        }
        long bw = 1000L * (long)(current + this._lastTotal) / totalTime;
        if (bw > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParticipating(long now) {
        this._updateLock.writeLock().lock();
        try {
            this.locked_updateParticipating(now);
        }
        finally {
            this._updateLock.writeLock().unlock();
        }
    }

    private void locked_updateParticipating(long now) {
        long elapsed = now - this._lastPartUpdateTime;
        if (elapsed <= 0L) {
            this._lastPartUpdateTime = now;
            return;
        }
        this._lastPartUpdateTime = now;
        if (--this._lastIndex < 0) {
            this._lastIndex = 99;
        }
        this._counts[this._lastIndex] = this._currentParticipating.getAndSet(0);
        this._times[this._lastIndex] = elapsed;
        this._lastTotal = 0;
        this._lastTotalTime = 0L;
        for (int i = 0; i < 100; ++i) {
            int idx = (this._lastIndex + i) % 100;
            this._lastTotal += this._counts[idx];
            this._lastTotalTime += this._times[idx];
            if (this._lastTotalTime >= 4000L) break;
        }
        if (this._lastIndex == 0 && this._lastTotalTime > 0L) {
            long bw = 1000L * (long)this._lastTotal / this._lastTotalTime;
            this._context.statManager().addRateData("tunnel.participatingBandwidthOut", bw);
            if (this._lastTotal > 0 && this._log.shouldLog(20)) {
                this._log.info(DataHelper.formatSize(this._lastTotal) + " bytes out part. tunnels in last " + this._lastTotalTime + " ms: " + DataHelper.formatSize(bw) + " Bps");
            }
        }
    }
}

