/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    NSMenuItem nsItem;
    Menu parent;
    Menu menu;
    int accelerator;
    long nsItemAction;
    id nsItemTarget;
    String toolTipText;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, n2);
    }

    MenuItem(Menu menu, NSMenuItem nSMenuItem) {
        super(menu, 0);
        this.parent = menu;
        this.nsItem = nSMenuItem;
        menu.createItem(this, menu.getItemCount());
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    NSMenu createEmptyMenu() {
        if ((this.parent.style & 2) != 0) {
            return (NSMenu)new SWTMenu().alloc().init();
        }
        return null;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsItem);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getID() {
        this.checkWidget();
        return (int)this.nsItem.tag();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.nsItem.state() == 1L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int keyChar(int n) {
        switch (n) {
            case 8: {
                return 8;
            }
            case 13: {
                return 13;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 65536: {
                return 8997;
            }
            case 131072: {
                return 8679;
            }
            case 262144: {
                return 992003;
            }
            case 0x400000: {
                return 8984;
            }
            case 0x1000001: {
                return 8593;
            }
            case 0x1000002: {
                return 8595;
            }
            case 0x1000003: {
                return 8592;
            }
            case 0x1000004: {
                return 8594;
            }
            case 0x1000005: {
                return 8670;
            }
            case 0x1000006: {
                return 8671;
            }
            case 0x1000050: {
                return 3;
            }
            case 0x1000051: {
                return 63302;
            }
            case 0x1000007: {
                return 63273;
            }
            case 0x1000008: {
                return 63275;
            }
            case 0x100000A: {
                return 63236;
            }
            case 0x100000B: {
                return 63237;
            }
            case 0x100000C: {
                return 63238;
            }
            case 0x100000D: {
                return 63239;
            }
            case 0x100000E: {
                return 63240;
            }
            case 0x100000F: {
                return 63241;
            }
            case 0x1000010: {
                return 63242;
            }
            case 0x1000011: {
                return 63243;
            }
            case 0x1000012: {
                return 63244;
            }
            case 0x1000013: {
                return 63245;
            }
            case 0x1000014: {
                return 63246;
            }
            case 0x1000015: {
                return 63247;
            }
            case 0x1000016: {
                return 63248;
            }
            case 0x1000017: {
                return 63249;
            }
            case 0x1000018: {
                return 63250;
            }
        }
        return 0;
    }

    void register() {
        super.register();
        this.display.addWidget(this.nsItem, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        this.parent = null;
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.sendSelectionEvent(13, event, this.nsItemAction != 0L);
        if (this.isDisposed()) {
            return;
        }
        if (this.nsItemAction != 0L && event.doit) {
            NSApplication nSApplication = NSApplication.sharedApplication();
            nSApplication.sendAction(this.nsItemAction, this.nsItemTarget, nSApplication);
        }
    }

    public void setAccelerator(int n) {
        int n2;
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        this.accelerator = n;
        int n3 = n & 0x100FFFF;
        if (n3 == 27 && n3 == n && !this.display.escAsAcceleratorPresent) {
            this.display.escAsAcceleratorPresent = true;
        }
        String string = (n2 = this.keyChar(n3)) != 0 ? (char)n2 + "" : (char)n3 + "";
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(string);
        this.nsItem.setKeyEquivalent(nSString.lowercaseString());
        nSString.release();
        int n4 = 0;
        if ((n & 0x20000) != 0) {
            n4 |= 0x20000;
        }
        if ((n & 0x40000) != 0) {
            n4 |= 0x40000;
        }
        if ((n & 0x400000) != 0) {
            n4 |= 0x100000;
        }
        if ((n & 0x10000) != 0) {
            n4 |= 0x80000;
        }
        this.nsItem.setKeyEquivalentModifierMask(n4);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.nsItem.setEnabled(bl);
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.nsItem.setTag(n);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.nsItem.setImage(image != null ? image.handle : null);
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed() || menu == this.parent) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (this.parent.parent != null && menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if (menu == null) {
            NSMenu nSMenu = this.createEmptyMenu();
            if (nSMenu != null) {
                this.nsItem.setSubmenu(nSMenu);
                nSMenu.release();
            }
        } else {
            menu.cascade = this;
            this.nsItem.setSubmenu(menu.nsMenu);
        }
        if (menu != null) {
            this.nsItem.setTarget(null);
            this.nsItem.setAction(0L);
        } else {
            this.nsItem.setTarget(this.nsItem);
            this.nsItem.setAction(OS.sel_sendSelection);
        }
        this.updateText();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.nsItem.setState(bl ? 1L : 0L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.toolTipText != null) {
            this.toolTipText = null;
            this.nsItem.setToolTip(null);
        }
        if (string == null || string.trim().length() == 0 || string.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = string;
        char[] cArray = new char[this.toolTipText.length()];
        this.toolTipText.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        this.nsItem.setToolTip(NSString.stringWithCharacters(cArray, n));
    }

    void updateText() {
        if (this.isDisposed() || this.parent.isDisposed()) {
            return;
        }
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = 0;
        int n2 = 0;
        while (n < cArray.length && cArray[n] != '\t') {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            --n2;
        }
        String string = new String(cArray, 0, n2);
        NSMenu nSMenu = this.nsItem.submenu();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(string);
        if (nSMenu != null && (this.parent.getStyle() & 2) != 0) {
            nSMenu.setTitle(nSString);
        } else {
            int n3 = (this.parent.getStyle() & 0x4000000) != 0 ? 1 : 0;
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(2L);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setBaseWritingDirection(n3);
            nSMutableParagraphStyle.setLineBreakMode(5L);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            nSMutableDictionary.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSMutableDictionary);
            nSMutableDictionary.release();
            this.nsItem.setAttributedTitle(nSAttributedString);
            if (string.length() == 0) {
                this.nsItem.setTitle(NSString.string());
            }
            nSAttributedString.release();
        }
        nSString.release();
    }

    boolean updateAccelerator(boolean bl) {
        Object object;
        if (this.accelerator != 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (bl) {
            object = new char[this.text.length()];
            this.text.getChars(0, ((char[])object).length, (char[])object, 0);
            int n3 = 0;
            int n4 = 0;
            while (n3 < ((Object)object).length && object[n3] != 9) {
                if ((object[n4++] = object[n3++]) != 38 || n3 == ((Object)object).length) continue;
                if (object[n3] == 38) {
                    ++n3;
                    continue;
                }
                --n4;
            }
            if (n3 < ((Object)object).length && object[n3] == 9) {
                block31: for (n4 = n3 + 1; n4 < ((Object)object).length; ++n4) {
                    switch (object[n4]) {
                        case 8963: {
                            n |= 0x40000;
                            ++n3;
                            continue block31;
                        }
                        case 8997: {
                            n |= 0x80000;
                            ++n3;
                            continue block31;
                        }
                        case 8679: {
                            n |= 0x20000;
                            ++n3;
                            continue block31;
                        }
                        case 8984: {
                            n |= 0x100000;
                            ++n3;
                            continue block31;
                        }
                        default: {
                            n4 = ((Object)object).length;
                        }
                    }
                }
                block6 : switch (((Object)object).length - n3 - 1) {
                    case 1: {
                        n2 = object[n3 + 1];
                        if (n2 != 9251) break;
                        n2 = 32;
                        break;
                    }
                    case 2: {
                        if (object[n3 + 1] != 70) break;
                        switch (object[n3 + 2]) {
                            case 49: {
                                n2 = 63236;
                                break;
                            }
                            case 50: {
                                n2 = 63237;
                                break;
                            }
                            case 51: {
                                n2 = 63238;
                                break;
                            }
                            case 52: {
                                n2 = 63239;
                                break;
                            }
                            case 53: {
                                n2 = 63240;
                                break;
                            }
                            case 54: {
                                n2 = 63241;
                                break;
                            }
                            case 55: {
                                n2 = 63242;
                                break;
                            }
                            case 56: {
                                n2 = 63243;
                                break;
                            }
                            case 57: {
                                n2 = 63244;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (object[n3 + 1] != 70 || object[n3 + 2] != 49) break;
                        switch (object[n3 + 3]) {
                            case 48: {
                                n2 = 63245;
                                break block6;
                            }
                            case 49: {
                                n2 = 63246;
                                break block6;
                            }
                            case 50: {
                                n2 = 63247;
                                break block6;
                            }
                            case 51: {
                                n2 = 63248;
                                break block6;
                            }
                            case 52: {
                                n2 = 63249;
                                break block6;
                            }
                            case 53: {
                                n2 = 63250;
                            }
                        }
                    }
                }
            }
        }
        this.nsItem.setKeyEquivalentModifierMask(n);
        object = (NSString)new NSString().alloc();
        object = ((NSString)object).initWithString(n2 == 0 ? "" : String.valueOf((char)n2));
        this.nsItem.setKeyEquivalent(((NSString)object).lowercaseString());
        ((NSObject)object).release();
        return n2 != 0;
    }
}

